// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.async.Deferred');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__26741__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__26741__auto__){
return or__26741__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__26741__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__34638_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__34638_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__34643 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__34644 = null;
var count__34645 = (0);
var i__34646 = (0);
while(true){
if((i__34646 < count__34645)){
var n = cljs.core._nth.call(null,chunk__34644,i__34646);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__34647 = seq__34643;
var G__34648 = chunk__34644;
var G__34649 = count__34645;
var G__34650 = (i__34646 + (1));
seq__34643 = G__34647;
chunk__34644 = G__34648;
count__34645 = G__34649;
i__34646 = G__34650;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__34643);
if(temp__6753__auto__){
var seq__34643__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34643__$1)){
var c__27647__auto__ = cljs.core.chunk_first.call(null,seq__34643__$1);
var G__34651 = cljs.core.chunk_rest.call(null,seq__34643__$1);
var G__34652 = c__27647__auto__;
var G__34653 = cljs.core.count.call(null,c__27647__auto__);
var G__34654 = (0);
seq__34643 = G__34651;
chunk__34644 = G__34652;
count__34645 = G__34653;
i__34646 = G__34654;
continue;
} else {
var n = cljs.core.first.call(null,seq__34643__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__34655 = cljs.core.next.call(null,seq__34643__$1);
var G__34656 = null;
var G__34657 = (0);
var G__34658 = (0);
seq__34643 = G__34655;
chunk__34644 = G__34656;
count__34645 = G__34657;
i__34646 = G__34658;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__34709_34720 = cljs.core.seq.call(null,deps);
var chunk__34710_34721 = null;
var count__34711_34722 = (0);
var i__34712_34723 = (0);
while(true){
if((i__34712_34723 < count__34711_34722)){
var dep_34724 = cljs.core._nth.call(null,chunk__34710_34721,i__34712_34723);
topo_sort_helper_STAR_.call(null,dep_34724,(depth + (1)),state);

var G__34725 = seq__34709_34720;
var G__34726 = chunk__34710_34721;
var G__34727 = count__34711_34722;
var G__34728 = (i__34712_34723 + (1));
seq__34709_34720 = G__34725;
chunk__34710_34721 = G__34726;
count__34711_34722 = G__34727;
i__34712_34723 = G__34728;
continue;
} else {
var temp__6753__auto___34729 = cljs.core.seq.call(null,seq__34709_34720);
if(temp__6753__auto___34729){
var seq__34709_34730__$1 = temp__6753__auto___34729;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34709_34730__$1)){
var c__27647__auto___34731 = cljs.core.chunk_first.call(null,seq__34709_34730__$1);
var G__34732 = cljs.core.chunk_rest.call(null,seq__34709_34730__$1);
var G__34733 = c__27647__auto___34731;
var G__34734 = cljs.core.count.call(null,c__27647__auto___34731);
var G__34735 = (0);
seq__34709_34720 = G__34732;
chunk__34710_34721 = G__34733;
count__34711_34722 = G__34734;
i__34712_34723 = G__34735;
continue;
} else {
var dep_34736 = cljs.core.first.call(null,seq__34709_34730__$1);
topo_sort_helper_STAR_.call(null,dep_34736,(depth + (1)),state);

var G__34737 = cljs.core.next.call(null,seq__34709_34730__$1);
var G__34738 = null;
var G__34739 = (0);
var G__34740 = (0);
seq__34709_34720 = G__34737;
chunk__34710_34721 = G__34738;
count__34711_34722 = G__34739;
i__34712_34723 = G__34740;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__34713){
var vec__34717 = p__34713;
var seq__34718 = cljs.core.seq.call(null,vec__34717);
var first__34719 = cljs.core.first.call(null,seq__34718);
var seq__34718__$1 = cljs.core.next.call(null,seq__34718);
var x = first__34719;
var xs = seq__34718__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__34717,seq__34718,first__34719,seq__34718__$1,x,xs,get_deps__$1){
return (function (p1__34659_SHARP_){
return clojure.set.difference.call(null,p1__34659_SHARP_,x);
});})(vec__34717,seq__34718,first__34719,seq__34718__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__34753 = cljs.core.seq.call(null,provides);
var chunk__34754 = null;
var count__34755 = (0);
var i__34756 = (0);
while(true){
if((i__34756 < count__34755)){
var prov = cljs.core._nth.call(null,chunk__34754,i__34756);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34757_34765 = cljs.core.seq.call(null,requires);
var chunk__34758_34766 = null;
var count__34759_34767 = (0);
var i__34760_34768 = (0);
while(true){
if((i__34760_34768 < count__34759_34767)){
var req_34769 = cljs.core._nth.call(null,chunk__34758_34766,i__34760_34768);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34769,prov);

var G__34770 = seq__34757_34765;
var G__34771 = chunk__34758_34766;
var G__34772 = count__34759_34767;
var G__34773 = (i__34760_34768 + (1));
seq__34757_34765 = G__34770;
chunk__34758_34766 = G__34771;
count__34759_34767 = G__34772;
i__34760_34768 = G__34773;
continue;
} else {
var temp__6753__auto___34774 = cljs.core.seq.call(null,seq__34757_34765);
if(temp__6753__auto___34774){
var seq__34757_34775__$1 = temp__6753__auto___34774;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34757_34775__$1)){
var c__27647__auto___34776 = cljs.core.chunk_first.call(null,seq__34757_34775__$1);
var G__34777 = cljs.core.chunk_rest.call(null,seq__34757_34775__$1);
var G__34778 = c__27647__auto___34776;
var G__34779 = cljs.core.count.call(null,c__27647__auto___34776);
var G__34780 = (0);
seq__34757_34765 = G__34777;
chunk__34758_34766 = G__34778;
count__34759_34767 = G__34779;
i__34760_34768 = G__34780;
continue;
} else {
var req_34781 = cljs.core.first.call(null,seq__34757_34775__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34781,prov);

var G__34782 = cljs.core.next.call(null,seq__34757_34775__$1);
var G__34783 = null;
var G__34784 = (0);
var G__34785 = (0);
seq__34757_34765 = G__34782;
chunk__34758_34766 = G__34783;
count__34759_34767 = G__34784;
i__34760_34768 = G__34785;
continue;
}
} else {
}
}
break;
}

var G__34786 = seq__34753;
var G__34787 = chunk__34754;
var G__34788 = count__34755;
var G__34789 = (i__34756 + (1));
seq__34753 = G__34786;
chunk__34754 = G__34787;
count__34755 = G__34788;
i__34756 = G__34789;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__34753);
if(temp__6753__auto__){
var seq__34753__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34753__$1)){
var c__27647__auto__ = cljs.core.chunk_first.call(null,seq__34753__$1);
var G__34790 = cljs.core.chunk_rest.call(null,seq__34753__$1);
var G__34791 = c__27647__auto__;
var G__34792 = cljs.core.count.call(null,c__27647__auto__);
var G__34793 = (0);
seq__34753 = G__34790;
chunk__34754 = G__34791;
count__34755 = G__34792;
i__34756 = G__34793;
continue;
} else {
var prov = cljs.core.first.call(null,seq__34753__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34761_34794 = cljs.core.seq.call(null,requires);
var chunk__34762_34795 = null;
var count__34763_34796 = (0);
var i__34764_34797 = (0);
while(true){
if((i__34764_34797 < count__34763_34796)){
var req_34798 = cljs.core._nth.call(null,chunk__34762_34795,i__34764_34797);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34798,prov);

var G__34799 = seq__34761_34794;
var G__34800 = chunk__34762_34795;
var G__34801 = count__34763_34796;
var G__34802 = (i__34764_34797 + (1));
seq__34761_34794 = G__34799;
chunk__34762_34795 = G__34800;
count__34763_34796 = G__34801;
i__34764_34797 = G__34802;
continue;
} else {
var temp__6753__auto___34803__$1 = cljs.core.seq.call(null,seq__34761_34794);
if(temp__6753__auto___34803__$1){
var seq__34761_34804__$1 = temp__6753__auto___34803__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34761_34804__$1)){
var c__27647__auto___34805 = cljs.core.chunk_first.call(null,seq__34761_34804__$1);
var G__34806 = cljs.core.chunk_rest.call(null,seq__34761_34804__$1);
var G__34807 = c__27647__auto___34805;
var G__34808 = cljs.core.count.call(null,c__27647__auto___34805);
var G__34809 = (0);
seq__34761_34794 = G__34806;
chunk__34762_34795 = G__34807;
count__34763_34796 = G__34808;
i__34764_34797 = G__34809;
continue;
} else {
var req_34810 = cljs.core.first.call(null,seq__34761_34804__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34810,prov);

var G__34811 = cljs.core.next.call(null,seq__34761_34804__$1);
var G__34812 = null;
var G__34813 = (0);
var G__34814 = (0);
seq__34761_34794 = G__34811;
chunk__34762_34795 = G__34812;
count__34763_34796 = G__34813;
i__34764_34797 = G__34814;
continue;
}
} else {
}
}
break;
}

var G__34815 = cljs.core.next.call(null,seq__34753__$1);
var G__34816 = null;
var G__34817 = (0);
var G__34818 = (0);
seq__34753 = G__34815;
chunk__34754 = G__34816;
count__34755 = G__34817;
i__34756 = G__34818;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__34823_34827 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__34824_34828 = null;
var count__34825_34829 = (0);
var i__34826_34830 = (0);
while(true){
if((i__34826_34830 < count__34825_34829)){
var ns_34831 = cljs.core._nth.call(null,chunk__34824_34828,i__34826_34830);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34831);

var G__34832 = seq__34823_34827;
var G__34833 = chunk__34824_34828;
var G__34834 = count__34825_34829;
var G__34835 = (i__34826_34830 + (1));
seq__34823_34827 = G__34832;
chunk__34824_34828 = G__34833;
count__34825_34829 = G__34834;
i__34826_34830 = G__34835;
continue;
} else {
var temp__6753__auto___34836 = cljs.core.seq.call(null,seq__34823_34827);
if(temp__6753__auto___34836){
var seq__34823_34837__$1 = temp__6753__auto___34836;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34823_34837__$1)){
var c__27647__auto___34838 = cljs.core.chunk_first.call(null,seq__34823_34837__$1);
var G__34839 = cljs.core.chunk_rest.call(null,seq__34823_34837__$1);
var G__34840 = c__27647__auto___34838;
var G__34841 = cljs.core.count.call(null,c__27647__auto___34838);
var G__34842 = (0);
seq__34823_34827 = G__34839;
chunk__34824_34828 = G__34840;
count__34825_34829 = G__34841;
i__34826_34830 = G__34842;
continue;
} else {
var ns_34843 = cljs.core.first.call(null,seq__34823_34837__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34843);

var G__34844 = cljs.core.next.call(null,seq__34823_34837__$1);
var G__34845 = null;
var G__34846 = (0);
var G__34847 = (0);
seq__34823_34827 = G__34844;
chunk__34824_34828 = G__34845;
count__34825_34829 = G__34846;
i__34826_34830 = G__34847;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__26741__auto__ = goog.require__;
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__34848__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__34848 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34849__i = 0, G__34849__a = new Array(arguments.length -  0);
while (G__34849__i < G__34849__a.length) {G__34849__a[G__34849__i] = arguments[G__34849__i + 0]; ++G__34849__i;}
  args = new cljs.core.IndexedSeq(G__34849__a,0);
} 
return G__34848__delegate.call(this,args);};
G__34848.cljs$lang$maxFixedArity = 0;
G__34848.cljs$lang$applyTo = (function (arglist__34850){
var args = cljs.core.seq(arglist__34850);
return G__34848__delegate(args);
});
G__34848.cljs$core$IFn$_invoke$arity$variadic = G__34848__delegate;
return G__34848;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__34851 = cljs.core._EQ_;
var expr__34852 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__34851.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__34852))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str(node_path_lib.sep),cljs.core.str(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__34851,expr__34852){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__34851,expr__34852))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__34851,expr__34852){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e34854){if((e34854 instanceof Error)){
var e = e34854;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34854;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__34851,expr__34852))
} else {
if(cljs.core.truth_(pred__34851.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__34852))){
return ((function (pred__34851,expr__34852){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__34851,expr__34852){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__34851,expr__34852))
);

return deferred.addErrback(((function (deferred,pred__34851,expr__34852){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__34851,expr__34852))
);
});
;})(pred__34851,expr__34852))
} else {
if(cljs.core.truth_(pred__34851.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__34852))){
return ((function (pred__34851,expr__34852){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e34855){if((e34855 instanceof Error)){
var e = e34855;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34855;

}
}})());
});
;})(pred__34851,expr__34852))
} else {
return ((function (pred__34851,expr__34852){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__34851,expr__34852))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__34856,callback){
var map__34859 = p__34856;
var map__34859__$1 = ((((!((map__34859 == null)))?((((map__34859.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34859.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34859):map__34859);
var file_msg = map__34859__$1;
var request_url = cljs.core.get.call(null,map__34859__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__34859,map__34859__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__34859,map__34859__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__){
return (function (state_34883){
var state_val_34884 = (state_34883[(1)]);
if((state_val_34884 === (7))){
var inst_34879 = (state_34883[(2)]);
var state_34883__$1 = state_34883;
var statearr_34885_34905 = state_34883__$1;
(statearr_34885_34905[(2)] = inst_34879);

(statearr_34885_34905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34884 === (1))){
var state_34883__$1 = state_34883;
var statearr_34886_34906 = state_34883__$1;
(statearr_34886_34906[(2)] = null);

(statearr_34886_34906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34884 === (4))){
var inst_34863 = (state_34883[(7)]);
var inst_34863__$1 = (state_34883[(2)]);
var state_34883__$1 = (function (){var statearr_34887 = state_34883;
(statearr_34887[(7)] = inst_34863__$1);

return statearr_34887;
})();
if(cljs.core.truth_(inst_34863__$1)){
var statearr_34888_34907 = state_34883__$1;
(statearr_34888_34907[(1)] = (5));

} else {
var statearr_34889_34908 = state_34883__$1;
(statearr_34889_34908[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34884 === (6))){
var state_34883__$1 = state_34883;
var statearr_34890_34909 = state_34883__$1;
(statearr_34890_34909[(2)] = null);

(statearr_34890_34909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34884 === (3))){
var inst_34881 = (state_34883[(2)]);
var state_34883__$1 = state_34883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34883__$1,inst_34881);
} else {
if((state_val_34884 === (2))){
var state_34883__$1 = state_34883;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34883__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_34884 === (11))){
var inst_34875 = (state_34883[(2)]);
var state_34883__$1 = (function (){var statearr_34891 = state_34883;
(statearr_34891[(8)] = inst_34875);

return statearr_34891;
})();
var statearr_34892_34910 = state_34883__$1;
(statearr_34892_34910[(2)] = null);

(statearr_34892_34910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34884 === (9))){
var inst_34869 = (state_34883[(9)]);
var inst_34867 = (state_34883[(10)]);
var inst_34871 = inst_34869.call(null,inst_34867);
var state_34883__$1 = state_34883;
var statearr_34893_34911 = state_34883__$1;
(statearr_34893_34911[(2)] = inst_34871);

(statearr_34893_34911[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34884 === (5))){
var inst_34863 = (state_34883[(7)]);
var inst_34865 = figwheel.client.file_reloading.blocking_load.call(null,inst_34863);
var state_34883__$1 = state_34883;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34883__$1,(8),inst_34865);
} else {
if((state_val_34884 === (10))){
var inst_34867 = (state_34883[(10)]);
var inst_34873 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_34867);
var state_34883__$1 = state_34883;
var statearr_34894_34912 = state_34883__$1;
(statearr_34894_34912[(2)] = inst_34873);

(statearr_34894_34912[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34884 === (8))){
var inst_34863 = (state_34883[(7)]);
var inst_34869 = (state_34883[(9)]);
var inst_34867 = (state_34883[(2)]);
var inst_34868 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_34869__$1 = cljs.core.get.call(null,inst_34868,inst_34863);
var state_34883__$1 = (function (){var statearr_34895 = state_34883;
(statearr_34895[(9)] = inst_34869__$1);

(statearr_34895[(10)] = inst_34867);

return statearr_34895;
})();
if(cljs.core.truth_(inst_34869__$1)){
var statearr_34896_34913 = state_34883__$1;
(statearr_34896_34913[(1)] = (9));

} else {
var statearr_34897_34914 = state_34883__$1;
(statearr_34897_34914[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto__))
;
return ((function (switch__29920__auto__,c__30034__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__29921__auto__ = null;
var figwheel$client$file_reloading$state_machine__29921__auto____0 = (function (){
var statearr_34901 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34901[(0)] = figwheel$client$file_reloading$state_machine__29921__auto__);

(statearr_34901[(1)] = (1));

return statearr_34901;
});
var figwheel$client$file_reloading$state_machine__29921__auto____1 = (function (state_34883){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_34883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e34902){if((e34902 instanceof Object)){
var ex__29924__auto__ = e34902;
var statearr_34903_34915 = state_34883;
(statearr_34903_34915[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34883);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34902;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34916 = state_34883;
state_34883 = G__34916;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__29921__auto__ = function(state_34883){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__29921__auto____1.call(this,state_34883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__29921__auto____0;
figwheel$client$file_reloading$state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__29921__auto____1;
return figwheel$client$file_reloading$state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__))
})();
var state__30036__auto__ = (function (){var statearr_34904 = f__30035__auto__.call(null);
(statearr_34904[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_34904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__))
);

return c__30034__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__34917,callback){
var map__34920 = p__34917;
var map__34920__$1 = ((((!((map__34920 == null)))?((((map__34920.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34920.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34920):map__34920);
var file_msg = map__34920__$1;
var namespace = cljs.core.get.call(null,map__34920__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__34920,map__34920__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__34920,map__34920__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__34922){
var map__34925 = p__34922;
var map__34925__$1 = ((((!((map__34925 == null)))?((((map__34925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34925.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34925):map__34925);
var file_msg = map__34925__$1;
var namespace = cljs.core.get.call(null,map__34925__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__34927){
var map__34930 = p__34927;
var map__34930__$1 = ((((!((map__34930 == null)))?((((map__34930.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34930.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34930):map__34930);
var file_msg = map__34930__$1;
var namespace = cljs.core.get.call(null,map__34930__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__26729__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__26729__auto__){
var or__26741__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
var or__26741__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__26741__auto____$1)){
return or__26741__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__26729__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__34932,callback){
var map__34935 = p__34932;
var map__34935__$1 = ((((!((map__34935 == null)))?((((map__34935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34935.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34935):map__34935);
var file_msg = map__34935__$1;
var request_url = cljs.core.get.call(null,map__34935__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__34935__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30034__auto___35039 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto___35039,out){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto___35039,out){
return (function (state_35021){
var state_val_35022 = (state_35021[(1)]);
if((state_val_35022 === (1))){
var inst_34995 = cljs.core.seq.call(null,files);
var inst_34996 = cljs.core.first.call(null,inst_34995);
var inst_34997 = cljs.core.next.call(null,inst_34995);
var inst_34998 = files;
var state_35021__$1 = (function (){var statearr_35023 = state_35021;
(statearr_35023[(7)] = inst_34997);

(statearr_35023[(8)] = inst_34996);

(statearr_35023[(9)] = inst_34998);

return statearr_35023;
})();
var statearr_35024_35040 = state_35021__$1;
(statearr_35024_35040[(2)] = null);

(statearr_35024_35040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (2))){
var inst_35004 = (state_35021[(10)]);
var inst_34998 = (state_35021[(9)]);
var inst_35003 = cljs.core.seq.call(null,inst_34998);
var inst_35004__$1 = cljs.core.first.call(null,inst_35003);
var inst_35005 = cljs.core.next.call(null,inst_35003);
var inst_35006 = (inst_35004__$1 == null);
var inst_35007 = cljs.core.not.call(null,inst_35006);
var state_35021__$1 = (function (){var statearr_35025 = state_35021;
(statearr_35025[(10)] = inst_35004__$1);

(statearr_35025[(11)] = inst_35005);

return statearr_35025;
})();
if(inst_35007){
var statearr_35026_35041 = state_35021__$1;
(statearr_35026_35041[(1)] = (4));

} else {
var statearr_35027_35042 = state_35021__$1;
(statearr_35027_35042[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (3))){
var inst_35019 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35021__$1,inst_35019);
} else {
if((state_val_35022 === (4))){
var inst_35004 = (state_35021[(10)]);
var inst_35009 = figwheel.client.file_reloading.reload_js_file.call(null,inst_35004);
var state_35021__$1 = state_35021;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35021__$1,(7),inst_35009);
} else {
if((state_val_35022 === (5))){
var inst_35015 = cljs.core.async.close_BANG_.call(null,out);
var state_35021__$1 = state_35021;
var statearr_35028_35043 = state_35021__$1;
(statearr_35028_35043[(2)] = inst_35015);

(statearr_35028_35043[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (6))){
var inst_35017 = (state_35021[(2)]);
var state_35021__$1 = state_35021;
var statearr_35029_35044 = state_35021__$1;
(statearr_35029_35044[(2)] = inst_35017);

(statearr_35029_35044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35022 === (7))){
var inst_35005 = (state_35021[(11)]);
var inst_35011 = (state_35021[(2)]);
var inst_35012 = cljs.core.async.put_BANG_.call(null,out,inst_35011);
var inst_34998 = inst_35005;
var state_35021__$1 = (function (){var statearr_35030 = state_35021;
(statearr_35030[(12)] = inst_35012);

(statearr_35030[(9)] = inst_34998);

return statearr_35030;
})();
var statearr_35031_35045 = state_35021__$1;
(statearr_35031_35045[(2)] = null);

(statearr_35031_35045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30034__auto___35039,out))
;
return ((function (switch__29920__auto__,c__30034__auto___35039,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto____0 = (function (){
var statearr_35035 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35035[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto__);

(statearr_35035[(1)] = (1));

return statearr_35035;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto____1 = (function (state_35021){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_35021);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e35036){if((e35036 instanceof Object)){
var ex__29924__auto__ = e35036;
var statearr_35037_35046 = state_35021;
(statearr_35037_35046[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35021);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35036;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35047 = state_35021;
state_35021 = G__35047;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto__ = function(state_35021){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto____1.call(this,state_35021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto___35039,out))
})();
var state__30036__auto__ = (function (){var statearr_35038 = f__30035__auto__.call(null);
(statearr_35038[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto___35039);

return statearr_35038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto___35039,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__35048,opts){
var map__35052 = p__35048;
var map__35052__$1 = ((((!((map__35052 == null)))?((((map__35052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35052.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35052):map__35052);
var eval_body = cljs.core.get.call(null,map__35052__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__35052__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__26729__auto__ = eval_body;
if(cljs.core.truth_(and__26729__auto__)){
return typeof eval_body === 'string';
} else {
return and__26729__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e35054){var e = e35054;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__35055_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35055_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__35064){
var vec__35065 = p__35064;
var k = cljs.core.nth.call(null,vec__35065,(0),null);
var v = cljs.core.nth.call(null,vec__35065,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__35068){
var vec__35069 = p__35068;
var k = cljs.core.nth.call(null,vec__35069,(0),null);
var v = cljs.core.nth.call(null,vec__35069,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__35075,p__35076){
var map__35324 = p__35075;
var map__35324__$1 = ((((!((map__35324 == null)))?((((map__35324.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35324.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35324):map__35324);
var opts = map__35324__$1;
var before_jsload = cljs.core.get.call(null,map__35324__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__35324__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__35324__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__35325 = p__35076;
var map__35325__$1 = ((((!((map__35325 == null)))?((((map__35325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35325.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35325):map__35325);
var msg = map__35325__$1;
var files = cljs.core.get.call(null,map__35325__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__35325__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__35325__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30034__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30035__auto__ = (function (){var switch__29920__auto__ = ((function (c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_35479){
var state_val_35480 = (state_35479[(1)]);
if((state_val_35480 === (7))){
var inst_35342 = (state_35479[(7)]);
var inst_35341 = (state_35479[(8)]);
var inst_35340 = (state_35479[(9)]);
var inst_35339 = (state_35479[(10)]);
var inst_35347 = cljs.core._nth.call(null,inst_35340,inst_35342);
var inst_35348 = figwheel.client.file_reloading.eval_body.call(null,inst_35347,opts);
var inst_35349 = (inst_35342 + (1));
var tmp35481 = inst_35341;
var tmp35482 = inst_35340;
var tmp35483 = inst_35339;
var inst_35339__$1 = tmp35483;
var inst_35340__$1 = tmp35482;
var inst_35341__$1 = tmp35481;
var inst_35342__$1 = inst_35349;
var state_35479__$1 = (function (){var statearr_35484 = state_35479;
(statearr_35484[(7)] = inst_35342__$1);

(statearr_35484[(8)] = inst_35341__$1);

(statearr_35484[(11)] = inst_35348);

(statearr_35484[(9)] = inst_35340__$1);

(statearr_35484[(10)] = inst_35339__$1);

return statearr_35484;
})();
var statearr_35485_35571 = state_35479__$1;
(statearr_35485_35571[(2)] = null);

(statearr_35485_35571[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (20))){
var inst_35382 = (state_35479[(12)]);
var inst_35390 = figwheel.client.file_reloading.sort_files.call(null,inst_35382);
var state_35479__$1 = state_35479;
var statearr_35486_35572 = state_35479__$1;
(statearr_35486_35572[(2)] = inst_35390);

(statearr_35486_35572[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (27))){
var state_35479__$1 = state_35479;
var statearr_35487_35573 = state_35479__$1;
(statearr_35487_35573[(2)] = null);

(statearr_35487_35573[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (1))){
var inst_35331 = (state_35479[(13)]);
var inst_35328 = before_jsload.call(null,files);
var inst_35329 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_35330 = (function (){return ((function (inst_35331,inst_35328,inst_35329,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35072_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35072_SHARP_);
});
;})(inst_35331,inst_35328,inst_35329,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35331__$1 = cljs.core.filter.call(null,inst_35330,files);
var inst_35332 = cljs.core.not_empty.call(null,inst_35331__$1);
var state_35479__$1 = (function (){var statearr_35488 = state_35479;
(statearr_35488[(14)] = inst_35329);

(statearr_35488[(13)] = inst_35331__$1);

(statearr_35488[(15)] = inst_35328);

return statearr_35488;
})();
if(cljs.core.truth_(inst_35332)){
var statearr_35489_35574 = state_35479__$1;
(statearr_35489_35574[(1)] = (2));

} else {
var statearr_35490_35575 = state_35479__$1;
(statearr_35490_35575[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (24))){
var state_35479__$1 = state_35479;
var statearr_35491_35576 = state_35479__$1;
(statearr_35491_35576[(2)] = null);

(statearr_35491_35576[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (39))){
var inst_35432 = (state_35479[(16)]);
var state_35479__$1 = state_35479;
var statearr_35492_35577 = state_35479__$1;
(statearr_35492_35577[(2)] = inst_35432);

(statearr_35492_35577[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (46))){
var inst_35474 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
var statearr_35493_35578 = state_35479__$1;
(statearr_35493_35578[(2)] = inst_35474);

(statearr_35493_35578[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (4))){
var inst_35376 = (state_35479[(2)]);
var inst_35377 = cljs.core.List.EMPTY;
var inst_35378 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_35377);
var inst_35379 = (function (){return ((function (inst_35376,inst_35377,inst_35378,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35073_SHARP_){
var and__26729__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__35073_SHARP_);
if(cljs.core.truth_(and__26729__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__35073_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__35073_SHARP_)));
} else {
return and__26729__auto__;
}
});
;})(inst_35376,inst_35377,inst_35378,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35380 = cljs.core.filter.call(null,inst_35379,files);
var inst_35381 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_35382 = cljs.core.concat.call(null,inst_35380,inst_35381);
var state_35479__$1 = (function (){var statearr_35494 = state_35479;
(statearr_35494[(17)] = inst_35376);

(statearr_35494[(18)] = inst_35378);

(statearr_35494[(12)] = inst_35382);

return statearr_35494;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_35495_35579 = state_35479__$1;
(statearr_35495_35579[(1)] = (16));

} else {
var statearr_35496_35580 = state_35479__$1;
(statearr_35496_35580[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (15))){
var inst_35366 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
var statearr_35497_35581 = state_35479__$1;
(statearr_35497_35581[(2)] = inst_35366);

(statearr_35497_35581[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (21))){
var inst_35392 = (state_35479[(19)]);
var inst_35392__$1 = (state_35479[(2)]);
var inst_35393 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_35392__$1);
var state_35479__$1 = (function (){var statearr_35498 = state_35479;
(statearr_35498[(19)] = inst_35392__$1);

return statearr_35498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35479__$1,(22),inst_35393);
} else {
if((state_val_35480 === (31))){
var inst_35477 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35479__$1,inst_35477);
} else {
if((state_val_35480 === (32))){
var inst_35432 = (state_35479[(16)]);
var inst_35437 = inst_35432.cljs$lang$protocol_mask$partition0$;
var inst_35438 = (inst_35437 & (64));
var inst_35439 = inst_35432.cljs$core$ISeq$;
var inst_35440 = (cljs.core.PROTOCOL_SENTINEL === inst_35439);
var inst_35441 = (inst_35438) || (inst_35440);
var state_35479__$1 = state_35479;
if(cljs.core.truth_(inst_35441)){
var statearr_35499_35582 = state_35479__$1;
(statearr_35499_35582[(1)] = (35));

} else {
var statearr_35500_35583 = state_35479__$1;
(statearr_35500_35583[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (40))){
var inst_35454 = (state_35479[(20)]);
var inst_35453 = (state_35479[(2)]);
var inst_35454__$1 = cljs.core.get.call(null,inst_35453,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_35455 = cljs.core.get.call(null,inst_35453,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_35456 = cljs.core.not_empty.call(null,inst_35454__$1);
var state_35479__$1 = (function (){var statearr_35501 = state_35479;
(statearr_35501[(20)] = inst_35454__$1);

(statearr_35501[(21)] = inst_35455);

return statearr_35501;
})();
if(cljs.core.truth_(inst_35456)){
var statearr_35502_35584 = state_35479__$1;
(statearr_35502_35584[(1)] = (41));

} else {
var statearr_35503_35585 = state_35479__$1;
(statearr_35503_35585[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (33))){
var state_35479__$1 = state_35479;
var statearr_35504_35586 = state_35479__$1;
(statearr_35504_35586[(2)] = false);

(statearr_35504_35586[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (13))){
var inst_35352 = (state_35479[(22)]);
var inst_35356 = cljs.core.chunk_first.call(null,inst_35352);
var inst_35357 = cljs.core.chunk_rest.call(null,inst_35352);
var inst_35358 = cljs.core.count.call(null,inst_35356);
var inst_35339 = inst_35357;
var inst_35340 = inst_35356;
var inst_35341 = inst_35358;
var inst_35342 = (0);
var state_35479__$1 = (function (){var statearr_35505 = state_35479;
(statearr_35505[(7)] = inst_35342);

(statearr_35505[(8)] = inst_35341);

(statearr_35505[(9)] = inst_35340);

(statearr_35505[(10)] = inst_35339);

return statearr_35505;
})();
var statearr_35506_35587 = state_35479__$1;
(statearr_35506_35587[(2)] = null);

(statearr_35506_35587[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (22))){
var inst_35396 = (state_35479[(23)]);
var inst_35395 = (state_35479[(24)]);
var inst_35392 = (state_35479[(19)]);
var inst_35400 = (state_35479[(25)]);
var inst_35395__$1 = (state_35479[(2)]);
var inst_35396__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_35395__$1);
var inst_35397 = (function (){var all_files = inst_35392;
var res_SINGLEQUOTE_ = inst_35395__$1;
var res = inst_35396__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_35396,inst_35395,inst_35392,inst_35400,inst_35395__$1,inst_35396__$1,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__35074_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__35074_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_35396,inst_35395,inst_35392,inst_35400,inst_35395__$1,inst_35396__$1,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35398 = cljs.core.filter.call(null,inst_35397,inst_35395__$1);
var inst_35399 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_35400__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_35399);
var inst_35401 = cljs.core.not_empty.call(null,inst_35400__$1);
var state_35479__$1 = (function (){var statearr_35507 = state_35479;
(statearr_35507[(23)] = inst_35396__$1);

(statearr_35507[(24)] = inst_35395__$1);

(statearr_35507[(26)] = inst_35398);

(statearr_35507[(25)] = inst_35400__$1);

return statearr_35507;
})();
if(cljs.core.truth_(inst_35401)){
var statearr_35508_35588 = state_35479__$1;
(statearr_35508_35588[(1)] = (23));

} else {
var statearr_35509_35589 = state_35479__$1;
(statearr_35509_35589[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (36))){
var state_35479__$1 = state_35479;
var statearr_35510_35590 = state_35479__$1;
(statearr_35510_35590[(2)] = false);

(statearr_35510_35590[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (41))){
var inst_35454 = (state_35479[(20)]);
var inst_35458 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_35459 = cljs.core.map.call(null,inst_35458,inst_35454);
var inst_35460 = cljs.core.pr_str.call(null,inst_35459);
var inst_35461 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_35460)].join('');
var inst_35462 = figwheel.client.utils.log.call(null,inst_35461);
var state_35479__$1 = state_35479;
var statearr_35511_35591 = state_35479__$1;
(statearr_35511_35591[(2)] = inst_35462);

(statearr_35511_35591[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (43))){
var inst_35455 = (state_35479[(21)]);
var inst_35465 = (state_35479[(2)]);
var inst_35466 = cljs.core.not_empty.call(null,inst_35455);
var state_35479__$1 = (function (){var statearr_35512 = state_35479;
(statearr_35512[(27)] = inst_35465);

return statearr_35512;
})();
if(cljs.core.truth_(inst_35466)){
var statearr_35513_35592 = state_35479__$1;
(statearr_35513_35592[(1)] = (44));

} else {
var statearr_35514_35593 = state_35479__$1;
(statearr_35514_35593[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (29))){
var inst_35396 = (state_35479[(23)]);
var inst_35395 = (state_35479[(24)]);
var inst_35398 = (state_35479[(26)]);
var inst_35432 = (state_35479[(16)]);
var inst_35392 = (state_35479[(19)]);
var inst_35400 = (state_35479[(25)]);
var inst_35428 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_35431 = (function (){var all_files = inst_35392;
var res_SINGLEQUOTE_ = inst_35395;
var res = inst_35396;
var files_not_loaded = inst_35398;
var dependencies_that_loaded = inst_35400;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35432,inst_35392,inst_35400,inst_35428,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35430){
var map__35515 = p__35430;
var map__35515__$1 = ((((!((map__35515 == null)))?((((map__35515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35515.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35515):map__35515);
var namespace = cljs.core.get.call(null,map__35515__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35432,inst_35392,inst_35400,inst_35428,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35432__$1 = cljs.core.group_by.call(null,inst_35431,inst_35398);
var inst_35434 = (inst_35432__$1 == null);
var inst_35435 = cljs.core.not.call(null,inst_35434);
var state_35479__$1 = (function (){var statearr_35517 = state_35479;
(statearr_35517[(28)] = inst_35428);

(statearr_35517[(16)] = inst_35432__$1);

return statearr_35517;
})();
if(inst_35435){
var statearr_35518_35594 = state_35479__$1;
(statearr_35518_35594[(1)] = (32));

} else {
var statearr_35519_35595 = state_35479__$1;
(statearr_35519_35595[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (44))){
var inst_35455 = (state_35479[(21)]);
var inst_35468 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_35455);
var inst_35469 = cljs.core.pr_str.call(null,inst_35468);
var inst_35470 = [cljs.core.str("not required: "),cljs.core.str(inst_35469)].join('');
var inst_35471 = figwheel.client.utils.log.call(null,inst_35470);
var state_35479__$1 = state_35479;
var statearr_35520_35596 = state_35479__$1;
(statearr_35520_35596[(2)] = inst_35471);

(statearr_35520_35596[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (6))){
var inst_35373 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
var statearr_35521_35597 = state_35479__$1;
(statearr_35521_35597[(2)] = inst_35373);

(statearr_35521_35597[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (28))){
var inst_35398 = (state_35479[(26)]);
var inst_35425 = (state_35479[(2)]);
var inst_35426 = cljs.core.not_empty.call(null,inst_35398);
var state_35479__$1 = (function (){var statearr_35522 = state_35479;
(statearr_35522[(29)] = inst_35425);

return statearr_35522;
})();
if(cljs.core.truth_(inst_35426)){
var statearr_35523_35598 = state_35479__$1;
(statearr_35523_35598[(1)] = (29));

} else {
var statearr_35524_35599 = state_35479__$1;
(statearr_35524_35599[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (25))){
var inst_35396 = (state_35479[(23)]);
var inst_35412 = (state_35479[(2)]);
var inst_35413 = cljs.core.not_empty.call(null,inst_35396);
var state_35479__$1 = (function (){var statearr_35525 = state_35479;
(statearr_35525[(30)] = inst_35412);

return statearr_35525;
})();
if(cljs.core.truth_(inst_35413)){
var statearr_35526_35600 = state_35479__$1;
(statearr_35526_35600[(1)] = (26));

} else {
var statearr_35527_35601 = state_35479__$1;
(statearr_35527_35601[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (34))){
var inst_35448 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
if(cljs.core.truth_(inst_35448)){
var statearr_35528_35602 = state_35479__$1;
(statearr_35528_35602[(1)] = (38));

} else {
var statearr_35529_35603 = state_35479__$1;
(statearr_35529_35603[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (17))){
var state_35479__$1 = state_35479;
var statearr_35530_35604 = state_35479__$1;
(statearr_35530_35604[(2)] = recompile_dependents);

(statearr_35530_35604[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (3))){
var state_35479__$1 = state_35479;
var statearr_35531_35605 = state_35479__$1;
(statearr_35531_35605[(2)] = null);

(statearr_35531_35605[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (12))){
var inst_35369 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
var statearr_35532_35606 = state_35479__$1;
(statearr_35532_35606[(2)] = inst_35369);

(statearr_35532_35606[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (2))){
var inst_35331 = (state_35479[(13)]);
var inst_35338 = cljs.core.seq.call(null,inst_35331);
var inst_35339 = inst_35338;
var inst_35340 = null;
var inst_35341 = (0);
var inst_35342 = (0);
var state_35479__$1 = (function (){var statearr_35533 = state_35479;
(statearr_35533[(7)] = inst_35342);

(statearr_35533[(8)] = inst_35341);

(statearr_35533[(9)] = inst_35340);

(statearr_35533[(10)] = inst_35339);

return statearr_35533;
})();
var statearr_35534_35607 = state_35479__$1;
(statearr_35534_35607[(2)] = null);

(statearr_35534_35607[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (23))){
var inst_35396 = (state_35479[(23)]);
var inst_35395 = (state_35479[(24)]);
var inst_35398 = (state_35479[(26)]);
var inst_35392 = (state_35479[(19)]);
var inst_35400 = (state_35479[(25)]);
var inst_35403 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_35405 = (function (){var all_files = inst_35392;
var res_SINGLEQUOTE_ = inst_35395;
var res = inst_35396;
var files_not_loaded = inst_35398;
var dependencies_that_loaded = inst_35400;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35392,inst_35400,inst_35403,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35404){
var map__35535 = p__35404;
var map__35535__$1 = ((((!((map__35535 == null)))?((((map__35535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35535.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35535):map__35535);
var request_url = cljs.core.get.call(null,map__35535__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35392,inst_35400,inst_35403,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35406 = cljs.core.reverse.call(null,inst_35400);
var inst_35407 = cljs.core.map.call(null,inst_35405,inst_35406);
var inst_35408 = cljs.core.pr_str.call(null,inst_35407);
var inst_35409 = figwheel.client.utils.log.call(null,inst_35408);
var state_35479__$1 = (function (){var statearr_35537 = state_35479;
(statearr_35537[(31)] = inst_35403);

return statearr_35537;
})();
var statearr_35538_35608 = state_35479__$1;
(statearr_35538_35608[(2)] = inst_35409);

(statearr_35538_35608[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (35))){
var state_35479__$1 = state_35479;
var statearr_35539_35609 = state_35479__$1;
(statearr_35539_35609[(2)] = true);

(statearr_35539_35609[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (19))){
var inst_35382 = (state_35479[(12)]);
var inst_35388 = figwheel.client.file_reloading.expand_files.call(null,inst_35382);
var state_35479__$1 = state_35479;
var statearr_35540_35610 = state_35479__$1;
(statearr_35540_35610[(2)] = inst_35388);

(statearr_35540_35610[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (11))){
var state_35479__$1 = state_35479;
var statearr_35541_35611 = state_35479__$1;
(statearr_35541_35611[(2)] = null);

(statearr_35541_35611[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (9))){
var inst_35371 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
var statearr_35542_35612 = state_35479__$1;
(statearr_35542_35612[(2)] = inst_35371);

(statearr_35542_35612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (5))){
var inst_35342 = (state_35479[(7)]);
var inst_35341 = (state_35479[(8)]);
var inst_35344 = (inst_35342 < inst_35341);
var inst_35345 = inst_35344;
var state_35479__$1 = state_35479;
if(cljs.core.truth_(inst_35345)){
var statearr_35543_35613 = state_35479__$1;
(statearr_35543_35613[(1)] = (7));

} else {
var statearr_35544_35614 = state_35479__$1;
(statearr_35544_35614[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (14))){
var inst_35352 = (state_35479[(22)]);
var inst_35361 = cljs.core.first.call(null,inst_35352);
var inst_35362 = figwheel.client.file_reloading.eval_body.call(null,inst_35361,opts);
var inst_35363 = cljs.core.next.call(null,inst_35352);
var inst_35339 = inst_35363;
var inst_35340 = null;
var inst_35341 = (0);
var inst_35342 = (0);
var state_35479__$1 = (function (){var statearr_35545 = state_35479;
(statearr_35545[(7)] = inst_35342);

(statearr_35545[(8)] = inst_35341);

(statearr_35545[(32)] = inst_35362);

(statearr_35545[(9)] = inst_35340);

(statearr_35545[(10)] = inst_35339);

return statearr_35545;
})();
var statearr_35546_35615 = state_35479__$1;
(statearr_35546_35615[(2)] = null);

(statearr_35546_35615[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (45))){
var state_35479__$1 = state_35479;
var statearr_35547_35616 = state_35479__$1;
(statearr_35547_35616[(2)] = null);

(statearr_35547_35616[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (26))){
var inst_35396 = (state_35479[(23)]);
var inst_35395 = (state_35479[(24)]);
var inst_35398 = (state_35479[(26)]);
var inst_35392 = (state_35479[(19)]);
var inst_35400 = (state_35479[(25)]);
var inst_35415 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_35417 = (function (){var all_files = inst_35392;
var res_SINGLEQUOTE_ = inst_35395;
var res = inst_35396;
var files_not_loaded = inst_35398;
var dependencies_that_loaded = inst_35400;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35392,inst_35400,inst_35415,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__35416){
var map__35548 = p__35416;
var map__35548__$1 = ((((!((map__35548 == null)))?((((map__35548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35548.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35548):map__35548);
var namespace = cljs.core.get.call(null,map__35548__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__35548__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35392,inst_35400,inst_35415,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35418 = cljs.core.map.call(null,inst_35417,inst_35396);
var inst_35419 = cljs.core.pr_str.call(null,inst_35418);
var inst_35420 = figwheel.client.utils.log.call(null,inst_35419);
var inst_35421 = (function (){var all_files = inst_35392;
var res_SINGLEQUOTE_ = inst_35395;
var res = inst_35396;
var files_not_loaded = inst_35398;
var dependencies_that_loaded = inst_35400;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35392,inst_35400,inst_35415,inst_35417,inst_35418,inst_35419,inst_35420,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_35396,inst_35395,inst_35398,inst_35392,inst_35400,inst_35415,inst_35417,inst_35418,inst_35419,inst_35420,state_val_35480,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_35422 = setTimeout(inst_35421,(10));
var state_35479__$1 = (function (){var statearr_35550 = state_35479;
(statearr_35550[(33)] = inst_35415);

(statearr_35550[(34)] = inst_35420);

return statearr_35550;
})();
var statearr_35551_35617 = state_35479__$1;
(statearr_35551_35617[(2)] = inst_35422);

(statearr_35551_35617[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (16))){
var state_35479__$1 = state_35479;
var statearr_35552_35618 = state_35479__$1;
(statearr_35552_35618[(2)] = reload_dependents);

(statearr_35552_35618[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (38))){
var inst_35432 = (state_35479[(16)]);
var inst_35450 = cljs.core.apply.call(null,cljs.core.hash_map,inst_35432);
var state_35479__$1 = state_35479;
var statearr_35553_35619 = state_35479__$1;
(statearr_35553_35619[(2)] = inst_35450);

(statearr_35553_35619[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (30))){
var state_35479__$1 = state_35479;
var statearr_35554_35620 = state_35479__$1;
(statearr_35554_35620[(2)] = null);

(statearr_35554_35620[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (10))){
var inst_35352 = (state_35479[(22)]);
var inst_35354 = cljs.core.chunked_seq_QMARK_.call(null,inst_35352);
var state_35479__$1 = state_35479;
if(inst_35354){
var statearr_35555_35621 = state_35479__$1;
(statearr_35555_35621[(1)] = (13));

} else {
var statearr_35556_35622 = state_35479__$1;
(statearr_35556_35622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (18))){
var inst_35386 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
if(cljs.core.truth_(inst_35386)){
var statearr_35557_35623 = state_35479__$1;
(statearr_35557_35623[(1)] = (19));

} else {
var statearr_35558_35624 = state_35479__$1;
(statearr_35558_35624[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (42))){
var state_35479__$1 = state_35479;
var statearr_35559_35625 = state_35479__$1;
(statearr_35559_35625[(2)] = null);

(statearr_35559_35625[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (37))){
var inst_35445 = (state_35479[(2)]);
var state_35479__$1 = state_35479;
var statearr_35560_35626 = state_35479__$1;
(statearr_35560_35626[(2)] = inst_35445);

(statearr_35560_35626[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35480 === (8))){
var inst_35352 = (state_35479[(22)]);
var inst_35339 = (state_35479[(10)]);
var inst_35352__$1 = cljs.core.seq.call(null,inst_35339);
var state_35479__$1 = (function (){var statearr_35561 = state_35479;
(statearr_35561[(22)] = inst_35352__$1);

return statearr_35561;
})();
if(inst_35352__$1){
var statearr_35562_35627 = state_35479__$1;
(statearr_35562_35627[(1)] = (10));

} else {
var statearr_35563_35628 = state_35479__$1;
(statearr_35563_35628[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__29920__auto__,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto____0 = (function (){
var statearr_35567 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35567[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto__);

(statearr_35567[(1)] = (1));

return statearr_35567;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto____1 = (function (state_35479){
while(true){
var ret_value__29922__auto__ = (function (){try{while(true){
var result__29923__auto__ = switch__29920__auto__.call(null,state_35479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29923__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29923__auto__;
}
break;
}
}catch (e35568){if((e35568 instanceof Object)){
var ex__29924__auto__ = e35568;
var statearr_35569_35629 = state_35479;
(statearr_35569_35629[(5)] = ex__29924__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35568;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29922__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35630 = state_35479;
state_35479 = G__35630;
continue;
} else {
return ret_value__29922__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto__ = function(state_35479){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto____1.call(this,state_35479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29921__auto__;
})()
;})(switch__29920__auto__,c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30036__auto__ = (function (){var statearr_35570 = f__30035__auto__.call(null);
(statearr_35570[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30034__auto__);

return statearr_35570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30036__auto__);
});})(c__30034__auto__,map__35324,map__35324__$1,opts,before_jsload,on_jsload,reload_dependents,map__35325,map__35325__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30034__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__35633,link){
var map__35636 = p__35633;
var map__35636__$1 = ((((!((map__35636 == null)))?((((map__35636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35636.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35636):map__35636);
var file = cljs.core.get.call(null,map__35636__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__35636,map__35636__$1,file){
return (function (p1__35631_SHARP_,p2__35632_SHARP_){
if(cljs.core._EQ_.call(null,p1__35631_SHARP_,p2__35632_SHARP_)){
return p1__35631_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__35636,map__35636__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__35642){
var map__35643 = p__35642;
var map__35643__$1 = ((((!((map__35643 == null)))?((((map__35643.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35643.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35643):map__35643);
var match_length = cljs.core.get.call(null,map__35643__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__35643__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__35638_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__35638_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__35645_SHARP_,p2__35646_SHARP_){
return cljs.core.assoc.call(null,p1__35645_SHARP_,cljs.core.get.call(null,p2__35646_SHARP_,key),p2__35646_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__6751__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6751__auto__)){
var link = temp__6751__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__6751__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__6751__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_35647 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_35647);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_35647);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__35648,p__35649){
var map__35654 = p__35648;
var map__35654__$1 = ((((!((map__35654 == null)))?((((map__35654.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35654.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35654):map__35654);
var on_cssload = cljs.core.get.call(null,map__35654__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__35655 = p__35649;
var map__35655__$1 = ((((!((map__35655 == null)))?((((map__35655.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35655.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35655):map__35655);
var files_msg = map__35655__$1;
var files = cljs.core.get.call(null,map__35655__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__6753__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__6753__auto__)){
var f_datas = temp__6753__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1489589602629