(ns line-tree.demo
  (:require [reagent.core :as r]
            [line-tree.table :as table]
            [line-tree.flex  :as flex]))

(defn node [text]
  [:div.node text])

(defn demo []
  [:div.tree-demo
    [:h1 "Line Tree Demo"]

    [:h2 "Table-based Tree"]
    [:h3 "Vertical"]
    [table/tree [node "A"]
      [[node "B"]
       [table/tree [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h3 "Horizontal"]
    [table/tree
      {:orientation :h
       :node [node "A"]
       :labels {:first "up" :last "down"}
       :branches
         [{:branch [node "B"]
           :labels {:first "B-up" :last "B-down"}}
          [table/tree
            {:orientation :h
             :node [node "C"]
             :labels {:first "only up"}
             :branches [[node "C1"] [node "C2"] [node "C3"]]}]
          [node "D"]]}]

    [:h2 "Flex-based Tree"]
    [:h3 "Vertical"]
    [flex/tree [node "A"]
      [[node "B"]
       [flex/tree [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h3 "Vertical (stretched)"]
    [flex/tree
      {:orientation :v
       :stretched? true
       :node [node "A"]
       :branches
         [[node "B"]
          [flex/tree [node "C"] [[node "C1"] [node "C2"] [node "C3"]]]
          [node "D"]]}]

    [:h3 "Horizontal"]
    [flex/tree
      {:orientation :h
       :node [node "A"]
       :labels {:first "up" :last "down"}
       :branches
         [{:branch [node "B"]
           :labels {:first "B-up" :last "B-down"}}
          [flex/tree
            {:orientation :h
             :node [node "C"]
             :labels {:first "only-up"}
             :branches [[node "C1"] [node "C2"] [node "C3"]]}]
          [node "D"]]}]

    [:h3 "Single/Zero Branch Cases"]
    [flex/tree [node "A"]
      [[flex/tree [node "B1"]
         [[flex/tree [node "C"] []]]]
       [node "B2"]]]])

(r/render [demo] (.getElementById js/document "app"))
