// Compiled by ClojureScript 1.9.293 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('reagent.impl.util');
goog.require('reagent.interop');
goog.require('reagent.ratom');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('cljsjs.react.dom');
goog.require('reagent.debug');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(cljs.core.some_QMARK_.call(null,reagent.dom.imported)){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__26741__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__26741__auto__)){
return or__26741__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_38256 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_38256){
return (function (){
var _STAR_always_update_STAR_38257 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(cljs.core.some_QMARK_.call(null,callback)){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_38257;
}});})(_STAR_always_update_STAR_38256))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_38256;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args38258 = [];
var len__27957__auto___38261 = arguments.length;
var i__27958__auto___38262 = (0);
while(true){
if((i__27958__auto___38262 < len__27957__auto___38261)){
args38258.push((arguments[i__27958__auto___38262]));

var G__38263 = (i__27958__auto___38262 + (1));
i__27958__auto___38262 = G__38263;
continue;
} else {
}
break;
}

var G__38260 = args38258.length;
switch (G__38260) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38258.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__38269_38273 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__38270_38274 = null;
var count__38271_38275 = (0);
var i__38272_38276 = (0);
while(true){
if((i__38272_38276 < count__38271_38275)){
var v_38277 = cljs.core._nth.call(null,chunk__38270_38274,i__38272_38276);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_38277);

var G__38278 = seq__38269_38273;
var G__38279 = chunk__38270_38274;
var G__38280 = count__38271_38275;
var G__38281 = (i__38272_38276 + (1));
seq__38269_38273 = G__38278;
chunk__38270_38274 = G__38279;
count__38271_38275 = G__38280;
i__38272_38276 = G__38281;
continue;
} else {
var temp__6753__auto___38282 = cljs.core.seq.call(null,seq__38269_38273);
if(temp__6753__auto___38282){
var seq__38269_38283__$1 = temp__6753__auto___38282;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38269_38283__$1)){
var c__27647__auto___38284 = cljs.core.chunk_first.call(null,seq__38269_38283__$1);
var G__38285 = cljs.core.chunk_rest.call(null,seq__38269_38283__$1);
var G__38286 = c__27647__auto___38284;
var G__38287 = cljs.core.count.call(null,c__27647__auto___38284);
var G__38288 = (0);
seq__38269_38273 = G__38285;
chunk__38270_38274 = G__38286;
count__38271_38275 = G__38287;
i__38272_38276 = G__38288;
continue;
} else {
var v_38289 = cljs.core.first.call(null,seq__38269_38283__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_38289);

var G__38290 = cljs.core.next.call(null,seq__38269_38283__$1);
var G__38291 = null;
var G__38292 = (0);
var G__38293 = (0);
seq__38269_38273 = G__38290;
chunk__38270_38274 = G__38291;
count__38271_38275 = G__38292;
i__38272_38276 = G__38293;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map?rel=1489589612415