(ns tree.demo
  (:require [reagent.core :as r]
            [tree.table-based :as table :refer [node]]
            [tree.flex-based :as flex]))

(defn demo []
  [:div.tree-demo
    [:h1 "Table-based Tree"]
    [:h2 "Vertical"]
    [table/tree [node "A"]
      [[node "B"]
       [table/tree [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h2 "Horizontal"]
    [table/tree :h [node "A"]
      [[node "B"]
       [table/tree :h [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h1 "Flex-based Tree"]
    [:h2 "Vertical"]
    [flex/tree :v [node "A"]
      [[node "B"]
       [flex/tree :v [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h2 "Horizontal"]
    [flex/tree :h [node "A"]
      [[node "B"]
       [flex/tree :h [node "C"]
         [[node "C1"] [node "C2"] [node "C3"]]]
       [node "D"]]]

    [:h2 "Uneven Tree"]
    [flex/tree :v [node "A"]
      [[flex/tree :v [node "B1"]
         [[flex/tree :v [node "C"] []]]]
       [node "B2"]]]])

(r/render [demo] (.getElementById js/document "app"))
