(ns tree.flex-based
  (:require [tree.table-based :refer [border-settings]]))

(defn link [orientation]
  (let [[l r] (get border-settings [orientation :link])]
    [:div.link {:class (name orientation)}
      [:div.cells
        [:div.line {:class l}]
        [:div.line {:class r}]]]))

(defn branch-head
  [orientation line]
  (let [[l r] (get border-settings [orientation line])]
    [:div.branch-head
      [:div.cells {:class (name line)}
        [:div.line {:class (str (name orientation) " " l)}]
        [:div.line {:class (str (name orientation) " " r)}]]]))

(defn branches [orientation sub-els]
  [:div.branches {:class (name orientation)}
    (map-indexed
      (fn [i el]
        [:div.branch
          [branch-head
            orientation
            (cond (= 1 (count sub-els)) :link
                  (= i 0) :first
                  (= i (-> sub-els count dec)) :last
                  :else :inner)]
          [:div.el el]])
      sub-els)])

(defn tree [orientation el sub-els]
  [:div.tree-flex {:class (name orientation)}
    [:div.el el]
    (when (seq sub-els) [link orientation])
    (when (seq sub-els) [branches orientation sub-els])])
