(ns tree.table-based)

(defn node [text]
  [:div.node text])

(def border-settings
  {[:v :link] ["t b l" "t r b l"]
   [:v :first] ["t r b l" "r b"]
   [:v :inner] ["b l" "b l r"]
   [:v :last]  ["l b" "t r b l"]

   [:h :link] ["t r l" "t r b l"]
   [:h :first] ["t r b l" "r b"]
   [:h :inner] ["t r" "t r b"]
   [:h :last]  ["r t" "t r b l"]})

(defn link
  ([] (link :v))
  ([orientation]
   (let [[l r] (get border-settings [orientation :link])]
     (case orientation
       :v [:table.link.v [:tr [:td.line {:class l}]
                              [:td.line {:class r}]]]
       :h [:table.link.h [:tr [:td.line {:class l}]]
                         [:tr [:td.line {:class r}]]]))))

(defn branch-head
  ([line] (branch-head :v line))
  ([orientation line]
   (let [[l r] (get border-settings [orientation line])]
     (case orientation
       :v [:table.branch-head.v {:class (name line)}
            [:tr [:td.line {:class l}]
                 [:td.line {:class r}]]]
       :h [:table.branch-head.h {:class (name line)}
            [:tr [:td.line {:class l}]]
            [:tr [:td.line {:class r}]]]))))

(defn branches
  ([sub-els] (branches :v sub-els))
  ([orientation sub-els]
   (let [[l r] sub-els]
     (case orientation
       :v [:table.branches.v
            [:tr
              (map-indexed
                (fn [i el]
                  [:td.branch
                    [branch-head
                      orientation
                      (cond (= i 0) :first
                            (= i (-> sub-els count dec)) :last
                            :else :inner)]
                    el])
                sub-els)]]
       :h [:table.branches.h
            (map-indexed
              (fn [i el]
                [:tr
                  [:td.branch
                  [branch-head
                    orientation
                    (cond (= i 0) :first
                          (= i (-> sub-els count dec)) :last
                          :else :inner)]]
                  [:td el]])
                sub-els)]))))

(defn tree
  ([el sub-els] (tree :v el sub-els))
  ([orientation el sub-els]
   (case orientation
     :v [:div.tree.v
          el
          [link orientation]
          [branches orientation sub-els]]
     :h [:table.tree.h
          [:tr
            [:td el]
            [:td [link orientation]]
            [:td [branches orientation sub-els]]]])))
