// Compiled by ClojureScript 1.9.456 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args30465 = [];
var len__28242__auto___30471 = arguments.length;
var i__28243__auto___30472 = (0);
while(true){
if((i__28243__auto___30472 < len__28242__auto___30471)){
args30465.push((arguments[i__28243__auto___30472]));

var G__30473 = (i__28243__auto___30472 + (1));
i__28243__auto___30472 = G__30473;
continue;
} else {
}
break;
}

var G__30467 = args30465.length;
switch (G__30467) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args30465.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async30468 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30468 = (function (f,blockable,meta30469){
this.f = f;
this.blockable = blockable;
this.meta30469 = meta30469;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30468.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30470,meta30469__$1){
var self__ = this;
var _30470__$1 = this;
return (new cljs.core.async.t_cljs$core$async30468(self__.f,self__.blockable,meta30469__$1));
});

cljs.core.async.t_cljs$core$async30468.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30470){
var self__ = this;
var _30470__$1 = this;
return self__.meta30469;
});

cljs.core.async.t_cljs$core$async30468.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30468.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30468.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async30468.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async30468.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30469","meta30469",318938703,null)], null);
});

cljs.core.async.t_cljs$core$async30468.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30468.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30468";

cljs.core.async.t_cljs$core$async30468.cljs$lang$ctorPrWriter = (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async30468");
});

cljs.core.async.__GT_t_cljs$core$async30468 = (function cljs$core$async$__GT_t_cljs$core$async30468(f__$1,blockable__$1,meta30469){
return (new cljs.core.async.t_cljs$core$async30468(f__$1,blockable__$1,meta30469));
});

}

return (new cljs.core.async.t_cljs$core$async30468(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args30477 = [];
var len__28242__auto___30480 = arguments.length;
var i__28243__auto___30481 = (0);
while(true){
if((i__28243__auto___30481 < len__28242__auto___30480)){
args30477.push((arguments[i__28243__auto___30481]));

var G__30482 = (i__28243__auto___30481 + (1));
i__28243__auto___30481 = G__30482;
continue;
} else {
}
break;
}

var G__30479 = args30477.length;
switch (G__30479) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args30477.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args30484 = [];
var len__28242__auto___30487 = arguments.length;
var i__28243__auto___30488 = (0);
while(true){
if((i__28243__auto___30488 < len__28242__auto___30487)){
args30484.push((arguments[i__28243__auto___30488]));

var G__30489 = (i__28243__auto___30488 + (1));
i__28243__auto___30488 = G__30489;
continue;
} else {
}
break;
}

var G__30486 = args30484.length;
switch (G__30486) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args30484.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args30491 = [];
var len__28242__auto___30494 = arguments.length;
var i__28243__auto___30495 = (0);
while(true){
if((i__28243__auto___30495 < len__28242__auto___30494)){
args30491.push((arguments[i__28243__auto___30495]));

var G__30496 = (i__28243__auto___30495 + (1));
i__28243__auto___30495 = G__30496;
continue;
} else {
}
break;
}

var G__30493 = args30491.length;
switch (G__30493) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args30491.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_30498 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_30498);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_30498,ret){
return (function (){
return fn1.call(null,val_30498);
});})(val_30498,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args30499 = [];
var len__28242__auto___30502 = arguments.length;
var i__28243__auto___30503 = (0);
while(true){
if((i__28243__auto___30503 < len__28242__auto___30502)){
args30499.push((arguments[i__28243__auto___30503]));

var G__30504 = (i__28243__auto___30503 + (1));
i__28243__auto___30503 = G__30504;
continue;
} else {
}
break;
}

var G__30501 = args30499.length;
switch (G__30501) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args30499.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28042__auto___30506 = n;
var x_30507 = (0);
while(true){
if((x_30507 < n__28042__auto___30506)){
(a[x_30507] = (0));

var G__30508 = (x_30507 + (1));
x_30507 = G__30508;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__30509 = (i + (1));
i = G__30509;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async30513 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30513 = (function (flag,meta30514){
this.flag = flag;
this.meta30514 = meta30514;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30513.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_30515,meta30514__$1){
var self__ = this;
var _30515__$1 = this;
return (new cljs.core.async.t_cljs$core$async30513(self__.flag,meta30514__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async30513.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_30515){
var self__ = this;
var _30515__$1 = this;
return self__.meta30514;
});})(flag))
;

cljs.core.async.t_cljs$core$async30513.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30513.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async30513.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30513.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async30513.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30514","meta30514",599981508,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async30513.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30513.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30513";

cljs.core.async.t_cljs$core$async30513.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async30513");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async30513 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async30513(flag__$1,meta30514){
return (new cljs.core.async.t_cljs$core$async30513(flag__$1,meta30514));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async30513(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async30519 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30519 = (function (flag,cb,meta30520){
this.flag = flag;
this.cb = cb;
this.meta30520 = meta30520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30521,meta30520__$1){
var self__ = this;
var _30521__$1 = this;
return (new cljs.core.async.t_cljs$core$async30519(self__.flag,self__.cb,meta30520__$1));
});

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30521){
var self__ = this;
var _30521__$1 = this;
return self__.meta30520;
});

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async30519.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async30519.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30520","meta30520",-1402435610,null)], null);
});

cljs.core.async.t_cljs$core$async30519.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30519.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30519";

cljs.core.async.t_cljs$core$async30519.cljs$lang$ctorPrWriter = (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async30519");
});

cljs.core.async.__GT_t_cljs$core$async30519 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async30519(flag__$1,cb__$1,meta30520){
return (new cljs.core.async.t_cljs$core$async30519(flag__$1,cb__$1,meta30520));
});

}

return (new cljs.core.async.t_cljs$core$async30519(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30522_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30522_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30523_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30523_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27021__auto__ = wport;
if(cljs.core.truth_(or__27021__auto__)){
return or__27021__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30524 = (i + (1));
i = G__30524;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27021__auto__ = ret;
if(cljs.core.truth_(or__27021__auto__)){
return or__27021__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__27009__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27009__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27009__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28249__auto__ = [];
var len__28242__auto___30530 = arguments.length;
var i__28243__auto___30531 = (0);
while(true){
if((i__28243__auto___30531 < len__28242__auto___30530)){
args__28249__auto__.push((arguments[i__28243__auto___30531]));

var G__30532 = (i__28243__auto___30531 + (1));
i__28243__auto___30531 = G__30532;
continue;
} else {
}
break;
}

var argseq__28250__auto__ = ((((1) < args__28249__auto__.length))?(new cljs.core.IndexedSeq(args__28249__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28250__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30527){
var map__30528 = p__30527;
var map__30528__$1 = ((((!((map__30528 == null)))?((((map__30528.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30528.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30528):map__30528);
var opts = map__30528__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30525){
var G__30526 = cljs.core.first.call(null,seq30525);
var seq30525__$1 = cljs.core.next.call(null,seq30525);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30526,seq30525__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args30533 = [];
var len__28242__auto___30583 = arguments.length;
var i__28243__auto___30584 = (0);
while(true){
if((i__28243__auto___30584 < len__28242__auto___30583)){
args30533.push((arguments[i__28243__auto___30584]));

var G__30585 = (i__28243__auto___30584 + (1));
i__28243__auto___30584 = G__30585;
continue;
} else {
}
break;
}

var G__30535 = args30533.length;
switch (G__30535) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args30533.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30406__auto___30587 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___30587){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___30587){
return (function (state_30559){
var state_val_30560 = (state_30559[(1)]);
if((state_val_30560 === (7))){
var inst_30555 = (state_30559[(2)]);
var state_30559__$1 = state_30559;
var statearr_30561_30588 = state_30559__$1;
(statearr_30561_30588[(2)] = inst_30555);

(statearr_30561_30588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (1))){
var state_30559__$1 = state_30559;
var statearr_30562_30589 = state_30559__$1;
(statearr_30562_30589[(2)] = null);

(statearr_30562_30589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (4))){
var inst_30538 = (state_30559[(7)]);
var inst_30538__$1 = (state_30559[(2)]);
var inst_30539 = (inst_30538__$1 == null);
var state_30559__$1 = (function (){var statearr_30563 = state_30559;
(statearr_30563[(7)] = inst_30538__$1);

return statearr_30563;
})();
if(cljs.core.truth_(inst_30539)){
var statearr_30564_30590 = state_30559__$1;
(statearr_30564_30590[(1)] = (5));

} else {
var statearr_30565_30591 = state_30559__$1;
(statearr_30565_30591[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (13))){
var state_30559__$1 = state_30559;
var statearr_30566_30592 = state_30559__$1;
(statearr_30566_30592[(2)] = null);

(statearr_30566_30592[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (6))){
var inst_30538 = (state_30559[(7)]);
var state_30559__$1 = state_30559;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30559__$1,(11),to,inst_30538);
} else {
if((state_val_30560 === (3))){
var inst_30557 = (state_30559[(2)]);
var state_30559__$1 = state_30559;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30559__$1,inst_30557);
} else {
if((state_val_30560 === (12))){
var state_30559__$1 = state_30559;
var statearr_30567_30593 = state_30559__$1;
(statearr_30567_30593[(2)] = null);

(statearr_30567_30593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (2))){
var state_30559__$1 = state_30559;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30559__$1,(4),from);
} else {
if((state_val_30560 === (11))){
var inst_30548 = (state_30559[(2)]);
var state_30559__$1 = state_30559;
if(cljs.core.truth_(inst_30548)){
var statearr_30568_30594 = state_30559__$1;
(statearr_30568_30594[(1)] = (12));

} else {
var statearr_30569_30595 = state_30559__$1;
(statearr_30569_30595[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (9))){
var state_30559__$1 = state_30559;
var statearr_30570_30596 = state_30559__$1;
(statearr_30570_30596[(2)] = null);

(statearr_30570_30596[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (5))){
var state_30559__$1 = state_30559;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30571_30597 = state_30559__$1;
(statearr_30571_30597[(1)] = (8));

} else {
var statearr_30572_30598 = state_30559__$1;
(statearr_30572_30598[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (14))){
var inst_30553 = (state_30559[(2)]);
var state_30559__$1 = state_30559;
var statearr_30573_30599 = state_30559__$1;
(statearr_30573_30599[(2)] = inst_30553);

(statearr_30573_30599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (10))){
var inst_30545 = (state_30559[(2)]);
var state_30559__$1 = state_30559;
var statearr_30574_30600 = state_30559__$1;
(statearr_30574_30600[(2)] = inst_30545);

(statearr_30574_30600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30560 === (8))){
var inst_30542 = cljs.core.async.close_BANG_.call(null,to);
var state_30559__$1 = state_30559;
var statearr_30575_30601 = state_30559__$1;
(statearr_30575_30601[(2)] = inst_30542);

(statearr_30575_30601[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___30587))
;
return ((function (switch__30292__auto__,c__30406__auto___30587){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_30579 = [null,null,null,null,null,null,null,null];
(statearr_30579[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_30579[(1)] = (1));

return statearr_30579;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_30559){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_30559);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e30580){if((e30580 instanceof Object)){
var ex__30296__auto__ = e30580;
var statearr_30581_30602 = state_30559;
(statearr_30581_30602[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30559);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30580;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30603 = state_30559;
state_30559 = G__30603;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_30559){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_30559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___30587))
})();
var state__30408__auto__ = (function (){var statearr_30582 = f__30407__auto__.call(null);
(statearr_30582[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___30587);

return statearr_30582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___30587))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__30791){
var vec__30792 = p__30791;
var v = cljs.core.nth.call(null,vec__30792,(0),null);
var p = cljs.core.nth.call(null,vec__30792,(1),null);
var job = vec__30792;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30406__auto___30978 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___30978,res,vec__30792,v,p,job,jobs,results){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___30978,res,vec__30792,v,p,job,jobs,results){
return (function (state_30799){
var state_val_30800 = (state_30799[(1)]);
if((state_val_30800 === (1))){
var state_30799__$1 = state_30799;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30799__$1,(2),res,v);
} else {
if((state_val_30800 === (2))){
var inst_30796 = (state_30799[(2)]);
var inst_30797 = cljs.core.async.close_BANG_.call(null,res);
var state_30799__$1 = (function (){var statearr_30801 = state_30799;
(statearr_30801[(7)] = inst_30796);

return statearr_30801;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30799__$1,inst_30797);
} else {
return null;
}
}
});})(c__30406__auto___30978,res,vec__30792,v,p,job,jobs,results))
;
return ((function (switch__30292__auto__,c__30406__auto___30978,res,vec__30792,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0 = (function (){
var statearr_30805 = [null,null,null,null,null,null,null,null];
(statearr_30805[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__);

(statearr_30805[(1)] = (1));

return statearr_30805;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1 = (function (state_30799){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_30799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e30806){if((e30806 instanceof Object)){
var ex__30296__auto__ = e30806;
var statearr_30807_30979 = state_30799;
(statearr_30807_30979[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30799);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30980 = state_30799;
state_30799 = G__30980;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = function(state_30799){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1.call(this,state_30799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___30978,res,vec__30792,v,p,job,jobs,results))
})();
var state__30408__auto__ = (function (){var statearr_30808 = f__30407__auto__.call(null);
(statearr_30808[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___30978);

return statearr_30808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___30978,res,vec__30792,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__30809){
var vec__30810 = p__30809;
var v = cljs.core.nth.call(null,vec__30810,(0),null);
var p = cljs.core.nth.call(null,vec__30810,(1),null);
var job = vec__30810;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28042__auto___30981 = n;
var __30982 = (0);
while(true){
if((__30982 < n__28042__auto___30981)){
var G__30813_30983 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__30813_30983) {
case "compute":
var c__30406__auto___30985 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30982,c__30406__auto___30985,G__30813_30983,n__28042__auto___30981,jobs,results,process,async){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (__30982,c__30406__auto___30985,G__30813_30983,n__28042__auto___30981,jobs,results,process,async){
return (function (state_30826){
var state_val_30827 = (state_30826[(1)]);
if((state_val_30827 === (1))){
var state_30826__$1 = state_30826;
var statearr_30828_30986 = state_30826__$1;
(statearr_30828_30986[(2)] = null);

(statearr_30828_30986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30827 === (2))){
var state_30826__$1 = state_30826;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30826__$1,(4),jobs);
} else {
if((state_val_30827 === (3))){
var inst_30824 = (state_30826[(2)]);
var state_30826__$1 = state_30826;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30826__$1,inst_30824);
} else {
if((state_val_30827 === (4))){
var inst_30816 = (state_30826[(2)]);
var inst_30817 = process.call(null,inst_30816);
var state_30826__$1 = state_30826;
if(cljs.core.truth_(inst_30817)){
var statearr_30829_30987 = state_30826__$1;
(statearr_30829_30987[(1)] = (5));

} else {
var statearr_30830_30988 = state_30826__$1;
(statearr_30830_30988[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30827 === (5))){
var state_30826__$1 = state_30826;
var statearr_30831_30989 = state_30826__$1;
(statearr_30831_30989[(2)] = null);

(statearr_30831_30989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30827 === (6))){
var state_30826__$1 = state_30826;
var statearr_30832_30990 = state_30826__$1;
(statearr_30832_30990[(2)] = null);

(statearr_30832_30990[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30827 === (7))){
var inst_30822 = (state_30826[(2)]);
var state_30826__$1 = state_30826;
var statearr_30833_30991 = state_30826__$1;
(statearr_30833_30991[(2)] = inst_30822);

(statearr_30833_30991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30982,c__30406__auto___30985,G__30813_30983,n__28042__auto___30981,jobs,results,process,async))
;
return ((function (__30982,switch__30292__auto__,c__30406__auto___30985,G__30813_30983,n__28042__auto___30981,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0 = (function (){
var statearr_30837 = [null,null,null,null,null,null,null];
(statearr_30837[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__);

(statearr_30837[(1)] = (1));

return statearr_30837;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1 = (function (state_30826){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_30826);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e30838){if((e30838 instanceof Object)){
var ex__30296__auto__ = e30838;
var statearr_30839_30992 = state_30826;
(statearr_30839_30992[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30826);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30993 = state_30826;
state_30826 = G__30993;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = function(state_30826){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1.call(this,state_30826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__;
})()
;})(__30982,switch__30292__auto__,c__30406__auto___30985,G__30813_30983,n__28042__auto___30981,jobs,results,process,async))
})();
var state__30408__auto__ = (function (){var statearr_30840 = f__30407__auto__.call(null);
(statearr_30840[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___30985);

return statearr_30840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(__30982,c__30406__auto___30985,G__30813_30983,n__28042__auto___30981,jobs,results,process,async))
);


break;
case "async":
var c__30406__auto___30994 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30982,c__30406__auto___30994,G__30813_30983,n__28042__auto___30981,jobs,results,process,async){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (__30982,c__30406__auto___30994,G__30813_30983,n__28042__auto___30981,jobs,results,process,async){
return (function (state_30853){
var state_val_30854 = (state_30853[(1)]);
if((state_val_30854 === (1))){
var state_30853__$1 = state_30853;
var statearr_30855_30995 = state_30853__$1;
(statearr_30855_30995[(2)] = null);

(statearr_30855_30995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30854 === (2))){
var state_30853__$1 = state_30853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30853__$1,(4),jobs);
} else {
if((state_val_30854 === (3))){
var inst_30851 = (state_30853[(2)]);
var state_30853__$1 = state_30853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30853__$1,inst_30851);
} else {
if((state_val_30854 === (4))){
var inst_30843 = (state_30853[(2)]);
var inst_30844 = async.call(null,inst_30843);
var state_30853__$1 = state_30853;
if(cljs.core.truth_(inst_30844)){
var statearr_30856_30996 = state_30853__$1;
(statearr_30856_30996[(1)] = (5));

} else {
var statearr_30857_30997 = state_30853__$1;
(statearr_30857_30997[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30854 === (5))){
var state_30853__$1 = state_30853;
var statearr_30858_30998 = state_30853__$1;
(statearr_30858_30998[(2)] = null);

(statearr_30858_30998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30854 === (6))){
var state_30853__$1 = state_30853;
var statearr_30859_30999 = state_30853__$1;
(statearr_30859_30999[(2)] = null);

(statearr_30859_30999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30854 === (7))){
var inst_30849 = (state_30853[(2)]);
var state_30853__$1 = state_30853;
var statearr_30860_31000 = state_30853__$1;
(statearr_30860_31000[(2)] = inst_30849);

(statearr_30860_31000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30982,c__30406__auto___30994,G__30813_30983,n__28042__auto___30981,jobs,results,process,async))
;
return ((function (__30982,switch__30292__auto__,c__30406__auto___30994,G__30813_30983,n__28042__auto___30981,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0 = (function (){
var statearr_30864 = [null,null,null,null,null,null,null];
(statearr_30864[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__);

(statearr_30864[(1)] = (1));

return statearr_30864;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1 = (function (state_30853){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_30853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e30865){if((e30865 instanceof Object)){
var ex__30296__auto__ = e30865;
var statearr_30866_31001 = state_30853;
(statearr_30866_31001[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30853);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30865;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31002 = state_30853;
state_30853 = G__31002;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = function(state_30853){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1.call(this,state_30853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__;
})()
;})(__30982,switch__30292__auto__,c__30406__auto___30994,G__30813_30983,n__28042__auto___30981,jobs,results,process,async))
})();
var state__30408__auto__ = (function (){var statearr_30867 = f__30407__auto__.call(null);
(statearr_30867[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___30994);

return statearr_30867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(__30982,c__30406__auto___30994,G__30813_30983,n__28042__auto___30981,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__31003 = (__30982 + (1));
__30982 = G__31003;
continue;
} else {
}
break;
}

var c__30406__auto___31004 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___31004,jobs,results,process,async){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___31004,jobs,results,process,async){
return (function (state_30889){
var state_val_30890 = (state_30889[(1)]);
if((state_val_30890 === (1))){
var state_30889__$1 = state_30889;
var statearr_30891_31005 = state_30889__$1;
(statearr_30891_31005[(2)] = null);

(statearr_30891_31005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30890 === (2))){
var state_30889__$1 = state_30889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30889__$1,(4),from);
} else {
if((state_val_30890 === (3))){
var inst_30887 = (state_30889[(2)]);
var state_30889__$1 = state_30889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30889__$1,inst_30887);
} else {
if((state_val_30890 === (4))){
var inst_30870 = (state_30889[(7)]);
var inst_30870__$1 = (state_30889[(2)]);
var inst_30871 = (inst_30870__$1 == null);
var state_30889__$1 = (function (){var statearr_30892 = state_30889;
(statearr_30892[(7)] = inst_30870__$1);

return statearr_30892;
})();
if(cljs.core.truth_(inst_30871)){
var statearr_30893_31006 = state_30889__$1;
(statearr_30893_31006[(1)] = (5));

} else {
var statearr_30894_31007 = state_30889__$1;
(statearr_30894_31007[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30890 === (5))){
var inst_30873 = cljs.core.async.close_BANG_.call(null,jobs);
var state_30889__$1 = state_30889;
var statearr_30895_31008 = state_30889__$1;
(statearr_30895_31008[(2)] = inst_30873);

(statearr_30895_31008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30890 === (6))){
var inst_30870 = (state_30889[(7)]);
var inst_30875 = (state_30889[(8)]);
var inst_30875__$1 = cljs.core.async.chan.call(null,(1));
var inst_30876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30877 = [inst_30870,inst_30875__$1];
var inst_30878 = (new cljs.core.PersistentVector(null,2,(5),inst_30876,inst_30877,null));
var state_30889__$1 = (function (){var statearr_30896 = state_30889;
(statearr_30896[(8)] = inst_30875__$1);

return statearr_30896;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30889__$1,(8),jobs,inst_30878);
} else {
if((state_val_30890 === (7))){
var inst_30885 = (state_30889[(2)]);
var state_30889__$1 = state_30889;
var statearr_30897_31009 = state_30889__$1;
(statearr_30897_31009[(2)] = inst_30885);

(statearr_30897_31009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30890 === (8))){
var inst_30875 = (state_30889[(8)]);
var inst_30880 = (state_30889[(2)]);
var state_30889__$1 = (function (){var statearr_30898 = state_30889;
(statearr_30898[(9)] = inst_30880);

return statearr_30898;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30889__$1,(9),results,inst_30875);
} else {
if((state_val_30890 === (9))){
var inst_30882 = (state_30889[(2)]);
var state_30889__$1 = (function (){var statearr_30899 = state_30889;
(statearr_30899[(10)] = inst_30882);

return statearr_30899;
})();
var statearr_30900_31010 = state_30889__$1;
(statearr_30900_31010[(2)] = null);

(statearr_30900_31010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___31004,jobs,results,process,async))
;
return ((function (switch__30292__auto__,c__30406__auto___31004,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0 = (function (){
var statearr_30904 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30904[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__);

(statearr_30904[(1)] = (1));

return statearr_30904;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1 = (function (state_30889){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_30889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e30905){if((e30905 instanceof Object)){
var ex__30296__auto__ = e30905;
var statearr_30906_31011 = state_30889;
(statearr_30906_31011[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30889);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30905;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31012 = state_30889;
state_30889 = G__31012;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = function(state_30889){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1.call(this,state_30889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___31004,jobs,results,process,async))
})();
var state__30408__auto__ = (function (){var statearr_30907 = f__30407__auto__.call(null);
(statearr_30907[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___31004);

return statearr_30907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___31004,jobs,results,process,async))
);


var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__,jobs,results,process,async){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__,jobs,results,process,async){
return (function (state_30945){
var state_val_30946 = (state_30945[(1)]);
if((state_val_30946 === (7))){
var inst_30941 = (state_30945[(2)]);
var state_30945__$1 = state_30945;
var statearr_30947_31013 = state_30945__$1;
(statearr_30947_31013[(2)] = inst_30941);

(statearr_30947_31013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (20))){
var state_30945__$1 = state_30945;
var statearr_30948_31014 = state_30945__$1;
(statearr_30948_31014[(2)] = null);

(statearr_30948_31014[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (1))){
var state_30945__$1 = state_30945;
var statearr_30949_31015 = state_30945__$1;
(statearr_30949_31015[(2)] = null);

(statearr_30949_31015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (4))){
var inst_30910 = (state_30945[(7)]);
var inst_30910__$1 = (state_30945[(2)]);
var inst_30911 = (inst_30910__$1 == null);
var state_30945__$1 = (function (){var statearr_30950 = state_30945;
(statearr_30950[(7)] = inst_30910__$1);

return statearr_30950;
})();
if(cljs.core.truth_(inst_30911)){
var statearr_30951_31016 = state_30945__$1;
(statearr_30951_31016[(1)] = (5));

} else {
var statearr_30952_31017 = state_30945__$1;
(statearr_30952_31017[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (15))){
var inst_30923 = (state_30945[(8)]);
var state_30945__$1 = state_30945;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30945__$1,(18),to,inst_30923);
} else {
if((state_val_30946 === (21))){
var inst_30936 = (state_30945[(2)]);
var state_30945__$1 = state_30945;
var statearr_30953_31018 = state_30945__$1;
(statearr_30953_31018[(2)] = inst_30936);

(statearr_30953_31018[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (13))){
var inst_30938 = (state_30945[(2)]);
var state_30945__$1 = (function (){var statearr_30954 = state_30945;
(statearr_30954[(9)] = inst_30938);

return statearr_30954;
})();
var statearr_30955_31019 = state_30945__$1;
(statearr_30955_31019[(2)] = null);

(statearr_30955_31019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (6))){
var inst_30910 = (state_30945[(7)]);
var state_30945__$1 = state_30945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30945__$1,(11),inst_30910);
} else {
if((state_val_30946 === (17))){
var inst_30931 = (state_30945[(2)]);
var state_30945__$1 = state_30945;
if(cljs.core.truth_(inst_30931)){
var statearr_30956_31020 = state_30945__$1;
(statearr_30956_31020[(1)] = (19));

} else {
var statearr_30957_31021 = state_30945__$1;
(statearr_30957_31021[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (3))){
var inst_30943 = (state_30945[(2)]);
var state_30945__$1 = state_30945;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30945__$1,inst_30943);
} else {
if((state_val_30946 === (12))){
var inst_30920 = (state_30945[(10)]);
var state_30945__$1 = state_30945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30945__$1,(14),inst_30920);
} else {
if((state_val_30946 === (2))){
var state_30945__$1 = state_30945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30945__$1,(4),results);
} else {
if((state_val_30946 === (19))){
var state_30945__$1 = state_30945;
var statearr_30958_31022 = state_30945__$1;
(statearr_30958_31022[(2)] = null);

(statearr_30958_31022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (11))){
var inst_30920 = (state_30945[(2)]);
var state_30945__$1 = (function (){var statearr_30959 = state_30945;
(statearr_30959[(10)] = inst_30920);

return statearr_30959;
})();
var statearr_30960_31023 = state_30945__$1;
(statearr_30960_31023[(2)] = null);

(statearr_30960_31023[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (9))){
var state_30945__$1 = state_30945;
var statearr_30961_31024 = state_30945__$1;
(statearr_30961_31024[(2)] = null);

(statearr_30961_31024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (5))){
var state_30945__$1 = state_30945;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30962_31025 = state_30945__$1;
(statearr_30962_31025[(1)] = (8));

} else {
var statearr_30963_31026 = state_30945__$1;
(statearr_30963_31026[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (14))){
var inst_30925 = (state_30945[(11)]);
var inst_30923 = (state_30945[(8)]);
var inst_30923__$1 = (state_30945[(2)]);
var inst_30924 = (inst_30923__$1 == null);
var inst_30925__$1 = cljs.core.not.call(null,inst_30924);
var state_30945__$1 = (function (){var statearr_30964 = state_30945;
(statearr_30964[(11)] = inst_30925__$1);

(statearr_30964[(8)] = inst_30923__$1);

return statearr_30964;
})();
if(inst_30925__$1){
var statearr_30965_31027 = state_30945__$1;
(statearr_30965_31027[(1)] = (15));

} else {
var statearr_30966_31028 = state_30945__$1;
(statearr_30966_31028[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (16))){
var inst_30925 = (state_30945[(11)]);
var state_30945__$1 = state_30945;
var statearr_30967_31029 = state_30945__$1;
(statearr_30967_31029[(2)] = inst_30925);

(statearr_30967_31029[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (10))){
var inst_30917 = (state_30945[(2)]);
var state_30945__$1 = state_30945;
var statearr_30968_31030 = state_30945__$1;
(statearr_30968_31030[(2)] = inst_30917);

(statearr_30968_31030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (18))){
var inst_30928 = (state_30945[(2)]);
var state_30945__$1 = state_30945;
var statearr_30969_31031 = state_30945__$1;
(statearr_30969_31031[(2)] = inst_30928);

(statearr_30969_31031[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30946 === (8))){
var inst_30914 = cljs.core.async.close_BANG_.call(null,to);
var state_30945__$1 = state_30945;
var statearr_30970_31032 = state_30945__$1;
(statearr_30970_31032[(2)] = inst_30914);

(statearr_30970_31032[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto__,jobs,results,process,async))
;
return ((function (switch__30292__auto__,c__30406__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0 = (function (){
var statearr_30974 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30974[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__);

(statearr_30974[(1)] = (1));

return statearr_30974;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1 = (function (state_30945){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_30945);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e30975){if((e30975 instanceof Object)){
var ex__30296__auto__ = e30975;
var statearr_30976_31033 = state_30945;
(statearr_30976_31033[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30945);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30975;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31034 = state_30945;
state_30945 = G__31034;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__ = function(state_30945){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1.call(this,state_30945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30293__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__,jobs,results,process,async))
})();
var state__30408__auto__ = (function (){var statearr_30977 = f__30407__auto__.call(null);
(statearr_30977[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_30977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__,jobs,results,process,async))
);

return c__30406__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args31035 = [];
var len__28242__auto___31038 = arguments.length;
var i__28243__auto___31039 = (0);
while(true){
if((i__28243__auto___31039 < len__28242__auto___31038)){
args31035.push((arguments[i__28243__auto___31039]));

var G__31040 = (i__28243__auto___31039 + (1));
i__28243__auto___31039 = G__31040;
continue;
} else {
}
break;
}

var G__31037 = args31035.length;
switch (G__31037) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args31035.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args31042 = [];
var len__28242__auto___31045 = arguments.length;
var i__28243__auto___31046 = (0);
while(true){
if((i__28243__auto___31046 < len__28242__auto___31045)){
args31042.push((arguments[i__28243__auto___31046]));

var G__31047 = (i__28243__auto___31046 + (1));
i__28243__auto___31046 = G__31047;
continue;
} else {
}
break;
}

var G__31044 = args31042.length;
switch (G__31044) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args31042.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args31049 = [];
var len__28242__auto___31102 = arguments.length;
var i__28243__auto___31103 = (0);
while(true){
if((i__28243__auto___31103 < len__28242__auto___31102)){
args31049.push((arguments[i__28243__auto___31103]));

var G__31104 = (i__28243__auto___31103 + (1));
i__28243__auto___31103 = G__31104;
continue;
} else {
}
break;
}

var G__31051 = args31049.length;
switch (G__31051) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args31049.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30406__auto___31106 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___31106,tc,fc){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___31106,tc,fc){
return (function (state_31077){
var state_val_31078 = (state_31077[(1)]);
if((state_val_31078 === (7))){
var inst_31073 = (state_31077[(2)]);
var state_31077__$1 = state_31077;
var statearr_31079_31107 = state_31077__$1;
(statearr_31079_31107[(2)] = inst_31073);

(statearr_31079_31107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (1))){
var state_31077__$1 = state_31077;
var statearr_31080_31108 = state_31077__$1;
(statearr_31080_31108[(2)] = null);

(statearr_31080_31108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (4))){
var inst_31054 = (state_31077[(7)]);
var inst_31054__$1 = (state_31077[(2)]);
var inst_31055 = (inst_31054__$1 == null);
var state_31077__$1 = (function (){var statearr_31081 = state_31077;
(statearr_31081[(7)] = inst_31054__$1);

return statearr_31081;
})();
if(cljs.core.truth_(inst_31055)){
var statearr_31082_31109 = state_31077__$1;
(statearr_31082_31109[(1)] = (5));

} else {
var statearr_31083_31110 = state_31077__$1;
(statearr_31083_31110[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (13))){
var state_31077__$1 = state_31077;
var statearr_31084_31111 = state_31077__$1;
(statearr_31084_31111[(2)] = null);

(statearr_31084_31111[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (6))){
var inst_31054 = (state_31077[(7)]);
var inst_31060 = p.call(null,inst_31054);
var state_31077__$1 = state_31077;
if(cljs.core.truth_(inst_31060)){
var statearr_31085_31112 = state_31077__$1;
(statearr_31085_31112[(1)] = (9));

} else {
var statearr_31086_31113 = state_31077__$1;
(statearr_31086_31113[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (3))){
var inst_31075 = (state_31077[(2)]);
var state_31077__$1 = state_31077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31077__$1,inst_31075);
} else {
if((state_val_31078 === (12))){
var state_31077__$1 = state_31077;
var statearr_31087_31114 = state_31077__$1;
(statearr_31087_31114[(2)] = null);

(statearr_31087_31114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (2))){
var state_31077__$1 = state_31077;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31077__$1,(4),ch);
} else {
if((state_val_31078 === (11))){
var inst_31054 = (state_31077[(7)]);
var inst_31064 = (state_31077[(2)]);
var state_31077__$1 = state_31077;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31077__$1,(8),inst_31064,inst_31054);
} else {
if((state_val_31078 === (9))){
var state_31077__$1 = state_31077;
var statearr_31088_31115 = state_31077__$1;
(statearr_31088_31115[(2)] = tc);

(statearr_31088_31115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (5))){
var inst_31057 = cljs.core.async.close_BANG_.call(null,tc);
var inst_31058 = cljs.core.async.close_BANG_.call(null,fc);
var state_31077__$1 = (function (){var statearr_31089 = state_31077;
(statearr_31089[(8)] = inst_31057);

return statearr_31089;
})();
var statearr_31090_31116 = state_31077__$1;
(statearr_31090_31116[(2)] = inst_31058);

(statearr_31090_31116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (14))){
var inst_31071 = (state_31077[(2)]);
var state_31077__$1 = state_31077;
var statearr_31091_31117 = state_31077__$1;
(statearr_31091_31117[(2)] = inst_31071);

(statearr_31091_31117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (10))){
var state_31077__$1 = state_31077;
var statearr_31092_31118 = state_31077__$1;
(statearr_31092_31118[(2)] = fc);

(statearr_31092_31118[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31078 === (8))){
var inst_31066 = (state_31077[(2)]);
var state_31077__$1 = state_31077;
if(cljs.core.truth_(inst_31066)){
var statearr_31093_31119 = state_31077__$1;
(statearr_31093_31119[(1)] = (12));

} else {
var statearr_31094_31120 = state_31077__$1;
(statearr_31094_31120[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___31106,tc,fc))
;
return ((function (switch__30292__auto__,c__30406__auto___31106,tc,fc){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_31098 = [null,null,null,null,null,null,null,null,null];
(statearr_31098[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_31098[(1)] = (1));

return statearr_31098;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_31077){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_31077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e31099){if((e31099 instanceof Object)){
var ex__30296__auto__ = e31099;
var statearr_31100_31121 = state_31077;
(statearr_31100_31121[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31077);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31122 = state_31077;
state_31077 = G__31122;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_31077){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_31077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___31106,tc,fc))
})();
var state__30408__auto__ = (function (){var statearr_31101 = f__30407__auto__.call(null);
(statearr_31101[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___31106);

return statearr_31101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___31106,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__){
return (function (state_31186){
var state_val_31187 = (state_31186[(1)]);
if((state_val_31187 === (7))){
var inst_31182 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
var statearr_31188_31209 = state_31186__$1;
(statearr_31188_31209[(2)] = inst_31182);

(statearr_31188_31209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (1))){
var inst_31166 = init;
var state_31186__$1 = (function (){var statearr_31189 = state_31186;
(statearr_31189[(7)] = inst_31166);

return statearr_31189;
})();
var statearr_31190_31210 = state_31186__$1;
(statearr_31190_31210[(2)] = null);

(statearr_31190_31210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (4))){
var inst_31169 = (state_31186[(8)]);
var inst_31169__$1 = (state_31186[(2)]);
var inst_31170 = (inst_31169__$1 == null);
var state_31186__$1 = (function (){var statearr_31191 = state_31186;
(statearr_31191[(8)] = inst_31169__$1);

return statearr_31191;
})();
if(cljs.core.truth_(inst_31170)){
var statearr_31192_31211 = state_31186__$1;
(statearr_31192_31211[(1)] = (5));

} else {
var statearr_31193_31212 = state_31186__$1;
(statearr_31193_31212[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (6))){
var inst_31169 = (state_31186[(8)]);
var inst_31166 = (state_31186[(7)]);
var inst_31173 = (state_31186[(9)]);
var inst_31173__$1 = f.call(null,inst_31166,inst_31169);
var inst_31174 = cljs.core.reduced_QMARK_.call(null,inst_31173__$1);
var state_31186__$1 = (function (){var statearr_31194 = state_31186;
(statearr_31194[(9)] = inst_31173__$1);

return statearr_31194;
})();
if(inst_31174){
var statearr_31195_31213 = state_31186__$1;
(statearr_31195_31213[(1)] = (8));

} else {
var statearr_31196_31214 = state_31186__$1;
(statearr_31196_31214[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (3))){
var inst_31184 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31186__$1,inst_31184);
} else {
if((state_val_31187 === (2))){
var state_31186__$1 = state_31186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31186__$1,(4),ch);
} else {
if((state_val_31187 === (9))){
var inst_31173 = (state_31186[(9)]);
var inst_31166 = inst_31173;
var state_31186__$1 = (function (){var statearr_31197 = state_31186;
(statearr_31197[(7)] = inst_31166);

return statearr_31197;
})();
var statearr_31198_31215 = state_31186__$1;
(statearr_31198_31215[(2)] = null);

(statearr_31198_31215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (5))){
var inst_31166 = (state_31186[(7)]);
var state_31186__$1 = state_31186;
var statearr_31199_31216 = state_31186__$1;
(statearr_31199_31216[(2)] = inst_31166);

(statearr_31199_31216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (10))){
var inst_31180 = (state_31186[(2)]);
var state_31186__$1 = state_31186;
var statearr_31200_31217 = state_31186__$1;
(statearr_31200_31217[(2)] = inst_31180);

(statearr_31200_31217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31187 === (8))){
var inst_31173 = (state_31186[(9)]);
var inst_31176 = cljs.core.deref.call(null,inst_31173);
var state_31186__$1 = state_31186;
var statearr_31201_31218 = state_31186__$1;
(statearr_31201_31218[(2)] = inst_31176);

(statearr_31201_31218[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto__))
;
return ((function (switch__30292__auto__,c__30406__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30293__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30293__auto____0 = (function (){
var statearr_31205 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31205[(0)] = cljs$core$async$reduce_$_state_machine__30293__auto__);

(statearr_31205[(1)] = (1));

return statearr_31205;
});
var cljs$core$async$reduce_$_state_machine__30293__auto____1 = (function (state_31186){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_31186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e31206){if((e31206 instanceof Object)){
var ex__30296__auto__ = e31206;
var statearr_31207_31219 = state_31186;
(statearr_31207_31219[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31186);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31206;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31220 = state_31186;
state_31186 = G__31220;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30293__auto__ = function(state_31186){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30293__auto____1.call(this,state_31186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30293__auto____0;
cljs$core$async$reduce_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30293__auto____1;
return cljs$core$async$reduce_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__))
})();
var state__30408__auto__ = (function (){var statearr_31208 = f__30407__auto__.call(null);
(statearr_31208[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_31208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__))
);

return c__30406__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args31221 = [];
var len__28242__auto___31273 = arguments.length;
var i__28243__auto___31274 = (0);
while(true){
if((i__28243__auto___31274 < len__28242__auto___31273)){
args31221.push((arguments[i__28243__auto___31274]));

var G__31275 = (i__28243__auto___31274 + (1));
i__28243__auto___31274 = G__31275;
continue;
} else {
}
break;
}

var G__31223 = args31221.length;
switch (G__31223) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args31221.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__){
return (function (state_31248){
var state_val_31249 = (state_31248[(1)]);
if((state_val_31249 === (7))){
var inst_31230 = (state_31248[(2)]);
var state_31248__$1 = state_31248;
var statearr_31250_31277 = state_31248__$1;
(statearr_31250_31277[(2)] = inst_31230);

(statearr_31250_31277[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (1))){
var inst_31224 = cljs.core.seq.call(null,coll);
var inst_31225 = inst_31224;
var state_31248__$1 = (function (){var statearr_31251 = state_31248;
(statearr_31251[(7)] = inst_31225);

return statearr_31251;
})();
var statearr_31252_31278 = state_31248__$1;
(statearr_31252_31278[(2)] = null);

(statearr_31252_31278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (4))){
var inst_31225 = (state_31248[(7)]);
var inst_31228 = cljs.core.first.call(null,inst_31225);
var state_31248__$1 = state_31248;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31248__$1,(7),ch,inst_31228);
} else {
if((state_val_31249 === (13))){
var inst_31242 = (state_31248[(2)]);
var state_31248__$1 = state_31248;
var statearr_31253_31279 = state_31248__$1;
(statearr_31253_31279[(2)] = inst_31242);

(statearr_31253_31279[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (6))){
var inst_31233 = (state_31248[(2)]);
var state_31248__$1 = state_31248;
if(cljs.core.truth_(inst_31233)){
var statearr_31254_31280 = state_31248__$1;
(statearr_31254_31280[(1)] = (8));

} else {
var statearr_31255_31281 = state_31248__$1;
(statearr_31255_31281[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (3))){
var inst_31246 = (state_31248[(2)]);
var state_31248__$1 = state_31248;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31248__$1,inst_31246);
} else {
if((state_val_31249 === (12))){
var state_31248__$1 = state_31248;
var statearr_31256_31282 = state_31248__$1;
(statearr_31256_31282[(2)] = null);

(statearr_31256_31282[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (2))){
var inst_31225 = (state_31248[(7)]);
var state_31248__$1 = state_31248;
if(cljs.core.truth_(inst_31225)){
var statearr_31257_31283 = state_31248__$1;
(statearr_31257_31283[(1)] = (4));

} else {
var statearr_31258_31284 = state_31248__$1;
(statearr_31258_31284[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (11))){
var inst_31239 = cljs.core.async.close_BANG_.call(null,ch);
var state_31248__$1 = state_31248;
var statearr_31259_31285 = state_31248__$1;
(statearr_31259_31285[(2)] = inst_31239);

(statearr_31259_31285[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (9))){
var state_31248__$1 = state_31248;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31260_31286 = state_31248__$1;
(statearr_31260_31286[(1)] = (11));

} else {
var statearr_31261_31287 = state_31248__$1;
(statearr_31261_31287[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (5))){
var inst_31225 = (state_31248[(7)]);
var state_31248__$1 = state_31248;
var statearr_31262_31288 = state_31248__$1;
(statearr_31262_31288[(2)] = inst_31225);

(statearr_31262_31288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (10))){
var inst_31244 = (state_31248[(2)]);
var state_31248__$1 = state_31248;
var statearr_31263_31289 = state_31248__$1;
(statearr_31263_31289[(2)] = inst_31244);

(statearr_31263_31289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31249 === (8))){
var inst_31225 = (state_31248[(7)]);
var inst_31235 = cljs.core.next.call(null,inst_31225);
var inst_31225__$1 = inst_31235;
var state_31248__$1 = (function (){var statearr_31264 = state_31248;
(statearr_31264[(7)] = inst_31225__$1);

return statearr_31264;
})();
var statearr_31265_31290 = state_31248__$1;
(statearr_31265_31290[(2)] = null);

(statearr_31265_31290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto__))
;
return ((function (switch__30292__auto__,c__30406__auto__){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_31269 = [null,null,null,null,null,null,null,null];
(statearr_31269[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_31269[(1)] = (1));

return statearr_31269;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_31248){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_31248);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e31270){if((e31270 instanceof Object)){
var ex__30296__auto__ = e31270;
var statearr_31271_31291 = state_31248;
(statearr_31271_31291[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31248);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31270;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31292 = state_31248;
state_31248 = G__31292;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_31248){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_31248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__))
})();
var state__30408__auto__ = (function (){var statearr_31272 = f__30407__auto__.call(null);
(statearr_31272[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_31272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__))
);

return c__30406__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27739__auto__ = (((_ == null))?null:_);
var m__27740__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,_);
} else {
var m__27740__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27740__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m,ch);
} else {
var m__27740__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m);
} else {
var m__27740__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31518 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31518 = (function (ch,cs,meta31519){
this.ch = ch;
this.cs = cs;
this.meta31519 = meta31519;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_31520,meta31519__$1){
var self__ = this;
var _31520__$1 = this;
return (new cljs.core.async.t_cljs$core$async31518(self__.ch,self__.cs,meta31519__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_31520){
var self__ = this;
var _31520__$1 = this;
return self__.meta31519;
});})(cs))
;

cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31518.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async31518.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta31519","meta31519",1196958079,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async31518.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31518.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31518";

cljs.core.async.t_cljs$core$async31518.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async31518");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async31518 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async31518(ch__$1,cs__$1,meta31519){
return (new cljs.core.async.t_cljs$core$async31518(ch__$1,cs__$1,meta31519));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async31518(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30406__auto___31743 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___31743,cs,m,dchan,dctr,done){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___31743,cs,m,dchan,dctr,done){
return (function (state_31655){
var state_val_31656 = (state_31655[(1)]);
if((state_val_31656 === (7))){
var inst_31651 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31657_31744 = state_31655__$1;
(statearr_31657_31744[(2)] = inst_31651);

(statearr_31657_31744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (20))){
var inst_31554 = (state_31655[(7)]);
var inst_31566 = cljs.core.first.call(null,inst_31554);
var inst_31567 = cljs.core.nth.call(null,inst_31566,(0),null);
var inst_31568 = cljs.core.nth.call(null,inst_31566,(1),null);
var state_31655__$1 = (function (){var statearr_31658 = state_31655;
(statearr_31658[(8)] = inst_31567);

return statearr_31658;
})();
if(cljs.core.truth_(inst_31568)){
var statearr_31659_31745 = state_31655__$1;
(statearr_31659_31745[(1)] = (22));

} else {
var statearr_31660_31746 = state_31655__$1;
(statearr_31660_31746[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (27))){
var inst_31523 = (state_31655[(9)]);
var inst_31598 = (state_31655[(10)]);
var inst_31596 = (state_31655[(11)]);
var inst_31603 = (state_31655[(12)]);
var inst_31603__$1 = cljs.core._nth.call(null,inst_31596,inst_31598);
var inst_31604 = cljs.core.async.put_BANG_.call(null,inst_31603__$1,inst_31523,done);
var state_31655__$1 = (function (){var statearr_31661 = state_31655;
(statearr_31661[(12)] = inst_31603__$1);

return statearr_31661;
})();
if(cljs.core.truth_(inst_31604)){
var statearr_31662_31747 = state_31655__$1;
(statearr_31662_31747[(1)] = (30));

} else {
var statearr_31663_31748 = state_31655__$1;
(statearr_31663_31748[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (1))){
var state_31655__$1 = state_31655;
var statearr_31664_31749 = state_31655__$1;
(statearr_31664_31749[(2)] = null);

(statearr_31664_31749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (24))){
var inst_31554 = (state_31655[(7)]);
var inst_31573 = (state_31655[(2)]);
var inst_31574 = cljs.core.next.call(null,inst_31554);
var inst_31532 = inst_31574;
var inst_31533 = null;
var inst_31534 = (0);
var inst_31535 = (0);
var state_31655__$1 = (function (){var statearr_31665 = state_31655;
(statearr_31665[(13)] = inst_31533);

(statearr_31665[(14)] = inst_31535);

(statearr_31665[(15)] = inst_31532);

(statearr_31665[(16)] = inst_31573);

(statearr_31665[(17)] = inst_31534);

return statearr_31665;
})();
var statearr_31666_31750 = state_31655__$1;
(statearr_31666_31750[(2)] = null);

(statearr_31666_31750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (39))){
var state_31655__$1 = state_31655;
var statearr_31670_31751 = state_31655__$1;
(statearr_31670_31751[(2)] = null);

(statearr_31670_31751[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (4))){
var inst_31523 = (state_31655[(9)]);
var inst_31523__$1 = (state_31655[(2)]);
var inst_31524 = (inst_31523__$1 == null);
var state_31655__$1 = (function (){var statearr_31671 = state_31655;
(statearr_31671[(9)] = inst_31523__$1);

return statearr_31671;
})();
if(cljs.core.truth_(inst_31524)){
var statearr_31672_31752 = state_31655__$1;
(statearr_31672_31752[(1)] = (5));

} else {
var statearr_31673_31753 = state_31655__$1;
(statearr_31673_31753[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (15))){
var inst_31533 = (state_31655[(13)]);
var inst_31535 = (state_31655[(14)]);
var inst_31532 = (state_31655[(15)]);
var inst_31534 = (state_31655[(17)]);
var inst_31550 = (state_31655[(2)]);
var inst_31551 = (inst_31535 + (1));
var tmp31667 = inst_31533;
var tmp31668 = inst_31532;
var tmp31669 = inst_31534;
var inst_31532__$1 = tmp31668;
var inst_31533__$1 = tmp31667;
var inst_31534__$1 = tmp31669;
var inst_31535__$1 = inst_31551;
var state_31655__$1 = (function (){var statearr_31674 = state_31655;
(statearr_31674[(13)] = inst_31533__$1);

(statearr_31674[(14)] = inst_31535__$1);

(statearr_31674[(15)] = inst_31532__$1);

(statearr_31674[(18)] = inst_31550);

(statearr_31674[(17)] = inst_31534__$1);

return statearr_31674;
})();
var statearr_31675_31754 = state_31655__$1;
(statearr_31675_31754[(2)] = null);

(statearr_31675_31754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (21))){
var inst_31577 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31679_31755 = state_31655__$1;
(statearr_31679_31755[(2)] = inst_31577);

(statearr_31679_31755[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (31))){
var inst_31603 = (state_31655[(12)]);
var inst_31607 = done.call(null,null);
var inst_31608 = cljs.core.async.untap_STAR_.call(null,m,inst_31603);
var state_31655__$1 = (function (){var statearr_31680 = state_31655;
(statearr_31680[(19)] = inst_31607);

return statearr_31680;
})();
var statearr_31681_31756 = state_31655__$1;
(statearr_31681_31756[(2)] = inst_31608);

(statearr_31681_31756[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (32))){
var inst_31595 = (state_31655[(20)]);
var inst_31597 = (state_31655[(21)]);
var inst_31598 = (state_31655[(10)]);
var inst_31596 = (state_31655[(11)]);
var inst_31610 = (state_31655[(2)]);
var inst_31611 = (inst_31598 + (1));
var tmp31676 = inst_31595;
var tmp31677 = inst_31597;
var tmp31678 = inst_31596;
var inst_31595__$1 = tmp31676;
var inst_31596__$1 = tmp31678;
var inst_31597__$1 = tmp31677;
var inst_31598__$1 = inst_31611;
var state_31655__$1 = (function (){var statearr_31682 = state_31655;
(statearr_31682[(22)] = inst_31610);

(statearr_31682[(20)] = inst_31595__$1);

(statearr_31682[(21)] = inst_31597__$1);

(statearr_31682[(10)] = inst_31598__$1);

(statearr_31682[(11)] = inst_31596__$1);

return statearr_31682;
})();
var statearr_31683_31757 = state_31655__$1;
(statearr_31683_31757[(2)] = null);

(statearr_31683_31757[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (40))){
var inst_31623 = (state_31655[(23)]);
var inst_31627 = done.call(null,null);
var inst_31628 = cljs.core.async.untap_STAR_.call(null,m,inst_31623);
var state_31655__$1 = (function (){var statearr_31684 = state_31655;
(statearr_31684[(24)] = inst_31627);

return statearr_31684;
})();
var statearr_31685_31758 = state_31655__$1;
(statearr_31685_31758[(2)] = inst_31628);

(statearr_31685_31758[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (33))){
var inst_31614 = (state_31655[(25)]);
var inst_31616 = cljs.core.chunked_seq_QMARK_.call(null,inst_31614);
var state_31655__$1 = state_31655;
if(inst_31616){
var statearr_31686_31759 = state_31655__$1;
(statearr_31686_31759[(1)] = (36));

} else {
var statearr_31687_31760 = state_31655__$1;
(statearr_31687_31760[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (13))){
var inst_31544 = (state_31655[(26)]);
var inst_31547 = cljs.core.async.close_BANG_.call(null,inst_31544);
var state_31655__$1 = state_31655;
var statearr_31688_31761 = state_31655__$1;
(statearr_31688_31761[(2)] = inst_31547);

(statearr_31688_31761[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (22))){
var inst_31567 = (state_31655[(8)]);
var inst_31570 = cljs.core.async.close_BANG_.call(null,inst_31567);
var state_31655__$1 = state_31655;
var statearr_31689_31762 = state_31655__$1;
(statearr_31689_31762[(2)] = inst_31570);

(statearr_31689_31762[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (36))){
var inst_31614 = (state_31655[(25)]);
var inst_31618 = cljs.core.chunk_first.call(null,inst_31614);
var inst_31619 = cljs.core.chunk_rest.call(null,inst_31614);
var inst_31620 = cljs.core.count.call(null,inst_31618);
var inst_31595 = inst_31619;
var inst_31596 = inst_31618;
var inst_31597 = inst_31620;
var inst_31598 = (0);
var state_31655__$1 = (function (){var statearr_31690 = state_31655;
(statearr_31690[(20)] = inst_31595);

(statearr_31690[(21)] = inst_31597);

(statearr_31690[(10)] = inst_31598);

(statearr_31690[(11)] = inst_31596);

return statearr_31690;
})();
var statearr_31691_31763 = state_31655__$1;
(statearr_31691_31763[(2)] = null);

(statearr_31691_31763[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (41))){
var inst_31614 = (state_31655[(25)]);
var inst_31630 = (state_31655[(2)]);
var inst_31631 = cljs.core.next.call(null,inst_31614);
var inst_31595 = inst_31631;
var inst_31596 = null;
var inst_31597 = (0);
var inst_31598 = (0);
var state_31655__$1 = (function (){var statearr_31692 = state_31655;
(statearr_31692[(20)] = inst_31595);

(statearr_31692[(21)] = inst_31597);

(statearr_31692[(10)] = inst_31598);

(statearr_31692[(11)] = inst_31596);

(statearr_31692[(27)] = inst_31630);

return statearr_31692;
})();
var statearr_31693_31764 = state_31655__$1;
(statearr_31693_31764[(2)] = null);

(statearr_31693_31764[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (43))){
var state_31655__$1 = state_31655;
var statearr_31694_31765 = state_31655__$1;
(statearr_31694_31765[(2)] = null);

(statearr_31694_31765[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (29))){
var inst_31639 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31695_31766 = state_31655__$1;
(statearr_31695_31766[(2)] = inst_31639);

(statearr_31695_31766[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (44))){
var inst_31648 = (state_31655[(2)]);
var state_31655__$1 = (function (){var statearr_31696 = state_31655;
(statearr_31696[(28)] = inst_31648);

return statearr_31696;
})();
var statearr_31697_31767 = state_31655__$1;
(statearr_31697_31767[(2)] = null);

(statearr_31697_31767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (6))){
var inst_31587 = (state_31655[(29)]);
var inst_31586 = cljs.core.deref.call(null,cs);
var inst_31587__$1 = cljs.core.keys.call(null,inst_31586);
var inst_31588 = cljs.core.count.call(null,inst_31587__$1);
var inst_31589 = cljs.core.reset_BANG_.call(null,dctr,inst_31588);
var inst_31594 = cljs.core.seq.call(null,inst_31587__$1);
var inst_31595 = inst_31594;
var inst_31596 = null;
var inst_31597 = (0);
var inst_31598 = (0);
var state_31655__$1 = (function (){var statearr_31698 = state_31655;
(statearr_31698[(20)] = inst_31595);

(statearr_31698[(21)] = inst_31597);

(statearr_31698[(29)] = inst_31587__$1);

(statearr_31698[(10)] = inst_31598);

(statearr_31698[(11)] = inst_31596);

(statearr_31698[(30)] = inst_31589);

return statearr_31698;
})();
var statearr_31699_31768 = state_31655__$1;
(statearr_31699_31768[(2)] = null);

(statearr_31699_31768[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (28))){
var inst_31614 = (state_31655[(25)]);
var inst_31595 = (state_31655[(20)]);
var inst_31614__$1 = cljs.core.seq.call(null,inst_31595);
var state_31655__$1 = (function (){var statearr_31700 = state_31655;
(statearr_31700[(25)] = inst_31614__$1);

return statearr_31700;
})();
if(inst_31614__$1){
var statearr_31701_31769 = state_31655__$1;
(statearr_31701_31769[(1)] = (33));

} else {
var statearr_31702_31770 = state_31655__$1;
(statearr_31702_31770[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (25))){
var inst_31597 = (state_31655[(21)]);
var inst_31598 = (state_31655[(10)]);
var inst_31600 = (inst_31598 < inst_31597);
var inst_31601 = inst_31600;
var state_31655__$1 = state_31655;
if(cljs.core.truth_(inst_31601)){
var statearr_31703_31771 = state_31655__$1;
(statearr_31703_31771[(1)] = (27));

} else {
var statearr_31704_31772 = state_31655__$1;
(statearr_31704_31772[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (34))){
var state_31655__$1 = state_31655;
var statearr_31705_31773 = state_31655__$1;
(statearr_31705_31773[(2)] = null);

(statearr_31705_31773[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (17))){
var state_31655__$1 = state_31655;
var statearr_31706_31774 = state_31655__$1;
(statearr_31706_31774[(2)] = null);

(statearr_31706_31774[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (3))){
var inst_31653 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31655__$1,inst_31653);
} else {
if((state_val_31656 === (12))){
var inst_31582 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31707_31775 = state_31655__$1;
(statearr_31707_31775[(2)] = inst_31582);

(statearr_31707_31775[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (2))){
var state_31655__$1 = state_31655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31655__$1,(4),ch);
} else {
if((state_val_31656 === (23))){
var state_31655__$1 = state_31655;
var statearr_31708_31776 = state_31655__$1;
(statearr_31708_31776[(2)] = null);

(statearr_31708_31776[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (35))){
var inst_31637 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31709_31777 = state_31655__$1;
(statearr_31709_31777[(2)] = inst_31637);

(statearr_31709_31777[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (19))){
var inst_31554 = (state_31655[(7)]);
var inst_31558 = cljs.core.chunk_first.call(null,inst_31554);
var inst_31559 = cljs.core.chunk_rest.call(null,inst_31554);
var inst_31560 = cljs.core.count.call(null,inst_31558);
var inst_31532 = inst_31559;
var inst_31533 = inst_31558;
var inst_31534 = inst_31560;
var inst_31535 = (0);
var state_31655__$1 = (function (){var statearr_31710 = state_31655;
(statearr_31710[(13)] = inst_31533);

(statearr_31710[(14)] = inst_31535);

(statearr_31710[(15)] = inst_31532);

(statearr_31710[(17)] = inst_31534);

return statearr_31710;
})();
var statearr_31711_31778 = state_31655__$1;
(statearr_31711_31778[(2)] = null);

(statearr_31711_31778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (11))){
var inst_31554 = (state_31655[(7)]);
var inst_31532 = (state_31655[(15)]);
var inst_31554__$1 = cljs.core.seq.call(null,inst_31532);
var state_31655__$1 = (function (){var statearr_31712 = state_31655;
(statearr_31712[(7)] = inst_31554__$1);

return statearr_31712;
})();
if(inst_31554__$1){
var statearr_31713_31779 = state_31655__$1;
(statearr_31713_31779[(1)] = (16));

} else {
var statearr_31714_31780 = state_31655__$1;
(statearr_31714_31780[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (9))){
var inst_31584 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31715_31781 = state_31655__$1;
(statearr_31715_31781[(2)] = inst_31584);

(statearr_31715_31781[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (5))){
var inst_31530 = cljs.core.deref.call(null,cs);
var inst_31531 = cljs.core.seq.call(null,inst_31530);
var inst_31532 = inst_31531;
var inst_31533 = null;
var inst_31534 = (0);
var inst_31535 = (0);
var state_31655__$1 = (function (){var statearr_31716 = state_31655;
(statearr_31716[(13)] = inst_31533);

(statearr_31716[(14)] = inst_31535);

(statearr_31716[(15)] = inst_31532);

(statearr_31716[(17)] = inst_31534);

return statearr_31716;
})();
var statearr_31717_31782 = state_31655__$1;
(statearr_31717_31782[(2)] = null);

(statearr_31717_31782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (14))){
var state_31655__$1 = state_31655;
var statearr_31718_31783 = state_31655__$1;
(statearr_31718_31783[(2)] = null);

(statearr_31718_31783[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (45))){
var inst_31645 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31719_31784 = state_31655__$1;
(statearr_31719_31784[(2)] = inst_31645);

(statearr_31719_31784[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (26))){
var inst_31587 = (state_31655[(29)]);
var inst_31641 = (state_31655[(2)]);
var inst_31642 = cljs.core.seq.call(null,inst_31587);
var state_31655__$1 = (function (){var statearr_31720 = state_31655;
(statearr_31720[(31)] = inst_31641);

return statearr_31720;
})();
if(inst_31642){
var statearr_31721_31785 = state_31655__$1;
(statearr_31721_31785[(1)] = (42));

} else {
var statearr_31722_31786 = state_31655__$1;
(statearr_31722_31786[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (16))){
var inst_31554 = (state_31655[(7)]);
var inst_31556 = cljs.core.chunked_seq_QMARK_.call(null,inst_31554);
var state_31655__$1 = state_31655;
if(inst_31556){
var statearr_31723_31787 = state_31655__$1;
(statearr_31723_31787[(1)] = (19));

} else {
var statearr_31724_31788 = state_31655__$1;
(statearr_31724_31788[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (38))){
var inst_31634 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31725_31789 = state_31655__$1;
(statearr_31725_31789[(2)] = inst_31634);

(statearr_31725_31789[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (30))){
var state_31655__$1 = state_31655;
var statearr_31726_31790 = state_31655__$1;
(statearr_31726_31790[(2)] = null);

(statearr_31726_31790[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (10))){
var inst_31533 = (state_31655[(13)]);
var inst_31535 = (state_31655[(14)]);
var inst_31543 = cljs.core._nth.call(null,inst_31533,inst_31535);
var inst_31544 = cljs.core.nth.call(null,inst_31543,(0),null);
var inst_31545 = cljs.core.nth.call(null,inst_31543,(1),null);
var state_31655__$1 = (function (){var statearr_31727 = state_31655;
(statearr_31727[(26)] = inst_31544);

return statearr_31727;
})();
if(cljs.core.truth_(inst_31545)){
var statearr_31728_31791 = state_31655__$1;
(statearr_31728_31791[(1)] = (13));

} else {
var statearr_31729_31792 = state_31655__$1;
(statearr_31729_31792[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (18))){
var inst_31580 = (state_31655[(2)]);
var state_31655__$1 = state_31655;
var statearr_31730_31793 = state_31655__$1;
(statearr_31730_31793[(2)] = inst_31580);

(statearr_31730_31793[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (42))){
var state_31655__$1 = state_31655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31655__$1,(45),dchan);
} else {
if((state_val_31656 === (37))){
var inst_31623 = (state_31655[(23)]);
var inst_31523 = (state_31655[(9)]);
var inst_31614 = (state_31655[(25)]);
var inst_31623__$1 = cljs.core.first.call(null,inst_31614);
var inst_31624 = cljs.core.async.put_BANG_.call(null,inst_31623__$1,inst_31523,done);
var state_31655__$1 = (function (){var statearr_31731 = state_31655;
(statearr_31731[(23)] = inst_31623__$1);

return statearr_31731;
})();
if(cljs.core.truth_(inst_31624)){
var statearr_31732_31794 = state_31655__$1;
(statearr_31732_31794[(1)] = (39));

} else {
var statearr_31733_31795 = state_31655__$1;
(statearr_31733_31795[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31656 === (8))){
var inst_31535 = (state_31655[(14)]);
var inst_31534 = (state_31655[(17)]);
var inst_31537 = (inst_31535 < inst_31534);
var inst_31538 = inst_31537;
var state_31655__$1 = state_31655;
if(cljs.core.truth_(inst_31538)){
var statearr_31734_31796 = state_31655__$1;
(statearr_31734_31796[(1)] = (10));

} else {
var statearr_31735_31797 = state_31655__$1;
(statearr_31735_31797[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___31743,cs,m,dchan,dctr,done))
;
return ((function (switch__30292__auto__,c__30406__auto___31743,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30293__auto__ = null;
var cljs$core$async$mult_$_state_machine__30293__auto____0 = (function (){
var statearr_31739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31739[(0)] = cljs$core$async$mult_$_state_machine__30293__auto__);

(statearr_31739[(1)] = (1));

return statearr_31739;
});
var cljs$core$async$mult_$_state_machine__30293__auto____1 = (function (state_31655){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_31655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e31740){if((e31740 instanceof Object)){
var ex__30296__auto__ = e31740;
var statearr_31741_31798 = state_31655;
(statearr_31741_31798[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31655);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31799 = state_31655;
state_31655 = G__31799;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30293__auto__ = function(state_31655){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30293__auto____1.call(this,state_31655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30293__auto____0;
cljs$core$async$mult_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30293__auto____1;
return cljs$core$async$mult_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___31743,cs,m,dchan,dctr,done))
})();
var state__30408__auto__ = (function (){var statearr_31742 = f__30407__auto__.call(null);
(statearr_31742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___31743);

return statearr_31742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___31743,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args31800 = [];
var len__28242__auto___31803 = arguments.length;
var i__28243__auto___31804 = (0);
while(true){
if((i__28243__auto___31804 < len__28242__auto___31803)){
args31800.push((arguments[i__28243__auto___31804]));

var G__31805 = (i__28243__auto___31804 + (1));
i__28243__auto___31804 = G__31805;
continue;
} else {
}
break;
}

var G__31802 = args31800.length;
switch (G__31802) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args31800.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m,ch);
} else {
var m__27740__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m,ch);
} else {
var m__27740__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m);
} else {
var m__27740__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m,state_map);
} else {
var m__27740__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27739__auto__ = (((m == null))?null:m);
var m__27740__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,m,mode);
} else {
var m__27740__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28249__auto__ = [];
var len__28242__auto___31817 = arguments.length;
var i__28243__auto___31818 = (0);
while(true){
if((i__28243__auto___31818 < len__28242__auto___31817)){
args__28249__auto__.push((arguments[i__28243__auto___31818]));

var G__31819 = (i__28243__auto___31818 + (1));
i__28243__auto___31818 = G__31819;
continue;
} else {
}
break;
}

var argseq__28250__auto__ = ((((3) < args__28249__auto__.length))?(new cljs.core.IndexedSeq(args__28249__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28250__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31811){
var map__31812 = p__31811;
var map__31812__$1 = ((((!((map__31812 == null)))?((((map__31812.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31812.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31812):map__31812);
var opts = map__31812__$1;
var statearr_31814_31820 = state;
(statearr_31814_31820[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__31812,map__31812__$1,opts){
return (function (val){
var statearr_31815_31821 = state;
(statearr_31815_31821[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31812,map__31812__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_31816_31822 = state;
(statearr_31816_31822[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31807){
var G__31808 = cljs.core.first.call(null,seq31807);
var seq31807__$1 = cljs.core.next.call(null,seq31807);
var G__31809 = cljs.core.first.call(null,seq31807__$1);
var seq31807__$2 = cljs.core.next.call(null,seq31807__$1);
var G__31810 = cljs.core.first.call(null,seq31807__$2);
var seq31807__$3 = cljs.core.next.call(null,seq31807__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31808,G__31809,G__31810,seq31807__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31990 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31990 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta31991){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta31991 = meta31991;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31992,meta31991__$1){
var self__ = this;
var _31992__$1 = this;
return (new cljs.core.async.t_cljs$core$async31990(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta31991__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31992){
var self__ = this;
var _31992__$1 = this;
return self__.meta31991;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta31991","meta31991",889251314,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31990.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31990.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31990";

cljs.core.async.t_cljs$core$async31990.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async31990");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31990 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31990(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31991){
return (new cljs.core.async.t_cljs$core$async31990(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta31991));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31990(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30406__auto___32157 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___32157,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___32157,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32094){
var state_val_32095 = (state_32094[(1)]);
if((state_val_32095 === (7))){
var inst_32009 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32096_32158 = state_32094__$1;
(statearr_32096_32158[(2)] = inst_32009);

(statearr_32096_32158[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (20))){
var inst_32021 = (state_32094[(7)]);
var state_32094__$1 = state_32094;
var statearr_32097_32159 = state_32094__$1;
(statearr_32097_32159[(2)] = inst_32021);

(statearr_32097_32159[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (27))){
var state_32094__$1 = state_32094;
var statearr_32098_32160 = state_32094__$1;
(statearr_32098_32160[(2)] = null);

(statearr_32098_32160[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (1))){
var inst_31996 = (state_32094[(8)]);
var inst_31996__$1 = calc_state.call(null);
var inst_31998 = (inst_31996__$1 == null);
var inst_31999 = cljs.core.not.call(null,inst_31998);
var state_32094__$1 = (function (){var statearr_32099 = state_32094;
(statearr_32099[(8)] = inst_31996__$1);

return statearr_32099;
})();
if(inst_31999){
var statearr_32100_32161 = state_32094__$1;
(statearr_32100_32161[(1)] = (2));

} else {
var statearr_32101_32162 = state_32094__$1;
(statearr_32101_32162[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (24))){
var inst_32068 = (state_32094[(9)]);
var inst_32054 = (state_32094[(10)]);
var inst_32045 = (state_32094[(11)]);
var inst_32068__$1 = inst_32045.call(null,inst_32054);
var state_32094__$1 = (function (){var statearr_32102 = state_32094;
(statearr_32102[(9)] = inst_32068__$1);

return statearr_32102;
})();
if(cljs.core.truth_(inst_32068__$1)){
var statearr_32103_32163 = state_32094__$1;
(statearr_32103_32163[(1)] = (29));

} else {
var statearr_32104_32164 = state_32094__$1;
(statearr_32104_32164[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (4))){
var inst_32012 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32012)){
var statearr_32105_32165 = state_32094__$1;
(statearr_32105_32165[(1)] = (8));

} else {
var statearr_32106_32166 = state_32094__$1;
(statearr_32106_32166[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (15))){
var inst_32039 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32039)){
var statearr_32107_32167 = state_32094__$1;
(statearr_32107_32167[(1)] = (19));

} else {
var statearr_32108_32168 = state_32094__$1;
(statearr_32108_32168[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (21))){
var inst_32044 = (state_32094[(12)]);
var inst_32044__$1 = (state_32094[(2)]);
var inst_32045 = cljs.core.get.call(null,inst_32044__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32046 = cljs.core.get.call(null,inst_32044__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32047 = cljs.core.get.call(null,inst_32044__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32094__$1 = (function (){var statearr_32109 = state_32094;
(statearr_32109[(13)] = inst_32046);

(statearr_32109[(12)] = inst_32044__$1);

(statearr_32109[(11)] = inst_32045);

return statearr_32109;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_32094__$1,(22),inst_32047);
} else {
if((state_val_32095 === (31))){
var inst_32076 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32076)){
var statearr_32110_32169 = state_32094__$1;
(statearr_32110_32169[(1)] = (32));

} else {
var statearr_32111_32170 = state_32094__$1;
(statearr_32111_32170[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (32))){
var inst_32053 = (state_32094[(14)]);
var state_32094__$1 = state_32094;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32094__$1,(35),out,inst_32053);
} else {
if((state_val_32095 === (33))){
var inst_32044 = (state_32094[(12)]);
var inst_32021 = inst_32044;
var state_32094__$1 = (function (){var statearr_32112 = state_32094;
(statearr_32112[(7)] = inst_32021);

return statearr_32112;
})();
var statearr_32113_32171 = state_32094__$1;
(statearr_32113_32171[(2)] = null);

(statearr_32113_32171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (13))){
var inst_32021 = (state_32094[(7)]);
var inst_32028 = inst_32021.cljs$lang$protocol_mask$partition0$;
var inst_32029 = (inst_32028 & (64));
var inst_32030 = inst_32021.cljs$core$ISeq$;
var inst_32031 = (cljs.core.PROTOCOL_SENTINEL === inst_32030);
var inst_32032 = (inst_32029) || (inst_32031);
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32032)){
var statearr_32114_32172 = state_32094__$1;
(statearr_32114_32172[(1)] = (16));

} else {
var statearr_32115_32173 = state_32094__$1;
(statearr_32115_32173[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (22))){
var inst_32054 = (state_32094[(10)]);
var inst_32053 = (state_32094[(14)]);
var inst_32052 = (state_32094[(2)]);
var inst_32053__$1 = cljs.core.nth.call(null,inst_32052,(0),null);
var inst_32054__$1 = cljs.core.nth.call(null,inst_32052,(1),null);
var inst_32055 = (inst_32053__$1 == null);
var inst_32056 = cljs.core._EQ_.call(null,inst_32054__$1,change);
var inst_32057 = (inst_32055) || (inst_32056);
var state_32094__$1 = (function (){var statearr_32116 = state_32094;
(statearr_32116[(10)] = inst_32054__$1);

(statearr_32116[(14)] = inst_32053__$1);

return statearr_32116;
})();
if(cljs.core.truth_(inst_32057)){
var statearr_32117_32174 = state_32094__$1;
(statearr_32117_32174[(1)] = (23));

} else {
var statearr_32118_32175 = state_32094__$1;
(statearr_32118_32175[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (36))){
var inst_32044 = (state_32094[(12)]);
var inst_32021 = inst_32044;
var state_32094__$1 = (function (){var statearr_32119 = state_32094;
(statearr_32119[(7)] = inst_32021);

return statearr_32119;
})();
var statearr_32120_32176 = state_32094__$1;
(statearr_32120_32176[(2)] = null);

(statearr_32120_32176[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (29))){
var inst_32068 = (state_32094[(9)]);
var state_32094__$1 = state_32094;
var statearr_32121_32177 = state_32094__$1;
(statearr_32121_32177[(2)] = inst_32068);

(statearr_32121_32177[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (6))){
var state_32094__$1 = state_32094;
var statearr_32122_32178 = state_32094__$1;
(statearr_32122_32178[(2)] = false);

(statearr_32122_32178[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (28))){
var inst_32064 = (state_32094[(2)]);
var inst_32065 = calc_state.call(null);
var inst_32021 = inst_32065;
var state_32094__$1 = (function (){var statearr_32123 = state_32094;
(statearr_32123[(15)] = inst_32064);

(statearr_32123[(7)] = inst_32021);

return statearr_32123;
})();
var statearr_32124_32179 = state_32094__$1;
(statearr_32124_32179[(2)] = null);

(statearr_32124_32179[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (25))){
var inst_32090 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32125_32180 = state_32094__$1;
(statearr_32125_32180[(2)] = inst_32090);

(statearr_32125_32180[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (34))){
var inst_32088 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32126_32181 = state_32094__$1;
(statearr_32126_32181[(2)] = inst_32088);

(statearr_32126_32181[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (17))){
var state_32094__$1 = state_32094;
var statearr_32127_32182 = state_32094__$1;
(statearr_32127_32182[(2)] = false);

(statearr_32127_32182[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (3))){
var state_32094__$1 = state_32094;
var statearr_32128_32183 = state_32094__$1;
(statearr_32128_32183[(2)] = false);

(statearr_32128_32183[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (12))){
var inst_32092 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32094__$1,inst_32092);
} else {
if((state_val_32095 === (2))){
var inst_31996 = (state_32094[(8)]);
var inst_32001 = inst_31996.cljs$lang$protocol_mask$partition0$;
var inst_32002 = (inst_32001 & (64));
var inst_32003 = inst_31996.cljs$core$ISeq$;
var inst_32004 = (cljs.core.PROTOCOL_SENTINEL === inst_32003);
var inst_32005 = (inst_32002) || (inst_32004);
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32005)){
var statearr_32129_32184 = state_32094__$1;
(statearr_32129_32184[(1)] = (5));

} else {
var statearr_32130_32185 = state_32094__$1;
(statearr_32130_32185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (23))){
var inst_32053 = (state_32094[(14)]);
var inst_32059 = (inst_32053 == null);
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32059)){
var statearr_32131_32186 = state_32094__$1;
(statearr_32131_32186[(1)] = (26));

} else {
var statearr_32132_32187 = state_32094__$1;
(statearr_32132_32187[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (35))){
var inst_32079 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
if(cljs.core.truth_(inst_32079)){
var statearr_32133_32188 = state_32094__$1;
(statearr_32133_32188[(1)] = (36));

} else {
var statearr_32134_32189 = state_32094__$1;
(statearr_32134_32189[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (19))){
var inst_32021 = (state_32094[(7)]);
var inst_32041 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32021);
var state_32094__$1 = state_32094;
var statearr_32135_32190 = state_32094__$1;
(statearr_32135_32190[(2)] = inst_32041);

(statearr_32135_32190[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (11))){
var inst_32021 = (state_32094[(7)]);
var inst_32025 = (inst_32021 == null);
var inst_32026 = cljs.core.not.call(null,inst_32025);
var state_32094__$1 = state_32094;
if(inst_32026){
var statearr_32136_32191 = state_32094__$1;
(statearr_32136_32191[(1)] = (13));

} else {
var statearr_32137_32192 = state_32094__$1;
(statearr_32137_32192[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (9))){
var inst_31996 = (state_32094[(8)]);
var state_32094__$1 = state_32094;
var statearr_32138_32193 = state_32094__$1;
(statearr_32138_32193[(2)] = inst_31996);

(statearr_32138_32193[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (5))){
var state_32094__$1 = state_32094;
var statearr_32139_32194 = state_32094__$1;
(statearr_32139_32194[(2)] = true);

(statearr_32139_32194[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (14))){
var state_32094__$1 = state_32094;
var statearr_32140_32195 = state_32094__$1;
(statearr_32140_32195[(2)] = false);

(statearr_32140_32195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (26))){
var inst_32054 = (state_32094[(10)]);
var inst_32061 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_32054);
var state_32094__$1 = state_32094;
var statearr_32141_32196 = state_32094__$1;
(statearr_32141_32196[(2)] = inst_32061);

(statearr_32141_32196[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (16))){
var state_32094__$1 = state_32094;
var statearr_32142_32197 = state_32094__$1;
(statearr_32142_32197[(2)] = true);

(statearr_32142_32197[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (38))){
var inst_32084 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32143_32198 = state_32094__$1;
(statearr_32143_32198[(2)] = inst_32084);

(statearr_32143_32198[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (30))){
var inst_32046 = (state_32094[(13)]);
var inst_32054 = (state_32094[(10)]);
var inst_32045 = (state_32094[(11)]);
var inst_32071 = cljs.core.empty_QMARK_.call(null,inst_32045);
var inst_32072 = inst_32046.call(null,inst_32054);
var inst_32073 = cljs.core.not.call(null,inst_32072);
var inst_32074 = (inst_32071) && (inst_32073);
var state_32094__$1 = state_32094;
var statearr_32144_32199 = state_32094__$1;
(statearr_32144_32199[(2)] = inst_32074);

(statearr_32144_32199[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (10))){
var inst_31996 = (state_32094[(8)]);
var inst_32017 = (state_32094[(2)]);
var inst_32018 = cljs.core.get.call(null,inst_32017,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32019 = cljs.core.get.call(null,inst_32017,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32020 = cljs.core.get.call(null,inst_32017,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32021 = inst_31996;
var state_32094__$1 = (function (){var statearr_32145 = state_32094;
(statearr_32145[(16)] = inst_32018);

(statearr_32145[(17)] = inst_32020);

(statearr_32145[(7)] = inst_32021);

(statearr_32145[(18)] = inst_32019);

return statearr_32145;
})();
var statearr_32146_32200 = state_32094__$1;
(statearr_32146_32200[(2)] = null);

(statearr_32146_32200[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (18))){
var inst_32036 = (state_32094[(2)]);
var state_32094__$1 = state_32094;
var statearr_32147_32201 = state_32094__$1;
(statearr_32147_32201[(2)] = inst_32036);

(statearr_32147_32201[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (37))){
var state_32094__$1 = state_32094;
var statearr_32148_32202 = state_32094__$1;
(statearr_32148_32202[(2)] = null);

(statearr_32148_32202[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32095 === (8))){
var inst_31996 = (state_32094[(8)]);
var inst_32014 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31996);
var state_32094__$1 = state_32094;
var statearr_32149_32203 = state_32094__$1;
(statearr_32149_32203[(2)] = inst_32014);

(statearr_32149_32203[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___32157,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30292__auto__,c__30406__auto___32157,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30293__auto__ = null;
var cljs$core$async$mix_$_state_machine__30293__auto____0 = (function (){
var statearr_32153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32153[(0)] = cljs$core$async$mix_$_state_machine__30293__auto__);

(statearr_32153[(1)] = (1));

return statearr_32153;
});
var cljs$core$async$mix_$_state_machine__30293__auto____1 = (function (state_32094){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e32154){if((e32154 instanceof Object)){
var ex__30296__auto__ = e32154;
var statearr_32155_32204 = state_32094;
(statearr_32155_32204[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32094);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32154;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32205 = state_32094;
state_32094 = G__32205;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30293__auto__ = function(state_32094){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30293__auto____1.call(this,state_32094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30293__auto____0;
cljs$core$async$mix_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30293__auto____1;
return cljs$core$async$mix_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___32157,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30408__auto__ = (function (){var statearr_32156 = f__30407__auto__.call(null);
(statearr_32156[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___32157);

return statearr_32156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___32157,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27739__auto__ = (((p == null))?null:p);
var m__27740__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27740__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27739__auto__ = (((p == null))?null:p);
var m__27740__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,p,v,ch);
} else {
var m__27740__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args32206 = [];
var len__28242__auto___32209 = arguments.length;
var i__28243__auto___32210 = (0);
while(true){
if((i__28243__auto___32210 < len__28242__auto___32209)){
args32206.push((arguments[i__28243__auto___32210]));

var G__32211 = (i__28243__auto___32210 + (1));
i__28243__auto___32210 = G__32211;
continue;
} else {
}
break;
}

var G__32208 = args32206.length;
switch (G__32208) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32206.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27739__auto__ = (((p == null))?null:p);
var m__27740__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,p);
} else {
var m__27740__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27739__auto__ = (((p == null))?null:p);
var m__27740__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27739__auto__)]);
if(!((m__27740__auto__ == null))){
return m__27740__auto__.call(null,p,v);
} else {
var m__27740__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27740__auto____$1 == null))){
return m__27740__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args32214 = [];
var len__28242__auto___32339 = arguments.length;
var i__28243__auto___32340 = (0);
while(true){
if((i__28243__auto___32340 < len__28242__auto___32339)){
args32214.push((arguments[i__28243__auto___32340]));

var G__32341 = (i__28243__auto___32340 + (1));
i__28243__auto___32340 = G__32341;
continue;
} else {
}
break;
}

var G__32216 = args32214.length;
switch (G__32216) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32214.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27021__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27021__auto__)){
return or__27021__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27021__auto__,mults){
return (function (p1__32213_SHARP_){
if(cljs.core.truth_(p1__32213_SHARP_.call(null,topic))){
return p1__32213_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32213_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27021__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32217 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32217 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32218){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32218 = meta32218;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32219,meta32218__$1){
var self__ = this;
var _32219__$1 = this;
return (new cljs.core.async.t_cljs$core$async32217(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32218__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32219){
var self__ = this;
var _32219__$1 = this;
return self__.meta32218;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32218","meta32218",-1671580388,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32217.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32217.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32217";

cljs.core.async.t_cljs$core$async32217.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async32217");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32217 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32217(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32218){
return (new cljs.core.async.t_cljs$core$async32217(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32218));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32217(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30406__auto___32343 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___32343,mults,ensure_mult,p){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___32343,mults,ensure_mult,p){
return (function (state_32291){
var state_val_32292 = (state_32291[(1)]);
if((state_val_32292 === (7))){
var inst_32287 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32293_32344 = state_32291__$1;
(statearr_32293_32344[(2)] = inst_32287);

(statearr_32293_32344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (20))){
var state_32291__$1 = state_32291;
var statearr_32294_32345 = state_32291__$1;
(statearr_32294_32345[(2)] = null);

(statearr_32294_32345[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (1))){
var state_32291__$1 = state_32291;
var statearr_32295_32346 = state_32291__$1;
(statearr_32295_32346[(2)] = null);

(statearr_32295_32346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (24))){
var inst_32270 = (state_32291[(7)]);
var inst_32279 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32270);
var state_32291__$1 = state_32291;
var statearr_32296_32347 = state_32291__$1;
(statearr_32296_32347[(2)] = inst_32279);

(statearr_32296_32347[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (4))){
var inst_32222 = (state_32291[(8)]);
var inst_32222__$1 = (state_32291[(2)]);
var inst_32223 = (inst_32222__$1 == null);
var state_32291__$1 = (function (){var statearr_32297 = state_32291;
(statearr_32297[(8)] = inst_32222__$1);

return statearr_32297;
})();
if(cljs.core.truth_(inst_32223)){
var statearr_32298_32348 = state_32291__$1;
(statearr_32298_32348[(1)] = (5));

} else {
var statearr_32299_32349 = state_32291__$1;
(statearr_32299_32349[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (15))){
var inst_32264 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32300_32350 = state_32291__$1;
(statearr_32300_32350[(2)] = inst_32264);

(statearr_32300_32350[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (21))){
var inst_32284 = (state_32291[(2)]);
var state_32291__$1 = (function (){var statearr_32301 = state_32291;
(statearr_32301[(9)] = inst_32284);

return statearr_32301;
})();
var statearr_32302_32351 = state_32291__$1;
(statearr_32302_32351[(2)] = null);

(statearr_32302_32351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (13))){
var inst_32246 = (state_32291[(10)]);
var inst_32248 = cljs.core.chunked_seq_QMARK_.call(null,inst_32246);
var state_32291__$1 = state_32291;
if(inst_32248){
var statearr_32303_32352 = state_32291__$1;
(statearr_32303_32352[(1)] = (16));

} else {
var statearr_32304_32353 = state_32291__$1;
(statearr_32304_32353[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (22))){
var inst_32276 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
if(cljs.core.truth_(inst_32276)){
var statearr_32305_32354 = state_32291__$1;
(statearr_32305_32354[(1)] = (23));

} else {
var statearr_32306_32355 = state_32291__$1;
(statearr_32306_32355[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (6))){
var inst_32270 = (state_32291[(7)]);
var inst_32222 = (state_32291[(8)]);
var inst_32272 = (state_32291[(11)]);
var inst_32270__$1 = topic_fn.call(null,inst_32222);
var inst_32271 = cljs.core.deref.call(null,mults);
var inst_32272__$1 = cljs.core.get.call(null,inst_32271,inst_32270__$1);
var state_32291__$1 = (function (){var statearr_32307 = state_32291;
(statearr_32307[(7)] = inst_32270__$1);

(statearr_32307[(11)] = inst_32272__$1);

return statearr_32307;
})();
if(cljs.core.truth_(inst_32272__$1)){
var statearr_32308_32356 = state_32291__$1;
(statearr_32308_32356[(1)] = (19));

} else {
var statearr_32309_32357 = state_32291__$1;
(statearr_32309_32357[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (25))){
var inst_32281 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32310_32358 = state_32291__$1;
(statearr_32310_32358[(2)] = inst_32281);

(statearr_32310_32358[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (17))){
var inst_32246 = (state_32291[(10)]);
var inst_32255 = cljs.core.first.call(null,inst_32246);
var inst_32256 = cljs.core.async.muxch_STAR_.call(null,inst_32255);
var inst_32257 = cljs.core.async.close_BANG_.call(null,inst_32256);
var inst_32258 = cljs.core.next.call(null,inst_32246);
var inst_32232 = inst_32258;
var inst_32233 = null;
var inst_32234 = (0);
var inst_32235 = (0);
var state_32291__$1 = (function (){var statearr_32311 = state_32291;
(statearr_32311[(12)] = inst_32234);

(statearr_32311[(13)] = inst_32233);

(statearr_32311[(14)] = inst_32232);

(statearr_32311[(15)] = inst_32235);

(statearr_32311[(16)] = inst_32257);

return statearr_32311;
})();
var statearr_32312_32359 = state_32291__$1;
(statearr_32312_32359[(2)] = null);

(statearr_32312_32359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (3))){
var inst_32289 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32291__$1,inst_32289);
} else {
if((state_val_32292 === (12))){
var inst_32266 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32313_32360 = state_32291__$1;
(statearr_32313_32360[(2)] = inst_32266);

(statearr_32313_32360[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (2))){
var state_32291__$1 = state_32291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32291__$1,(4),ch);
} else {
if((state_val_32292 === (23))){
var state_32291__$1 = state_32291;
var statearr_32314_32361 = state_32291__$1;
(statearr_32314_32361[(2)] = null);

(statearr_32314_32361[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (19))){
var inst_32222 = (state_32291[(8)]);
var inst_32272 = (state_32291[(11)]);
var inst_32274 = cljs.core.async.muxch_STAR_.call(null,inst_32272);
var state_32291__$1 = state_32291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32291__$1,(22),inst_32274,inst_32222);
} else {
if((state_val_32292 === (11))){
var inst_32246 = (state_32291[(10)]);
var inst_32232 = (state_32291[(14)]);
var inst_32246__$1 = cljs.core.seq.call(null,inst_32232);
var state_32291__$1 = (function (){var statearr_32315 = state_32291;
(statearr_32315[(10)] = inst_32246__$1);

return statearr_32315;
})();
if(inst_32246__$1){
var statearr_32316_32362 = state_32291__$1;
(statearr_32316_32362[(1)] = (13));

} else {
var statearr_32317_32363 = state_32291__$1;
(statearr_32317_32363[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (9))){
var inst_32268 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32318_32364 = state_32291__$1;
(statearr_32318_32364[(2)] = inst_32268);

(statearr_32318_32364[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (5))){
var inst_32229 = cljs.core.deref.call(null,mults);
var inst_32230 = cljs.core.vals.call(null,inst_32229);
var inst_32231 = cljs.core.seq.call(null,inst_32230);
var inst_32232 = inst_32231;
var inst_32233 = null;
var inst_32234 = (0);
var inst_32235 = (0);
var state_32291__$1 = (function (){var statearr_32319 = state_32291;
(statearr_32319[(12)] = inst_32234);

(statearr_32319[(13)] = inst_32233);

(statearr_32319[(14)] = inst_32232);

(statearr_32319[(15)] = inst_32235);

return statearr_32319;
})();
var statearr_32320_32365 = state_32291__$1;
(statearr_32320_32365[(2)] = null);

(statearr_32320_32365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (14))){
var state_32291__$1 = state_32291;
var statearr_32324_32366 = state_32291__$1;
(statearr_32324_32366[(2)] = null);

(statearr_32324_32366[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (16))){
var inst_32246 = (state_32291[(10)]);
var inst_32250 = cljs.core.chunk_first.call(null,inst_32246);
var inst_32251 = cljs.core.chunk_rest.call(null,inst_32246);
var inst_32252 = cljs.core.count.call(null,inst_32250);
var inst_32232 = inst_32251;
var inst_32233 = inst_32250;
var inst_32234 = inst_32252;
var inst_32235 = (0);
var state_32291__$1 = (function (){var statearr_32325 = state_32291;
(statearr_32325[(12)] = inst_32234);

(statearr_32325[(13)] = inst_32233);

(statearr_32325[(14)] = inst_32232);

(statearr_32325[(15)] = inst_32235);

return statearr_32325;
})();
var statearr_32326_32367 = state_32291__$1;
(statearr_32326_32367[(2)] = null);

(statearr_32326_32367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (10))){
var inst_32234 = (state_32291[(12)]);
var inst_32233 = (state_32291[(13)]);
var inst_32232 = (state_32291[(14)]);
var inst_32235 = (state_32291[(15)]);
var inst_32240 = cljs.core._nth.call(null,inst_32233,inst_32235);
var inst_32241 = cljs.core.async.muxch_STAR_.call(null,inst_32240);
var inst_32242 = cljs.core.async.close_BANG_.call(null,inst_32241);
var inst_32243 = (inst_32235 + (1));
var tmp32321 = inst_32234;
var tmp32322 = inst_32233;
var tmp32323 = inst_32232;
var inst_32232__$1 = tmp32323;
var inst_32233__$1 = tmp32322;
var inst_32234__$1 = tmp32321;
var inst_32235__$1 = inst_32243;
var state_32291__$1 = (function (){var statearr_32327 = state_32291;
(statearr_32327[(12)] = inst_32234__$1);

(statearr_32327[(13)] = inst_32233__$1);

(statearr_32327[(17)] = inst_32242);

(statearr_32327[(14)] = inst_32232__$1);

(statearr_32327[(15)] = inst_32235__$1);

return statearr_32327;
})();
var statearr_32328_32368 = state_32291__$1;
(statearr_32328_32368[(2)] = null);

(statearr_32328_32368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (18))){
var inst_32261 = (state_32291[(2)]);
var state_32291__$1 = state_32291;
var statearr_32329_32369 = state_32291__$1;
(statearr_32329_32369[(2)] = inst_32261);

(statearr_32329_32369[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32292 === (8))){
var inst_32234 = (state_32291[(12)]);
var inst_32235 = (state_32291[(15)]);
var inst_32237 = (inst_32235 < inst_32234);
var inst_32238 = inst_32237;
var state_32291__$1 = state_32291;
if(cljs.core.truth_(inst_32238)){
var statearr_32330_32370 = state_32291__$1;
(statearr_32330_32370[(1)] = (10));

} else {
var statearr_32331_32371 = state_32291__$1;
(statearr_32331_32371[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___32343,mults,ensure_mult,p))
;
return ((function (switch__30292__auto__,c__30406__auto___32343,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_32335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32335[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_32335[(1)] = (1));

return statearr_32335;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_32291){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e32336){if((e32336 instanceof Object)){
var ex__30296__auto__ = e32336;
var statearr_32337_32372 = state_32291;
(statearr_32337_32372[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32336;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32373 = state_32291;
state_32291 = G__32373;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_32291){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_32291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___32343,mults,ensure_mult,p))
})();
var state__30408__auto__ = (function (){var statearr_32338 = f__30407__auto__.call(null);
(statearr_32338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___32343);

return statearr_32338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___32343,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args32374 = [];
var len__28242__auto___32377 = arguments.length;
var i__28243__auto___32378 = (0);
while(true){
if((i__28243__auto___32378 < len__28242__auto___32377)){
args32374.push((arguments[i__28243__auto___32378]));

var G__32379 = (i__28243__auto___32378 + (1));
i__28243__auto___32378 = G__32379;
continue;
} else {
}
break;
}

var G__32376 = args32374.length;
switch (G__32376) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32374.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args32381 = [];
var len__28242__auto___32384 = arguments.length;
var i__28243__auto___32385 = (0);
while(true){
if((i__28243__auto___32385 < len__28242__auto___32384)){
args32381.push((arguments[i__28243__auto___32385]));

var G__32386 = (i__28243__auto___32385 + (1));
i__28243__auto___32385 = G__32386;
continue;
} else {
}
break;
}

var G__32383 = args32381.length;
switch (G__32383) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32381.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args32388 = [];
var len__28242__auto___32459 = arguments.length;
var i__28243__auto___32460 = (0);
while(true){
if((i__28243__auto___32460 < len__28242__auto___32459)){
args32388.push((arguments[i__28243__auto___32460]));

var G__32461 = (i__28243__auto___32460 + (1));
i__28243__auto___32460 = G__32461;
continue;
} else {
}
break;
}

var G__32390 = args32388.length;
switch (G__32390) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32388.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30406__auto___32463 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___32463,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___32463,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32429){
var state_val_32430 = (state_32429[(1)]);
if((state_val_32430 === (7))){
var state_32429__$1 = state_32429;
var statearr_32431_32464 = state_32429__$1;
(statearr_32431_32464[(2)] = null);

(statearr_32431_32464[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (1))){
var state_32429__$1 = state_32429;
var statearr_32432_32465 = state_32429__$1;
(statearr_32432_32465[(2)] = null);

(statearr_32432_32465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (4))){
var inst_32393 = (state_32429[(7)]);
var inst_32395 = (inst_32393 < cnt);
var state_32429__$1 = state_32429;
if(cljs.core.truth_(inst_32395)){
var statearr_32433_32466 = state_32429__$1;
(statearr_32433_32466[(1)] = (6));

} else {
var statearr_32434_32467 = state_32429__$1;
(statearr_32434_32467[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (15))){
var inst_32425 = (state_32429[(2)]);
var state_32429__$1 = state_32429;
var statearr_32435_32468 = state_32429__$1;
(statearr_32435_32468[(2)] = inst_32425);

(statearr_32435_32468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (13))){
var inst_32418 = cljs.core.async.close_BANG_.call(null,out);
var state_32429__$1 = state_32429;
var statearr_32436_32469 = state_32429__$1;
(statearr_32436_32469[(2)] = inst_32418);

(statearr_32436_32469[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (6))){
var state_32429__$1 = state_32429;
var statearr_32437_32470 = state_32429__$1;
(statearr_32437_32470[(2)] = null);

(statearr_32437_32470[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (3))){
var inst_32427 = (state_32429[(2)]);
var state_32429__$1 = state_32429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32429__$1,inst_32427);
} else {
if((state_val_32430 === (12))){
var inst_32415 = (state_32429[(8)]);
var inst_32415__$1 = (state_32429[(2)]);
var inst_32416 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32415__$1);
var state_32429__$1 = (function (){var statearr_32438 = state_32429;
(statearr_32438[(8)] = inst_32415__$1);

return statearr_32438;
})();
if(cljs.core.truth_(inst_32416)){
var statearr_32439_32471 = state_32429__$1;
(statearr_32439_32471[(1)] = (13));

} else {
var statearr_32440_32472 = state_32429__$1;
(statearr_32440_32472[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (2))){
var inst_32392 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32393 = (0);
var state_32429__$1 = (function (){var statearr_32441 = state_32429;
(statearr_32441[(7)] = inst_32393);

(statearr_32441[(9)] = inst_32392);

return statearr_32441;
})();
var statearr_32442_32473 = state_32429__$1;
(statearr_32442_32473[(2)] = null);

(statearr_32442_32473[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (11))){
var inst_32393 = (state_32429[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32429,(10),Object,null,(9));
var inst_32402 = chs__$1.call(null,inst_32393);
var inst_32403 = done.call(null,inst_32393);
var inst_32404 = cljs.core.async.take_BANG_.call(null,inst_32402,inst_32403);
var state_32429__$1 = state_32429;
var statearr_32443_32474 = state_32429__$1;
(statearr_32443_32474[(2)] = inst_32404);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32429__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (9))){
var inst_32393 = (state_32429[(7)]);
var inst_32406 = (state_32429[(2)]);
var inst_32407 = (inst_32393 + (1));
var inst_32393__$1 = inst_32407;
var state_32429__$1 = (function (){var statearr_32444 = state_32429;
(statearr_32444[(10)] = inst_32406);

(statearr_32444[(7)] = inst_32393__$1);

return statearr_32444;
})();
var statearr_32445_32475 = state_32429__$1;
(statearr_32445_32475[(2)] = null);

(statearr_32445_32475[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (5))){
var inst_32413 = (state_32429[(2)]);
var state_32429__$1 = (function (){var statearr_32446 = state_32429;
(statearr_32446[(11)] = inst_32413);

return statearr_32446;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32429__$1,(12),dchan);
} else {
if((state_val_32430 === (14))){
var inst_32415 = (state_32429[(8)]);
var inst_32420 = cljs.core.apply.call(null,f,inst_32415);
var state_32429__$1 = state_32429;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32429__$1,(16),out,inst_32420);
} else {
if((state_val_32430 === (16))){
var inst_32422 = (state_32429[(2)]);
var state_32429__$1 = (function (){var statearr_32447 = state_32429;
(statearr_32447[(12)] = inst_32422);

return statearr_32447;
})();
var statearr_32448_32476 = state_32429__$1;
(statearr_32448_32476[(2)] = null);

(statearr_32448_32476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (10))){
var inst_32397 = (state_32429[(2)]);
var inst_32398 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32429__$1 = (function (){var statearr_32449 = state_32429;
(statearr_32449[(13)] = inst_32397);

return statearr_32449;
})();
var statearr_32450_32477 = state_32429__$1;
(statearr_32450_32477[(2)] = inst_32398);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32429__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32430 === (8))){
var inst_32411 = (state_32429[(2)]);
var state_32429__$1 = state_32429;
var statearr_32451_32478 = state_32429__$1;
(statearr_32451_32478[(2)] = inst_32411);

(statearr_32451_32478[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___32463,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30292__auto__,c__30406__auto___32463,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_32455 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32455[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_32455[(1)] = (1));

return statearr_32455;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_32429){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e32456){if((e32456 instanceof Object)){
var ex__30296__auto__ = e32456;
var statearr_32457_32479 = state_32429;
(statearr_32457_32479[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32429);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32456;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32480 = state_32429;
state_32429 = G__32480;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_32429){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_32429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___32463,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30408__auto__ = (function (){var statearr_32458 = f__30407__auto__.call(null);
(statearr_32458[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___32463);

return statearr_32458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___32463,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args32482 = [];
var len__28242__auto___32540 = arguments.length;
var i__28243__auto___32541 = (0);
while(true){
if((i__28243__auto___32541 < len__28242__auto___32540)){
args32482.push((arguments[i__28243__auto___32541]));

var G__32542 = (i__28243__auto___32541 + (1));
i__28243__auto___32541 = G__32542;
continue;
} else {
}
break;
}

var G__32484 = args32482.length;
switch (G__32484) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32482.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30406__auto___32544 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___32544,out){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___32544,out){
return (function (state_32516){
var state_val_32517 = (state_32516[(1)]);
if((state_val_32517 === (7))){
var inst_32496 = (state_32516[(7)]);
var inst_32495 = (state_32516[(8)]);
var inst_32495__$1 = (state_32516[(2)]);
var inst_32496__$1 = cljs.core.nth.call(null,inst_32495__$1,(0),null);
var inst_32497 = cljs.core.nth.call(null,inst_32495__$1,(1),null);
var inst_32498 = (inst_32496__$1 == null);
var state_32516__$1 = (function (){var statearr_32518 = state_32516;
(statearr_32518[(7)] = inst_32496__$1);

(statearr_32518[(8)] = inst_32495__$1);

(statearr_32518[(9)] = inst_32497);

return statearr_32518;
})();
if(cljs.core.truth_(inst_32498)){
var statearr_32519_32545 = state_32516__$1;
(statearr_32519_32545[(1)] = (8));

} else {
var statearr_32520_32546 = state_32516__$1;
(statearr_32520_32546[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32517 === (1))){
var inst_32485 = cljs.core.vec.call(null,chs);
var inst_32486 = inst_32485;
var state_32516__$1 = (function (){var statearr_32521 = state_32516;
(statearr_32521[(10)] = inst_32486);

return statearr_32521;
})();
var statearr_32522_32547 = state_32516__$1;
(statearr_32522_32547[(2)] = null);

(statearr_32522_32547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32517 === (4))){
var inst_32486 = (state_32516[(10)]);
var state_32516__$1 = state_32516;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32516__$1,(7),inst_32486);
} else {
if((state_val_32517 === (6))){
var inst_32512 = (state_32516[(2)]);
var state_32516__$1 = state_32516;
var statearr_32523_32548 = state_32516__$1;
(statearr_32523_32548[(2)] = inst_32512);

(statearr_32523_32548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32517 === (3))){
var inst_32514 = (state_32516[(2)]);
var state_32516__$1 = state_32516;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32516__$1,inst_32514);
} else {
if((state_val_32517 === (2))){
var inst_32486 = (state_32516[(10)]);
var inst_32488 = cljs.core.count.call(null,inst_32486);
var inst_32489 = (inst_32488 > (0));
var state_32516__$1 = state_32516;
if(cljs.core.truth_(inst_32489)){
var statearr_32525_32549 = state_32516__$1;
(statearr_32525_32549[(1)] = (4));

} else {
var statearr_32526_32550 = state_32516__$1;
(statearr_32526_32550[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32517 === (11))){
var inst_32486 = (state_32516[(10)]);
var inst_32505 = (state_32516[(2)]);
var tmp32524 = inst_32486;
var inst_32486__$1 = tmp32524;
var state_32516__$1 = (function (){var statearr_32527 = state_32516;
(statearr_32527[(11)] = inst_32505);

(statearr_32527[(10)] = inst_32486__$1);

return statearr_32527;
})();
var statearr_32528_32551 = state_32516__$1;
(statearr_32528_32551[(2)] = null);

(statearr_32528_32551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32517 === (9))){
var inst_32496 = (state_32516[(7)]);
var state_32516__$1 = state_32516;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32516__$1,(11),out,inst_32496);
} else {
if((state_val_32517 === (5))){
var inst_32510 = cljs.core.async.close_BANG_.call(null,out);
var state_32516__$1 = state_32516;
var statearr_32529_32552 = state_32516__$1;
(statearr_32529_32552[(2)] = inst_32510);

(statearr_32529_32552[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32517 === (10))){
var inst_32508 = (state_32516[(2)]);
var state_32516__$1 = state_32516;
var statearr_32530_32553 = state_32516__$1;
(statearr_32530_32553[(2)] = inst_32508);

(statearr_32530_32553[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32517 === (8))){
var inst_32496 = (state_32516[(7)]);
var inst_32495 = (state_32516[(8)]);
var inst_32497 = (state_32516[(9)]);
var inst_32486 = (state_32516[(10)]);
var inst_32500 = (function (){var cs = inst_32486;
var vec__32491 = inst_32495;
var v = inst_32496;
var c = inst_32497;
return ((function (cs,vec__32491,v,c,inst_32496,inst_32495,inst_32497,inst_32486,state_val_32517,c__30406__auto___32544,out){
return (function (p1__32481_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32481_SHARP_);
});
;})(cs,vec__32491,v,c,inst_32496,inst_32495,inst_32497,inst_32486,state_val_32517,c__30406__auto___32544,out))
})();
var inst_32501 = cljs.core.filterv.call(null,inst_32500,inst_32486);
var inst_32486__$1 = inst_32501;
var state_32516__$1 = (function (){var statearr_32531 = state_32516;
(statearr_32531[(10)] = inst_32486__$1);

return statearr_32531;
})();
var statearr_32532_32554 = state_32516__$1;
(statearr_32532_32554[(2)] = null);

(statearr_32532_32554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___32544,out))
;
return ((function (switch__30292__auto__,c__30406__auto___32544,out){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_32536 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32536[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_32536[(1)] = (1));

return statearr_32536;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_32516){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32516);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e32537){if((e32537 instanceof Object)){
var ex__30296__auto__ = e32537;
var statearr_32538_32555 = state_32516;
(statearr_32538_32555[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32516);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32556 = state_32516;
state_32516 = G__32556;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_32516){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_32516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___32544,out))
})();
var state__30408__auto__ = (function (){var statearr_32539 = f__30407__auto__.call(null);
(statearr_32539[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___32544);

return statearr_32539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___32544,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args32557 = [];
var len__28242__auto___32606 = arguments.length;
var i__28243__auto___32607 = (0);
while(true){
if((i__28243__auto___32607 < len__28242__auto___32606)){
args32557.push((arguments[i__28243__auto___32607]));

var G__32608 = (i__28243__auto___32607 + (1));
i__28243__auto___32607 = G__32608;
continue;
} else {
}
break;
}

var G__32559 = args32557.length;
switch (G__32559) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32557.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30406__auto___32610 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___32610,out){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___32610,out){
return (function (state_32583){
var state_val_32584 = (state_32583[(1)]);
if((state_val_32584 === (7))){
var inst_32565 = (state_32583[(7)]);
var inst_32565__$1 = (state_32583[(2)]);
var inst_32566 = (inst_32565__$1 == null);
var inst_32567 = cljs.core.not.call(null,inst_32566);
var state_32583__$1 = (function (){var statearr_32585 = state_32583;
(statearr_32585[(7)] = inst_32565__$1);

return statearr_32585;
})();
if(inst_32567){
var statearr_32586_32611 = state_32583__$1;
(statearr_32586_32611[(1)] = (8));

} else {
var statearr_32587_32612 = state_32583__$1;
(statearr_32587_32612[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (1))){
var inst_32560 = (0);
var state_32583__$1 = (function (){var statearr_32588 = state_32583;
(statearr_32588[(8)] = inst_32560);

return statearr_32588;
})();
var statearr_32589_32613 = state_32583__$1;
(statearr_32589_32613[(2)] = null);

(statearr_32589_32613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (4))){
var state_32583__$1 = state_32583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32583__$1,(7),ch);
} else {
if((state_val_32584 === (6))){
var inst_32578 = (state_32583[(2)]);
var state_32583__$1 = state_32583;
var statearr_32590_32614 = state_32583__$1;
(statearr_32590_32614[(2)] = inst_32578);

(statearr_32590_32614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (3))){
var inst_32580 = (state_32583[(2)]);
var inst_32581 = cljs.core.async.close_BANG_.call(null,out);
var state_32583__$1 = (function (){var statearr_32591 = state_32583;
(statearr_32591[(9)] = inst_32580);

return statearr_32591;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32583__$1,inst_32581);
} else {
if((state_val_32584 === (2))){
var inst_32560 = (state_32583[(8)]);
var inst_32562 = (inst_32560 < n);
var state_32583__$1 = state_32583;
if(cljs.core.truth_(inst_32562)){
var statearr_32592_32615 = state_32583__$1;
(statearr_32592_32615[(1)] = (4));

} else {
var statearr_32593_32616 = state_32583__$1;
(statearr_32593_32616[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (11))){
var inst_32560 = (state_32583[(8)]);
var inst_32570 = (state_32583[(2)]);
var inst_32571 = (inst_32560 + (1));
var inst_32560__$1 = inst_32571;
var state_32583__$1 = (function (){var statearr_32594 = state_32583;
(statearr_32594[(8)] = inst_32560__$1);

(statearr_32594[(10)] = inst_32570);

return statearr_32594;
})();
var statearr_32595_32617 = state_32583__$1;
(statearr_32595_32617[(2)] = null);

(statearr_32595_32617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (9))){
var state_32583__$1 = state_32583;
var statearr_32596_32618 = state_32583__$1;
(statearr_32596_32618[(2)] = null);

(statearr_32596_32618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (5))){
var state_32583__$1 = state_32583;
var statearr_32597_32619 = state_32583__$1;
(statearr_32597_32619[(2)] = null);

(statearr_32597_32619[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (10))){
var inst_32575 = (state_32583[(2)]);
var state_32583__$1 = state_32583;
var statearr_32598_32620 = state_32583__$1;
(statearr_32598_32620[(2)] = inst_32575);

(statearr_32598_32620[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32584 === (8))){
var inst_32565 = (state_32583[(7)]);
var state_32583__$1 = state_32583;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32583__$1,(11),out,inst_32565);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___32610,out))
;
return ((function (switch__30292__auto__,c__30406__auto___32610,out){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_32602 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32602[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_32602[(1)] = (1));

return statearr_32602;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_32583){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e32603){if((e32603 instanceof Object)){
var ex__30296__auto__ = e32603;
var statearr_32604_32621 = state_32583;
(statearr_32604_32621[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32583);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32603;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32622 = state_32583;
state_32583 = G__32622;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_32583){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_32583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___32610,out))
})();
var state__30408__auto__ = (function (){var statearr_32605 = f__30407__auto__.call(null);
(statearr_32605[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___32610);

return statearr_32605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___32610,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32630 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32630 = (function (f,ch,meta32631){
this.f = f;
this.ch = ch;
this.meta32631 = meta32631;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32632,meta32631__$1){
var self__ = this;
var _32632__$1 = this;
return (new cljs.core.async.t_cljs$core$async32630(self__.f,self__.ch,meta32631__$1));
});

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32632){
var self__ = this;
var _32632__$1 = this;
return self__.meta32631;
});

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32633 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32633 = (function (f,ch,meta32631,_,fn1,meta32634){
this.f = f;
this.ch = ch;
this.meta32631 = meta32631;
this._ = _;
this.fn1 = fn1;
this.meta32634 = meta32634;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32633.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32635,meta32634__$1){
var self__ = this;
var _32635__$1 = this;
return (new cljs.core.async.t_cljs$core$async32633(self__.f,self__.ch,self__.meta32631,self__._,self__.fn1,meta32634__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32633.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32635){
var self__ = this;
var _32635__$1 = this;
return self__.meta32634;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32633.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32633.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32633.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32633.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32623_SHARP_){
return f1.call(null,(((p1__32623_SHARP_ == null))?null:self__.f.call(null,p1__32623_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32633.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32631","meta32631",1542743918,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32630","cljs.core.async/t_cljs$core$async32630",659845845,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32634","meta32634",-1281424113,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32633.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32633.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32633";

cljs.core.async.t_cljs$core$async32633.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async32633");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32633 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32633(f__$1,ch__$1,meta32631__$1,___$2,fn1__$1,meta32634){
return (new cljs.core.async.t_cljs$core$async32633(f__$1,ch__$1,meta32631__$1,___$2,fn1__$1,meta32634));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32633(self__.f,self__.ch,self__.meta32631,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27009__auto__ = ret;
if(cljs.core.truth_(and__27009__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27009__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32630.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32630.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32631","meta32631",1542743918,null)], null);
});

cljs.core.async.t_cljs$core$async32630.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32630.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32630";

cljs.core.async.t_cljs$core$async32630.cljs$lang$ctorPrWriter = (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async32630");
});

cljs.core.async.__GT_t_cljs$core$async32630 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32630(f__$1,ch__$1,meta32631){
return (new cljs.core.async.t_cljs$core$async32630(f__$1,ch__$1,meta32631));
});

}

return (new cljs.core.async.t_cljs$core$async32630(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32639 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32639 = (function (f,ch,meta32640){
this.f = f;
this.ch = ch;
this.meta32640 = meta32640;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32641,meta32640__$1){
var self__ = this;
var _32641__$1 = this;
return (new cljs.core.async.t_cljs$core$async32639(self__.f,self__.ch,meta32640__$1));
});

cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32641){
var self__ = this;
var _32641__$1 = this;
return self__.meta32640;
});

cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32639.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32639.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32640","meta32640",384969228,null)], null);
});

cljs.core.async.t_cljs$core$async32639.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32639.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32639";

cljs.core.async.t_cljs$core$async32639.cljs$lang$ctorPrWriter = (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async32639");
});

cljs.core.async.__GT_t_cljs$core$async32639 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32639(f__$1,ch__$1,meta32640){
return (new cljs.core.async.t_cljs$core$async32639(f__$1,ch__$1,meta32640));
});

}

return (new cljs.core.async.t_cljs$core$async32639(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32645 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32645 = (function (p,ch,meta32646){
this.p = p;
this.ch = ch;
this.meta32646 = meta32646;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32647,meta32646__$1){
var self__ = this;
var _32647__$1 = this;
return (new cljs.core.async.t_cljs$core$async32645(self__.p,self__.ch,meta32646__$1));
});

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32647){
var self__ = this;
var _32647__$1 = this;
return self__.meta32646;
});

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32645.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32645.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32646","meta32646",-491350052,null)], null);
});

cljs.core.async.t_cljs$core$async32645.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32645.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32645";

cljs.core.async.t_cljs$core$async32645.cljs$lang$ctorPrWriter = (function (this__27678__auto__,writer__27679__auto__,opt__27680__auto__){
return cljs.core._write.call(null,writer__27679__auto__,"cljs.core.async/t_cljs$core$async32645");
});

cljs.core.async.__GT_t_cljs$core$async32645 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32645(p__$1,ch__$1,meta32646){
return (new cljs.core.async.t_cljs$core$async32645(p__$1,ch__$1,meta32646));
});

}

return (new cljs.core.async.t_cljs$core$async32645(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args32648 = [];
var len__28242__auto___32692 = arguments.length;
var i__28243__auto___32693 = (0);
while(true){
if((i__28243__auto___32693 < len__28242__auto___32692)){
args32648.push((arguments[i__28243__auto___32693]));

var G__32694 = (i__28243__auto___32693 + (1));
i__28243__auto___32693 = G__32694;
continue;
} else {
}
break;
}

var G__32650 = args32648.length;
switch (G__32650) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32648.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30406__auto___32696 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___32696,out){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___32696,out){
return (function (state_32671){
var state_val_32672 = (state_32671[(1)]);
if((state_val_32672 === (7))){
var inst_32667 = (state_32671[(2)]);
var state_32671__$1 = state_32671;
var statearr_32673_32697 = state_32671__$1;
(statearr_32673_32697[(2)] = inst_32667);

(statearr_32673_32697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (1))){
var state_32671__$1 = state_32671;
var statearr_32674_32698 = state_32671__$1;
(statearr_32674_32698[(2)] = null);

(statearr_32674_32698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (4))){
var inst_32653 = (state_32671[(7)]);
var inst_32653__$1 = (state_32671[(2)]);
var inst_32654 = (inst_32653__$1 == null);
var state_32671__$1 = (function (){var statearr_32675 = state_32671;
(statearr_32675[(7)] = inst_32653__$1);

return statearr_32675;
})();
if(cljs.core.truth_(inst_32654)){
var statearr_32676_32699 = state_32671__$1;
(statearr_32676_32699[(1)] = (5));

} else {
var statearr_32677_32700 = state_32671__$1;
(statearr_32677_32700[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (6))){
var inst_32653 = (state_32671[(7)]);
var inst_32658 = p.call(null,inst_32653);
var state_32671__$1 = state_32671;
if(cljs.core.truth_(inst_32658)){
var statearr_32678_32701 = state_32671__$1;
(statearr_32678_32701[(1)] = (8));

} else {
var statearr_32679_32702 = state_32671__$1;
(statearr_32679_32702[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (3))){
var inst_32669 = (state_32671[(2)]);
var state_32671__$1 = state_32671;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32671__$1,inst_32669);
} else {
if((state_val_32672 === (2))){
var state_32671__$1 = state_32671;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32671__$1,(4),ch);
} else {
if((state_val_32672 === (11))){
var inst_32661 = (state_32671[(2)]);
var state_32671__$1 = state_32671;
var statearr_32680_32703 = state_32671__$1;
(statearr_32680_32703[(2)] = inst_32661);

(statearr_32680_32703[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (9))){
var state_32671__$1 = state_32671;
var statearr_32681_32704 = state_32671__$1;
(statearr_32681_32704[(2)] = null);

(statearr_32681_32704[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (5))){
var inst_32656 = cljs.core.async.close_BANG_.call(null,out);
var state_32671__$1 = state_32671;
var statearr_32682_32705 = state_32671__$1;
(statearr_32682_32705[(2)] = inst_32656);

(statearr_32682_32705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (10))){
var inst_32664 = (state_32671[(2)]);
var state_32671__$1 = (function (){var statearr_32683 = state_32671;
(statearr_32683[(8)] = inst_32664);

return statearr_32683;
})();
var statearr_32684_32706 = state_32671__$1;
(statearr_32684_32706[(2)] = null);

(statearr_32684_32706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32672 === (8))){
var inst_32653 = (state_32671[(7)]);
var state_32671__$1 = state_32671;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32671__$1,(11),out,inst_32653);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___32696,out))
;
return ((function (switch__30292__auto__,c__30406__auto___32696,out){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_32688 = [null,null,null,null,null,null,null,null,null];
(statearr_32688[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_32688[(1)] = (1));

return statearr_32688;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_32671){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32671);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e32689){if((e32689 instanceof Object)){
var ex__30296__auto__ = e32689;
var statearr_32690_32707 = state_32671;
(statearr_32690_32707[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32671);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32689;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32708 = state_32671;
state_32671 = G__32708;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_32671){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_32671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___32696,out))
})();
var state__30408__auto__ = (function (){var statearr_32691 = f__30407__auto__.call(null);
(statearr_32691[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___32696);

return statearr_32691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___32696,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args32709 = [];
var len__28242__auto___32712 = arguments.length;
var i__28243__auto___32713 = (0);
while(true){
if((i__28243__auto___32713 < len__28242__auto___32712)){
args32709.push((arguments[i__28243__auto___32713]));

var G__32714 = (i__28243__auto___32713 + (1));
i__28243__auto___32713 = G__32714;
continue;
} else {
}
break;
}

var G__32711 = args32709.length;
switch (G__32711) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32709.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__){
return (function (state_32881){
var state_val_32882 = (state_32881[(1)]);
if((state_val_32882 === (7))){
var inst_32877 = (state_32881[(2)]);
var state_32881__$1 = state_32881;
var statearr_32883_32924 = state_32881__$1;
(statearr_32883_32924[(2)] = inst_32877);

(statearr_32883_32924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (20))){
var inst_32847 = (state_32881[(7)]);
var inst_32858 = (state_32881[(2)]);
var inst_32859 = cljs.core.next.call(null,inst_32847);
var inst_32833 = inst_32859;
var inst_32834 = null;
var inst_32835 = (0);
var inst_32836 = (0);
var state_32881__$1 = (function (){var statearr_32884 = state_32881;
(statearr_32884[(8)] = inst_32836);

(statearr_32884[(9)] = inst_32835);

(statearr_32884[(10)] = inst_32833);

(statearr_32884[(11)] = inst_32834);

(statearr_32884[(12)] = inst_32858);

return statearr_32884;
})();
var statearr_32885_32925 = state_32881__$1;
(statearr_32885_32925[(2)] = null);

(statearr_32885_32925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (1))){
var state_32881__$1 = state_32881;
var statearr_32886_32926 = state_32881__$1;
(statearr_32886_32926[(2)] = null);

(statearr_32886_32926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (4))){
var inst_32822 = (state_32881[(13)]);
var inst_32822__$1 = (state_32881[(2)]);
var inst_32823 = (inst_32822__$1 == null);
var state_32881__$1 = (function (){var statearr_32887 = state_32881;
(statearr_32887[(13)] = inst_32822__$1);

return statearr_32887;
})();
if(cljs.core.truth_(inst_32823)){
var statearr_32888_32927 = state_32881__$1;
(statearr_32888_32927[(1)] = (5));

} else {
var statearr_32889_32928 = state_32881__$1;
(statearr_32889_32928[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (15))){
var state_32881__$1 = state_32881;
var statearr_32893_32929 = state_32881__$1;
(statearr_32893_32929[(2)] = null);

(statearr_32893_32929[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (21))){
var state_32881__$1 = state_32881;
var statearr_32894_32930 = state_32881__$1;
(statearr_32894_32930[(2)] = null);

(statearr_32894_32930[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (13))){
var inst_32836 = (state_32881[(8)]);
var inst_32835 = (state_32881[(9)]);
var inst_32833 = (state_32881[(10)]);
var inst_32834 = (state_32881[(11)]);
var inst_32843 = (state_32881[(2)]);
var inst_32844 = (inst_32836 + (1));
var tmp32890 = inst_32835;
var tmp32891 = inst_32833;
var tmp32892 = inst_32834;
var inst_32833__$1 = tmp32891;
var inst_32834__$1 = tmp32892;
var inst_32835__$1 = tmp32890;
var inst_32836__$1 = inst_32844;
var state_32881__$1 = (function (){var statearr_32895 = state_32881;
(statearr_32895[(8)] = inst_32836__$1);

(statearr_32895[(14)] = inst_32843);

(statearr_32895[(9)] = inst_32835__$1);

(statearr_32895[(10)] = inst_32833__$1);

(statearr_32895[(11)] = inst_32834__$1);

return statearr_32895;
})();
var statearr_32896_32931 = state_32881__$1;
(statearr_32896_32931[(2)] = null);

(statearr_32896_32931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (22))){
var state_32881__$1 = state_32881;
var statearr_32897_32932 = state_32881__$1;
(statearr_32897_32932[(2)] = null);

(statearr_32897_32932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (6))){
var inst_32822 = (state_32881[(13)]);
var inst_32831 = f.call(null,inst_32822);
var inst_32832 = cljs.core.seq.call(null,inst_32831);
var inst_32833 = inst_32832;
var inst_32834 = null;
var inst_32835 = (0);
var inst_32836 = (0);
var state_32881__$1 = (function (){var statearr_32898 = state_32881;
(statearr_32898[(8)] = inst_32836);

(statearr_32898[(9)] = inst_32835);

(statearr_32898[(10)] = inst_32833);

(statearr_32898[(11)] = inst_32834);

return statearr_32898;
})();
var statearr_32899_32933 = state_32881__$1;
(statearr_32899_32933[(2)] = null);

(statearr_32899_32933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (17))){
var inst_32847 = (state_32881[(7)]);
var inst_32851 = cljs.core.chunk_first.call(null,inst_32847);
var inst_32852 = cljs.core.chunk_rest.call(null,inst_32847);
var inst_32853 = cljs.core.count.call(null,inst_32851);
var inst_32833 = inst_32852;
var inst_32834 = inst_32851;
var inst_32835 = inst_32853;
var inst_32836 = (0);
var state_32881__$1 = (function (){var statearr_32900 = state_32881;
(statearr_32900[(8)] = inst_32836);

(statearr_32900[(9)] = inst_32835);

(statearr_32900[(10)] = inst_32833);

(statearr_32900[(11)] = inst_32834);

return statearr_32900;
})();
var statearr_32901_32934 = state_32881__$1;
(statearr_32901_32934[(2)] = null);

(statearr_32901_32934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (3))){
var inst_32879 = (state_32881[(2)]);
var state_32881__$1 = state_32881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32881__$1,inst_32879);
} else {
if((state_val_32882 === (12))){
var inst_32867 = (state_32881[(2)]);
var state_32881__$1 = state_32881;
var statearr_32902_32935 = state_32881__$1;
(statearr_32902_32935[(2)] = inst_32867);

(statearr_32902_32935[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (2))){
var state_32881__$1 = state_32881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32881__$1,(4),in$);
} else {
if((state_val_32882 === (23))){
var inst_32875 = (state_32881[(2)]);
var state_32881__$1 = state_32881;
var statearr_32903_32936 = state_32881__$1;
(statearr_32903_32936[(2)] = inst_32875);

(statearr_32903_32936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (19))){
var inst_32862 = (state_32881[(2)]);
var state_32881__$1 = state_32881;
var statearr_32904_32937 = state_32881__$1;
(statearr_32904_32937[(2)] = inst_32862);

(statearr_32904_32937[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (11))){
var inst_32833 = (state_32881[(10)]);
var inst_32847 = (state_32881[(7)]);
var inst_32847__$1 = cljs.core.seq.call(null,inst_32833);
var state_32881__$1 = (function (){var statearr_32905 = state_32881;
(statearr_32905[(7)] = inst_32847__$1);

return statearr_32905;
})();
if(inst_32847__$1){
var statearr_32906_32938 = state_32881__$1;
(statearr_32906_32938[(1)] = (14));

} else {
var statearr_32907_32939 = state_32881__$1;
(statearr_32907_32939[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (9))){
var inst_32869 = (state_32881[(2)]);
var inst_32870 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32881__$1 = (function (){var statearr_32908 = state_32881;
(statearr_32908[(15)] = inst_32869);

return statearr_32908;
})();
if(cljs.core.truth_(inst_32870)){
var statearr_32909_32940 = state_32881__$1;
(statearr_32909_32940[(1)] = (21));

} else {
var statearr_32910_32941 = state_32881__$1;
(statearr_32910_32941[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (5))){
var inst_32825 = cljs.core.async.close_BANG_.call(null,out);
var state_32881__$1 = state_32881;
var statearr_32911_32942 = state_32881__$1;
(statearr_32911_32942[(2)] = inst_32825);

(statearr_32911_32942[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (14))){
var inst_32847 = (state_32881[(7)]);
var inst_32849 = cljs.core.chunked_seq_QMARK_.call(null,inst_32847);
var state_32881__$1 = state_32881;
if(inst_32849){
var statearr_32912_32943 = state_32881__$1;
(statearr_32912_32943[(1)] = (17));

} else {
var statearr_32913_32944 = state_32881__$1;
(statearr_32913_32944[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (16))){
var inst_32865 = (state_32881[(2)]);
var state_32881__$1 = state_32881;
var statearr_32914_32945 = state_32881__$1;
(statearr_32914_32945[(2)] = inst_32865);

(statearr_32914_32945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32882 === (10))){
var inst_32836 = (state_32881[(8)]);
var inst_32834 = (state_32881[(11)]);
var inst_32841 = cljs.core._nth.call(null,inst_32834,inst_32836);
var state_32881__$1 = state_32881;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32881__$1,(13),out,inst_32841);
} else {
if((state_val_32882 === (18))){
var inst_32847 = (state_32881[(7)]);
var inst_32856 = cljs.core.first.call(null,inst_32847);
var state_32881__$1 = state_32881;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32881__$1,(20),out,inst_32856);
} else {
if((state_val_32882 === (8))){
var inst_32836 = (state_32881[(8)]);
var inst_32835 = (state_32881[(9)]);
var inst_32838 = (inst_32836 < inst_32835);
var inst_32839 = inst_32838;
var state_32881__$1 = state_32881;
if(cljs.core.truth_(inst_32839)){
var statearr_32915_32946 = state_32881__$1;
(statearr_32915_32946[(1)] = (10));

} else {
var statearr_32916_32947 = state_32881__$1;
(statearr_32916_32947[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto__))
;
return ((function (switch__30292__auto__,c__30406__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30293__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30293__auto____0 = (function (){
var statearr_32920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32920[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30293__auto__);

(statearr_32920[(1)] = (1));

return statearr_32920;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30293__auto____1 = (function (state_32881){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e32921){if((e32921 instanceof Object)){
var ex__30296__auto__ = e32921;
var statearr_32922_32948 = state_32881;
(statearr_32922_32948[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32881);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32921;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32949 = state_32881;
state_32881 = G__32949;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30293__auto__ = function(state_32881){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30293__auto____1.call(this,state_32881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30293__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30293__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__))
})();
var state__30408__auto__ = (function (){var statearr_32923 = f__30407__auto__.call(null);
(statearr_32923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_32923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__))
);

return c__30406__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args32950 = [];
var len__28242__auto___32953 = arguments.length;
var i__28243__auto___32954 = (0);
while(true){
if((i__28243__auto___32954 < len__28242__auto___32953)){
args32950.push((arguments[i__28243__auto___32954]));

var G__32955 = (i__28243__auto___32954 + (1));
i__28243__auto___32954 = G__32955;
continue;
} else {
}
break;
}

var G__32952 = args32950.length;
switch (G__32952) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32950.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args32957 = [];
var len__28242__auto___32960 = arguments.length;
var i__28243__auto___32961 = (0);
while(true){
if((i__28243__auto___32961 < len__28242__auto___32960)){
args32957.push((arguments[i__28243__auto___32961]));

var G__32962 = (i__28243__auto___32961 + (1));
i__28243__auto___32961 = G__32962;
continue;
} else {
}
break;
}

var G__32959 = args32957.length;
switch (G__32959) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32957.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args32964 = [];
var len__28242__auto___33015 = arguments.length;
var i__28243__auto___33016 = (0);
while(true){
if((i__28243__auto___33016 < len__28242__auto___33015)){
args32964.push((arguments[i__28243__auto___33016]));

var G__33017 = (i__28243__auto___33016 + (1));
i__28243__auto___33016 = G__33017;
continue;
} else {
}
break;
}

var G__32966 = args32964.length;
switch (G__32966) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args32964.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30406__auto___33019 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___33019,out){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___33019,out){
return (function (state_32990){
var state_val_32991 = (state_32990[(1)]);
if((state_val_32991 === (7))){
var inst_32985 = (state_32990[(2)]);
var state_32990__$1 = state_32990;
var statearr_32992_33020 = state_32990__$1;
(statearr_32992_33020[(2)] = inst_32985);

(statearr_32992_33020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32991 === (1))){
var inst_32967 = null;
var state_32990__$1 = (function (){var statearr_32993 = state_32990;
(statearr_32993[(7)] = inst_32967);

return statearr_32993;
})();
var statearr_32994_33021 = state_32990__$1;
(statearr_32994_33021[(2)] = null);

(statearr_32994_33021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32991 === (4))){
var inst_32970 = (state_32990[(8)]);
var inst_32970__$1 = (state_32990[(2)]);
var inst_32971 = (inst_32970__$1 == null);
var inst_32972 = cljs.core.not.call(null,inst_32971);
var state_32990__$1 = (function (){var statearr_32995 = state_32990;
(statearr_32995[(8)] = inst_32970__$1);

return statearr_32995;
})();
if(inst_32972){
var statearr_32996_33022 = state_32990__$1;
(statearr_32996_33022[(1)] = (5));

} else {
var statearr_32997_33023 = state_32990__$1;
(statearr_32997_33023[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32991 === (6))){
var state_32990__$1 = state_32990;
var statearr_32998_33024 = state_32990__$1;
(statearr_32998_33024[(2)] = null);

(statearr_32998_33024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32991 === (3))){
var inst_32987 = (state_32990[(2)]);
var inst_32988 = cljs.core.async.close_BANG_.call(null,out);
var state_32990__$1 = (function (){var statearr_32999 = state_32990;
(statearr_32999[(9)] = inst_32987);

return statearr_32999;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32990__$1,inst_32988);
} else {
if((state_val_32991 === (2))){
var state_32990__$1 = state_32990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32990__$1,(4),ch);
} else {
if((state_val_32991 === (11))){
var inst_32970 = (state_32990[(8)]);
var inst_32979 = (state_32990[(2)]);
var inst_32967 = inst_32970;
var state_32990__$1 = (function (){var statearr_33000 = state_32990;
(statearr_33000[(10)] = inst_32979);

(statearr_33000[(7)] = inst_32967);

return statearr_33000;
})();
var statearr_33001_33025 = state_32990__$1;
(statearr_33001_33025[(2)] = null);

(statearr_33001_33025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32991 === (9))){
var inst_32970 = (state_32990[(8)]);
var state_32990__$1 = state_32990;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32990__$1,(11),out,inst_32970);
} else {
if((state_val_32991 === (5))){
var inst_32970 = (state_32990[(8)]);
var inst_32967 = (state_32990[(7)]);
var inst_32974 = cljs.core._EQ_.call(null,inst_32970,inst_32967);
var state_32990__$1 = state_32990;
if(inst_32974){
var statearr_33003_33026 = state_32990__$1;
(statearr_33003_33026[(1)] = (8));

} else {
var statearr_33004_33027 = state_32990__$1;
(statearr_33004_33027[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32991 === (10))){
var inst_32982 = (state_32990[(2)]);
var state_32990__$1 = state_32990;
var statearr_33005_33028 = state_32990__$1;
(statearr_33005_33028[(2)] = inst_32982);

(statearr_33005_33028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32991 === (8))){
var inst_32967 = (state_32990[(7)]);
var tmp33002 = inst_32967;
var inst_32967__$1 = tmp33002;
var state_32990__$1 = (function (){var statearr_33006 = state_32990;
(statearr_33006[(7)] = inst_32967__$1);

return statearr_33006;
})();
var statearr_33007_33029 = state_32990__$1;
(statearr_33007_33029[(2)] = null);

(statearr_33007_33029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___33019,out))
;
return ((function (switch__30292__auto__,c__30406__auto___33019,out){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_33011 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33011[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_33011[(1)] = (1));

return statearr_33011;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_32990){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_32990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e33012){if((e33012 instanceof Object)){
var ex__30296__auto__ = e33012;
var statearr_33013_33030 = state_32990;
(statearr_33013_33030[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33012;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33031 = state_32990;
state_32990 = G__33031;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_32990){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_32990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___33019,out))
})();
var state__30408__auto__ = (function (){var statearr_33014 = f__30407__auto__.call(null);
(statearr_33014[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___33019);

return statearr_33014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___33019,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args33032 = [];
var len__28242__auto___33102 = arguments.length;
var i__28243__auto___33103 = (0);
while(true){
if((i__28243__auto___33103 < len__28242__auto___33102)){
args33032.push((arguments[i__28243__auto___33103]));

var G__33104 = (i__28243__auto___33103 + (1));
i__28243__auto___33103 = G__33104;
continue;
} else {
}
break;
}

var G__33034 = args33032.length;
switch (G__33034) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33032.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30406__auto___33106 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___33106,out){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___33106,out){
return (function (state_33072){
var state_val_33073 = (state_33072[(1)]);
if((state_val_33073 === (7))){
var inst_33068 = (state_33072[(2)]);
var state_33072__$1 = state_33072;
var statearr_33074_33107 = state_33072__$1;
(statearr_33074_33107[(2)] = inst_33068);

(statearr_33074_33107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (1))){
var inst_33035 = (new Array(n));
var inst_33036 = inst_33035;
var inst_33037 = (0);
var state_33072__$1 = (function (){var statearr_33075 = state_33072;
(statearr_33075[(7)] = inst_33036);

(statearr_33075[(8)] = inst_33037);

return statearr_33075;
})();
var statearr_33076_33108 = state_33072__$1;
(statearr_33076_33108[(2)] = null);

(statearr_33076_33108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (4))){
var inst_33040 = (state_33072[(9)]);
var inst_33040__$1 = (state_33072[(2)]);
var inst_33041 = (inst_33040__$1 == null);
var inst_33042 = cljs.core.not.call(null,inst_33041);
var state_33072__$1 = (function (){var statearr_33077 = state_33072;
(statearr_33077[(9)] = inst_33040__$1);

return statearr_33077;
})();
if(inst_33042){
var statearr_33078_33109 = state_33072__$1;
(statearr_33078_33109[(1)] = (5));

} else {
var statearr_33079_33110 = state_33072__$1;
(statearr_33079_33110[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (15))){
var inst_33062 = (state_33072[(2)]);
var state_33072__$1 = state_33072;
var statearr_33080_33111 = state_33072__$1;
(statearr_33080_33111[(2)] = inst_33062);

(statearr_33080_33111[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (13))){
var state_33072__$1 = state_33072;
var statearr_33081_33112 = state_33072__$1;
(statearr_33081_33112[(2)] = null);

(statearr_33081_33112[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (6))){
var inst_33037 = (state_33072[(8)]);
var inst_33058 = (inst_33037 > (0));
var state_33072__$1 = state_33072;
if(cljs.core.truth_(inst_33058)){
var statearr_33082_33113 = state_33072__$1;
(statearr_33082_33113[(1)] = (12));

} else {
var statearr_33083_33114 = state_33072__$1;
(statearr_33083_33114[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (3))){
var inst_33070 = (state_33072[(2)]);
var state_33072__$1 = state_33072;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33072__$1,inst_33070);
} else {
if((state_val_33073 === (12))){
var inst_33036 = (state_33072[(7)]);
var inst_33060 = cljs.core.vec.call(null,inst_33036);
var state_33072__$1 = state_33072;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33072__$1,(15),out,inst_33060);
} else {
if((state_val_33073 === (2))){
var state_33072__$1 = state_33072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33072__$1,(4),ch);
} else {
if((state_val_33073 === (11))){
var inst_33052 = (state_33072[(2)]);
var inst_33053 = (new Array(n));
var inst_33036 = inst_33053;
var inst_33037 = (0);
var state_33072__$1 = (function (){var statearr_33084 = state_33072;
(statearr_33084[(7)] = inst_33036);

(statearr_33084[(8)] = inst_33037);

(statearr_33084[(10)] = inst_33052);

return statearr_33084;
})();
var statearr_33085_33115 = state_33072__$1;
(statearr_33085_33115[(2)] = null);

(statearr_33085_33115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (9))){
var inst_33036 = (state_33072[(7)]);
var inst_33050 = cljs.core.vec.call(null,inst_33036);
var state_33072__$1 = state_33072;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33072__$1,(11),out,inst_33050);
} else {
if((state_val_33073 === (5))){
var inst_33036 = (state_33072[(7)]);
var inst_33040 = (state_33072[(9)]);
var inst_33037 = (state_33072[(8)]);
var inst_33045 = (state_33072[(11)]);
var inst_33044 = (inst_33036[inst_33037] = inst_33040);
var inst_33045__$1 = (inst_33037 + (1));
var inst_33046 = (inst_33045__$1 < n);
var state_33072__$1 = (function (){var statearr_33086 = state_33072;
(statearr_33086[(12)] = inst_33044);

(statearr_33086[(11)] = inst_33045__$1);

return statearr_33086;
})();
if(cljs.core.truth_(inst_33046)){
var statearr_33087_33116 = state_33072__$1;
(statearr_33087_33116[(1)] = (8));

} else {
var statearr_33088_33117 = state_33072__$1;
(statearr_33088_33117[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (14))){
var inst_33065 = (state_33072[(2)]);
var inst_33066 = cljs.core.async.close_BANG_.call(null,out);
var state_33072__$1 = (function (){var statearr_33090 = state_33072;
(statearr_33090[(13)] = inst_33065);

return statearr_33090;
})();
var statearr_33091_33118 = state_33072__$1;
(statearr_33091_33118[(2)] = inst_33066);

(statearr_33091_33118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (10))){
var inst_33056 = (state_33072[(2)]);
var state_33072__$1 = state_33072;
var statearr_33092_33119 = state_33072__$1;
(statearr_33092_33119[(2)] = inst_33056);

(statearr_33092_33119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33073 === (8))){
var inst_33036 = (state_33072[(7)]);
var inst_33045 = (state_33072[(11)]);
var tmp33089 = inst_33036;
var inst_33036__$1 = tmp33089;
var inst_33037 = inst_33045;
var state_33072__$1 = (function (){var statearr_33093 = state_33072;
(statearr_33093[(7)] = inst_33036__$1);

(statearr_33093[(8)] = inst_33037);

return statearr_33093;
})();
var statearr_33094_33120 = state_33072__$1;
(statearr_33094_33120[(2)] = null);

(statearr_33094_33120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___33106,out))
;
return ((function (switch__30292__auto__,c__30406__auto___33106,out){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_33098 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33098[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_33098[(1)] = (1));

return statearr_33098;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_33072){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_33072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e33099){if((e33099 instanceof Object)){
var ex__30296__auto__ = e33099;
var statearr_33100_33121 = state_33072;
(statearr_33100_33121[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33072);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33122 = state_33072;
state_33072 = G__33122;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_33072){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_33072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___33106,out))
})();
var state__30408__auto__ = (function (){var statearr_33101 = f__30407__auto__.call(null);
(statearr_33101[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___33106);

return statearr_33101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___33106,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args33123 = [];
var len__28242__auto___33197 = arguments.length;
var i__28243__auto___33198 = (0);
while(true){
if((i__28243__auto___33198 < len__28242__auto___33197)){
args33123.push((arguments[i__28243__auto___33198]));

var G__33199 = (i__28243__auto___33198 + (1));
i__28243__auto___33198 = G__33199;
continue;
} else {
}
break;
}

var G__33125 = args33123.length;
switch (G__33125) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args33123.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30406__auto___33201 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___33201,out){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___33201,out){
return (function (state_33167){
var state_val_33168 = (state_33167[(1)]);
if((state_val_33168 === (7))){
var inst_33163 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
var statearr_33169_33202 = state_33167__$1;
(statearr_33169_33202[(2)] = inst_33163);

(statearr_33169_33202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (1))){
var inst_33126 = [];
var inst_33127 = inst_33126;
var inst_33128 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33167__$1 = (function (){var statearr_33170 = state_33167;
(statearr_33170[(7)] = inst_33128);

(statearr_33170[(8)] = inst_33127);

return statearr_33170;
})();
var statearr_33171_33203 = state_33167__$1;
(statearr_33171_33203[(2)] = null);

(statearr_33171_33203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (4))){
var inst_33131 = (state_33167[(9)]);
var inst_33131__$1 = (state_33167[(2)]);
var inst_33132 = (inst_33131__$1 == null);
var inst_33133 = cljs.core.not.call(null,inst_33132);
var state_33167__$1 = (function (){var statearr_33172 = state_33167;
(statearr_33172[(9)] = inst_33131__$1);

return statearr_33172;
})();
if(inst_33133){
var statearr_33173_33204 = state_33167__$1;
(statearr_33173_33204[(1)] = (5));

} else {
var statearr_33174_33205 = state_33167__$1;
(statearr_33174_33205[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (15))){
var inst_33157 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
var statearr_33175_33206 = state_33167__$1;
(statearr_33175_33206[(2)] = inst_33157);

(statearr_33175_33206[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (13))){
var state_33167__$1 = state_33167;
var statearr_33176_33207 = state_33167__$1;
(statearr_33176_33207[(2)] = null);

(statearr_33176_33207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (6))){
var inst_33127 = (state_33167[(8)]);
var inst_33152 = inst_33127.length;
var inst_33153 = (inst_33152 > (0));
var state_33167__$1 = state_33167;
if(cljs.core.truth_(inst_33153)){
var statearr_33177_33208 = state_33167__$1;
(statearr_33177_33208[(1)] = (12));

} else {
var statearr_33178_33209 = state_33167__$1;
(statearr_33178_33209[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (3))){
var inst_33165 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33167__$1,inst_33165);
} else {
if((state_val_33168 === (12))){
var inst_33127 = (state_33167[(8)]);
var inst_33155 = cljs.core.vec.call(null,inst_33127);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33167__$1,(15),out,inst_33155);
} else {
if((state_val_33168 === (2))){
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33167__$1,(4),ch);
} else {
if((state_val_33168 === (11))){
var inst_33131 = (state_33167[(9)]);
var inst_33135 = (state_33167[(10)]);
var inst_33145 = (state_33167[(2)]);
var inst_33146 = [];
var inst_33147 = inst_33146.push(inst_33131);
var inst_33127 = inst_33146;
var inst_33128 = inst_33135;
var state_33167__$1 = (function (){var statearr_33179 = state_33167;
(statearr_33179[(7)] = inst_33128);

(statearr_33179[(11)] = inst_33145);

(statearr_33179[(8)] = inst_33127);

(statearr_33179[(12)] = inst_33147);

return statearr_33179;
})();
var statearr_33180_33210 = state_33167__$1;
(statearr_33180_33210[(2)] = null);

(statearr_33180_33210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (9))){
var inst_33127 = (state_33167[(8)]);
var inst_33143 = cljs.core.vec.call(null,inst_33127);
var state_33167__$1 = state_33167;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33167__$1,(11),out,inst_33143);
} else {
if((state_val_33168 === (5))){
var inst_33128 = (state_33167[(7)]);
var inst_33131 = (state_33167[(9)]);
var inst_33135 = (state_33167[(10)]);
var inst_33135__$1 = f.call(null,inst_33131);
var inst_33136 = cljs.core._EQ_.call(null,inst_33135__$1,inst_33128);
var inst_33137 = cljs.core.keyword_identical_QMARK_.call(null,inst_33128,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_33138 = (inst_33136) || (inst_33137);
var state_33167__$1 = (function (){var statearr_33181 = state_33167;
(statearr_33181[(10)] = inst_33135__$1);

return statearr_33181;
})();
if(cljs.core.truth_(inst_33138)){
var statearr_33182_33211 = state_33167__$1;
(statearr_33182_33211[(1)] = (8));

} else {
var statearr_33183_33212 = state_33167__$1;
(statearr_33183_33212[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (14))){
var inst_33160 = (state_33167[(2)]);
var inst_33161 = cljs.core.async.close_BANG_.call(null,out);
var state_33167__$1 = (function (){var statearr_33185 = state_33167;
(statearr_33185[(13)] = inst_33160);

return statearr_33185;
})();
var statearr_33186_33213 = state_33167__$1;
(statearr_33186_33213[(2)] = inst_33161);

(statearr_33186_33213[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (10))){
var inst_33150 = (state_33167[(2)]);
var state_33167__$1 = state_33167;
var statearr_33187_33214 = state_33167__$1;
(statearr_33187_33214[(2)] = inst_33150);

(statearr_33187_33214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33168 === (8))){
var inst_33131 = (state_33167[(9)]);
var inst_33127 = (state_33167[(8)]);
var inst_33135 = (state_33167[(10)]);
var inst_33140 = inst_33127.push(inst_33131);
var tmp33184 = inst_33127;
var inst_33127__$1 = tmp33184;
var inst_33128 = inst_33135;
var state_33167__$1 = (function (){var statearr_33188 = state_33167;
(statearr_33188[(7)] = inst_33128);

(statearr_33188[(14)] = inst_33140);

(statearr_33188[(8)] = inst_33127__$1);

return statearr_33188;
})();
var statearr_33189_33215 = state_33167__$1;
(statearr_33189_33215[(2)] = null);

(statearr_33189_33215[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___33201,out))
;
return ((function (switch__30292__auto__,c__30406__auto___33201,out){
return (function() {
var cljs$core$async$state_machine__30293__auto__ = null;
var cljs$core$async$state_machine__30293__auto____0 = (function (){
var statearr_33193 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33193[(0)] = cljs$core$async$state_machine__30293__auto__);

(statearr_33193[(1)] = (1));

return statearr_33193;
});
var cljs$core$async$state_machine__30293__auto____1 = (function (state_33167){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_33167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e33194){if((e33194 instanceof Object)){
var ex__30296__auto__ = e33194;
var statearr_33195_33216 = state_33167;
(statearr_33195_33216[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33167);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33194;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33217 = state_33167;
state_33167 = G__33217;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
cljs$core$async$state_machine__30293__auto__ = function(state_33167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30293__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30293__auto____1.call(this,state_33167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30293__auto____0;
cljs$core$async$state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30293__auto____1;
return cljs$core$async$state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___33201,out))
})();
var state__30408__auto__ = (function (){var statearr_33196 = f__30407__auto__.call(null);
(statearr_33196[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___33201);

return statearr_33196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___33201,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1486396814181