// Compiled by ClojureScript 1.9.456 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.9";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args37893 = [];
var len__28242__auto___37896 = arguments.length;
var i__28243__auto___37897 = (0);
while(true){
if((i__28243__auto___37897 < len__28242__auto___37896)){
args37893.push((arguments[i__28243__auto___37897]));

var G__37898 = (i__28243__auto___37897 + (1));
i__28243__auto___37897 = G__37898;
continue;
} else {
}
break;
}

var G__37895 = args37893.length;
switch (G__37895) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args37893.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__28249__auto__ = [];
var len__28242__auto___37901 = arguments.length;
var i__28243__auto___37902 = (0);
while(true){
if((i__28243__auto___37902 < len__28242__auto___37901)){
args__28249__auto__.push((arguments[i__28243__auto___37902]));

var G__37903 = (i__28243__auto___37902 + (1));
i__28243__auto___37902 = G__37903;
continue;
} else {
}
break;
}

var argseq__28250__auto__ = ((((0) < args__28249__auto__.length))?(new cljs.core.IndexedSeq(args__28249__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__28250__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq37900){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37900));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__28249__auto__ = [];
var len__28242__auto___37905 = arguments.length;
var i__28243__auto___37906 = (0);
while(true){
if((i__28243__auto___37906 < len__28242__auto___37905)){
args__28249__auto__.push((arguments[i__28243__auto___37906]));

var G__37907 = (i__28243__auto___37906 + (1));
i__28243__auto___37906 = G__37907;
continue;
} else {
}
break;
}

var argseq__28250__auto__ = ((((0) < args__28249__auto__.length))?(new cljs.core.IndexedSeq(args__28249__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__28250__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq37904){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq37904));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__37908){
var map__37911 = p__37908;
var map__37911__$1 = ((((!((map__37911 == null)))?((((map__37911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37911.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37911):map__37911);
var message = cljs.core.get.call(null,map__37911__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__37911__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__27021__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__27021__auto__)){
return or__27021__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__27009__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__27009__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__27009__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__30406__auto___38073 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___38073,ch){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___38073,ch){
return (function (state_38042){
var state_val_38043 = (state_38042[(1)]);
if((state_val_38043 === (7))){
var inst_38038 = (state_38042[(2)]);
var state_38042__$1 = state_38042;
var statearr_38044_38074 = state_38042__$1;
(statearr_38044_38074[(2)] = inst_38038);

(statearr_38044_38074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (1))){
var state_38042__$1 = state_38042;
var statearr_38045_38075 = state_38042__$1;
(statearr_38045_38075[(2)] = null);

(statearr_38045_38075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (4))){
var inst_37995 = (state_38042[(7)]);
var inst_37995__$1 = (state_38042[(2)]);
var state_38042__$1 = (function (){var statearr_38046 = state_38042;
(statearr_38046[(7)] = inst_37995__$1);

return statearr_38046;
})();
if(cljs.core.truth_(inst_37995__$1)){
var statearr_38047_38076 = state_38042__$1;
(statearr_38047_38076[(1)] = (5));

} else {
var statearr_38048_38077 = state_38042__$1;
(statearr_38048_38077[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (15))){
var inst_38002 = (state_38042[(8)]);
var inst_38017 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_38002);
var inst_38018 = cljs.core.first.call(null,inst_38017);
var inst_38019 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_38018);
var inst_38020 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38019)].join('');
var inst_38021 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_38020);
var state_38042__$1 = state_38042;
var statearr_38049_38078 = state_38042__$1;
(statearr_38049_38078[(2)] = inst_38021);

(statearr_38049_38078[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (13))){
var inst_38026 = (state_38042[(2)]);
var state_38042__$1 = state_38042;
var statearr_38050_38079 = state_38042__$1;
(statearr_38050_38079[(2)] = inst_38026);

(statearr_38050_38079[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (6))){
var state_38042__$1 = state_38042;
var statearr_38051_38080 = state_38042__$1;
(statearr_38051_38080[(2)] = null);

(statearr_38051_38080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (17))){
var inst_38024 = (state_38042[(2)]);
var state_38042__$1 = state_38042;
var statearr_38052_38081 = state_38042__$1;
(statearr_38052_38081[(2)] = inst_38024);

(statearr_38052_38081[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (3))){
var inst_38040 = (state_38042[(2)]);
var state_38042__$1 = state_38042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38042__$1,inst_38040);
} else {
if((state_val_38043 === (12))){
var inst_38001 = (state_38042[(9)]);
var inst_38015 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_38001,opts);
var state_38042__$1 = state_38042;
if(cljs.core.truth_(inst_38015)){
var statearr_38053_38082 = state_38042__$1;
(statearr_38053_38082[(1)] = (15));

} else {
var statearr_38054_38083 = state_38042__$1;
(statearr_38054_38083[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (2))){
var state_38042__$1 = state_38042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38042__$1,(4),ch);
} else {
if((state_val_38043 === (11))){
var inst_38002 = (state_38042[(8)]);
var inst_38007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38008 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_38002);
var inst_38009 = cljs.core.async.timeout.call(null,(1000));
var inst_38010 = [inst_38008,inst_38009];
var inst_38011 = (new cljs.core.PersistentVector(null,2,(5),inst_38007,inst_38010,null));
var state_38042__$1 = state_38042;
return cljs.core.async.ioc_alts_BANG_.call(null,state_38042__$1,(14),inst_38011);
} else {
if((state_val_38043 === (9))){
var inst_38002 = (state_38042[(8)]);
var inst_38028 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_38029 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_38002);
var inst_38030 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_38029);
var inst_38031 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38030)].join('');
var inst_38032 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_38031);
var state_38042__$1 = (function (){var statearr_38055 = state_38042;
(statearr_38055[(10)] = inst_38028);

return statearr_38055;
})();
var statearr_38056_38084 = state_38042__$1;
(statearr_38056_38084[(2)] = inst_38032);

(statearr_38056_38084[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (5))){
var inst_37995 = (state_38042[(7)]);
var inst_37997 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_37998 = (new cljs.core.PersistentArrayMap(null,2,inst_37997,null));
var inst_37999 = (new cljs.core.PersistentHashSet(null,inst_37998,null));
var inst_38000 = figwheel.client.focus_msgs.call(null,inst_37999,inst_37995);
var inst_38001 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_38000);
var inst_38002 = cljs.core.first.call(null,inst_38000);
var inst_38003 = figwheel.client.autoload_QMARK_.call(null);
var state_38042__$1 = (function (){var statearr_38057 = state_38042;
(statearr_38057[(8)] = inst_38002);

(statearr_38057[(9)] = inst_38001);

return statearr_38057;
})();
if(cljs.core.truth_(inst_38003)){
var statearr_38058_38085 = state_38042__$1;
(statearr_38058_38085[(1)] = (8));

} else {
var statearr_38059_38086 = state_38042__$1;
(statearr_38059_38086[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (14))){
var inst_38013 = (state_38042[(2)]);
var state_38042__$1 = state_38042;
var statearr_38060_38087 = state_38042__$1;
(statearr_38060_38087[(2)] = inst_38013);

(statearr_38060_38087[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (16))){
var state_38042__$1 = state_38042;
var statearr_38061_38088 = state_38042__$1;
(statearr_38061_38088[(2)] = null);

(statearr_38061_38088[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (10))){
var inst_38034 = (state_38042[(2)]);
var state_38042__$1 = (function (){var statearr_38062 = state_38042;
(statearr_38062[(11)] = inst_38034);

return statearr_38062;
})();
var statearr_38063_38089 = state_38042__$1;
(statearr_38063_38089[(2)] = null);

(statearr_38063_38089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38043 === (8))){
var inst_38001 = (state_38042[(9)]);
var inst_38005 = figwheel.client.reload_file_state_QMARK_.call(null,inst_38001,opts);
var state_38042__$1 = state_38042;
if(cljs.core.truth_(inst_38005)){
var statearr_38064_38090 = state_38042__$1;
(statearr_38064_38090[(1)] = (11));

} else {
var statearr_38065_38091 = state_38042__$1;
(statearr_38065_38091[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto___38073,ch))
;
return ((function (switch__30292__auto__,c__30406__auto___38073,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__30293__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__30293__auto____0 = (function (){
var statearr_38069 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38069[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__30293__auto__);

(statearr_38069[(1)] = (1));

return statearr_38069;
});
var figwheel$client$file_reloader_plugin_$_state_machine__30293__auto____1 = (function (state_38042){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_38042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e38070){if((e38070 instanceof Object)){
var ex__30296__auto__ = e38070;
var statearr_38071_38092 = state_38042;
(statearr_38071_38092[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38042);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38070;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38093 = state_38042;
state_38042 = G__38093;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__30293__auto__ = function(state_38042){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__30293__auto____1.call(this,state_38042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__30293__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__30293__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___38073,ch))
})();
var state__30408__auto__ = (function (){var statearr_38072 = f__30407__auto__.call(null);
(statearr_38072[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___38073);

return statearr_38072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___38073,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__38094_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__38094_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_38097 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_38097){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e38096){if((e38096 instanceof Error)){
var e = e38096;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_38097], null));
} else {
var e = e38096;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_38097))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__38098){
var map__38107 = p__38098;
var map__38107__$1 = ((((!((map__38107 == null)))?((((map__38107.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38107.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38107):map__38107);
var opts = map__38107__$1;
var build_id = cljs.core.get.call(null,map__38107__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__38107,map__38107__$1,opts,build_id){
return (function (p__38109){
var vec__38110 = p__38109;
var seq__38111 = cljs.core.seq.call(null,vec__38110);
var first__38112 = cljs.core.first.call(null,seq__38111);
var seq__38111__$1 = cljs.core.next.call(null,seq__38111);
var map__38113 = first__38112;
var map__38113__$1 = ((((!((map__38113 == null)))?((((map__38113.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38113.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38113):map__38113);
var msg = map__38113__$1;
var msg_name = cljs.core.get.call(null,map__38113__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__38111__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__38110,seq__38111,first__38112,seq__38111__$1,map__38113,map__38113__$1,msg,msg_name,_,map__38107,map__38107__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__38110,seq__38111,first__38112,seq__38111__$1,map__38113,map__38113__$1,msg,msg_name,_,map__38107,map__38107__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__38107,map__38107__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__38121){
var vec__38122 = p__38121;
var seq__38123 = cljs.core.seq.call(null,vec__38122);
var first__38124 = cljs.core.first.call(null,seq__38123);
var seq__38123__$1 = cljs.core.next.call(null,seq__38123);
var map__38125 = first__38124;
var map__38125__$1 = ((((!((map__38125 == null)))?((((map__38125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38125.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38125):map__38125);
var msg = map__38125__$1;
var msg_name = cljs.core.get.call(null,map__38125__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__38123__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__38127){
var map__38139 = p__38127;
var map__38139__$1 = ((((!((map__38139 == null)))?((((map__38139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38139.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38139):map__38139);
var on_compile_warning = cljs.core.get.call(null,map__38139__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__38139__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__38139,map__38139__$1,on_compile_warning,on_compile_fail){
return (function (p__38141){
var vec__38142 = p__38141;
var seq__38143 = cljs.core.seq.call(null,vec__38142);
var first__38144 = cljs.core.first.call(null,seq__38143);
var seq__38143__$1 = cljs.core.next.call(null,seq__38143);
var map__38145 = first__38144;
var map__38145__$1 = ((((!((map__38145 == null)))?((((map__38145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38145.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38145):map__38145);
var msg = map__38145__$1;
var msg_name = cljs.core.get.call(null,map__38145__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__38143__$1;
var pred__38147 = cljs.core._EQ_;
var expr__38148 = msg_name;
if(cljs.core.truth_(pred__38147.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__38148))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__38147.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__38148))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__38139,map__38139__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__,msg_hist,msg_names,msg){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__,msg_hist,msg_names,msg){
return (function (state_38376){
var state_val_38377 = (state_38376[(1)]);
if((state_val_38377 === (7))){
var inst_38296 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38296)){
var statearr_38378_38428 = state_38376__$1;
(statearr_38378_38428[(1)] = (8));

} else {
var statearr_38379_38429 = state_38376__$1;
(statearr_38379_38429[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (20))){
var inst_38370 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38380_38430 = state_38376__$1;
(statearr_38380_38430[(2)] = inst_38370);

(statearr_38380_38430[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (27))){
var inst_38366 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38381_38431 = state_38376__$1;
(statearr_38381_38431[(2)] = inst_38366);

(statearr_38381_38431[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (1))){
var inst_38289 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38289)){
var statearr_38382_38432 = state_38376__$1;
(statearr_38382_38432[(1)] = (2));

} else {
var statearr_38383_38433 = state_38376__$1;
(statearr_38383_38433[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (24))){
var inst_38368 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38384_38434 = state_38376__$1;
(statearr_38384_38434[(2)] = inst_38368);

(statearr_38384_38434[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (4))){
var inst_38374 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38376__$1,inst_38374);
} else {
if((state_val_38377 === (15))){
var inst_38372 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38385_38435 = state_38376__$1;
(statearr_38385_38435[(2)] = inst_38372);

(statearr_38385_38435[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (21))){
var inst_38325 = (state_38376[(2)]);
var inst_38326 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38327 = figwheel.client.auto_jump_to_error.call(null,opts,inst_38326);
var state_38376__$1 = (function (){var statearr_38386 = state_38376;
(statearr_38386[(7)] = inst_38325);

return statearr_38386;
})();
var statearr_38387_38436 = state_38376__$1;
(statearr_38387_38436[(2)] = inst_38327);

(statearr_38387_38436[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (31))){
var inst_38355 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38355)){
var statearr_38388_38437 = state_38376__$1;
(statearr_38388_38437[(1)] = (34));

} else {
var statearr_38389_38438 = state_38376__$1;
(statearr_38389_38438[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (32))){
var inst_38364 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38390_38439 = state_38376__$1;
(statearr_38390_38439[(2)] = inst_38364);

(statearr_38390_38439[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (33))){
var inst_38351 = (state_38376[(2)]);
var inst_38352 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38353 = figwheel.client.auto_jump_to_error.call(null,opts,inst_38352);
var state_38376__$1 = (function (){var statearr_38391 = state_38376;
(statearr_38391[(8)] = inst_38351);

return statearr_38391;
})();
var statearr_38392_38440 = state_38376__$1;
(statearr_38392_38440[(2)] = inst_38353);

(statearr_38392_38440[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (13))){
var inst_38310 = figwheel.client.heads_up.clear.call(null);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(16),inst_38310);
} else {
if((state_val_38377 === (22))){
var inst_38331 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38332 = figwheel.client.heads_up.append_warning_message.call(null,inst_38331);
var state_38376__$1 = state_38376;
var statearr_38393_38441 = state_38376__$1;
(statearr_38393_38441[(2)] = inst_38332);

(statearr_38393_38441[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (36))){
var inst_38362 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38394_38442 = state_38376__$1;
(statearr_38394_38442[(2)] = inst_38362);

(statearr_38394_38442[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (29))){
var inst_38342 = (state_38376[(2)]);
var inst_38343 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38344 = figwheel.client.auto_jump_to_error.call(null,opts,inst_38343);
var state_38376__$1 = (function (){var statearr_38395 = state_38376;
(statearr_38395[(9)] = inst_38342);

return statearr_38395;
})();
var statearr_38396_38443 = state_38376__$1;
(statearr_38396_38443[(2)] = inst_38344);

(statearr_38396_38443[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (6))){
var inst_38291 = (state_38376[(10)]);
var state_38376__$1 = state_38376;
var statearr_38397_38444 = state_38376__$1;
(statearr_38397_38444[(2)] = inst_38291);

(statearr_38397_38444[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (28))){
var inst_38338 = (state_38376[(2)]);
var inst_38339 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38340 = figwheel.client.heads_up.display_warning.call(null,inst_38339);
var state_38376__$1 = (function (){var statearr_38398 = state_38376;
(statearr_38398[(11)] = inst_38338);

return statearr_38398;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(29),inst_38340);
} else {
if((state_val_38377 === (25))){
var inst_38336 = figwheel.client.heads_up.clear.call(null);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(28),inst_38336);
} else {
if((state_val_38377 === (34))){
var inst_38357 = figwheel.client.heads_up.flash_loaded.call(null);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(37),inst_38357);
} else {
if((state_val_38377 === (17))){
var inst_38316 = (state_38376[(2)]);
var inst_38317 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38318 = figwheel.client.auto_jump_to_error.call(null,opts,inst_38317);
var state_38376__$1 = (function (){var statearr_38399 = state_38376;
(statearr_38399[(12)] = inst_38316);

return statearr_38399;
})();
var statearr_38400_38445 = state_38376__$1;
(statearr_38400_38445[(2)] = inst_38318);

(statearr_38400_38445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (3))){
var inst_38308 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38308)){
var statearr_38401_38446 = state_38376__$1;
(statearr_38401_38446[(1)] = (13));

} else {
var statearr_38402_38447 = state_38376__$1;
(statearr_38402_38447[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (12))){
var inst_38304 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38403_38448 = state_38376__$1;
(statearr_38403_38448[(2)] = inst_38304);

(statearr_38403_38448[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (2))){
var inst_38291 = (state_38376[(10)]);
var inst_38291__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_38376__$1 = (function (){var statearr_38404 = state_38376;
(statearr_38404[(10)] = inst_38291__$1);

return statearr_38404;
})();
if(cljs.core.truth_(inst_38291__$1)){
var statearr_38405_38449 = state_38376__$1;
(statearr_38405_38449[(1)] = (5));

} else {
var statearr_38406_38450 = state_38376__$1;
(statearr_38406_38450[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (23))){
var inst_38334 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38334)){
var statearr_38407_38451 = state_38376__$1;
(statearr_38407_38451[(1)] = (25));

} else {
var statearr_38408_38452 = state_38376__$1;
(statearr_38408_38452[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (35))){
var state_38376__$1 = state_38376;
var statearr_38409_38453 = state_38376__$1;
(statearr_38409_38453[(2)] = null);

(statearr_38409_38453[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (19))){
var inst_38329 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38329)){
var statearr_38410_38454 = state_38376__$1;
(statearr_38410_38454[(1)] = (22));

} else {
var statearr_38411_38455 = state_38376__$1;
(statearr_38411_38455[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (11))){
var inst_38300 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38412_38456 = state_38376__$1;
(statearr_38412_38456[(2)] = inst_38300);

(statearr_38412_38456[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (9))){
var inst_38302 = figwheel.client.heads_up.clear.call(null);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(12),inst_38302);
} else {
if((state_val_38377 === (5))){
var inst_38293 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_38376__$1 = state_38376;
var statearr_38413_38457 = state_38376__$1;
(statearr_38413_38457[(2)] = inst_38293);

(statearr_38413_38457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (14))){
var inst_38320 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38320)){
var statearr_38414_38458 = state_38376__$1;
(statearr_38414_38458[(1)] = (18));

} else {
var statearr_38415_38459 = state_38376__$1;
(statearr_38415_38459[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (26))){
var inst_38346 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_38376__$1 = state_38376;
if(cljs.core.truth_(inst_38346)){
var statearr_38416_38460 = state_38376__$1;
(statearr_38416_38460[(1)] = (30));

} else {
var statearr_38417_38461 = state_38376__$1;
(statearr_38417_38461[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (16))){
var inst_38312 = (state_38376[(2)]);
var inst_38313 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38314 = figwheel.client.heads_up.display_exception.call(null,inst_38313);
var state_38376__$1 = (function (){var statearr_38418 = state_38376;
(statearr_38418[(13)] = inst_38312);

return statearr_38418;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(17),inst_38314);
} else {
if((state_val_38377 === (30))){
var inst_38348 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38349 = figwheel.client.heads_up.display_warning.call(null,inst_38348);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(33),inst_38349);
} else {
if((state_val_38377 === (10))){
var inst_38306 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38419_38462 = state_38376__$1;
(statearr_38419_38462[(2)] = inst_38306);

(statearr_38419_38462[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (18))){
var inst_38322 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_38323 = figwheel.client.heads_up.display_exception.call(null,inst_38322);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(21),inst_38323);
} else {
if((state_val_38377 === (37))){
var inst_38359 = (state_38376[(2)]);
var state_38376__$1 = state_38376;
var statearr_38420_38463 = state_38376__$1;
(statearr_38420_38463[(2)] = inst_38359);

(statearr_38420_38463[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38377 === (8))){
var inst_38298 = figwheel.client.heads_up.flash_loaded.call(null);
var state_38376__$1 = state_38376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38376__$1,(11),inst_38298);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30406__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__30292__auto__,c__30406__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto____0 = (function (){
var statearr_38424 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38424[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto__);

(statearr_38424[(1)] = (1));

return statearr_38424;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto____1 = (function (state_38376){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_38376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e38425){if((e38425 instanceof Object)){
var ex__30296__auto__ = e38425;
var statearr_38426_38464 = state_38376;
(statearr_38426_38464[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38376);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38425;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38465 = state_38376;
state_38376 = G__38465;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto__ = function(state_38376){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto____1.call(this,state_38376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__,msg_hist,msg_names,msg))
})();
var state__30408__auto__ = (function (){var statearr_38427 = f__30407__auto__.call(null);
(statearr_38427[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_38427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__,msg_hist,msg_names,msg))
);

return c__30406__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__30406__auto___38528 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto___38528,ch){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto___38528,ch){
return (function (state_38511){
var state_val_38512 = (state_38511[(1)]);
if((state_val_38512 === (1))){
var state_38511__$1 = state_38511;
var statearr_38513_38529 = state_38511__$1;
(statearr_38513_38529[(2)] = null);

(statearr_38513_38529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38512 === (2))){
var state_38511__$1 = state_38511;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38511__$1,(4),ch);
} else {
if((state_val_38512 === (3))){
var inst_38509 = (state_38511[(2)]);
var state_38511__$1 = state_38511;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38511__$1,inst_38509);
} else {
if((state_val_38512 === (4))){
var inst_38499 = (state_38511[(7)]);
var inst_38499__$1 = (state_38511[(2)]);
var state_38511__$1 = (function (){var statearr_38514 = state_38511;
(statearr_38514[(7)] = inst_38499__$1);

return statearr_38514;
})();
if(cljs.core.truth_(inst_38499__$1)){
var statearr_38515_38530 = state_38511__$1;
(statearr_38515_38530[(1)] = (5));

} else {
var statearr_38516_38531 = state_38511__$1;
(statearr_38516_38531[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38512 === (5))){
var inst_38499 = (state_38511[(7)]);
var inst_38501 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_38499);
var state_38511__$1 = state_38511;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38511__$1,(8),inst_38501);
} else {
if((state_val_38512 === (6))){
var state_38511__$1 = state_38511;
var statearr_38517_38532 = state_38511__$1;
(statearr_38517_38532[(2)] = null);

(statearr_38517_38532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38512 === (7))){
var inst_38507 = (state_38511[(2)]);
var state_38511__$1 = state_38511;
var statearr_38518_38533 = state_38511__$1;
(statearr_38518_38533[(2)] = inst_38507);

(statearr_38518_38533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38512 === (8))){
var inst_38503 = (state_38511[(2)]);
var state_38511__$1 = (function (){var statearr_38519 = state_38511;
(statearr_38519[(8)] = inst_38503);

return statearr_38519;
})();
var statearr_38520_38534 = state_38511__$1;
(statearr_38520_38534[(2)] = null);

(statearr_38520_38534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__30406__auto___38528,ch))
;
return ((function (switch__30292__auto__,c__30406__auto___38528,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__30293__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__30293__auto____0 = (function (){
var statearr_38524 = [null,null,null,null,null,null,null,null,null];
(statearr_38524[(0)] = figwheel$client$heads_up_plugin_$_state_machine__30293__auto__);

(statearr_38524[(1)] = (1));

return statearr_38524;
});
var figwheel$client$heads_up_plugin_$_state_machine__30293__auto____1 = (function (state_38511){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_38511);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e38525){if((e38525 instanceof Object)){
var ex__30296__auto__ = e38525;
var statearr_38526_38535 = state_38511;
(statearr_38526_38535[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38511);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38525;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38536 = state_38511;
state_38511 = G__38536;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__30293__auto__ = function(state_38511){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__30293__auto____1.call(this,state_38511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__30293__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__30293__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto___38528,ch))
})();
var state__30408__auto__ = (function (){var statearr_38527 = f__30407__auto__.call(null);
(statearr_38527[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto___38528);

return statearr_38527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto___38528,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__){
return (function (state_38557){
var state_val_38558 = (state_38557[(1)]);
if((state_val_38558 === (1))){
var inst_38552 = cljs.core.async.timeout.call(null,(3000));
var state_38557__$1 = state_38557;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38557__$1,(2),inst_38552);
} else {
if((state_val_38558 === (2))){
var inst_38554 = (state_38557[(2)]);
var inst_38555 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_38557__$1 = (function (){var statearr_38559 = state_38557;
(statearr_38559[(7)] = inst_38554);

return statearr_38559;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38557__$1,inst_38555);
} else {
return null;
}
}
});})(c__30406__auto__))
;
return ((function (switch__30292__auto__,c__30406__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__30293__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__30293__auto____0 = (function (){
var statearr_38563 = [null,null,null,null,null,null,null,null];
(statearr_38563[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__30293__auto__);

(statearr_38563[(1)] = (1));

return statearr_38563;
});
var figwheel$client$enforce_project_plugin_$_state_machine__30293__auto____1 = (function (state_38557){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_38557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e38564){if((e38564 instanceof Object)){
var ex__30296__auto__ = e38564;
var statearr_38565_38567 = state_38557;
(statearr_38565_38567[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38557);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38564;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38568 = state_38557;
state_38557 = G__38568;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__30293__auto__ = function(state_38557){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__30293__auto____1.call(this,state_38557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__30293__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__30293__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__))
})();
var state__30408__auto__ = (function (){var statearr_38566 = f__30407__auto__.call(null);
(statearr_38566[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_38566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__))
);

return c__30406__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__6753__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__6753__auto__)){
var figwheel_version = temp__6753__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30406__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30406__auto__,figwheel_version,temp__6753__auto__){
return (function (){
var f__30407__auto__ = (function (){var switch__30292__auto__ = ((function (c__30406__auto__,figwheel_version,temp__6753__auto__){
return (function (state_38591){
var state_val_38592 = (state_38591[(1)]);
if((state_val_38592 === (1))){
var inst_38585 = cljs.core.async.timeout.call(null,(2000));
var state_38591__$1 = state_38591;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38591__$1,(2),inst_38585);
} else {
if((state_val_38592 === (2))){
var inst_38587 = (state_38591[(2)]);
var inst_38588 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_38589 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_38588);
var state_38591__$1 = (function (){var statearr_38593 = state_38591;
(statearr_38593[(7)] = inst_38587);

return statearr_38593;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38591__$1,inst_38589);
} else {
return null;
}
}
});})(c__30406__auto__,figwheel_version,temp__6753__auto__))
;
return ((function (switch__30292__auto__,c__30406__auto__,figwheel_version,temp__6753__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto____0 = (function (){
var statearr_38597 = [null,null,null,null,null,null,null,null];
(statearr_38597[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto__);

(statearr_38597[(1)] = (1));

return statearr_38597;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto____1 = (function (state_38591){
while(true){
var ret_value__30294__auto__ = (function (){try{while(true){
var result__30295__auto__ = switch__30292__auto__.call(null,state_38591);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30295__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30295__auto__;
}
break;
}
}catch (e38598){if((e38598 instanceof Object)){
var ex__30296__auto__ = e38598;
var statearr_38599_38601 = state_38591;
(statearr_38599_38601[(5)] = ex__30296__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38591);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38598;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30294__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38602 = state_38591;
state_38591 = G__38602;
continue;
} else {
return ret_value__30294__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto__ = function(state_38591){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto____1.call(this,state_38591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30293__auto__;
})()
;})(switch__30292__auto__,c__30406__auto__,figwheel_version,temp__6753__auto__))
})();
var state__30408__auto__ = (function (){var statearr_38600 = f__30407__auto__.call(null);
(statearr_38600[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__30406__auto__);

return statearr_38600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30408__auto__);
});})(c__30406__auto__,figwheel_version,temp__6753__auto__))
);

return c__30406__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__38603){
var map__38607 = p__38603;
var map__38607__$1 = ((((!((map__38607 == null)))?((((map__38607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38607.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38607):map__38607);
var file = cljs.core.get.call(null,map__38607__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__38607__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__38607__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__38609 = "";
var G__38609__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38609),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__38609);
var G__38609__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38609__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__38609__$1);
if(cljs.core.truth_((function (){var and__27009__auto__ = line;
if(cljs.core.truth_(and__27009__auto__)){
return column;
} else {
return and__27009__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38609__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__38609__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__38610){
var map__38617 = p__38610;
var map__38617__$1 = ((((!((map__38617 == null)))?((((map__38617.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38617.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38617):map__38617);
var ed = map__38617__$1;
var formatted_exception = cljs.core.get.call(null,map__38617__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__38617__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__38617__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__38619_38623 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__38620_38624 = null;
var count__38621_38625 = (0);
var i__38622_38626 = (0);
while(true){
if((i__38622_38626 < count__38621_38625)){
var msg_38627 = cljs.core._nth.call(null,chunk__38620_38624,i__38622_38626);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_38627);

var G__38628 = seq__38619_38623;
var G__38629 = chunk__38620_38624;
var G__38630 = count__38621_38625;
var G__38631 = (i__38622_38626 + (1));
seq__38619_38623 = G__38628;
chunk__38620_38624 = G__38629;
count__38621_38625 = G__38630;
i__38622_38626 = G__38631;
continue;
} else {
var temp__6753__auto___38632 = cljs.core.seq.call(null,seq__38619_38623);
if(temp__6753__auto___38632){
var seq__38619_38633__$1 = temp__6753__auto___38632;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38619_38633__$1)){
var c__27932__auto___38634 = cljs.core.chunk_first.call(null,seq__38619_38633__$1);
var G__38635 = cljs.core.chunk_rest.call(null,seq__38619_38633__$1);
var G__38636 = c__27932__auto___38634;
var G__38637 = cljs.core.count.call(null,c__27932__auto___38634);
var G__38638 = (0);
seq__38619_38623 = G__38635;
chunk__38620_38624 = G__38636;
count__38621_38625 = G__38637;
i__38622_38626 = G__38638;
continue;
} else {
var msg_38639 = cljs.core.first.call(null,seq__38619_38633__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_38639);

var G__38640 = cljs.core.next.call(null,seq__38619_38633__$1);
var G__38641 = null;
var G__38642 = (0);
var G__38643 = (0);
seq__38619_38623 = G__38640;
chunk__38620_38624 = G__38641;
count__38621_38625 = G__38642;
i__38622_38626 = G__38643;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__38644){
var map__38647 = p__38644;
var map__38647__$1 = ((((!((map__38647 == null)))?((((map__38647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38647.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38647):map__38647);
var w = map__38647__$1;
var message = cljs.core.get.call(null,map__38647__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__27009__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__27009__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__27009__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__38659 = cljs.core.seq.call(null,plugins);
var chunk__38660 = null;
var count__38661 = (0);
var i__38662 = (0);
while(true){
if((i__38662 < count__38661)){
var vec__38663 = cljs.core._nth.call(null,chunk__38660,i__38662);
var k = cljs.core.nth.call(null,vec__38663,(0),null);
var plugin = cljs.core.nth.call(null,vec__38663,(1),null);
if(cljs.core.truth_(plugin)){
var pl_38669 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__38659,chunk__38660,count__38661,i__38662,pl_38669,vec__38663,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_38669.call(null,msg_hist);
});})(seq__38659,chunk__38660,count__38661,i__38662,pl_38669,vec__38663,k,plugin))
);
} else {
}

var G__38670 = seq__38659;
var G__38671 = chunk__38660;
var G__38672 = count__38661;
var G__38673 = (i__38662 + (1));
seq__38659 = G__38670;
chunk__38660 = G__38671;
count__38661 = G__38672;
i__38662 = G__38673;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__38659);
if(temp__6753__auto__){
var seq__38659__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38659__$1)){
var c__27932__auto__ = cljs.core.chunk_first.call(null,seq__38659__$1);
var G__38674 = cljs.core.chunk_rest.call(null,seq__38659__$1);
var G__38675 = c__27932__auto__;
var G__38676 = cljs.core.count.call(null,c__27932__auto__);
var G__38677 = (0);
seq__38659 = G__38674;
chunk__38660 = G__38675;
count__38661 = G__38676;
i__38662 = G__38677;
continue;
} else {
var vec__38666 = cljs.core.first.call(null,seq__38659__$1);
var k = cljs.core.nth.call(null,vec__38666,(0),null);
var plugin = cljs.core.nth.call(null,vec__38666,(1),null);
if(cljs.core.truth_(plugin)){
var pl_38678 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__38659,chunk__38660,count__38661,i__38662,pl_38678,vec__38666,k,plugin,seq__38659__$1,temp__6753__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_38678.call(null,msg_hist);
});})(seq__38659,chunk__38660,count__38661,i__38662,pl_38678,vec__38666,k,plugin,seq__38659__$1,temp__6753__auto__))
);
} else {
}

var G__38679 = cljs.core.next.call(null,seq__38659__$1);
var G__38680 = null;
var G__38681 = (0);
var G__38682 = (0);
seq__38659 = G__38679;
chunk__38660 = G__38680;
count__38661 = G__38681;
i__38662 = G__38682;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args38683 = [];
var len__28242__auto___38690 = arguments.length;
var i__28243__auto___38691 = (0);
while(true){
if((i__28243__auto___38691 < len__28242__auto___38690)){
args38683.push((arguments[i__28243__auto___38691]));

var G__38692 = (i__28243__auto___38691 + (1));
i__28243__auto___38691 = G__38692;
continue;
} else {
}
break;
}

var G__38685 = args38683.length;
switch (G__38685) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args38683.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__38686_38694 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__38687_38695 = null;
var count__38688_38696 = (0);
var i__38689_38697 = (0);
while(true){
if((i__38689_38697 < count__38688_38696)){
var msg_38698 = cljs.core._nth.call(null,chunk__38687_38695,i__38689_38697);
figwheel.client.socket.handle_incoming_message.call(null,msg_38698);

var G__38699 = seq__38686_38694;
var G__38700 = chunk__38687_38695;
var G__38701 = count__38688_38696;
var G__38702 = (i__38689_38697 + (1));
seq__38686_38694 = G__38699;
chunk__38687_38695 = G__38700;
count__38688_38696 = G__38701;
i__38689_38697 = G__38702;
continue;
} else {
var temp__6753__auto___38703 = cljs.core.seq.call(null,seq__38686_38694);
if(temp__6753__auto___38703){
var seq__38686_38704__$1 = temp__6753__auto___38703;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38686_38704__$1)){
var c__27932__auto___38705 = cljs.core.chunk_first.call(null,seq__38686_38704__$1);
var G__38706 = cljs.core.chunk_rest.call(null,seq__38686_38704__$1);
var G__38707 = c__27932__auto___38705;
var G__38708 = cljs.core.count.call(null,c__27932__auto___38705);
var G__38709 = (0);
seq__38686_38694 = G__38706;
chunk__38687_38695 = G__38707;
count__38688_38696 = G__38708;
i__38689_38697 = G__38709;
continue;
} else {
var msg_38710 = cljs.core.first.call(null,seq__38686_38704__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_38710);

var G__38711 = cljs.core.next.call(null,seq__38686_38704__$1);
var G__38712 = null;
var G__38713 = (0);
var G__38714 = (0);
seq__38686_38694 = G__38711;
chunk__38687_38695 = G__38712;
count__38688_38696 = G__38713;
i__38689_38697 = G__38714;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__28249__auto__ = [];
var len__28242__auto___38719 = arguments.length;
var i__28243__auto___38720 = (0);
while(true){
if((i__28243__auto___38720 < len__28242__auto___38719)){
args__28249__auto__.push((arguments[i__28243__auto___38720]));

var G__38721 = (i__28243__auto___38720 + (1));
i__28243__auto___38720 = G__38721;
continue;
} else {
}
break;
}

var argseq__28250__auto__ = ((((0) < args__28249__auto__.length))?(new cljs.core.IndexedSeq(args__28249__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__28250__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__38716){
var map__38717 = p__38716;
var map__38717__$1 = ((((!((map__38717 == null)))?((((map__38717.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38717.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38717):map__38717);
var opts = map__38717__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq38715){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38715));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e38723){if((e38723 instanceof Error)){
var e = e38723;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e38723;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__38727){
var map__38728 = p__38727;
var map__38728__$1 = ((((!((map__38728 == null)))?((((map__38728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38728.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38728):map__38728);
var msg_name = cljs.core.get.call(null,map__38728__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1486396826413