(ns navtree.zipper
  (:require [clojure.zip :as z]))

(defn z-nav [tree id-fn children-fn]
  (z/zipper id-fn children-fn #() tree))

(defn z-nav->path [zn id-fn]
  (-> (map id-fn (z/path zn))
      (concat [(-> zn z/node id-fn)])))

(defn path->z-nav
  [tree id-fn children-fn path-list]
  (reduce
    (fn [z path-el]
      (loop [z (z/down z)]
        (if (-> z z/node id-fn (= path-el))
          z
          (recur (z/right z)))))
    (z-nav tree id-fn children-fn)
    (rest path-list)))
