// Compiled by ClojureScript 1.9.229 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args29278 = [];
var len__27753__auto___29284 = arguments.length;
var i__27754__auto___29285 = (0);
while(true){
if((i__27754__auto___29285 < len__27753__auto___29284)){
args29278.push((arguments[i__27754__auto___29285]));

var G__29286 = (i__27754__auto___29285 + (1));
i__27754__auto___29285 = G__29286;
continue;
} else {
}
break;
}

var G__29280 = args29278.length;
switch (G__29280) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29278.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async29281 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29281 = (function (f,blockable,meta29282){
this.f = f;
this.blockable = blockable;
this.meta29282 = meta29282;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29281.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29283,meta29282__$1){
var self__ = this;
var _29283__$1 = this;
return (new cljs.core.async.t_cljs$core$async29281(self__.f,self__.blockable,meta29282__$1));
});

cljs.core.async.t_cljs$core$async29281.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29283){
var self__ = this;
var _29283__$1 = this;
return self__.meta29282;
});

cljs.core.async.t_cljs$core$async29281.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29281.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29281.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async29281.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async29281.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29282","meta29282",-106263492,null)], null);
});

cljs.core.async.t_cljs$core$async29281.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29281.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29281";

cljs.core.async.t_cljs$core$async29281.cljs$lang$ctorPrWriter = (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async29281");
});

cljs.core.async.__GT_t_cljs$core$async29281 = (function cljs$core$async$__GT_t_cljs$core$async29281(f__$1,blockable__$1,meta29282){
return (new cljs.core.async.t_cljs$core$async29281(f__$1,blockable__$1,meta29282));
});

}

return (new cljs.core.async.t_cljs$core$async29281(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args29290 = [];
var len__27753__auto___29293 = arguments.length;
var i__27754__auto___29294 = (0);
while(true){
if((i__27754__auto___29294 < len__27753__auto___29293)){
args29290.push((arguments[i__27754__auto___29294]));

var G__29295 = (i__27754__auto___29294 + (1));
i__27754__auto___29294 = G__29295;
continue;
} else {
}
break;
}

var G__29292 = args29290.length;
switch (G__29292) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29290.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args29297 = [];
var len__27753__auto___29300 = arguments.length;
var i__27754__auto___29301 = (0);
while(true){
if((i__27754__auto___29301 < len__27753__auto___29300)){
args29297.push((arguments[i__27754__auto___29301]));

var G__29302 = (i__27754__auto___29301 + (1));
i__27754__auto___29301 = G__29302;
continue;
} else {
}
break;
}

var G__29299 = args29297.length;
switch (G__29299) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29297.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args29304 = [];
var len__27753__auto___29307 = arguments.length;
var i__27754__auto___29308 = (0);
while(true){
if((i__27754__auto___29308 < len__27753__auto___29307)){
args29304.push((arguments[i__27754__auto___29308]));

var G__29309 = (i__27754__auto___29308 + (1));
i__27754__auto___29308 = G__29309;
continue;
} else {
}
break;
}

var G__29306 = args29304.length;
switch (G__29306) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29304.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29311 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29311);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29311,ret){
return (function (){
return fn1.call(null,val_29311);
});})(val_29311,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args29312 = [];
var len__27753__auto___29315 = arguments.length;
var i__27754__auto___29316 = (0);
while(true){
if((i__27754__auto___29316 < len__27753__auto___29315)){
args29312.push((arguments[i__27754__auto___29316]));

var G__29317 = (i__27754__auto___29316 + (1));
i__27754__auto___29316 = G__29317;
continue;
} else {
}
break;
}

var G__29314 = args29312.length;
switch (G__29314) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29312.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6726__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6726__auto__)){
var ret = temp__6726__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6726__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6726__auto__)){
var retb = temp__6726__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6726__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6726__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__27583__auto___29319 = n;
var x_29320 = (0);
while(true){
if((x_29320 < n__27583__auto___29319)){
(a[x_29320] = (0));

var G__29321 = (x_29320 + (1));
x_29320 = G__29321;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29322 = (i + (1));
i = G__29322;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async29326 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29326 = (function (alt_flag,flag,meta29327){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29327 = meta29327;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29326.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29328,meta29327__$1){
var self__ = this;
var _29328__$1 = this;
return (new cljs.core.async.t_cljs$core$async29326(self__.alt_flag,self__.flag,meta29327__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async29326.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29328){
var self__ = this;
var _29328__$1 = this;
return self__.meta29327;
});})(flag))
;

cljs.core.async.t_cljs$core$async29326.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29326.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async29326.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29326.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29326.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29327","meta29327",1201493245,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async29326.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29326.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29326";

cljs.core.async.t_cljs$core$async29326.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async29326");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async29326 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29326(alt_flag__$1,flag__$1,meta29327){
return (new cljs.core.async.t_cljs$core$async29326(alt_flag__$1,flag__$1,meta29327));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async29326(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async29332 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29332 = (function (alt_handler,flag,cb,meta29333){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29333 = meta29333;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29332.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29334,meta29333__$1){
var self__ = this;
var _29334__$1 = this;
return (new cljs.core.async.t_cljs$core$async29332(self__.alt_handler,self__.flag,self__.cb,meta29333__$1));
});

cljs.core.async.t_cljs$core$async29332.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29334){
var self__ = this;
var _29334__$1 = this;
return self__.meta29333;
});

cljs.core.async.t_cljs$core$async29332.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29332.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async29332.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29332.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async29332.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29333","meta29333",-154080659,null)], null);
});

cljs.core.async.t_cljs$core$async29332.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29332.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29332";

cljs.core.async.t_cljs$core$async29332.cljs$lang$ctorPrWriter = (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async29332");
});

cljs.core.async.__GT_t_cljs$core$async29332 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29332(alt_handler__$1,flag__$1,cb__$1,meta29333){
return (new cljs.core.async.t_cljs$core$async29332(alt_handler__$1,flag__$1,cb__$1,meta29333));
});

}

return (new cljs.core.async.t_cljs$core$async29332(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29335_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29335_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__29336_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__29336_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__26570__auto__ = wport;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return port;
}
})()], null));
} else {
var G__29337 = (i + (1));
i = G__29337;
continue;
}
} else {
return null;
}
break;
}
})();
var or__26570__auto__ = ret;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6728__auto__ = (function (){var and__26558__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__26558__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__26558__auto__;
}
})();
if(cljs.core.truth_(temp__6728__auto__)){
var got = temp__6728__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__27760__auto__ = [];
var len__27753__auto___29343 = arguments.length;
var i__27754__auto___29344 = (0);
while(true){
if((i__27754__auto___29344 < len__27753__auto___29343)){
args__27760__auto__.push((arguments[i__27754__auto___29344]));

var G__29345 = (i__27754__auto___29344 + (1));
i__27754__auto___29344 = G__29345;
continue;
} else {
}
break;
}

var argseq__27761__auto__ = ((((1) < args__27760__auto__.length))?(new cljs.core.IndexedSeq(args__27760__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__27761__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__29340){
var map__29341 = p__29340;
var map__29341__$1 = ((((!((map__29341 == null)))?((((map__29341.cljs$lang$protocol_mask$partition0$ & (64))) || (map__29341.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29341):map__29341);
var opts = map__29341__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq29338){
var G__29339 = cljs.core.first.call(null,seq29338);
var seq29338__$1 = cljs.core.next.call(null,seq29338);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29339,seq29338__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args29346 = [];
var len__27753__auto___29396 = arguments.length;
var i__27754__auto___29397 = (0);
while(true){
if((i__27754__auto___29397 < len__27753__auto___29396)){
args29346.push((arguments[i__27754__auto___29397]));

var G__29398 = (i__27754__auto___29397 + (1));
i__27754__auto___29397 = G__29398;
continue;
} else {
}
break;
}

var G__29348 = args29346.length;
switch (G__29348) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29346.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29219__auto___29400 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___29400){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___29400){
return (function (state_29372){
var state_val_29373 = (state_29372[(1)]);
if((state_val_29373 === (7))){
var inst_29368 = (state_29372[(2)]);
var state_29372__$1 = state_29372;
var statearr_29374_29401 = state_29372__$1;
(statearr_29374_29401[(2)] = inst_29368);

(statearr_29374_29401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (1))){
var state_29372__$1 = state_29372;
var statearr_29375_29402 = state_29372__$1;
(statearr_29375_29402[(2)] = null);

(statearr_29375_29402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (4))){
var inst_29351 = (state_29372[(7)]);
var inst_29351__$1 = (state_29372[(2)]);
var inst_29352 = (inst_29351__$1 == null);
var state_29372__$1 = (function (){var statearr_29376 = state_29372;
(statearr_29376[(7)] = inst_29351__$1);

return statearr_29376;
})();
if(cljs.core.truth_(inst_29352)){
var statearr_29377_29403 = state_29372__$1;
(statearr_29377_29403[(1)] = (5));

} else {
var statearr_29378_29404 = state_29372__$1;
(statearr_29378_29404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (13))){
var state_29372__$1 = state_29372;
var statearr_29379_29405 = state_29372__$1;
(statearr_29379_29405[(2)] = null);

(statearr_29379_29405[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (6))){
var inst_29351 = (state_29372[(7)]);
var state_29372__$1 = state_29372;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29372__$1,(11),to,inst_29351);
} else {
if((state_val_29373 === (3))){
var inst_29370 = (state_29372[(2)]);
var state_29372__$1 = state_29372;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29372__$1,inst_29370);
} else {
if((state_val_29373 === (12))){
var state_29372__$1 = state_29372;
var statearr_29380_29406 = state_29372__$1;
(statearr_29380_29406[(2)] = null);

(statearr_29380_29406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (2))){
var state_29372__$1 = state_29372;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29372__$1,(4),from);
} else {
if((state_val_29373 === (11))){
var inst_29361 = (state_29372[(2)]);
var state_29372__$1 = state_29372;
if(cljs.core.truth_(inst_29361)){
var statearr_29381_29407 = state_29372__$1;
(statearr_29381_29407[(1)] = (12));

} else {
var statearr_29382_29408 = state_29372__$1;
(statearr_29382_29408[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (9))){
var state_29372__$1 = state_29372;
var statearr_29383_29409 = state_29372__$1;
(statearr_29383_29409[(2)] = null);

(statearr_29383_29409[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (5))){
var state_29372__$1 = state_29372;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29384_29410 = state_29372__$1;
(statearr_29384_29410[(1)] = (8));

} else {
var statearr_29385_29411 = state_29372__$1;
(statearr_29385_29411[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (14))){
var inst_29366 = (state_29372[(2)]);
var state_29372__$1 = state_29372;
var statearr_29386_29412 = state_29372__$1;
(statearr_29386_29412[(2)] = inst_29366);

(statearr_29386_29412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (10))){
var inst_29358 = (state_29372[(2)]);
var state_29372__$1 = state_29372;
var statearr_29387_29413 = state_29372__$1;
(statearr_29387_29413[(2)] = inst_29358);

(statearr_29387_29413[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29373 === (8))){
var inst_29355 = cljs.core.async.close_BANG_.call(null,to);
var state_29372__$1 = state_29372;
var statearr_29388_29414 = state_29372__$1;
(statearr_29388_29414[(2)] = inst_29355);

(statearr_29388_29414[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___29400))
;
return ((function (switch__29105__auto__,c__29219__auto___29400){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_29392 = [null,null,null,null,null,null,null,null];
(statearr_29392[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_29392[(1)] = (1));

return statearr_29392;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_29372){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29372);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e29393){if((e29393 instanceof Object)){
var ex__29109__auto__ = e29393;
var statearr_29394_29415 = state_29372;
(statearr_29394_29415[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29372);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29416 = state_29372;
state_29372 = G__29416;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_29372){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_29372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___29400))
})();
var state__29221__auto__ = (function (){var statearr_29395 = f__29220__auto__.call(null);
(statearr_29395[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___29400);

return statearr_29395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___29400))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__29604){
var vec__29605 = p__29604;
var v = cljs.core.nth.call(null,vec__29605,(0),null);
var p = cljs.core.nth.call(null,vec__29605,(1),null);
var job = vec__29605;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__29219__auto___29791 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___29791,res,vec__29605,v,p,job,jobs,results){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___29791,res,vec__29605,v,p,job,jobs,results){
return (function (state_29612){
var state_val_29613 = (state_29612[(1)]);
if((state_val_29613 === (1))){
var state_29612__$1 = state_29612;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29612__$1,(2),res,v);
} else {
if((state_val_29613 === (2))){
var inst_29609 = (state_29612[(2)]);
var inst_29610 = cljs.core.async.close_BANG_.call(null,res);
var state_29612__$1 = (function (){var statearr_29614 = state_29612;
(statearr_29614[(7)] = inst_29609);

return statearr_29614;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29612__$1,inst_29610);
} else {
return null;
}
}
});})(c__29219__auto___29791,res,vec__29605,v,p,job,jobs,results))
;
return ((function (switch__29105__auto__,c__29219__auto___29791,res,vec__29605,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0 = (function (){
var statearr_29618 = [null,null,null,null,null,null,null,null];
(statearr_29618[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__);

(statearr_29618[(1)] = (1));

return statearr_29618;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1 = (function (state_29612){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e29619){if((e29619 instanceof Object)){
var ex__29109__auto__ = e29619;
var statearr_29620_29792 = state_29612;
(statearr_29620_29792[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29612);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29619;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29793 = state_29612;
state_29612 = G__29793;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = function(state_29612){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1.call(this,state_29612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___29791,res,vec__29605,v,p,job,jobs,results))
})();
var state__29221__auto__ = (function (){var statearr_29621 = f__29220__auto__.call(null);
(statearr_29621[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___29791);

return statearr_29621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___29791,res,vec__29605,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__29622){
var vec__29623 = p__29622;
var v = cljs.core.nth.call(null,vec__29623,(0),null);
var p = cljs.core.nth.call(null,vec__29623,(1),null);
var job = vec__29623;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__27583__auto___29794 = n;
var __29795 = (0);
while(true){
if((__29795 < n__27583__auto___29794)){
var G__29626_29796 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__29626_29796) {
case "compute":
var c__29219__auto___29798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29795,c__29219__auto___29798,G__29626_29796,n__27583__auto___29794,jobs,results,process,async){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (__29795,c__29219__auto___29798,G__29626_29796,n__27583__auto___29794,jobs,results,process,async){
return (function (state_29639){
var state_val_29640 = (state_29639[(1)]);
if((state_val_29640 === (1))){
var state_29639__$1 = state_29639;
var statearr_29641_29799 = state_29639__$1;
(statearr_29641_29799[(2)] = null);

(statearr_29641_29799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (2))){
var state_29639__$1 = state_29639;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29639__$1,(4),jobs);
} else {
if((state_val_29640 === (3))){
var inst_29637 = (state_29639[(2)]);
var state_29639__$1 = state_29639;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29639__$1,inst_29637);
} else {
if((state_val_29640 === (4))){
var inst_29629 = (state_29639[(2)]);
var inst_29630 = process.call(null,inst_29629);
var state_29639__$1 = state_29639;
if(cljs.core.truth_(inst_29630)){
var statearr_29642_29800 = state_29639__$1;
(statearr_29642_29800[(1)] = (5));

} else {
var statearr_29643_29801 = state_29639__$1;
(statearr_29643_29801[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (5))){
var state_29639__$1 = state_29639;
var statearr_29644_29802 = state_29639__$1;
(statearr_29644_29802[(2)] = null);

(statearr_29644_29802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (6))){
var state_29639__$1 = state_29639;
var statearr_29645_29803 = state_29639__$1;
(statearr_29645_29803[(2)] = null);

(statearr_29645_29803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29640 === (7))){
var inst_29635 = (state_29639[(2)]);
var state_29639__$1 = state_29639;
var statearr_29646_29804 = state_29639__$1;
(statearr_29646_29804[(2)] = inst_29635);

(statearr_29646_29804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29795,c__29219__auto___29798,G__29626_29796,n__27583__auto___29794,jobs,results,process,async))
;
return ((function (__29795,switch__29105__auto__,c__29219__auto___29798,G__29626_29796,n__27583__auto___29794,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0 = (function (){
var statearr_29650 = [null,null,null,null,null,null,null];
(statearr_29650[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__);

(statearr_29650[(1)] = (1));

return statearr_29650;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1 = (function (state_29639){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29639);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e29651){if((e29651 instanceof Object)){
var ex__29109__auto__ = e29651;
var statearr_29652_29805 = state_29639;
(statearr_29652_29805[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29639);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29651;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29806 = state_29639;
state_29639 = G__29806;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = function(state_29639){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1.call(this,state_29639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__;
})()
;})(__29795,switch__29105__auto__,c__29219__auto___29798,G__29626_29796,n__27583__auto___29794,jobs,results,process,async))
})();
var state__29221__auto__ = (function (){var statearr_29653 = f__29220__auto__.call(null);
(statearr_29653[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___29798);

return statearr_29653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(__29795,c__29219__auto___29798,G__29626_29796,n__27583__auto___29794,jobs,results,process,async))
);


break;
case "async":
var c__29219__auto___29807 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__29795,c__29219__auto___29807,G__29626_29796,n__27583__auto___29794,jobs,results,process,async){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (__29795,c__29219__auto___29807,G__29626_29796,n__27583__auto___29794,jobs,results,process,async){
return (function (state_29666){
var state_val_29667 = (state_29666[(1)]);
if((state_val_29667 === (1))){
var state_29666__$1 = state_29666;
var statearr_29668_29808 = state_29666__$1;
(statearr_29668_29808[(2)] = null);

(statearr_29668_29808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29667 === (2))){
var state_29666__$1 = state_29666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29666__$1,(4),jobs);
} else {
if((state_val_29667 === (3))){
var inst_29664 = (state_29666[(2)]);
var state_29666__$1 = state_29666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29666__$1,inst_29664);
} else {
if((state_val_29667 === (4))){
var inst_29656 = (state_29666[(2)]);
var inst_29657 = async.call(null,inst_29656);
var state_29666__$1 = state_29666;
if(cljs.core.truth_(inst_29657)){
var statearr_29669_29809 = state_29666__$1;
(statearr_29669_29809[(1)] = (5));

} else {
var statearr_29670_29810 = state_29666__$1;
(statearr_29670_29810[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29667 === (5))){
var state_29666__$1 = state_29666;
var statearr_29671_29811 = state_29666__$1;
(statearr_29671_29811[(2)] = null);

(statearr_29671_29811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29667 === (6))){
var state_29666__$1 = state_29666;
var statearr_29672_29812 = state_29666__$1;
(statearr_29672_29812[(2)] = null);

(statearr_29672_29812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29667 === (7))){
var inst_29662 = (state_29666[(2)]);
var state_29666__$1 = state_29666;
var statearr_29673_29813 = state_29666__$1;
(statearr_29673_29813[(2)] = inst_29662);

(statearr_29673_29813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__29795,c__29219__auto___29807,G__29626_29796,n__27583__auto___29794,jobs,results,process,async))
;
return ((function (__29795,switch__29105__auto__,c__29219__auto___29807,G__29626_29796,n__27583__auto___29794,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0 = (function (){
var statearr_29677 = [null,null,null,null,null,null,null];
(statearr_29677[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__);

(statearr_29677[(1)] = (1));

return statearr_29677;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1 = (function (state_29666){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e29678){if((e29678 instanceof Object)){
var ex__29109__auto__ = e29678;
var statearr_29679_29814 = state_29666;
(statearr_29679_29814[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29666);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29678;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29815 = state_29666;
state_29666 = G__29815;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = function(state_29666){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1.call(this,state_29666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__;
})()
;})(__29795,switch__29105__auto__,c__29219__auto___29807,G__29626_29796,n__27583__auto___29794,jobs,results,process,async))
})();
var state__29221__auto__ = (function (){var statearr_29680 = f__29220__auto__.call(null);
(statearr_29680[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___29807);

return statearr_29680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(__29795,c__29219__auto___29807,G__29626_29796,n__27583__auto___29794,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__29816 = (__29795 + (1));
__29795 = G__29816;
continue;
} else {
}
break;
}

var c__29219__auto___29817 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___29817,jobs,results,process,async){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___29817,jobs,results,process,async){
return (function (state_29702){
var state_val_29703 = (state_29702[(1)]);
if((state_val_29703 === (1))){
var state_29702__$1 = state_29702;
var statearr_29704_29818 = state_29702__$1;
(statearr_29704_29818[(2)] = null);

(statearr_29704_29818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29703 === (2))){
var state_29702__$1 = state_29702;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29702__$1,(4),from);
} else {
if((state_val_29703 === (3))){
var inst_29700 = (state_29702[(2)]);
var state_29702__$1 = state_29702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29702__$1,inst_29700);
} else {
if((state_val_29703 === (4))){
var inst_29683 = (state_29702[(7)]);
var inst_29683__$1 = (state_29702[(2)]);
var inst_29684 = (inst_29683__$1 == null);
var state_29702__$1 = (function (){var statearr_29705 = state_29702;
(statearr_29705[(7)] = inst_29683__$1);

return statearr_29705;
})();
if(cljs.core.truth_(inst_29684)){
var statearr_29706_29819 = state_29702__$1;
(statearr_29706_29819[(1)] = (5));

} else {
var statearr_29707_29820 = state_29702__$1;
(statearr_29707_29820[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29703 === (5))){
var inst_29686 = cljs.core.async.close_BANG_.call(null,jobs);
var state_29702__$1 = state_29702;
var statearr_29708_29821 = state_29702__$1;
(statearr_29708_29821[(2)] = inst_29686);

(statearr_29708_29821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29703 === (6))){
var inst_29683 = (state_29702[(7)]);
var inst_29688 = (state_29702[(8)]);
var inst_29688__$1 = cljs.core.async.chan.call(null,(1));
var inst_29689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29690 = [inst_29683,inst_29688__$1];
var inst_29691 = (new cljs.core.PersistentVector(null,2,(5),inst_29689,inst_29690,null));
var state_29702__$1 = (function (){var statearr_29709 = state_29702;
(statearr_29709[(8)] = inst_29688__$1);

return statearr_29709;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29702__$1,(8),jobs,inst_29691);
} else {
if((state_val_29703 === (7))){
var inst_29698 = (state_29702[(2)]);
var state_29702__$1 = state_29702;
var statearr_29710_29822 = state_29702__$1;
(statearr_29710_29822[(2)] = inst_29698);

(statearr_29710_29822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29703 === (8))){
var inst_29688 = (state_29702[(8)]);
var inst_29693 = (state_29702[(2)]);
var state_29702__$1 = (function (){var statearr_29711 = state_29702;
(statearr_29711[(9)] = inst_29693);

return statearr_29711;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29702__$1,(9),results,inst_29688);
} else {
if((state_val_29703 === (9))){
var inst_29695 = (state_29702[(2)]);
var state_29702__$1 = (function (){var statearr_29712 = state_29702;
(statearr_29712[(10)] = inst_29695);

return statearr_29712;
})();
var statearr_29713_29823 = state_29702__$1;
(statearr_29713_29823[(2)] = null);

(statearr_29713_29823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___29817,jobs,results,process,async))
;
return ((function (switch__29105__auto__,c__29219__auto___29817,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0 = (function (){
var statearr_29717 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29717[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__);

(statearr_29717[(1)] = (1));

return statearr_29717;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1 = (function (state_29702){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e29718){if((e29718 instanceof Object)){
var ex__29109__auto__ = e29718;
var statearr_29719_29824 = state_29702;
(statearr_29719_29824[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29702);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29718;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29825 = state_29702;
state_29702 = G__29825;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = function(state_29702){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1.call(this,state_29702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___29817,jobs,results,process,async))
})();
var state__29221__auto__ = (function (){var statearr_29720 = f__29220__auto__.call(null);
(statearr_29720[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___29817);

return statearr_29720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___29817,jobs,results,process,async))
);


var c__29219__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto__,jobs,results,process,async){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto__,jobs,results,process,async){
return (function (state_29758){
var state_val_29759 = (state_29758[(1)]);
if((state_val_29759 === (7))){
var inst_29754 = (state_29758[(2)]);
var state_29758__$1 = state_29758;
var statearr_29760_29826 = state_29758__$1;
(statearr_29760_29826[(2)] = inst_29754);

(statearr_29760_29826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (20))){
var state_29758__$1 = state_29758;
var statearr_29761_29827 = state_29758__$1;
(statearr_29761_29827[(2)] = null);

(statearr_29761_29827[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (1))){
var state_29758__$1 = state_29758;
var statearr_29762_29828 = state_29758__$1;
(statearr_29762_29828[(2)] = null);

(statearr_29762_29828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (4))){
var inst_29723 = (state_29758[(7)]);
var inst_29723__$1 = (state_29758[(2)]);
var inst_29724 = (inst_29723__$1 == null);
var state_29758__$1 = (function (){var statearr_29763 = state_29758;
(statearr_29763[(7)] = inst_29723__$1);

return statearr_29763;
})();
if(cljs.core.truth_(inst_29724)){
var statearr_29764_29829 = state_29758__$1;
(statearr_29764_29829[(1)] = (5));

} else {
var statearr_29765_29830 = state_29758__$1;
(statearr_29765_29830[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (15))){
var inst_29736 = (state_29758[(8)]);
var state_29758__$1 = state_29758;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29758__$1,(18),to,inst_29736);
} else {
if((state_val_29759 === (21))){
var inst_29749 = (state_29758[(2)]);
var state_29758__$1 = state_29758;
var statearr_29766_29831 = state_29758__$1;
(statearr_29766_29831[(2)] = inst_29749);

(statearr_29766_29831[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (13))){
var inst_29751 = (state_29758[(2)]);
var state_29758__$1 = (function (){var statearr_29767 = state_29758;
(statearr_29767[(9)] = inst_29751);

return statearr_29767;
})();
var statearr_29768_29832 = state_29758__$1;
(statearr_29768_29832[(2)] = null);

(statearr_29768_29832[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (6))){
var inst_29723 = (state_29758[(7)]);
var state_29758__$1 = state_29758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29758__$1,(11),inst_29723);
} else {
if((state_val_29759 === (17))){
var inst_29744 = (state_29758[(2)]);
var state_29758__$1 = state_29758;
if(cljs.core.truth_(inst_29744)){
var statearr_29769_29833 = state_29758__$1;
(statearr_29769_29833[(1)] = (19));

} else {
var statearr_29770_29834 = state_29758__$1;
(statearr_29770_29834[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (3))){
var inst_29756 = (state_29758[(2)]);
var state_29758__$1 = state_29758;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29758__$1,inst_29756);
} else {
if((state_val_29759 === (12))){
var inst_29733 = (state_29758[(10)]);
var state_29758__$1 = state_29758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29758__$1,(14),inst_29733);
} else {
if((state_val_29759 === (2))){
var state_29758__$1 = state_29758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29758__$1,(4),results);
} else {
if((state_val_29759 === (19))){
var state_29758__$1 = state_29758;
var statearr_29771_29835 = state_29758__$1;
(statearr_29771_29835[(2)] = null);

(statearr_29771_29835[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (11))){
var inst_29733 = (state_29758[(2)]);
var state_29758__$1 = (function (){var statearr_29772 = state_29758;
(statearr_29772[(10)] = inst_29733);

return statearr_29772;
})();
var statearr_29773_29836 = state_29758__$1;
(statearr_29773_29836[(2)] = null);

(statearr_29773_29836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (9))){
var state_29758__$1 = state_29758;
var statearr_29774_29837 = state_29758__$1;
(statearr_29774_29837[(2)] = null);

(statearr_29774_29837[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (5))){
var state_29758__$1 = state_29758;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29775_29838 = state_29758__$1;
(statearr_29775_29838[(1)] = (8));

} else {
var statearr_29776_29839 = state_29758__$1;
(statearr_29776_29839[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (14))){
var inst_29736 = (state_29758[(8)]);
var inst_29738 = (state_29758[(11)]);
var inst_29736__$1 = (state_29758[(2)]);
var inst_29737 = (inst_29736__$1 == null);
var inst_29738__$1 = cljs.core.not.call(null,inst_29737);
var state_29758__$1 = (function (){var statearr_29777 = state_29758;
(statearr_29777[(8)] = inst_29736__$1);

(statearr_29777[(11)] = inst_29738__$1);

return statearr_29777;
})();
if(inst_29738__$1){
var statearr_29778_29840 = state_29758__$1;
(statearr_29778_29840[(1)] = (15));

} else {
var statearr_29779_29841 = state_29758__$1;
(statearr_29779_29841[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (16))){
var inst_29738 = (state_29758[(11)]);
var state_29758__$1 = state_29758;
var statearr_29780_29842 = state_29758__$1;
(statearr_29780_29842[(2)] = inst_29738);

(statearr_29780_29842[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (10))){
var inst_29730 = (state_29758[(2)]);
var state_29758__$1 = state_29758;
var statearr_29781_29843 = state_29758__$1;
(statearr_29781_29843[(2)] = inst_29730);

(statearr_29781_29843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (18))){
var inst_29741 = (state_29758[(2)]);
var state_29758__$1 = state_29758;
var statearr_29782_29844 = state_29758__$1;
(statearr_29782_29844[(2)] = inst_29741);

(statearr_29782_29844[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29759 === (8))){
var inst_29727 = cljs.core.async.close_BANG_.call(null,to);
var state_29758__$1 = state_29758;
var statearr_29783_29845 = state_29758__$1;
(statearr_29783_29845[(2)] = inst_29727);

(statearr_29783_29845[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto__,jobs,results,process,async))
;
return ((function (switch__29105__auto__,c__29219__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0 = (function (){
var statearr_29787 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29787[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__);

(statearr_29787[(1)] = (1));

return statearr_29787;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1 = (function (state_29758){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29758);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e29788){if((e29788 instanceof Object)){
var ex__29109__auto__ = e29788;
var statearr_29789_29846 = state_29758;
(statearr_29789_29846[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29758);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29788;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29847 = state_29758;
state_29758 = G__29847;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__ = function(state_29758){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1.call(this,state_29758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto__,jobs,results,process,async))
})();
var state__29221__auto__ = (function (){var statearr_29790 = f__29220__auto__.call(null);
(statearr_29790[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto__);

return statearr_29790;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto__,jobs,results,process,async))
);

return c__29219__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args29848 = [];
var len__27753__auto___29851 = arguments.length;
var i__27754__auto___29852 = (0);
while(true){
if((i__27754__auto___29852 < len__27753__auto___29851)){
args29848.push((arguments[i__27754__auto___29852]));

var G__29853 = (i__27754__auto___29852 + (1));
i__27754__auto___29852 = G__29853;
continue;
} else {
}
break;
}

var G__29850 = args29848.length;
switch (G__29850) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29848.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args29855 = [];
var len__27753__auto___29858 = arguments.length;
var i__27754__auto___29859 = (0);
while(true){
if((i__27754__auto___29859 < len__27753__auto___29858)){
args29855.push((arguments[i__27754__auto___29859]));

var G__29860 = (i__27754__auto___29859 + (1));
i__27754__auto___29859 = G__29860;
continue;
} else {
}
break;
}

var G__29857 = args29855.length;
switch (G__29857) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29855.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args29862 = [];
var len__27753__auto___29915 = arguments.length;
var i__27754__auto___29916 = (0);
while(true){
if((i__27754__auto___29916 < len__27753__auto___29915)){
args29862.push((arguments[i__27754__auto___29916]));

var G__29917 = (i__27754__auto___29916 + (1));
i__27754__auto___29916 = G__29917;
continue;
} else {
}
break;
}

var G__29864 = args29862.length;
switch (G__29864) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29862.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__29219__auto___29919 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___29919,tc,fc){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___29919,tc,fc){
return (function (state_29890){
var state_val_29891 = (state_29890[(1)]);
if((state_val_29891 === (7))){
var inst_29886 = (state_29890[(2)]);
var state_29890__$1 = state_29890;
var statearr_29892_29920 = state_29890__$1;
(statearr_29892_29920[(2)] = inst_29886);

(statearr_29892_29920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (1))){
var state_29890__$1 = state_29890;
var statearr_29893_29921 = state_29890__$1;
(statearr_29893_29921[(2)] = null);

(statearr_29893_29921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (4))){
var inst_29867 = (state_29890[(7)]);
var inst_29867__$1 = (state_29890[(2)]);
var inst_29868 = (inst_29867__$1 == null);
var state_29890__$1 = (function (){var statearr_29894 = state_29890;
(statearr_29894[(7)] = inst_29867__$1);

return statearr_29894;
})();
if(cljs.core.truth_(inst_29868)){
var statearr_29895_29922 = state_29890__$1;
(statearr_29895_29922[(1)] = (5));

} else {
var statearr_29896_29923 = state_29890__$1;
(statearr_29896_29923[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (13))){
var state_29890__$1 = state_29890;
var statearr_29897_29924 = state_29890__$1;
(statearr_29897_29924[(2)] = null);

(statearr_29897_29924[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (6))){
var inst_29867 = (state_29890[(7)]);
var inst_29873 = p.call(null,inst_29867);
var state_29890__$1 = state_29890;
if(cljs.core.truth_(inst_29873)){
var statearr_29898_29925 = state_29890__$1;
(statearr_29898_29925[(1)] = (9));

} else {
var statearr_29899_29926 = state_29890__$1;
(statearr_29899_29926[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (3))){
var inst_29888 = (state_29890[(2)]);
var state_29890__$1 = state_29890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29890__$1,inst_29888);
} else {
if((state_val_29891 === (12))){
var state_29890__$1 = state_29890;
var statearr_29900_29927 = state_29890__$1;
(statearr_29900_29927[(2)] = null);

(statearr_29900_29927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (2))){
var state_29890__$1 = state_29890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29890__$1,(4),ch);
} else {
if((state_val_29891 === (11))){
var inst_29867 = (state_29890[(7)]);
var inst_29877 = (state_29890[(2)]);
var state_29890__$1 = state_29890;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29890__$1,(8),inst_29877,inst_29867);
} else {
if((state_val_29891 === (9))){
var state_29890__$1 = state_29890;
var statearr_29901_29928 = state_29890__$1;
(statearr_29901_29928[(2)] = tc);

(statearr_29901_29928[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (5))){
var inst_29870 = cljs.core.async.close_BANG_.call(null,tc);
var inst_29871 = cljs.core.async.close_BANG_.call(null,fc);
var state_29890__$1 = (function (){var statearr_29902 = state_29890;
(statearr_29902[(8)] = inst_29870);

return statearr_29902;
})();
var statearr_29903_29929 = state_29890__$1;
(statearr_29903_29929[(2)] = inst_29871);

(statearr_29903_29929[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (14))){
var inst_29884 = (state_29890[(2)]);
var state_29890__$1 = state_29890;
var statearr_29904_29930 = state_29890__$1;
(statearr_29904_29930[(2)] = inst_29884);

(statearr_29904_29930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (10))){
var state_29890__$1 = state_29890;
var statearr_29905_29931 = state_29890__$1;
(statearr_29905_29931[(2)] = fc);

(statearr_29905_29931[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29891 === (8))){
var inst_29879 = (state_29890[(2)]);
var state_29890__$1 = state_29890;
if(cljs.core.truth_(inst_29879)){
var statearr_29906_29932 = state_29890__$1;
(statearr_29906_29932[(1)] = (12));

} else {
var statearr_29907_29933 = state_29890__$1;
(statearr_29907_29933[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___29919,tc,fc))
;
return ((function (switch__29105__auto__,c__29219__auto___29919,tc,fc){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_29911 = [null,null,null,null,null,null,null,null,null];
(statearr_29911[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_29911[(1)] = (1));

return statearr_29911;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_29890){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e29912){if((e29912 instanceof Object)){
var ex__29109__auto__ = e29912;
var statearr_29913_29934 = state_29890;
(statearr_29913_29934[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29890);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29935 = state_29890;
state_29890 = G__29935;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_29890){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_29890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___29919,tc,fc))
})();
var state__29221__auto__ = (function (){var statearr_29914 = f__29220__auto__.call(null);
(statearr_29914[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___29919);

return statearr_29914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___29919,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29219__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto__){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto__){
return (function (state_29999){
var state_val_30000 = (state_29999[(1)]);
if((state_val_30000 === (7))){
var inst_29995 = (state_29999[(2)]);
var state_29999__$1 = state_29999;
var statearr_30001_30022 = state_29999__$1;
(statearr_30001_30022[(2)] = inst_29995);

(statearr_30001_30022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (1))){
var inst_29979 = init;
var state_29999__$1 = (function (){var statearr_30002 = state_29999;
(statearr_30002[(7)] = inst_29979);

return statearr_30002;
})();
var statearr_30003_30023 = state_29999__$1;
(statearr_30003_30023[(2)] = null);

(statearr_30003_30023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (4))){
var inst_29982 = (state_29999[(8)]);
var inst_29982__$1 = (state_29999[(2)]);
var inst_29983 = (inst_29982__$1 == null);
var state_29999__$1 = (function (){var statearr_30004 = state_29999;
(statearr_30004[(8)] = inst_29982__$1);

return statearr_30004;
})();
if(cljs.core.truth_(inst_29983)){
var statearr_30005_30024 = state_29999__$1;
(statearr_30005_30024[(1)] = (5));

} else {
var statearr_30006_30025 = state_29999__$1;
(statearr_30006_30025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (6))){
var inst_29982 = (state_29999[(8)]);
var inst_29986 = (state_29999[(9)]);
var inst_29979 = (state_29999[(7)]);
var inst_29986__$1 = f.call(null,inst_29979,inst_29982);
var inst_29987 = cljs.core.reduced_QMARK_.call(null,inst_29986__$1);
var state_29999__$1 = (function (){var statearr_30007 = state_29999;
(statearr_30007[(9)] = inst_29986__$1);

return statearr_30007;
})();
if(inst_29987){
var statearr_30008_30026 = state_29999__$1;
(statearr_30008_30026[(1)] = (8));

} else {
var statearr_30009_30027 = state_29999__$1;
(statearr_30009_30027[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (3))){
var inst_29997 = (state_29999[(2)]);
var state_29999__$1 = state_29999;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29999__$1,inst_29997);
} else {
if((state_val_30000 === (2))){
var state_29999__$1 = state_29999;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29999__$1,(4),ch);
} else {
if((state_val_30000 === (9))){
var inst_29986 = (state_29999[(9)]);
var inst_29979 = inst_29986;
var state_29999__$1 = (function (){var statearr_30010 = state_29999;
(statearr_30010[(7)] = inst_29979);

return statearr_30010;
})();
var statearr_30011_30028 = state_29999__$1;
(statearr_30011_30028[(2)] = null);

(statearr_30011_30028[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (5))){
var inst_29979 = (state_29999[(7)]);
var state_29999__$1 = state_29999;
var statearr_30012_30029 = state_29999__$1;
(statearr_30012_30029[(2)] = inst_29979);

(statearr_30012_30029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (10))){
var inst_29993 = (state_29999[(2)]);
var state_29999__$1 = state_29999;
var statearr_30013_30030 = state_29999__$1;
(statearr_30013_30030[(2)] = inst_29993);

(statearr_30013_30030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30000 === (8))){
var inst_29986 = (state_29999[(9)]);
var inst_29989 = cljs.core.deref.call(null,inst_29986);
var state_29999__$1 = state_29999;
var statearr_30014_30031 = state_29999__$1;
(statearr_30014_30031[(2)] = inst_29989);

(statearr_30014_30031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto__))
;
return ((function (switch__29105__auto__,c__29219__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__29106__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29106__auto____0 = (function (){
var statearr_30018 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30018[(0)] = cljs$core$async$reduce_$_state_machine__29106__auto__);

(statearr_30018[(1)] = (1));

return statearr_30018;
});
var cljs$core$async$reduce_$_state_machine__29106__auto____1 = (function (state_29999){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_29999);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e30019){if((e30019 instanceof Object)){
var ex__29109__auto__ = e30019;
var statearr_30020_30032 = state_29999;
(statearr_30020_30032[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29999);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30019;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30033 = state_29999;
state_29999 = G__30033;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29106__auto__ = function(state_29999){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29106__auto____1.call(this,state_29999);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29106__auto____0;
cljs$core$async$reduce_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29106__auto____1;
return cljs$core$async$reduce_$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto__))
})();
var state__29221__auto__ = (function (){var statearr_30021 = f__29220__auto__.call(null);
(statearr_30021[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto__);

return statearr_30021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto__))
);

return c__29219__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30034 = [];
var len__27753__auto___30086 = arguments.length;
var i__27754__auto___30087 = (0);
while(true){
if((i__27754__auto___30087 < len__27753__auto___30086)){
args30034.push((arguments[i__27754__auto___30087]));

var G__30088 = (i__27754__auto___30087 + (1));
i__27754__auto___30087 = G__30088;
continue;
} else {
}
break;
}

var G__30036 = args30034.length;
switch (G__30036) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30034.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29219__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto__){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto__){
return (function (state_30061){
var state_val_30062 = (state_30061[(1)]);
if((state_val_30062 === (7))){
var inst_30043 = (state_30061[(2)]);
var state_30061__$1 = state_30061;
var statearr_30063_30090 = state_30061__$1;
(statearr_30063_30090[(2)] = inst_30043);

(statearr_30063_30090[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (1))){
var inst_30037 = cljs.core.seq.call(null,coll);
var inst_30038 = inst_30037;
var state_30061__$1 = (function (){var statearr_30064 = state_30061;
(statearr_30064[(7)] = inst_30038);

return statearr_30064;
})();
var statearr_30065_30091 = state_30061__$1;
(statearr_30065_30091[(2)] = null);

(statearr_30065_30091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (4))){
var inst_30038 = (state_30061[(7)]);
var inst_30041 = cljs.core.first.call(null,inst_30038);
var state_30061__$1 = state_30061;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30061__$1,(7),ch,inst_30041);
} else {
if((state_val_30062 === (13))){
var inst_30055 = (state_30061[(2)]);
var state_30061__$1 = state_30061;
var statearr_30066_30092 = state_30061__$1;
(statearr_30066_30092[(2)] = inst_30055);

(statearr_30066_30092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (6))){
var inst_30046 = (state_30061[(2)]);
var state_30061__$1 = state_30061;
if(cljs.core.truth_(inst_30046)){
var statearr_30067_30093 = state_30061__$1;
(statearr_30067_30093[(1)] = (8));

} else {
var statearr_30068_30094 = state_30061__$1;
(statearr_30068_30094[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (3))){
var inst_30059 = (state_30061[(2)]);
var state_30061__$1 = state_30061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30061__$1,inst_30059);
} else {
if((state_val_30062 === (12))){
var state_30061__$1 = state_30061;
var statearr_30069_30095 = state_30061__$1;
(statearr_30069_30095[(2)] = null);

(statearr_30069_30095[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (2))){
var inst_30038 = (state_30061[(7)]);
var state_30061__$1 = state_30061;
if(cljs.core.truth_(inst_30038)){
var statearr_30070_30096 = state_30061__$1;
(statearr_30070_30096[(1)] = (4));

} else {
var statearr_30071_30097 = state_30061__$1;
(statearr_30071_30097[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (11))){
var inst_30052 = cljs.core.async.close_BANG_.call(null,ch);
var state_30061__$1 = state_30061;
var statearr_30072_30098 = state_30061__$1;
(statearr_30072_30098[(2)] = inst_30052);

(statearr_30072_30098[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (9))){
var state_30061__$1 = state_30061;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30073_30099 = state_30061__$1;
(statearr_30073_30099[(1)] = (11));

} else {
var statearr_30074_30100 = state_30061__$1;
(statearr_30074_30100[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (5))){
var inst_30038 = (state_30061[(7)]);
var state_30061__$1 = state_30061;
var statearr_30075_30101 = state_30061__$1;
(statearr_30075_30101[(2)] = inst_30038);

(statearr_30075_30101[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (10))){
var inst_30057 = (state_30061[(2)]);
var state_30061__$1 = state_30061;
var statearr_30076_30102 = state_30061__$1;
(statearr_30076_30102[(2)] = inst_30057);

(statearr_30076_30102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (8))){
var inst_30038 = (state_30061[(7)]);
var inst_30048 = cljs.core.next.call(null,inst_30038);
var inst_30038__$1 = inst_30048;
var state_30061__$1 = (function (){var statearr_30077 = state_30061;
(statearr_30077[(7)] = inst_30038__$1);

return statearr_30077;
})();
var statearr_30078_30103 = state_30061__$1;
(statearr_30078_30103[(2)] = null);

(statearr_30078_30103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto__))
;
return ((function (switch__29105__auto__,c__29219__auto__){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_30082 = [null,null,null,null,null,null,null,null];
(statearr_30082[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_30082[(1)] = (1));

return statearr_30082;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_30061){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_30061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e30083){if((e30083 instanceof Object)){
var ex__29109__auto__ = e30083;
var statearr_30084_30104 = state_30061;
(statearr_30084_30104[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30083;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30105 = state_30061;
state_30061 = G__30105;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_30061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_30061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto__))
})();
var state__29221__auto__ = (function (){var statearr_30085 = f__29220__auto__.call(null);
(statearr_30085[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto__);

return statearr_30085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto__))
);

return c__29219__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27283__auto__ = (((_ == null))?null:_);
var m__27284__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,_);
} else {
var m__27284__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27284__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m,ch);
} else {
var m__27284__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m);
} else {
var m__27284__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30331 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30331 = (function (mult,ch,cs,meta30332){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30332 = meta30332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30333,meta30332__$1){
var self__ = this;
var _30333__$1 = this;
return (new cljs.core.async.t_cljs$core$async30331(self__.mult,self__.ch,self__.cs,meta30332__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30333){
var self__ = this;
var _30333__$1 = this;
return self__.meta30332;
});})(cs))
;

cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30331.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30331.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30332","meta30332",1508635366,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async30331.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30331";

cljs.core.async.t_cljs$core$async30331.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async30331");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async30331 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async30331(mult__$1,ch__$1,cs__$1,meta30332){
return (new cljs.core.async.t_cljs$core$async30331(mult__$1,ch__$1,cs__$1,meta30332));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async30331(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__29219__auto___30556 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___30556,cs,m,dchan,dctr,done){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___30556,cs,m,dchan,dctr,done){
return (function (state_30468){
var state_val_30469 = (state_30468[(1)]);
if((state_val_30469 === (7))){
var inst_30464 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30470_30557 = state_30468__$1;
(statearr_30470_30557[(2)] = inst_30464);

(statearr_30470_30557[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (20))){
var inst_30367 = (state_30468[(7)]);
var inst_30379 = cljs.core.first.call(null,inst_30367);
var inst_30380 = cljs.core.nth.call(null,inst_30379,(0),null);
var inst_30381 = cljs.core.nth.call(null,inst_30379,(1),null);
var state_30468__$1 = (function (){var statearr_30471 = state_30468;
(statearr_30471[(8)] = inst_30380);

return statearr_30471;
})();
if(cljs.core.truth_(inst_30381)){
var statearr_30472_30558 = state_30468__$1;
(statearr_30472_30558[(1)] = (22));

} else {
var statearr_30473_30559 = state_30468__$1;
(statearr_30473_30559[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (27))){
var inst_30416 = (state_30468[(9)]);
var inst_30409 = (state_30468[(10)]);
var inst_30336 = (state_30468[(11)]);
var inst_30411 = (state_30468[(12)]);
var inst_30416__$1 = cljs.core._nth.call(null,inst_30409,inst_30411);
var inst_30417 = cljs.core.async.put_BANG_.call(null,inst_30416__$1,inst_30336,done);
var state_30468__$1 = (function (){var statearr_30474 = state_30468;
(statearr_30474[(9)] = inst_30416__$1);

return statearr_30474;
})();
if(cljs.core.truth_(inst_30417)){
var statearr_30475_30560 = state_30468__$1;
(statearr_30475_30560[(1)] = (30));

} else {
var statearr_30476_30561 = state_30468__$1;
(statearr_30476_30561[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (1))){
var state_30468__$1 = state_30468;
var statearr_30477_30562 = state_30468__$1;
(statearr_30477_30562[(2)] = null);

(statearr_30477_30562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (24))){
var inst_30367 = (state_30468[(7)]);
var inst_30386 = (state_30468[(2)]);
var inst_30387 = cljs.core.next.call(null,inst_30367);
var inst_30345 = inst_30387;
var inst_30346 = null;
var inst_30347 = (0);
var inst_30348 = (0);
var state_30468__$1 = (function (){var statearr_30478 = state_30468;
(statearr_30478[(13)] = inst_30348);

(statearr_30478[(14)] = inst_30345);

(statearr_30478[(15)] = inst_30346);

(statearr_30478[(16)] = inst_30386);

(statearr_30478[(17)] = inst_30347);

return statearr_30478;
})();
var statearr_30479_30563 = state_30468__$1;
(statearr_30479_30563[(2)] = null);

(statearr_30479_30563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (39))){
var state_30468__$1 = state_30468;
var statearr_30483_30564 = state_30468__$1;
(statearr_30483_30564[(2)] = null);

(statearr_30483_30564[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (4))){
var inst_30336 = (state_30468[(11)]);
var inst_30336__$1 = (state_30468[(2)]);
var inst_30337 = (inst_30336__$1 == null);
var state_30468__$1 = (function (){var statearr_30484 = state_30468;
(statearr_30484[(11)] = inst_30336__$1);

return statearr_30484;
})();
if(cljs.core.truth_(inst_30337)){
var statearr_30485_30565 = state_30468__$1;
(statearr_30485_30565[(1)] = (5));

} else {
var statearr_30486_30566 = state_30468__$1;
(statearr_30486_30566[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (15))){
var inst_30348 = (state_30468[(13)]);
var inst_30345 = (state_30468[(14)]);
var inst_30346 = (state_30468[(15)]);
var inst_30347 = (state_30468[(17)]);
var inst_30363 = (state_30468[(2)]);
var inst_30364 = (inst_30348 + (1));
var tmp30480 = inst_30345;
var tmp30481 = inst_30346;
var tmp30482 = inst_30347;
var inst_30345__$1 = tmp30480;
var inst_30346__$1 = tmp30481;
var inst_30347__$1 = tmp30482;
var inst_30348__$1 = inst_30364;
var state_30468__$1 = (function (){var statearr_30487 = state_30468;
(statearr_30487[(13)] = inst_30348__$1);

(statearr_30487[(14)] = inst_30345__$1);

(statearr_30487[(15)] = inst_30346__$1);

(statearr_30487[(18)] = inst_30363);

(statearr_30487[(17)] = inst_30347__$1);

return statearr_30487;
})();
var statearr_30488_30567 = state_30468__$1;
(statearr_30488_30567[(2)] = null);

(statearr_30488_30567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (21))){
var inst_30390 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30492_30568 = state_30468__$1;
(statearr_30492_30568[(2)] = inst_30390);

(statearr_30492_30568[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (31))){
var inst_30416 = (state_30468[(9)]);
var inst_30420 = done.call(null,null);
var inst_30421 = cljs.core.async.untap_STAR_.call(null,m,inst_30416);
var state_30468__$1 = (function (){var statearr_30493 = state_30468;
(statearr_30493[(19)] = inst_30420);

return statearr_30493;
})();
var statearr_30494_30569 = state_30468__$1;
(statearr_30494_30569[(2)] = inst_30421);

(statearr_30494_30569[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (32))){
var inst_30409 = (state_30468[(10)]);
var inst_30408 = (state_30468[(20)]);
var inst_30411 = (state_30468[(12)]);
var inst_30410 = (state_30468[(21)]);
var inst_30423 = (state_30468[(2)]);
var inst_30424 = (inst_30411 + (1));
var tmp30489 = inst_30409;
var tmp30490 = inst_30408;
var tmp30491 = inst_30410;
var inst_30408__$1 = tmp30490;
var inst_30409__$1 = tmp30489;
var inst_30410__$1 = tmp30491;
var inst_30411__$1 = inst_30424;
var state_30468__$1 = (function (){var statearr_30495 = state_30468;
(statearr_30495[(10)] = inst_30409__$1);

(statearr_30495[(22)] = inst_30423);

(statearr_30495[(20)] = inst_30408__$1);

(statearr_30495[(12)] = inst_30411__$1);

(statearr_30495[(21)] = inst_30410__$1);

return statearr_30495;
})();
var statearr_30496_30570 = state_30468__$1;
(statearr_30496_30570[(2)] = null);

(statearr_30496_30570[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (40))){
var inst_30436 = (state_30468[(23)]);
var inst_30440 = done.call(null,null);
var inst_30441 = cljs.core.async.untap_STAR_.call(null,m,inst_30436);
var state_30468__$1 = (function (){var statearr_30497 = state_30468;
(statearr_30497[(24)] = inst_30440);

return statearr_30497;
})();
var statearr_30498_30571 = state_30468__$1;
(statearr_30498_30571[(2)] = inst_30441);

(statearr_30498_30571[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (33))){
var inst_30427 = (state_30468[(25)]);
var inst_30429 = cljs.core.chunked_seq_QMARK_.call(null,inst_30427);
var state_30468__$1 = state_30468;
if(inst_30429){
var statearr_30499_30572 = state_30468__$1;
(statearr_30499_30572[(1)] = (36));

} else {
var statearr_30500_30573 = state_30468__$1;
(statearr_30500_30573[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (13))){
var inst_30357 = (state_30468[(26)]);
var inst_30360 = cljs.core.async.close_BANG_.call(null,inst_30357);
var state_30468__$1 = state_30468;
var statearr_30501_30574 = state_30468__$1;
(statearr_30501_30574[(2)] = inst_30360);

(statearr_30501_30574[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (22))){
var inst_30380 = (state_30468[(8)]);
var inst_30383 = cljs.core.async.close_BANG_.call(null,inst_30380);
var state_30468__$1 = state_30468;
var statearr_30502_30575 = state_30468__$1;
(statearr_30502_30575[(2)] = inst_30383);

(statearr_30502_30575[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (36))){
var inst_30427 = (state_30468[(25)]);
var inst_30431 = cljs.core.chunk_first.call(null,inst_30427);
var inst_30432 = cljs.core.chunk_rest.call(null,inst_30427);
var inst_30433 = cljs.core.count.call(null,inst_30431);
var inst_30408 = inst_30432;
var inst_30409 = inst_30431;
var inst_30410 = inst_30433;
var inst_30411 = (0);
var state_30468__$1 = (function (){var statearr_30503 = state_30468;
(statearr_30503[(10)] = inst_30409);

(statearr_30503[(20)] = inst_30408);

(statearr_30503[(12)] = inst_30411);

(statearr_30503[(21)] = inst_30410);

return statearr_30503;
})();
var statearr_30504_30576 = state_30468__$1;
(statearr_30504_30576[(2)] = null);

(statearr_30504_30576[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (41))){
var inst_30427 = (state_30468[(25)]);
var inst_30443 = (state_30468[(2)]);
var inst_30444 = cljs.core.next.call(null,inst_30427);
var inst_30408 = inst_30444;
var inst_30409 = null;
var inst_30410 = (0);
var inst_30411 = (0);
var state_30468__$1 = (function (){var statearr_30505 = state_30468;
(statearr_30505[(10)] = inst_30409);

(statearr_30505[(20)] = inst_30408);

(statearr_30505[(12)] = inst_30411);

(statearr_30505[(27)] = inst_30443);

(statearr_30505[(21)] = inst_30410);

return statearr_30505;
})();
var statearr_30506_30577 = state_30468__$1;
(statearr_30506_30577[(2)] = null);

(statearr_30506_30577[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (43))){
var state_30468__$1 = state_30468;
var statearr_30507_30578 = state_30468__$1;
(statearr_30507_30578[(2)] = null);

(statearr_30507_30578[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (29))){
var inst_30452 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30508_30579 = state_30468__$1;
(statearr_30508_30579[(2)] = inst_30452);

(statearr_30508_30579[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (44))){
var inst_30461 = (state_30468[(2)]);
var state_30468__$1 = (function (){var statearr_30509 = state_30468;
(statearr_30509[(28)] = inst_30461);

return statearr_30509;
})();
var statearr_30510_30580 = state_30468__$1;
(statearr_30510_30580[(2)] = null);

(statearr_30510_30580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (6))){
var inst_30400 = (state_30468[(29)]);
var inst_30399 = cljs.core.deref.call(null,cs);
var inst_30400__$1 = cljs.core.keys.call(null,inst_30399);
var inst_30401 = cljs.core.count.call(null,inst_30400__$1);
var inst_30402 = cljs.core.reset_BANG_.call(null,dctr,inst_30401);
var inst_30407 = cljs.core.seq.call(null,inst_30400__$1);
var inst_30408 = inst_30407;
var inst_30409 = null;
var inst_30410 = (0);
var inst_30411 = (0);
var state_30468__$1 = (function (){var statearr_30511 = state_30468;
(statearr_30511[(10)] = inst_30409);

(statearr_30511[(29)] = inst_30400__$1);

(statearr_30511[(20)] = inst_30408);

(statearr_30511[(12)] = inst_30411);

(statearr_30511[(21)] = inst_30410);

(statearr_30511[(30)] = inst_30402);

return statearr_30511;
})();
var statearr_30512_30581 = state_30468__$1;
(statearr_30512_30581[(2)] = null);

(statearr_30512_30581[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (28))){
var inst_30408 = (state_30468[(20)]);
var inst_30427 = (state_30468[(25)]);
var inst_30427__$1 = cljs.core.seq.call(null,inst_30408);
var state_30468__$1 = (function (){var statearr_30513 = state_30468;
(statearr_30513[(25)] = inst_30427__$1);

return statearr_30513;
})();
if(inst_30427__$1){
var statearr_30514_30582 = state_30468__$1;
(statearr_30514_30582[(1)] = (33));

} else {
var statearr_30515_30583 = state_30468__$1;
(statearr_30515_30583[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (25))){
var inst_30411 = (state_30468[(12)]);
var inst_30410 = (state_30468[(21)]);
var inst_30413 = (inst_30411 < inst_30410);
var inst_30414 = inst_30413;
var state_30468__$1 = state_30468;
if(cljs.core.truth_(inst_30414)){
var statearr_30516_30584 = state_30468__$1;
(statearr_30516_30584[(1)] = (27));

} else {
var statearr_30517_30585 = state_30468__$1;
(statearr_30517_30585[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (34))){
var state_30468__$1 = state_30468;
var statearr_30518_30586 = state_30468__$1;
(statearr_30518_30586[(2)] = null);

(statearr_30518_30586[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (17))){
var state_30468__$1 = state_30468;
var statearr_30519_30587 = state_30468__$1;
(statearr_30519_30587[(2)] = null);

(statearr_30519_30587[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (3))){
var inst_30466 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30468__$1,inst_30466);
} else {
if((state_val_30469 === (12))){
var inst_30395 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30520_30588 = state_30468__$1;
(statearr_30520_30588[(2)] = inst_30395);

(statearr_30520_30588[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (2))){
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30468__$1,(4),ch);
} else {
if((state_val_30469 === (23))){
var state_30468__$1 = state_30468;
var statearr_30521_30589 = state_30468__$1;
(statearr_30521_30589[(2)] = null);

(statearr_30521_30589[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (35))){
var inst_30450 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30522_30590 = state_30468__$1;
(statearr_30522_30590[(2)] = inst_30450);

(statearr_30522_30590[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (19))){
var inst_30367 = (state_30468[(7)]);
var inst_30371 = cljs.core.chunk_first.call(null,inst_30367);
var inst_30372 = cljs.core.chunk_rest.call(null,inst_30367);
var inst_30373 = cljs.core.count.call(null,inst_30371);
var inst_30345 = inst_30372;
var inst_30346 = inst_30371;
var inst_30347 = inst_30373;
var inst_30348 = (0);
var state_30468__$1 = (function (){var statearr_30523 = state_30468;
(statearr_30523[(13)] = inst_30348);

(statearr_30523[(14)] = inst_30345);

(statearr_30523[(15)] = inst_30346);

(statearr_30523[(17)] = inst_30347);

return statearr_30523;
})();
var statearr_30524_30591 = state_30468__$1;
(statearr_30524_30591[(2)] = null);

(statearr_30524_30591[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (11))){
var inst_30345 = (state_30468[(14)]);
var inst_30367 = (state_30468[(7)]);
var inst_30367__$1 = cljs.core.seq.call(null,inst_30345);
var state_30468__$1 = (function (){var statearr_30525 = state_30468;
(statearr_30525[(7)] = inst_30367__$1);

return statearr_30525;
})();
if(inst_30367__$1){
var statearr_30526_30592 = state_30468__$1;
(statearr_30526_30592[(1)] = (16));

} else {
var statearr_30527_30593 = state_30468__$1;
(statearr_30527_30593[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (9))){
var inst_30397 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30528_30594 = state_30468__$1;
(statearr_30528_30594[(2)] = inst_30397);

(statearr_30528_30594[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (5))){
var inst_30343 = cljs.core.deref.call(null,cs);
var inst_30344 = cljs.core.seq.call(null,inst_30343);
var inst_30345 = inst_30344;
var inst_30346 = null;
var inst_30347 = (0);
var inst_30348 = (0);
var state_30468__$1 = (function (){var statearr_30529 = state_30468;
(statearr_30529[(13)] = inst_30348);

(statearr_30529[(14)] = inst_30345);

(statearr_30529[(15)] = inst_30346);

(statearr_30529[(17)] = inst_30347);

return statearr_30529;
})();
var statearr_30530_30595 = state_30468__$1;
(statearr_30530_30595[(2)] = null);

(statearr_30530_30595[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (14))){
var state_30468__$1 = state_30468;
var statearr_30531_30596 = state_30468__$1;
(statearr_30531_30596[(2)] = null);

(statearr_30531_30596[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (45))){
var inst_30458 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30532_30597 = state_30468__$1;
(statearr_30532_30597[(2)] = inst_30458);

(statearr_30532_30597[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (26))){
var inst_30400 = (state_30468[(29)]);
var inst_30454 = (state_30468[(2)]);
var inst_30455 = cljs.core.seq.call(null,inst_30400);
var state_30468__$1 = (function (){var statearr_30533 = state_30468;
(statearr_30533[(31)] = inst_30454);

return statearr_30533;
})();
if(inst_30455){
var statearr_30534_30598 = state_30468__$1;
(statearr_30534_30598[(1)] = (42));

} else {
var statearr_30535_30599 = state_30468__$1;
(statearr_30535_30599[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (16))){
var inst_30367 = (state_30468[(7)]);
var inst_30369 = cljs.core.chunked_seq_QMARK_.call(null,inst_30367);
var state_30468__$1 = state_30468;
if(inst_30369){
var statearr_30536_30600 = state_30468__$1;
(statearr_30536_30600[(1)] = (19));

} else {
var statearr_30537_30601 = state_30468__$1;
(statearr_30537_30601[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (38))){
var inst_30447 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30538_30602 = state_30468__$1;
(statearr_30538_30602[(2)] = inst_30447);

(statearr_30538_30602[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (30))){
var state_30468__$1 = state_30468;
var statearr_30539_30603 = state_30468__$1;
(statearr_30539_30603[(2)] = null);

(statearr_30539_30603[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (10))){
var inst_30348 = (state_30468[(13)]);
var inst_30346 = (state_30468[(15)]);
var inst_30356 = cljs.core._nth.call(null,inst_30346,inst_30348);
var inst_30357 = cljs.core.nth.call(null,inst_30356,(0),null);
var inst_30358 = cljs.core.nth.call(null,inst_30356,(1),null);
var state_30468__$1 = (function (){var statearr_30540 = state_30468;
(statearr_30540[(26)] = inst_30357);

return statearr_30540;
})();
if(cljs.core.truth_(inst_30358)){
var statearr_30541_30604 = state_30468__$1;
(statearr_30541_30604[(1)] = (13));

} else {
var statearr_30542_30605 = state_30468__$1;
(statearr_30542_30605[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (18))){
var inst_30393 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30543_30606 = state_30468__$1;
(statearr_30543_30606[(2)] = inst_30393);

(statearr_30543_30606[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (42))){
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30468__$1,(45),dchan);
} else {
if((state_val_30469 === (37))){
var inst_30436 = (state_30468[(23)]);
var inst_30336 = (state_30468[(11)]);
var inst_30427 = (state_30468[(25)]);
var inst_30436__$1 = cljs.core.first.call(null,inst_30427);
var inst_30437 = cljs.core.async.put_BANG_.call(null,inst_30436__$1,inst_30336,done);
var state_30468__$1 = (function (){var statearr_30544 = state_30468;
(statearr_30544[(23)] = inst_30436__$1);

return statearr_30544;
})();
if(cljs.core.truth_(inst_30437)){
var statearr_30545_30607 = state_30468__$1;
(statearr_30545_30607[(1)] = (39));

} else {
var statearr_30546_30608 = state_30468__$1;
(statearr_30546_30608[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30469 === (8))){
var inst_30348 = (state_30468[(13)]);
var inst_30347 = (state_30468[(17)]);
var inst_30350 = (inst_30348 < inst_30347);
var inst_30351 = inst_30350;
var state_30468__$1 = state_30468;
if(cljs.core.truth_(inst_30351)){
var statearr_30547_30609 = state_30468__$1;
(statearr_30547_30609[(1)] = (10));

} else {
var statearr_30548_30610 = state_30468__$1;
(statearr_30548_30610[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___30556,cs,m,dchan,dctr,done))
;
return ((function (switch__29105__auto__,c__29219__auto___30556,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__29106__auto__ = null;
var cljs$core$async$mult_$_state_machine__29106__auto____0 = (function (){
var statearr_30552 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30552[(0)] = cljs$core$async$mult_$_state_machine__29106__auto__);

(statearr_30552[(1)] = (1));

return statearr_30552;
});
var cljs$core$async$mult_$_state_machine__29106__auto____1 = (function (state_30468){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_30468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e30553){if((e30553 instanceof Object)){
var ex__29109__auto__ = e30553;
var statearr_30554_30611 = state_30468;
(statearr_30554_30611[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30468);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30553;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30612 = state_30468;
state_30468 = G__30612;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29106__auto__ = function(state_30468){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29106__auto____1.call(this,state_30468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29106__auto____0;
cljs$core$async$mult_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29106__auto____1;
return cljs$core$async$mult_$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___30556,cs,m,dchan,dctr,done))
})();
var state__29221__auto__ = (function (){var statearr_30555 = f__29220__auto__.call(null);
(statearr_30555[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___30556);

return statearr_30555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___30556,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args30613 = [];
var len__27753__auto___30616 = arguments.length;
var i__27754__auto___30617 = (0);
while(true){
if((i__27754__auto___30617 < len__27753__auto___30616)){
args30613.push((arguments[i__27754__auto___30617]));

var G__30618 = (i__27754__auto___30617 + (1));
i__27754__auto___30617 = G__30618;
continue;
} else {
}
break;
}

var G__30615 = args30613.length;
switch (G__30615) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30613.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m,ch);
} else {
var m__27284__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m,ch);
} else {
var m__27284__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m);
} else {
var m__27284__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m,state_map);
} else {
var m__27284__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27283__auto__ = (((m == null))?null:m);
var m__27284__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,m,mode);
} else {
var m__27284__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__27760__auto__ = [];
var len__27753__auto___30630 = arguments.length;
var i__27754__auto___30631 = (0);
while(true){
if((i__27754__auto___30631 < len__27753__auto___30630)){
args__27760__auto__.push((arguments[i__27754__auto___30631]));

var G__30632 = (i__27754__auto___30631 + (1));
i__27754__auto___30631 = G__30632;
continue;
} else {
}
break;
}

var argseq__27761__auto__ = ((((3) < args__27760__auto__.length))?(new cljs.core.IndexedSeq(args__27760__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__27761__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__30624){
var map__30625 = p__30624;
var map__30625__$1 = ((((!((map__30625 == null)))?((((map__30625.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30625.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30625):map__30625);
var opts = map__30625__$1;
var statearr_30627_30633 = state;
(statearr_30627_30633[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6728__auto__ = cljs.core.async.do_alts.call(null,((function (map__30625,map__30625__$1,opts){
return (function (val){
var statearr_30628_30634 = state;
(statearr_30628_30634[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__30625,map__30625__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6728__auto__)){
var cb = temp__6728__auto__;
var statearr_30629_30635 = state;
(statearr_30629_30635[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq30620){
var G__30621 = cljs.core.first.call(null,seq30620);
var seq30620__$1 = cljs.core.next.call(null,seq30620);
var G__30622 = cljs.core.first.call(null,seq30620__$1);
var seq30620__$2 = cljs.core.next.call(null,seq30620__$1);
var G__30623 = cljs.core.first.call(null,seq30620__$2);
var seq30620__$3 = cljs.core.next.call(null,seq30620__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30621,G__30622,G__30623,seq30620__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30801 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30801 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta30802){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta30802 = meta30802;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30803,meta30802__$1){
var self__ = this;
var _30803__$1 = this;
return (new cljs.core.async.t_cljs$core$async30801(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta30802__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_30803){
var self__ = this;
var _30803__$1 = this;
return self__.meta30802;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta30802","meta30802",-1787471013,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async30801.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30801.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30801";

cljs.core.async.t_cljs$core$async30801.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async30801");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async30801 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async30801(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30802){
return (new cljs.core.async.t_cljs$core$async30801(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta30802));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async30801(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29219__auto___30966 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___30966,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___30966,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_30903){
var state_val_30904 = (state_30903[(1)]);
if((state_val_30904 === (7))){
var inst_30819 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
var statearr_30905_30967 = state_30903__$1;
(statearr_30905_30967[(2)] = inst_30819);

(statearr_30905_30967[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (20))){
var inst_30831 = (state_30903[(7)]);
var state_30903__$1 = state_30903;
var statearr_30906_30968 = state_30903__$1;
(statearr_30906_30968[(2)] = inst_30831);

(statearr_30906_30968[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (27))){
var state_30903__$1 = state_30903;
var statearr_30907_30969 = state_30903__$1;
(statearr_30907_30969[(2)] = null);

(statearr_30907_30969[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (1))){
var inst_30807 = (state_30903[(8)]);
var inst_30807__$1 = calc_state.call(null);
var inst_30809 = (inst_30807__$1 == null);
var inst_30810 = cljs.core.not.call(null,inst_30809);
var state_30903__$1 = (function (){var statearr_30908 = state_30903;
(statearr_30908[(8)] = inst_30807__$1);

return statearr_30908;
})();
if(inst_30810){
var statearr_30909_30970 = state_30903__$1;
(statearr_30909_30970[(1)] = (2));

} else {
var statearr_30910_30971 = state_30903__$1;
(statearr_30910_30971[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (24))){
var inst_30863 = (state_30903[(9)]);
var inst_30877 = (state_30903[(10)]);
var inst_30854 = (state_30903[(11)]);
var inst_30877__$1 = inst_30854.call(null,inst_30863);
var state_30903__$1 = (function (){var statearr_30911 = state_30903;
(statearr_30911[(10)] = inst_30877__$1);

return statearr_30911;
})();
if(cljs.core.truth_(inst_30877__$1)){
var statearr_30912_30972 = state_30903__$1;
(statearr_30912_30972[(1)] = (29));

} else {
var statearr_30913_30973 = state_30903__$1;
(statearr_30913_30973[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (4))){
var inst_30822 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30822)){
var statearr_30914_30974 = state_30903__$1;
(statearr_30914_30974[(1)] = (8));

} else {
var statearr_30915_30975 = state_30903__$1;
(statearr_30915_30975[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (15))){
var inst_30848 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30848)){
var statearr_30916_30976 = state_30903__$1;
(statearr_30916_30976[(1)] = (19));

} else {
var statearr_30917_30977 = state_30903__$1;
(statearr_30917_30977[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (21))){
var inst_30853 = (state_30903[(12)]);
var inst_30853__$1 = (state_30903[(2)]);
var inst_30854 = cljs.core.get.call(null,inst_30853__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30855 = cljs.core.get.call(null,inst_30853__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30856 = cljs.core.get.call(null,inst_30853__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_30903__$1 = (function (){var statearr_30918 = state_30903;
(statearr_30918[(13)] = inst_30855);

(statearr_30918[(12)] = inst_30853__$1);

(statearr_30918[(11)] = inst_30854);

return statearr_30918;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_30903__$1,(22),inst_30856);
} else {
if((state_val_30904 === (31))){
var inst_30885 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30885)){
var statearr_30919_30978 = state_30903__$1;
(statearr_30919_30978[(1)] = (32));

} else {
var statearr_30920_30979 = state_30903__$1;
(statearr_30920_30979[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (32))){
var inst_30862 = (state_30903[(14)]);
var state_30903__$1 = state_30903;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30903__$1,(35),out,inst_30862);
} else {
if((state_val_30904 === (33))){
var inst_30853 = (state_30903[(12)]);
var inst_30831 = inst_30853;
var state_30903__$1 = (function (){var statearr_30921 = state_30903;
(statearr_30921[(7)] = inst_30831);

return statearr_30921;
})();
var statearr_30922_30980 = state_30903__$1;
(statearr_30922_30980[(2)] = null);

(statearr_30922_30980[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (13))){
var inst_30831 = (state_30903[(7)]);
var inst_30838 = inst_30831.cljs$lang$protocol_mask$partition0$;
var inst_30839 = (inst_30838 & (64));
var inst_30840 = inst_30831.cljs$core$ISeq$;
var inst_30841 = (inst_30839) || (inst_30840);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30841)){
var statearr_30923_30981 = state_30903__$1;
(statearr_30923_30981[(1)] = (16));

} else {
var statearr_30924_30982 = state_30903__$1;
(statearr_30924_30982[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (22))){
var inst_30862 = (state_30903[(14)]);
var inst_30863 = (state_30903[(9)]);
var inst_30861 = (state_30903[(2)]);
var inst_30862__$1 = cljs.core.nth.call(null,inst_30861,(0),null);
var inst_30863__$1 = cljs.core.nth.call(null,inst_30861,(1),null);
var inst_30864 = (inst_30862__$1 == null);
var inst_30865 = cljs.core._EQ_.call(null,inst_30863__$1,change);
var inst_30866 = (inst_30864) || (inst_30865);
var state_30903__$1 = (function (){var statearr_30925 = state_30903;
(statearr_30925[(14)] = inst_30862__$1);

(statearr_30925[(9)] = inst_30863__$1);

return statearr_30925;
})();
if(cljs.core.truth_(inst_30866)){
var statearr_30926_30983 = state_30903__$1;
(statearr_30926_30983[(1)] = (23));

} else {
var statearr_30927_30984 = state_30903__$1;
(statearr_30927_30984[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (36))){
var inst_30853 = (state_30903[(12)]);
var inst_30831 = inst_30853;
var state_30903__$1 = (function (){var statearr_30928 = state_30903;
(statearr_30928[(7)] = inst_30831);

return statearr_30928;
})();
var statearr_30929_30985 = state_30903__$1;
(statearr_30929_30985[(2)] = null);

(statearr_30929_30985[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (29))){
var inst_30877 = (state_30903[(10)]);
var state_30903__$1 = state_30903;
var statearr_30930_30986 = state_30903__$1;
(statearr_30930_30986[(2)] = inst_30877);

(statearr_30930_30986[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (6))){
var state_30903__$1 = state_30903;
var statearr_30931_30987 = state_30903__$1;
(statearr_30931_30987[(2)] = false);

(statearr_30931_30987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (28))){
var inst_30873 = (state_30903[(2)]);
var inst_30874 = calc_state.call(null);
var inst_30831 = inst_30874;
var state_30903__$1 = (function (){var statearr_30932 = state_30903;
(statearr_30932[(15)] = inst_30873);

(statearr_30932[(7)] = inst_30831);

return statearr_30932;
})();
var statearr_30933_30988 = state_30903__$1;
(statearr_30933_30988[(2)] = null);

(statearr_30933_30988[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (25))){
var inst_30899 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
var statearr_30934_30989 = state_30903__$1;
(statearr_30934_30989[(2)] = inst_30899);

(statearr_30934_30989[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (34))){
var inst_30897 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
var statearr_30935_30990 = state_30903__$1;
(statearr_30935_30990[(2)] = inst_30897);

(statearr_30935_30990[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (17))){
var state_30903__$1 = state_30903;
var statearr_30936_30991 = state_30903__$1;
(statearr_30936_30991[(2)] = false);

(statearr_30936_30991[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (3))){
var state_30903__$1 = state_30903;
var statearr_30937_30992 = state_30903__$1;
(statearr_30937_30992[(2)] = false);

(statearr_30937_30992[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (12))){
var inst_30901 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30903__$1,inst_30901);
} else {
if((state_val_30904 === (2))){
var inst_30807 = (state_30903[(8)]);
var inst_30812 = inst_30807.cljs$lang$protocol_mask$partition0$;
var inst_30813 = (inst_30812 & (64));
var inst_30814 = inst_30807.cljs$core$ISeq$;
var inst_30815 = (inst_30813) || (inst_30814);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30815)){
var statearr_30938_30993 = state_30903__$1;
(statearr_30938_30993[(1)] = (5));

} else {
var statearr_30939_30994 = state_30903__$1;
(statearr_30939_30994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (23))){
var inst_30862 = (state_30903[(14)]);
var inst_30868 = (inst_30862 == null);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30868)){
var statearr_30940_30995 = state_30903__$1;
(statearr_30940_30995[(1)] = (26));

} else {
var statearr_30941_30996 = state_30903__$1;
(statearr_30941_30996[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (35))){
var inst_30888 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
if(cljs.core.truth_(inst_30888)){
var statearr_30942_30997 = state_30903__$1;
(statearr_30942_30997[(1)] = (36));

} else {
var statearr_30943_30998 = state_30903__$1;
(statearr_30943_30998[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (19))){
var inst_30831 = (state_30903[(7)]);
var inst_30850 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30831);
var state_30903__$1 = state_30903;
var statearr_30944_30999 = state_30903__$1;
(statearr_30944_30999[(2)] = inst_30850);

(statearr_30944_30999[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (11))){
var inst_30831 = (state_30903[(7)]);
var inst_30835 = (inst_30831 == null);
var inst_30836 = cljs.core.not.call(null,inst_30835);
var state_30903__$1 = state_30903;
if(inst_30836){
var statearr_30945_31000 = state_30903__$1;
(statearr_30945_31000[(1)] = (13));

} else {
var statearr_30946_31001 = state_30903__$1;
(statearr_30946_31001[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (9))){
var inst_30807 = (state_30903[(8)]);
var state_30903__$1 = state_30903;
var statearr_30947_31002 = state_30903__$1;
(statearr_30947_31002[(2)] = inst_30807);

(statearr_30947_31002[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (5))){
var state_30903__$1 = state_30903;
var statearr_30948_31003 = state_30903__$1;
(statearr_30948_31003[(2)] = true);

(statearr_30948_31003[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (14))){
var state_30903__$1 = state_30903;
var statearr_30949_31004 = state_30903__$1;
(statearr_30949_31004[(2)] = false);

(statearr_30949_31004[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (26))){
var inst_30863 = (state_30903[(9)]);
var inst_30870 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_30863);
var state_30903__$1 = state_30903;
var statearr_30950_31005 = state_30903__$1;
(statearr_30950_31005[(2)] = inst_30870);

(statearr_30950_31005[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (16))){
var state_30903__$1 = state_30903;
var statearr_30951_31006 = state_30903__$1;
(statearr_30951_31006[(2)] = true);

(statearr_30951_31006[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (38))){
var inst_30893 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
var statearr_30952_31007 = state_30903__$1;
(statearr_30952_31007[(2)] = inst_30893);

(statearr_30952_31007[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (30))){
var inst_30855 = (state_30903[(13)]);
var inst_30863 = (state_30903[(9)]);
var inst_30854 = (state_30903[(11)]);
var inst_30880 = cljs.core.empty_QMARK_.call(null,inst_30854);
var inst_30881 = inst_30855.call(null,inst_30863);
var inst_30882 = cljs.core.not.call(null,inst_30881);
var inst_30883 = (inst_30880) && (inst_30882);
var state_30903__$1 = state_30903;
var statearr_30953_31008 = state_30903__$1;
(statearr_30953_31008[(2)] = inst_30883);

(statearr_30953_31008[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (10))){
var inst_30807 = (state_30903[(8)]);
var inst_30827 = (state_30903[(2)]);
var inst_30828 = cljs.core.get.call(null,inst_30827,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_30829 = cljs.core.get.call(null,inst_30827,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_30830 = cljs.core.get.call(null,inst_30827,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_30831 = inst_30807;
var state_30903__$1 = (function (){var statearr_30954 = state_30903;
(statearr_30954[(16)] = inst_30830);

(statearr_30954[(17)] = inst_30829);

(statearr_30954[(7)] = inst_30831);

(statearr_30954[(18)] = inst_30828);

return statearr_30954;
})();
var statearr_30955_31009 = state_30903__$1;
(statearr_30955_31009[(2)] = null);

(statearr_30955_31009[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (18))){
var inst_30845 = (state_30903[(2)]);
var state_30903__$1 = state_30903;
var statearr_30956_31010 = state_30903__$1;
(statearr_30956_31010[(2)] = inst_30845);

(statearr_30956_31010[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (37))){
var state_30903__$1 = state_30903;
var statearr_30957_31011 = state_30903__$1;
(statearr_30957_31011[(2)] = null);

(statearr_30957_31011[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30904 === (8))){
var inst_30807 = (state_30903[(8)]);
var inst_30824 = cljs.core.apply.call(null,cljs.core.hash_map,inst_30807);
var state_30903__$1 = state_30903;
var statearr_30958_31012 = state_30903__$1;
(statearr_30958_31012[(2)] = inst_30824);

(statearr_30958_31012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___30966,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__29105__auto__,c__29219__auto___30966,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__29106__auto__ = null;
var cljs$core$async$mix_$_state_machine__29106__auto____0 = (function (){
var statearr_30962 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30962[(0)] = cljs$core$async$mix_$_state_machine__29106__auto__);

(statearr_30962[(1)] = (1));

return statearr_30962;
});
var cljs$core$async$mix_$_state_machine__29106__auto____1 = (function (state_30903){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_30903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e30963){if((e30963 instanceof Object)){
var ex__29109__auto__ = e30963;
var statearr_30964_31013 = state_30903;
(statearr_30964_31013[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30903);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30963;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31014 = state_30903;
state_30903 = G__31014;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29106__auto__ = function(state_30903){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29106__auto____1.call(this,state_30903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29106__auto____0;
cljs$core$async$mix_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29106__auto____1;
return cljs$core$async$mix_$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___30966,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__29221__auto__ = (function (){var statearr_30965 = f__29220__auto__.call(null);
(statearr_30965[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___30966);

return statearr_30965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___30966,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27283__auto__ = (((p == null))?null:p);
var m__27284__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27284__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27283__auto__ = (((p == null))?null:p);
var m__27284__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,p,v,ch);
} else {
var m__27284__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31015 = [];
var len__27753__auto___31018 = arguments.length;
var i__27754__auto___31019 = (0);
while(true){
if((i__27754__auto___31019 < len__27753__auto___31018)){
args31015.push((arguments[i__27754__auto___31019]));

var G__31020 = (i__27754__auto___31019 + (1));
i__27754__auto___31019 = G__31020;
continue;
} else {
}
break;
}

var G__31017 = args31015.length;
switch (G__31017) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31015.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27283__auto__ = (((p == null))?null:p);
var m__27284__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,p);
} else {
var m__27284__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27283__auto__ = (((p == null))?null:p);
var m__27284__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27283__auto__)]);
if(!((m__27284__auto__ == null))){
return m__27284__auto__.call(null,p,v);
} else {
var m__27284__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27284__auto____$1 == null))){
return m__27284__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31023 = [];
var len__27753__auto___31148 = arguments.length;
var i__27754__auto___31149 = (0);
while(true){
if((i__27754__auto___31149 < len__27753__auto___31148)){
args31023.push((arguments[i__27754__auto___31149]));

var G__31150 = (i__27754__auto___31149 + (1));
i__27754__auto___31149 = G__31150;
continue;
} else {
}
break;
}

var G__31025 = args31023.length;
switch (G__31025) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31023.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__26570__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__26570__auto__,mults){
return (function (p1__31022_SHARP_){
if(cljs.core.truth_(p1__31022_SHARP_.call(null,topic))){
return p1__31022_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31022_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__26570__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31026 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31026 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31027){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31027 = meta31027;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31028,meta31027__$1){
var self__ = this;
var _31028__$1 = this;
return (new cljs.core.async.t_cljs$core$async31026(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31027__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31028){
var self__ = this;
var _31028__$1 = this;
return self__.meta31027;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6728__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6728__auto__)){
var m = temp__6728__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31027","meta31027",-254542966,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31026.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31026.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31026";

cljs.core.async.t_cljs$core$async31026.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async31026");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31026 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31026(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31027){
return (new cljs.core.async.t_cljs$core$async31026(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31027));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31026(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29219__auto___31152 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___31152,mults,ensure_mult,p){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___31152,mults,ensure_mult,p){
return (function (state_31100){
var state_val_31101 = (state_31100[(1)]);
if((state_val_31101 === (7))){
var inst_31096 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31102_31153 = state_31100__$1;
(statearr_31102_31153[(2)] = inst_31096);

(statearr_31102_31153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (20))){
var state_31100__$1 = state_31100;
var statearr_31103_31154 = state_31100__$1;
(statearr_31103_31154[(2)] = null);

(statearr_31103_31154[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (1))){
var state_31100__$1 = state_31100;
var statearr_31104_31155 = state_31100__$1;
(statearr_31104_31155[(2)] = null);

(statearr_31104_31155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (24))){
var inst_31079 = (state_31100[(7)]);
var inst_31088 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31079);
var state_31100__$1 = state_31100;
var statearr_31105_31156 = state_31100__$1;
(statearr_31105_31156[(2)] = inst_31088);

(statearr_31105_31156[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (4))){
var inst_31031 = (state_31100[(8)]);
var inst_31031__$1 = (state_31100[(2)]);
var inst_31032 = (inst_31031__$1 == null);
var state_31100__$1 = (function (){var statearr_31106 = state_31100;
(statearr_31106[(8)] = inst_31031__$1);

return statearr_31106;
})();
if(cljs.core.truth_(inst_31032)){
var statearr_31107_31157 = state_31100__$1;
(statearr_31107_31157[(1)] = (5));

} else {
var statearr_31108_31158 = state_31100__$1;
(statearr_31108_31158[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (15))){
var inst_31073 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31109_31159 = state_31100__$1;
(statearr_31109_31159[(2)] = inst_31073);

(statearr_31109_31159[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (21))){
var inst_31093 = (state_31100[(2)]);
var state_31100__$1 = (function (){var statearr_31110 = state_31100;
(statearr_31110[(9)] = inst_31093);

return statearr_31110;
})();
var statearr_31111_31160 = state_31100__$1;
(statearr_31111_31160[(2)] = null);

(statearr_31111_31160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (13))){
var inst_31055 = (state_31100[(10)]);
var inst_31057 = cljs.core.chunked_seq_QMARK_.call(null,inst_31055);
var state_31100__$1 = state_31100;
if(inst_31057){
var statearr_31112_31161 = state_31100__$1;
(statearr_31112_31161[(1)] = (16));

} else {
var statearr_31113_31162 = state_31100__$1;
(statearr_31113_31162[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (22))){
var inst_31085 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
if(cljs.core.truth_(inst_31085)){
var statearr_31114_31163 = state_31100__$1;
(statearr_31114_31163[(1)] = (23));

} else {
var statearr_31115_31164 = state_31100__$1;
(statearr_31115_31164[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (6))){
var inst_31081 = (state_31100[(11)]);
var inst_31079 = (state_31100[(7)]);
var inst_31031 = (state_31100[(8)]);
var inst_31079__$1 = topic_fn.call(null,inst_31031);
var inst_31080 = cljs.core.deref.call(null,mults);
var inst_31081__$1 = cljs.core.get.call(null,inst_31080,inst_31079__$1);
var state_31100__$1 = (function (){var statearr_31116 = state_31100;
(statearr_31116[(11)] = inst_31081__$1);

(statearr_31116[(7)] = inst_31079__$1);

return statearr_31116;
})();
if(cljs.core.truth_(inst_31081__$1)){
var statearr_31117_31165 = state_31100__$1;
(statearr_31117_31165[(1)] = (19));

} else {
var statearr_31118_31166 = state_31100__$1;
(statearr_31118_31166[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (25))){
var inst_31090 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31119_31167 = state_31100__$1;
(statearr_31119_31167[(2)] = inst_31090);

(statearr_31119_31167[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (17))){
var inst_31055 = (state_31100[(10)]);
var inst_31064 = cljs.core.first.call(null,inst_31055);
var inst_31065 = cljs.core.async.muxch_STAR_.call(null,inst_31064);
var inst_31066 = cljs.core.async.close_BANG_.call(null,inst_31065);
var inst_31067 = cljs.core.next.call(null,inst_31055);
var inst_31041 = inst_31067;
var inst_31042 = null;
var inst_31043 = (0);
var inst_31044 = (0);
var state_31100__$1 = (function (){var statearr_31120 = state_31100;
(statearr_31120[(12)] = inst_31044);

(statearr_31120[(13)] = inst_31043);

(statearr_31120[(14)] = inst_31066);

(statearr_31120[(15)] = inst_31041);

(statearr_31120[(16)] = inst_31042);

return statearr_31120;
})();
var statearr_31121_31168 = state_31100__$1;
(statearr_31121_31168[(2)] = null);

(statearr_31121_31168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (3))){
var inst_31098 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31100__$1,inst_31098);
} else {
if((state_val_31101 === (12))){
var inst_31075 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31122_31169 = state_31100__$1;
(statearr_31122_31169[(2)] = inst_31075);

(statearr_31122_31169[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (2))){
var state_31100__$1 = state_31100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31100__$1,(4),ch);
} else {
if((state_val_31101 === (23))){
var state_31100__$1 = state_31100;
var statearr_31123_31170 = state_31100__$1;
(statearr_31123_31170[(2)] = null);

(statearr_31123_31170[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (19))){
var inst_31081 = (state_31100[(11)]);
var inst_31031 = (state_31100[(8)]);
var inst_31083 = cljs.core.async.muxch_STAR_.call(null,inst_31081);
var state_31100__$1 = state_31100;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31100__$1,(22),inst_31083,inst_31031);
} else {
if((state_val_31101 === (11))){
var inst_31041 = (state_31100[(15)]);
var inst_31055 = (state_31100[(10)]);
var inst_31055__$1 = cljs.core.seq.call(null,inst_31041);
var state_31100__$1 = (function (){var statearr_31124 = state_31100;
(statearr_31124[(10)] = inst_31055__$1);

return statearr_31124;
})();
if(inst_31055__$1){
var statearr_31125_31171 = state_31100__$1;
(statearr_31125_31171[(1)] = (13));

} else {
var statearr_31126_31172 = state_31100__$1;
(statearr_31126_31172[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (9))){
var inst_31077 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31127_31173 = state_31100__$1;
(statearr_31127_31173[(2)] = inst_31077);

(statearr_31127_31173[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (5))){
var inst_31038 = cljs.core.deref.call(null,mults);
var inst_31039 = cljs.core.vals.call(null,inst_31038);
var inst_31040 = cljs.core.seq.call(null,inst_31039);
var inst_31041 = inst_31040;
var inst_31042 = null;
var inst_31043 = (0);
var inst_31044 = (0);
var state_31100__$1 = (function (){var statearr_31128 = state_31100;
(statearr_31128[(12)] = inst_31044);

(statearr_31128[(13)] = inst_31043);

(statearr_31128[(15)] = inst_31041);

(statearr_31128[(16)] = inst_31042);

return statearr_31128;
})();
var statearr_31129_31174 = state_31100__$1;
(statearr_31129_31174[(2)] = null);

(statearr_31129_31174[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (14))){
var state_31100__$1 = state_31100;
var statearr_31133_31175 = state_31100__$1;
(statearr_31133_31175[(2)] = null);

(statearr_31133_31175[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (16))){
var inst_31055 = (state_31100[(10)]);
var inst_31059 = cljs.core.chunk_first.call(null,inst_31055);
var inst_31060 = cljs.core.chunk_rest.call(null,inst_31055);
var inst_31061 = cljs.core.count.call(null,inst_31059);
var inst_31041 = inst_31060;
var inst_31042 = inst_31059;
var inst_31043 = inst_31061;
var inst_31044 = (0);
var state_31100__$1 = (function (){var statearr_31134 = state_31100;
(statearr_31134[(12)] = inst_31044);

(statearr_31134[(13)] = inst_31043);

(statearr_31134[(15)] = inst_31041);

(statearr_31134[(16)] = inst_31042);

return statearr_31134;
})();
var statearr_31135_31176 = state_31100__$1;
(statearr_31135_31176[(2)] = null);

(statearr_31135_31176[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (10))){
var inst_31044 = (state_31100[(12)]);
var inst_31043 = (state_31100[(13)]);
var inst_31041 = (state_31100[(15)]);
var inst_31042 = (state_31100[(16)]);
var inst_31049 = cljs.core._nth.call(null,inst_31042,inst_31044);
var inst_31050 = cljs.core.async.muxch_STAR_.call(null,inst_31049);
var inst_31051 = cljs.core.async.close_BANG_.call(null,inst_31050);
var inst_31052 = (inst_31044 + (1));
var tmp31130 = inst_31043;
var tmp31131 = inst_31041;
var tmp31132 = inst_31042;
var inst_31041__$1 = tmp31131;
var inst_31042__$1 = tmp31132;
var inst_31043__$1 = tmp31130;
var inst_31044__$1 = inst_31052;
var state_31100__$1 = (function (){var statearr_31136 = state_31100;
(statearr_31136[(12)] = inst_31044__$1);

(statearr_31136[(13)] = inst_31043__$1);

(statearr_31136[(17)] = inst_31051);

(statearr_31136[(15)] = inst_31041__$1);

(statearr_31136[(16)] = inst_31042__$1);

return statearr_31136;
})();
var statearr_31137_31177 = state_31100__$1;
(statearr_31137_31177[(2)] = null);

(statearr_31137_31177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (18))){
var inst_31070 = (state_31100[(2)]);
var state_31100__$1 = state_31100;
var statearr_31138_31178 = state_31100__$1;
(statearr_31138_31178[(2)] = inst_31070);

(statearr_31138_31178[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31101 === (8))){
var inst_31044 = (state_31100[(12)]);
var inst_31043 = (state_31100[(13)]);
var inst_31046 = (inst_31044 < inst_31043);
var inst_31047 = inst_31046;
var state_31100__$1 = state_31100;
if(cljs.core.truth_(inst_31047)){
var statearr_31139_31179 = state_31100__$1;
(statearr_31139_31179[(1)] = (10));

} else {
var statearr_31140_31180 = state_31100__$1;
(statearr_31140_31180[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___31152,mults,ensure_mult,p))
;
return ((function (switch__29105__auto__,c__29219__auto___31152,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_31144 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31144[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_31144[(1)] = (1));

return statearr_31144;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31100){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31145){if((e31145 instanceof Object)){
var ex__29109__auto__ = e31145;
var statearr_31146_31181 = state_31100;
(statearr_31146_31181[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31100);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31145;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31182 = state_31100;
state_31100 = G__31182;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31100){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___31152,mults,ensure_mult,p))
})();
var state__29221__auto__ = (function (){var statearr_31147 = f__29220__auto__.call(null);
(statearr_31147[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___31152);

return statearr_31147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___31152,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args31183 = [];
var len__27753__auto___31186 = arguments.length;
var i__27754__auto___31187 = (0);
while(true){
if((i__27754__auto___31187 < len__27753__auto___31186)){
args31183.push((arguments[i__27754__auto___31187]));

var G__31188 = (i__27754__auto___31187 + (1));
i__27754__auto___31187 = G__31188;
continue;
} else {
}
break;
}

var G__31185 = args31183.length;
switch (G__31185) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31183.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args31190 = [];
var len__27753__auto___31193 = arguments.length;
var i__27754__auto___31194 = (0);
while(true){
if((i__27754__auto___31194 < len__27753__auto___31193)){
args31190.push((arguments[i__27754__auto___31194]));

var G__31195 = (i__27754__auto___31194 + (1));
i__27754__auto___31194 = G__31195;
continue;
} else {
}
break;
}

var G__31192 = args31190.length;
switch (G__31192) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31190.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args31197 = [];
var len__27753__auto___31268 = arguments.length;
var i__27754__auto___31269 = (0);
while(true){
if((i__27754__auto___31269 < len__27753__auto___31268)){
args31197.push((arguments[i__27754__auto___31269]));

var G__31270 = (i__27754__auto___31269 + (1));
i__27754__auto___31269 = G__31270;
continue;
} else {
}
break;
}

var G__31199 = args31197.length;
switch (G__31199) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31197.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__29219__auto___31272 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___31272,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___31272,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31238){
var state_val_31239 = (state_31238[(1)]);
if((state_val_31239 === (7))){
var state_31238__$1 = state_31238;
var statearr_31240_31273 = state_31238__$1;
(statearr_31240_31273[(2)] = null);

(statearr_31240_31273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (1))){
var state_31238__$1 = state_31238;
var statearr_31241_31274 = state_31238__$1;
(statearr_31241_31274[(2)] = null);

(statearr_31241_31274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (4))){
var inst_31202 = (state_31238[(7)]);
var inst_31204 = (inst_31202 < cnt);
var state_31238__$1 = state_31238;
if(cljs.core.truth_(inst_31204)){
var statearr_31242_31275 = state_31238__$1;
(statearr_31242_31275[(1)] = (6));

} else {
var statearr_31243_31276 = state_31238__$1;
(statearr_31243_31276[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (15))){
var inst_31234 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
var statearr_31244_31277 = state_31238__$1;
(statearr_31244_31277[(2)] = inst_31234);

(statearr_31244_31277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (13))){
var inst_31227 = cljs.core.async.close_BANG_.call(null,out);
var state_31238__$1 = state_31238;
var statearr_31245_31278 = state_31238__$1;
(statearr_31245_31278[(2)] = inst_31227);

(statearr_31245_31278[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (6))){
var state_31238__$1 = state_31238;
var statearr_31246_31279 = state_31238__$1;
(statearr_31246_31279[(2)] = null);

(statearr_31246_31279[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (3))){
var inst_31236 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31238__$1,inst_31236);
} else {
if((state_val_31239 === (12))){
var inst_31224 = (state_31238[(8)]);
var inst_31224__$1 = (state_31238[(2)]);
var inst_31225 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_31224__$1);
var state_31238__$1 = (function (){var statearr_31247 = state_31238;
(statearr_31247[(8)] = inst_31224__$1);

return statearr_31247;
})();
if(cljs.core.truth_(inst_31225)){
var statearr_31248_31280 = state_31238__$1;
(statearr_31248_31280[(1)] = (13));

} else {
var statearr_31249_31281 = state_31238__$1;
(statearr_31249_31281[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (2))){
var inst_31201 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_31202 = (0);
var state_31238__$1 = (function (){var statearr_31250 = state_31238;
(statearr_31250[(9)] = inst_31201);

(statearr_31250[(7)] = inst_31202);

return statearr_31250;
})();
var statearr_31251_31282 = state_31238__$1;
(statearr_31251_31282[(2)] = null);

(statearr_31251_31282[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (11))){
var inst_31202 = (state_31238[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31238,(10),Object,null,(9));
var inst_31211 = chs__$1.call(null,inst_31202);
var inst_31212 = done.call(null,inst_31202);
var inst_31213 = cljs.core.async.take_BANG_.call(null,inst_31211,inst_31212);
var state_31238__$1 = state_31238;
var statearr_31252_31283 = state_31238__$1;
(statearr_31252_31283[(2)] = inst_31213);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31238__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (9))){
var inst_31202 = (state_31238[(7)]);
var inst_31215 = (state_31238[(2)]);
var inst_31216 = (inst_31202 + (1));
var inst_31202__$1 = inst_31216;
var state_31238__$1 = (function (){var statearr_31253 = state_31238;
(statearr_31253[(10)] = inst_31215);

(statearr_31253[(7)] = inst_31202__$1);

return statearr_31253;
})();
var statearr_31254_31284 = state_31238__$1;
(statearr_31254_31284[(2)] = null);

(statearr_31254_31284[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (5))){
var inst_31222 = (state_31238[(2)]);
var state_31238__$1 = (function (){var statearr_31255 = state_31238;
(statearr_31255[(11)] = inst_31222);

return statearr_31255;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31238__$1,(12),dchan);
} else {
if((state_val_31239 === (14))){
var inst_31224 = (state_31238[(8)]);
var inst_31229 = cljs.core.apply.call(null,f,inst_31224);
var state_31238__$1 = state_31238;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31238__$1,(16),out,inst_31229);
} else {
if((state_val_31239 === (16))){
var inst_31231 = (state_31238[(2)]);
var state_31238__$1 = (function (){var statearr_31256 = state_31238;
(statearr_31256[(12)] = inst_31231);

return statearr_31256;
})();
var statearr_31257_31285 = state_31238__$1;
(statearr_31257_31285[(2)] = null);

(statearr_31257_31285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (10))){
var inst_31206 = (state_31238[(2)]);
var inst_31207 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_31238__$1 = (function (){var statearr_31258 = state_31238;
(statearr_31258[(13)] = inst_31206);

return statearr_31258;
})();
var statearr_31259_31286 = state_31238__$1;
(statearr_31259_31286[(2)] = inst_31207);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31238__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31239 === (8))){
var inst_31220 = (state_31238[(2)]);
var state_31238__$1 = state_31238;
var statearr_31260_31287 = state_31238__$1;
(statearr_31260_31287[(2)] = inst_31220);

(statearr_31260_31287[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___31272,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__29105__auto__,c__29219__auto___31272,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_31264 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31264[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_31264[(1)] = (1));

return statearr_31264;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31238){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31265){if((e31265 instanceof Object)){
var ex__29109__auto__ = e31265;
var statearr_31266_31288 = state_31238;
(statearr_31266_31288[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31238);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31265;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31289 = state_31238;
state_31238 = G__31289;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31238){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___31272,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__29221__auto__ = (function (){var statearr_31267 = f__29220__auto__.call(null);
(statearr_31267[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___31272);

return statearr_31267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___31272,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args31291 = [];
var len__27753__auto___31349 = arguments.length;
var i__27754__auto___31350 = (0);
while(true){
if((i__27754__auto___31350 < len__27753__auto___31349)){
args31291.push((arguments[i__27754__auto___31350]));

var G__31351 = (i__27754__auto___31350 + (1));
i__27754__auto___31350 = G__31351;
continue;
} else {
}
break;
}

var G__31293 = args31291.length;
switch (G__31293) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31291.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29219__auto___31353 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___31353,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___31353,out){
return (function (state_31325){
var state_val_31326 = (state_31325[(1)]);
if((state_val_31326 === (7))){
var inst_31304 = (state_31325[(7)]);
var inst_31305 = (state_31325[(8)]);
var inst_31304__$1 = (state_31325[(2)]);
var inst_31305__$1 = cljs.core.nth.call(null,inst_31304__$1,(0),null);
var inst_31306 = cljs.core.nth.call(null,inst_31304__$1,(1),null);
var inst_31307 = (inst_31305__$1 == null);
var state_31325__$1 = (function (){var statearr_31327 = state_31325;
(statearr_31327[(9)] = inst_31306);

(statearr_31327[(7)] = inst_31304__$1);

(statearr_31327[(8)] = inst_31305__$1);

return statearr_31327;
})();
if(cljs.core.truth_(inst_31307)){
var statearr_31328_31354 = state_31325__$1;
(statearr_31328_31354[(1)] = (8));

} else {
var statearr_31329_31355 = state_31325__$1;
(statearr_31329_31355[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31326 === (1))){
var inst_31294 = cljs.core.vec.call(null,chs);
var inst_31295 = inst_31294;
var state_31325__$1 = (function (){var statearr_31330 = state_31325;
(statearr_31330[(10)] = inst_31295);

return statearr_31330;
})();
var statearr_31331_31356 = state_31325__$1;
(statearr_31331_31356[(2)] = null);

(statearr_31331_31356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31326 === (4))){
var inst_31295 = (state_31325[(10)]);
var state_31325__$1 = state_31325;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31325__$1,(7),inst_31295);
} else {
if((state_val_31326 === (6))){
var inst_31321 = (state_31325[(2)]);
var state_31325__$1 = state_31325;
var statearr_31332_31357 = state_31325__$1;
(statearr_31332_31357[(2)] = inst_31321);

(statearr_31332_31357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31326 === (3))){
var inst_31323 = (state_31325[(2)]);
var state_31325__$1 = state_31325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31325__$1,inst_31323);
} else {
if((state_val_31326 === (2))){
var inst_31295 = (state_31325[(10)]);
var inst_31297 = cljs.core.count.call(null,inst_31295);
var inst_31298 = (inst_31297 > (0));
var state_31325__$1 = state_31325;
if(cljs.core.truth_(inst_31298)){
var statearr_31334_31358 = state_31325__$1;
(statearr_31334_31358[(1)] = (4));

} else {
var statearr_31335_31359 = state_31325__$1;
(statearr_31335_31359[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31326 === (11))){
var inst_31295 = (state_31325[(10)]);
var inst_31314 = (state_31325[(2)]);
var tmp31333 = inst_31295;
var inst_31295__$1 = tmp31333;
var state_31325__$1 = (function (){var statearr_31336 = state_31325;
(statearr_31336[(10)] = inst_31295__$1);

(statearr_31336[(11)] = inst_31314);

return statearr_31336;
})();
var statearr_31337_31360 = state_31325__$1;
(statearr_31337_31360[(2)] = null);

(statearr_31337_31360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31326 === (9))){
var inst_31305 = (state_31325[(8)]);
var state_31325__$1 = state_31325;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31325__$1,(11),out,inst_31305);
} else {
if((state_val_31326 === (5))){
var inst_31319 = cljs.core.async.close_BANG_.call(null,out);
var state_31325__$1 = state_31325;
var statearr_31338_31361 = state_31325__$1;
(statearr_31338_31361[(2)] = inst_31319);

(statearr_31338_31361[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31326 === (10))){
var inst_31317 = (state_31325[(2)]);
var state_31325__$1 = state_31325;
var statearr_31339_31362 = state_31325__$1;
(statearr_31339_31362[(2)] = inst_31317);

(statearr_31339_31362[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31326 === (8))){
var inst_31306 = (state_31325[(9)]);
var inst_31295 = (state_31325[(10)]);
var inst_31304 = (state_31325[(7)]);
var inst_31305 = (state_31325[(8)]);
var inst_31309 = (function (){var cs = inst_31295;
var vec__31300 = inst_31304;
var v = inst_31305;
var c = inst_31306;
return ((function (cs,vec__31300,v,c,inst_31306,inst_31295,inst_31304,inst_31305,state_val_31326,c__29219__auto___31353,out){
return (function (p1__31290_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31290_SHARP_);
});
;})(cs,vec__31300,v,c,inst_31306,inst_31295,inst_31304,inst_31305,state_val_31326,c__29219__auto___31353,out))
})();
var inst_31310 = cljs.core.filterv.call(null,inst_31309,inst_31295);
var inst_31295__$1 = inst_31310;
var state_31325__$1 = (function (){var statearr_31340 = state_31325;
(statearr_31340[(10)] = inst_31295__$1);

return statearr_31340;
})();
var statearr_31341_31363 = state_31325__$1;
(statearr_31341_31363[(2)] = null);

(statearr_31341_31363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___31353,out))
;
return ((function (switch__29105__auto__,c__29219__auto___31353,out){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_31345 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31345[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_31345[(1)] = (1));

return statearr_31345;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31325){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31346){if((e31346 instanceof Object)){
var ex__29109__auto__ = e31346;
var statearr_31347_31364 = state_31325;
(statearr_31347_31364[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31346;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31365 = state_31325;
state_31325 = G__31365;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___31353,out))
})();
var state__29221__auto__ = (function (){var statearr_31348 = f__29220__auto__.call(null);
(statearr_31348[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___31353);

return statearr_31348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___31353,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args31366 = [];
var len__27753__auto___31415 = arguments.length;
var i__27754__auto___31416 = (0);
while(true){
if((i__27754__auto___31416 < len__27753__auto___31415)){
args31366.push((arguments[i__27754__auto___31416]));

var G__31417 = (i__27754__auto___31416 + (1));
i__27754__auto___31416 = G__31417;
continue;
} else {
}
break;
}

var G__31368 = args31366.length;
switch (G__31368) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31366.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29219__auto___31419 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___31419,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___31419,out){
return (function (state_31392){
var state_val_31393 = (state_31392[(1)]);
if((state_val_31393 === (7))){
var inst_31374 = (state_31392[(7)]);
var inst_31374__$1 = (state_31392[(2)]);
var inst_31375 = (inst_31374__$1 == null);
var inst_31376 = cljs.core.not.call(null,inst_31375);
var state_31392__$1 = (function (){var statearr_31394 = state_31392;
(statearr_31394[(7)] = inst_31374__$1);

return statearr_31394;
})();
if(inst_31376){
var statearr_31395_31420 = state_31392__$1;
(statearr_31395_31420[(1)] = (8));

} else {
var statearr_31396_31421 = state_31392__$1;
(statearr_31396_31421[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (1))){
var inst_31369 = (0);
var state_31392__$1 = (function (){var statearr_31397 = state_31392;
(statearr_31397[(8)] = inst_31369);

return statearr_31397;
})();
var statearr_31398_31422 = state_31392__$1;
(statearr_31398_31422[(2)] = null);

(statearr_31398_31422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (4))){
var state_31392__$1 = state_31392;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31392__$1,(7),ch);
} else {
if((state_val_31393 === (6))){
var inst_31387 = (state_31392[(2)]);
var state_31392__$1 = state_31392;
var statearr_31399_31423 = state_31392__$1;
(statearr_31399_31423[(2)] = inst_31387);

(statearr_31399_31423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (3))){
var inst_31389 = (state_31392[(2)]);
var inst_31390 = cljs.core.async.close_BANG_.call(null,out);
var state_31392__$1 = (function (){var statearr_31400 = state_31392;
(statearr_31400[(9)] = inst_31389);

return statearr_31400;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31392__$1,inst_31390);
} else {
if((state_val_31393 === (2))){
var inst_31369 = (state_31392[(8)]);
var inst_31371 = (inst_31369 < n);
var state_31392__$1 = state_31392;
if(cljs.core.truth_(inst_31371)){
var statearr_31401_31424 = state_31392__$1;
(statearr_31401_31424[(1)] = (4));

} else {
var statearr_31402_31425 = state_31392__$1;
(statearr_31402_31425[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (11))){
var inst_31369 = (state_31392[(8)]);
var inst_31379 = (state_31392[(2)]);
var inst_31380 = (inst_31369 + (1));
var inst_31369__$1 = inst_31380;
var state_31392__$1 = (function (){var statearr_31403 = state_31392;
(statearr_31403[(8)] = inst_31369__$1);

(statearr_31403[(10)] = inst_31379);

return statearr_31403;
})();
var statearr_31404_31426 = state_31392__$1;
(statearr_31404_31426[(2)] = null);

(statearr_31404_31426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (9))){
var state_31392__$1 = state_31392;
var statearr_31405_31427 = state_31392__$1;
(statearr_31405_31427[(2)] = null);

(statearr_31405_31427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (5))){
var state_31392__$1 = state_31392;
var statearr_31406_31428 = state_31392__$1;
(statearr_31406_31428[(2)] = null);

(statearr_31406_31428[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (10))){
var inst_31384 = (state_31392[(2)]);
var state_31392__$1 = state_31392;
var statearr_31407_31429 = state_31392__$1;
(statearr_31407_31429[(2)] = inst_31384);

(statearr_31407_31429[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31393 === (8))){
var inst_31374 = (state_31392[(7)]);
var state_31392__$1 = state_31392;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31392__$1,(11),out,inst_31374);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___31419,out))
;
return ((function (switch__29105__auto__,c__29219__auto___31419,out){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_31411 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31411[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_31411[(1)] = (1));

return statearr_31411;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31392){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31412){if((e31412 instanceof Object)){
var ex__29109__auto__ = e31412;
var statearr_31413_31430 = state_31392;
(statearr_31413_31430[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31392);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31412;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31431 = state_31392;
state_31392 = G__31431;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31392){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___31419,out))
})();
var state__29221__auto__ = (function (){var statearr_31414 = f__29220__auto__.call(null);
(statearr_31414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___31419);

return statearr_31414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___31419,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31439 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31439 = (function (map_LT_,f,ch,meta31440){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31440 = meta31440;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31441,meta31440__$1){
var self__ = this;
var _31441__$1 = this;
return (new cljs.core.async.t_cljs$core$async31439(self__.map_LT_,self__.f,self__.ch,meta31440__$1));
});

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31441){
var self__ = this;
var _31441__$1 = this;
return self__.meta31440;
});

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async31442 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31442 = (function (map_LT_,f,ch,meta31440,_,fn1,meta31443){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta31440 = meta31440;
this._ = _;
this.fn1 = fn1;
this.meta31443 = meta31443;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31442.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_31444,meta31443__$1){
var self__ = this;
var _31444__$1 = this;
return (new cljs.core.async.t_cljs$core$async31442(self__.map_LT_,self__.f,self__.ch,self__.meta31440,self__._,self__.fn1,meta31443__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async31442.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_31444){
var self__ = this;
var _31444__$1 = this;
return self__.meta31443;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31442.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async31442.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31442.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async31442.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__31432_SHARP_){
return f1.call(null,(((p1__31432_SHARP_ == null))?null:self__.f.call(null,p1__31432_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async31442.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31440","meta31440",2069757820,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async31439","cljs.core.async/t_cljs$core$async31439",-814681196,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta31443","meta31443",804663457,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async31442.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31442.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31442";

cljs.core.async.t_cljs$core$async31442.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async31442");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async31442 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31442(map_LT___$1,f__$1,ch__$1,meta31440__$1,___$2,fn1__$1,meta31443){
return (new cljs.core.async.t_cljs$core$async31442(map_LT___$1,f__$1,ch__$1,meta31440__$1,___$2,fn1__$1,meta31443));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async31442(self__.map_LT_,self__.f,self__.ch,self__.meta31440,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__26558__auto__ = ret;
if(cljs.core.truth_(and__26558__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__26558__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31439.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async31439.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31440","meta31440",2069757820,null)], null);
});

cljs.core.async.t_cljs$core$async31439.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31439.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31439";

cljs.core.async.t_cljs$core$async31439.cljs$lang$ctorPrWriter = (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async31439");
});

cljs.core.async.__GT_t_cljs$core$async31439 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async31439(map_LT___$1,f__$1,ch__$1,meta31440){
return (new cljs.core.async.t_cljs$core$async31439(map_LT___$1,f__$1,ch__$1,meta31440));
});

}

return (new cljs.core.async.t_cljs$core$async31439(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async31448 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31448 = (function (map_GT_,f,ch,meta31449){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta31449 = meta31449;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31450,meta31449__$1){
var self__ = this;
var _31450__$1 = this;
return (new cljs.core.async.t_cljs$core$async31448(self__.map_GT_,self__.f,self__.ch,meta31449__$1));
});

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31450){
var self__ = this;
var _31450__$1 = this;
return self__.meta31449;
});

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async31448.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31449","meta31449",-1722878432,null)], null);
});

cljs.core.async.t_cljs$core$async31448.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31448.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31448";

cljs.core.async.t_cljs$core$async31448.cljs$lang$ctorPrWriter = (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async31448");
});

cljs.core.async.__GT_t_cljs$core$async31448 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async31448(map_GT___$1,f__$1,ch__$1,meta31449){
return (new cljs.core.async.t_cljs$core$async31448(map_GT___$1,f__$1,ch__$1,meta31449));
});

}

return (new cljs.core.async.t_cljs$core$async31448(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async31454 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31454 = (function (filter_GT_,p,ch,meta31455){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta31455 = meta31455;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31456,meta31455__$1){
var self__ = this;
var _31456__$1 = this;
return (new cljs.core.async.t_cljs$core$async31454(self__.filter_GT_,self__.p,self__.ch,meta31455__$1));
});

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31456){
var self__ = this;
var _31456__$1 = this;
return self__.meta31455;
});

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async31454.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async31454.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta31455","meta31455",-38333954,null)], null);
});

cljs.core.async.t_cljs$core$async31454.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31454.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31454";

cljs.core.async.t_cljs$core$async31454.cljs$lang$ctorPrWriter = (function (this__27222__auto__,writer__27223__auto__,opt__27224__auto__){
return cljs.core._write.call(null,writer__27223__auto__,"cljs.core.async/t_cljs$core$async31454");
});

cljs.core.async.__GT_t_cljs$core$async31454 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async31454(filter_GT___$1,p__$1,ch__$1,meta31455){
return (new cljs.core.async.t_cljs$core$async31454(filter_GT___$1,p__$1,ch__$1,meta31455));
});

}

return (new cljs.core.async.t_cljs$core$async31454(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args31457 = [];
var len__27753__auto___31501 = arguments.length;
var i__27754__auto___31502 = (0);
while(true){
if((i__27754__auto___31502 < len__27753__auto___31501)){
args31457.push((arguments[i__27754__auto___31502]));

var G__31503 = (i__27754__auto___31502 + (1));
i__27754__auto___31502 = G__31503;
continue;
} else {
}
break;
}

var G__31459 = args31457.length;
switch (G__31459) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31457.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29219__auto___31505 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___31505,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___31505,out){
return (function (state_31480){
var state_val_31481 = (state_31480[(1)]);
if((state_val_31481 === (7))){
var inst_31476 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31482_31506 = state_31480__$1;
(statearr_31482_31506[(2)] = inst_31476);

(statearr_31482_31506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (1))){
var state_31480__$1 = state_31480;
var statearr_31483_31507 = state_31480__$1;
(statearr_31483_31507[(2)] = null);

(statearr_31483_31507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (4))){
var inst_31462 = (state_31480[(7)]);
var inst_31462__$1 = (state_31480[(2)]);
var inst_31463 = (inst_31462__$1 == null);
var state_31480__$1 = (function (){var statearr_31484 = state_31480;
(statearr_31484[(7)] = inst_31462__$1);

return statearr_31484;
})();
if(cljs.core.truth_(inst_31463)){
var statearr_31485_31508 = state_31480__$1;
(statearr_31485_31508[(1)] = (5));

} else {
var statearr_31486_31509 = state_31480__$1;
(statearr_31486_31509[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (6))){
var inst_31462 = (state_31480[(7)]);
var inst_31467 = p.call(null,inst_31462);
var state_31480__$1 = state_31480;
if(cljs.core.truth_(inst_31467)){
var statearr_31487_31510 = state_31480__$1;
(statearr_31487_31510[(1)] = (8));

} else {
var statearr_31488_31511 = state_31480__$1;
(statearr_31488_31511[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (3))){
var inst_31478 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31480__$1,inst_31478);
} else {
if((state_val_31481 === (2))){
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31480__$1,(4),ch);
} else {
if((state_val_31481 === (11))){
var inst_31470 = (state_31480[(2)]);
var state_31480__$1 = state_31480;
var statearr_31489_31512 = state_31480__$1;
(statearr_31489_31512[(2)] = inst_31470);

(statearr_31489_31512[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (9))){
var state_31480__$1 = state_31480;
var statearr_31490_31513 = state_31480__$1;
(statearr_31490_31513[(2)] = null);

(statearr_31490_31513[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (5))){
var inst_31465 = cljs.core.async.close_BANG_.call(null,out);
var state_31480__$1 = state_31480;
var statearr_31491_31514 = state_31480__$1;
(statearr_31491_31514[(2)] = inst_31465);

(statearr_31491_31514[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (10))){
var inst_31473 = (state_31480[(2)]);
var state_31480__$1 = (function (){var statearr_31492 = state_31480;
(statearr_31492[(8)] = inst_31473);

return statearr_31492;
})();
var statearr_31493_31515 = state_31480__$1;
(statearr_31493_31515[(2)] = null);

(statearr_31493_31515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31481 === (8))){
var inst_31462 = (state_31480[(7)]);
var state_31480__$1 = state_31480;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31480__$1,(11),out,inst_31462);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___31505,out))
;
return ((function (switch__29105__auto__,c__29219__auto___31505,out){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_31497 = [null,null,null,null,null,null,null,null,null];
(statearr_31497[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_31497[(1)] = (1));

return statearr_31497;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31480){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31498){if((e31498 instanceof Object)){
var ex__29109__auto__ = e31498;
var statearr_31499_31516 = state_31480;
(statearr_31499_31516[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31480);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31498;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31517 = state_31480;
state_31480 = G__31517;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31480){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___31505,out))
})();
var state__29221__auto__ = (function (){var statearr_31500 = f__29220__auto__.call(null);
(statearr_31500[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___31505);

return statearr_31500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___31505,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args31518 = [];
var len__27753__auto___31521 = arguments.length;
var i__27754__auto___31522 = (0);
while(true){
if((i__27754__auto___31522 < len__27753__auto___31521)){
args31518.push((arguments[i__27754__auto___31522]));

var G__31523 = (i__27754__auto___31522 + (1));
i__27754__auto___31522 = G__31523;
continue;
} else {
}
break;
}

var G__31520 = args31518.length;
switch (G__31520) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31518.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29219__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto__){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto__){
return (function (state_31690){
var state_val_31691 = (state_31690[(1)]);
if((state_val_31691 === (7))){
var inst_31686 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
var statearr_31692_31733 = state_31690__$1;
(statearr_31692_31733[(2)] = inst_31686);

(statearr_31692_31733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (20))){
var inst_31656 = (state_31690[(7)]);
var inst_31667 = (state_31690[(2)]);
var inst_31668 = cljs.core.next.call(null,inst_31656);
var inst_31642 = inst_31668;
var inst_31643 = null;
var inst_31644 = (0);
var inst_31645 = (0);
var state_31690__$1 = (function (){var statearr_31693 = state_31690;
(statearr_31693[(8)] = inst_31645);

(statearr_31693[(9)] = inst_31667);

(statearr_31693[(10)] = inst_31644);

(statearr_31693[(11)] = inst_31642);

(statearr_31693[(12)] = inst_31643);

return statearr_31693;
})();
var statearr_31694_31734 = state_31690__$1;
(statearr_31694_31734[(2)] = null);

(statearr_31694_31734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (1))){
var state_31690__$1 = state_31690;
var statearr_31695_31735 = state_31690__$1;
(statearr_31695_31735[(2)] = null);

(statearr_31695_31735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (4))){
var inst_31631 = (state_31690[(13)]);
var inst_31631__$1 = (state_31690[(2)]);
var inst_31632 = (inst_31631__$1 == null);
var state_31690__$1 = (function (){var statearr_31696 = state_31690;
(statearr_31696[(13)] = inst_31631__$1);

return statearr_31696;
})();
if(cljs.core.truth_(inst_31632)){
var statearr_31697_31736 = state_31690__$1;
(statearr_31697_31736[(1)] = (5));

} else {
var statearr_31698_31737 = state_31690__$1;
(statearr_31698_31737[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (15))){
var state_31690__$1 = state_31690;
var statearr_31702_31738 = state_31690__$1;
(statearr_31702_31738[(2)] = null);

(statearr_31702_31738[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (21))){
var state_31690__$1 = state_31690;
var statearr_31703_31739 = state_31690__$1;
(statearr_31703_31739[(2)] = null);

(statearr_31703_31739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (13))){
var inst_31645 = (state_31690[(8)]);
var inst_31644 = (state_31690[(10)]);
var inst_31642 = (state_31690[(11)]);
var inst_31643 = (state_31690[(12)]);
var inst_31652 = (state_31690[(2)]);
var inst_31653 = (inst_31645 + (1));
var tmp31699 = inst_31644;
var tmp31700 = inst_31642;
var tmp31701 = inst_31643;
var inst_31642__$1 = tmp31700;
var inst_31643__$1 = tmp31701;
var inst_31644__$1 = tmp31699;
var inst_31645__$1 = inst_31653;
var state_31690__$1 = (function (){var statearr_31704 = state_31690;
(statearr_31704[(8)] = inst_31645__$1);

(statearr_31704[(14)] = inst_31652);

(statearr_31704[(10)] = inst_31644__$1);

(statearr_31704[(11)] = inst_31642__$1);

(statearr_31704[(12)] = inst_31643__$1);

return statearr_31704;
})();
var statearr_31705_31740 = state_31690__$1;
(statearr_31705_31740[(2)] = null);

(statearr_31705_31740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (22))){
var state_31690__$1 = state_31690;
var statearr_31706_31741 = state_31690__$1;
(statearr_31706_31741[(2)] = null);

(statearr_31706_31741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (6))){
var inst_31631 = (state_31690[(13)]);
var inst_31640 = f.call(null,inst_31631);
var inst_31641 = cljs.core.seq.call(null,inst_31640);
var inst_31642 = inst_31641;
var inst_31643 = null;
var inst_31644 = (0);
var inst_31645 = (0);
var state_31690__$1 = (function (){var statearr_31707 = state_31690;
(statearr_31707[(8)] = inst_31645);

(statearr_31707[(10)] = inst_31644);

(statearr_31707[(11)] = inst_31642);

(statearr_31707[(12)] = inst_31643);

return statearr_31707;
})();
var statearr_31708_31742 = state_31690__$1;
(statearr_31708_31742[(2)] = null);

(statearr_31708_31742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (17))){
var inst_31656 = (state_31690[(7)]);
var inst_31660 = cljs.core.chunk_first.call(null,inst_31656);
var inst_31661 = cljs.core.chunk_rest.call(null,inst_31656);
var inst_31662 = cljs.core.count.call(null,inst_31660);
var inst_31642 = inst_31661;
var inst_31643 = inst_31660;
var inst_31644 = inst_31662;
var inst_31645 = (0);
var state_31690__$1 = (function (){var statearr_31709 = state_31690;
(statearr_31709[(8)] = inst_31645);

(statearr_31709[(10)] = inst_31644);

(statearr_31709[(11)] = inst_31642);

(statearr_31709[(12)] = inst_31643);

return statearr_31709;
})();
var statearr_31710_31743 = state_31690__$1;
(statearr_31710_31743[(2)] = null);

(statearr_31710_31743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (3))){
var inst_31688 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31690__$1,inst_31688);
} else {
if((state_val_31691 === (12))){
var inst_31676 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
var statearr_31711_31744 = state_31690__$1;
(statearr_31711_31744[(2)] = inst_31676);

(statearr_31711_31744[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (2))){
var state_31690__$1 = state_31690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31690__$1,(4),in$);
} else {
if((state_val_31691 === (23))){
var inst_31684 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
var statearr_31712_31745 = state_31690__$1;
(statearr_31712_31745[(2)] = inst_31684);

(statearr_31712_31745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (19))){
var inst_31671 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
var statearr_31713_31746 = state_31690__$1;
(statearr_31713_31746[(2)] = inst_31671);

(statearr_31713_31746[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (11))){
var inst_31656 = (state_31690[(7)]);
var inst_31642 = (state_31690[(11)]);
var inst_31656__$1 = cljs.core.seq.call(null,inst_31642);
var state_31690__$1 = (function (){var statearr_31714 = state_31690;
(statearr_31714[(7)] = inst_31656__$1);

return statearr_31714;
})();
if(inst_31656__$1){
var statearr_31715_31747 = state_31690__$1;
(statearr_31715_31747[(1)] = (14));

} else {
var statearr_31716_31748 = state_31690__$1;
(statearr_31716_31748[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (9))){
var inst_31678 = (state_31690[(2)]);
var inst_31679 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_31690__$1 = (function (){var statearr_31717 = state_31690;
(statearr_31717[(15)] = inst_31678);

return statearr_31717;
})();
if(cljs.core.truth_(inst_31679)){
var statearr_31718_31749 = state_31690__$1;
(statearr_31718_31749[(1)] = (21));

} else {
var statearr_31719_31750 = state_31690__$1;
(statearr_31719_31750[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (5))){
var inst_31634 = cljs.core.async.close_BANG_.call(null,out);
var state_31690__$1 = state_31690;
var statearr_31720_31751 = state_31690__$1;
(statearr_31720_31751[(2)] = inst_31634);

(statearr_31720_31751[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (14))){
var inst_31656 = (state_31690[(7)]);
var inst_31658 = cljs.core.chunked_seq_QMARK_.call(null,inst_31656);
var state_31690__$1 = state_31690;
if(inst_31658){
var statearr_31721_31752 = state_31690__$1;
(statearr_31721_31752[(1)] = (17));

} else {
var statearr_31722_31753 = state_31690__$1;
(statearr_31722_31753[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (16))){
var inst_31674 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
var statearr_31723_31754 = state_31690__$1;
(statearr_31723_31754[(2)] = inst_31674);

(statearr_31723_31754[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31691 === (10))){
var inst_31645 = (state_31690[(8)]);
var inst_31643 = (state_31690[(12)]);
var inst_31650 = cljs.core._nth.call(null,inst_31643,inst_31645);
var state_31690__$1 = state_31690;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31690__$1,(13),out,inst_31650);
} else {
if((state_val_31691 === (18))){
var inst_31656 = (state_31690[(7)]);
var inst_31665 = cljs.core.first.call(null,inst_31656);
var state_31690__$1 = state_31690;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31690__$1,(20),out,inst_31665);
} else {
if((state_val_31691 === (8))){
var inst_31645 = (state_31690[(8)]);
var inst_31644 = (state_31690[(10)]);
var inst_31647 = (inst_31645 < inst_31644);
var inst_31648 = inst_31647;
var state_31690__$1 = state_31690;
if(cljs.core.truth_(inst_31648)){
var statearr_31724_31755 = state_31690__$1;
(statearr_31724_31755[(1)] = (10));

} else {
var statearr_31725_31756 = state_31690__$1;
(statearr_31725_31756[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto__))
;
return ((function (switch__29105__auto__,c__29219__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29106__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29106__auto____0 = (function (){
var statearr_31729 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31729[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29106__auto__);

(statearr_31729[(1)] = (1));

return statearr_31729;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29106__auto____1 = (function (state_31690){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31690);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31730){if((e31730 instanceof Object)){
var ex__29109__auto__ = e31730;
var statearr_31731_31757 = state_31690;
(statearr_31731_31757[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31690);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31730;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31758 = state_31690;
state_31690 = G__31758;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29106__auto__ = function(state_31690){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29106__auto____1.call(this,state_31690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29106__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29106__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto__))
})();
var state__29221__auto__ = (function (){var statearr_31732 = f__29220__auto__.call(null);
(statearr_31732[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto__);

return statearr_31732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto__))
);

return c__29219__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args31759 = [];
var len__27753__auto___31762 = arguments.length;
var i__27754__auto___31763 = (0);
while(true){
if((i__27754__auto___31763 < len__27753__auto___31762)){
args31759.push((arguments[i__27754__auto___31763]));

var G__31764 = (i__27754__auto___31763 + (1));
i__27754__auto___31763 = G__31764;
continue;
} else {
}
break;
}

var G__31761 = args31759.length;
switch (G__31761) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31759.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args31766 = [];
var len__27753__auto___31769 = arguments.length;
var i__27754__auto___31770 = (0);
while(true){
if((i__27754__auto___31770 < len__27753__auto___31769)){
args31766.push((arguments[i__27754__auto___31770]));

var G__31771 = (i__27754__auto___31770 + (1));
i__27754__auto___31770 = G__31771;
continue;
} else {
}
break;
}

var G__31768 = args31766.length;
switch (G__31768) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31766.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args31773 = [];
var len__27753__auto___31824 = arguments.length;
var i__27754__auto___31825 = (0);
while(true){
if((i__27754__auto___31825 < len__27753__auto___31824)){
args31773.push((arguments[i__27754__auto___31825]));

var G__31826 = (i__27754__auto___31825 + (1));
i__27754__auto___31825 = G__31826;
continue;
} else {
}
break;
}

var G__31775 = args31773.length;
switch (G__31775) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31773.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29219__auto___31828 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___31828,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___31828,out){
return (function (state_31799){
var state_val_31800 = (state_31799[(1)]);
if((state_val_31800 === (7))){
var inst_31794 = (state_31799[(2)]);
var state_31799__$1 = state_31799;
var statearr_31801_31829 = state_31799__$1;
(statearr_31801_31829[(2)] = inst_31794);

(statearr_31801_31829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31800 === (1))){
var inst_31776 = null;
var state_31799__$1 = (function (){var statearr_31802 = state_31799;
(statearr_31802[(7)] = inst_31776);

return statearr_31802;
})();
var statearr_31803_31830 = state_31799__$1;
(statearr_31803_31830[(2)] = null);

(statearr_31803_31830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31800 === (4))){
var inst_31779 = (state_31799[(8)]);
var inst_31779__$1 = (state_31799[(2)]);
var inst_31780 = (inst_31779__$1 == null);
var inst_31781 = cljs.core.not.call(null,inst_31780);
var state_31799__$1 = (function (){var statearr_31804 = state_31799;
(statearr_31804[(8)] = inst_31779__$1);

return statearr_31804;
})();
if(inst_31781){
var statearr_31805_31831 = state_31799__$1;
(statearr_31805_31831[(1)] = (5));

} else {
var statearr_31806_31832 = state_31799__$1;
(statearr_31806_31832[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31800 === (6))){
var state_31799__$1 = state_31799;
var statearr_31807_31833 = state_31799__$1;
(statearr_31807_31833[(2)] = null);

(statearr_31807_31833[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31800 === (3))){
var inst_31796 = (state_31799[(2)]);
var inst_31797 = cljs.core.async.close_BANG_.call(null,out);
var state_31799__$1 = (function (){var statearr_31808 = state_31799;
(statearr_31808[(9)] = inst_31796);

return statearr_31808;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31799__$1,inst_31797);
} else {
if((state_val_31800 === (2))){
var state_31799__$1 = state_31799;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31799__$1,(4),ch);
} else {
if((state_val_31800 === (11))){
var inst_31779 = (state_31799[(8)]);
var inst_31788 = (state_31799[(2)]);
var inst_31776 = inst_31779;
var state_31799__$1 = (function (){var statearr_31809 = state_31799;
(statearr_31809[(10)] = inst_31788);

(statearr_31809[(7)] = inst_31776);

return statearr_31809;
})();
var statearr_31810_31834 = state_31799__$1;
(statearr_31810_31834[(2)] = null);

(statearr_31810_31834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31800 === (9))){
var inst_31779 = (state_31799[(8)]);
var state_31799__$1 = state_31799;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31799__$1,(11),out,inst_31779);
} else {
if((state_val_31800 === (5))){
var inst_31779 = (state_31799[(8)]);
var inst_31776 = (state_31799[(7)]);
var inst_31783 = cljs.core._EQ_.call(null,inst_31779,inst_31776);
var state_31799__$1 = state_31799;
if(inst_31783){
var statearr_31812_31835 = state_31799__$1;
(statearr_31812_31835[(1)] = (8));

} else {
var statearr_31813_31836 = state_31799__$1;
(statearr_31813_31836[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31800 === (10))){
var inst_31791 = (state_31799[(2)]);
var state_31799__$1 = state_31799;
var statearr_31814_31837 = state_31799__$1;
(statearr_31814_31837[(2)] = inst_31791);

(statearr_31814_31837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31800 === (8))){
var inst_31776 = (state_31799[(7)]);
var tmp31811 = inst_31776;
var inst_31776__$1 = tmp31811;
var state_31799__$1 = (function (){var statearr_31815 = state_31799;
(statearr_31815[(7)] = inst_31776__$1);

return statearr_31815;
})();
var statearr_31816_31838 = state_31799__$1;
(statearr_31816_31838[(2)] = null);

(statearr_31816_31838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___31828,out))
;
return ((function (switch__29105__auto__,c__29219__auto___31828,out){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_31820 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31820[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_31820[(1)] = (1));

return statearr_31820;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31799){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31821){if((e31821 instanceof Object)){
var ex__29109__auto__ = e31821;
var statearr_31822_31839 = state_31799;
(statearr_31822_31839[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31799);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31821;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31840 = state_31799;
state_31799 = G__31840;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31799){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___31828,out))
})();
var state__29221__auto__ = (function (){var statearr_31823 = f__29220__auto__.call(null);
(statearr_31823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___31828);

return statearr_31823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___31828,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args31841 = [];
var len__27753__auto___31911 = arguments.length;
var i__27754__auto___31912 = (0);
while(true){
if((i__27754__auto___31912 < len__27753__auto___31911)){
args31841.push((arguments[i__27754__auto___31912]));

var G__31913 = (i__27754__auto___31912 + (1));
i__27754__auto___31912 = G__31913;
continue;
} else {
}
break;
}

var G__31843 = args31841.length;
switch (G__31843) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31841.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29219__auto___31915 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___31915,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___31915,out){
return (function (state_31881){
var state_val_31882 = (state_31881[(1)]);
if((state_val_31882 === (7))){
var inst_31877 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
var statearr_31883_31916 = state_31881__$1;
(statearr_31883_31916[(2)] = inst_31877);

(statearr_31883_31916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (1))){
var inst_31844 = (new Array(n));
var inst_31845 = inst_31844;
var inst_31846 = (0);
var state_31881__$1 = (function (){var statearr_31884 = state_31881;
(statearr_31884[(7)] = inst_31846);

(statearr_31884[(8)] = inst_31845);

return statearr_31884;
})();
var statearr_31885_31917 = state_31881__$1;
(statearr_31885_31917[(2)] = null);

(statearr_31885_31917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (4))){
var inst_31849 = (state_31881[(9)]);
var inst_31849__$1 = (state_31881[(2)]);
var inst_31850 = (inst_31849__$1 == null);
var inst_31851 = cljs.core.not.call(null,inst_31850);
var state_31881__$1 = (function (){var statearr_31886 = state_31881;
(statearr_31886[(9)] = inst_31849__$1);

return statearr_31886;
})();
if(inst_31851){
var statearr_31887_31918 = state_31881__$1;
(statearr_31887_31918[(1)] = (5));

} else {
var statearr_31888_31919 = state_31881__$1;
(statearr_31888_31919[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (15))){
var inst_31871 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
var statearr_31889_31920 = state_31881__$1;
(statearr_31889_31920[(2)] = inst_31871);

(statearr_31889_31920[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (13))){
var state_31881__$1 = state_31881;
var statearr_31890_31921 = state_31881__$1;
(statearr_31890_31921[(2)] = null);

(statearr_31890_31921[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (6))){
var inst_31846 = (state_31881[(7)]);
var inst_31867 = (inst_31846 > (0));
var state_31881__$1 = state_31881;
if(cljs.core.truth_(inst_31867)){
var statearr_31891_31922 = state_31881__$1;
(statearr_31891_31922[(1)] = (12));

} else {
var statearr_31892_31923 = state_31881__$1;
(statearr_31892_31923[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (3))){
var inst_31879 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31881__$1,inst_31879);
} else {
if((state_val_31882 === (12))){
var inst_31845 = (state_31881[(8)]);
var inst_31869 = cljs.core.vec.call(null,inst_31845);
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31881__$1,(15),out,inst_31869);
} else {
if((state_val_31882 === (2))){
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31881__$1,(4),ch);
} else {
if((state_val_31882 === (11))){
var inst_31861 = (state_31881[(2)]);
var inst_31862 = (new Array(n));
var inst_31845 = inst_31862;
var inst_31846 = (0);
var state_31881__$1 = (function (){var statearr_31893 = state_31881;
(statearr_31893[(7)] = inst_31846);

(statearr_31893[(8)] = inst_31845);

(statearr_31893[(10)] = inst_31861);

return statearr_31893;
})();
var statearr_31894_31924 = state_31881__$1;
(statearr_31894_31924[(2)] = null);

(statearr_31894_31924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (9))){
var inst_31845 = (state_31881[(8)]);
var inst_31859 = cljs.core.vec.call(null,inst_31845);
var state_31881__$1 = state_31881;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31881__$1,(11),out,inst_31859);
} else {
if((state_val_31882 === (5))){
var inst_31846 = (state_31881[(7)]);
var inst_31845 = (state_31881[(8)]);
var inst_31854 = (state_31881[(11)]);
var inst_31849 = (state_31881[(9)]);
var inst_31853 = (inst_31845[inst_31846] = inst_31849);
var inst_31854__$1 = (inst_31846 + (1));
var inst_31855 = (inst_31854__$1 < n);
var state_31881__$1 = (function (){var statearr_31895 = state_31881;
(statearr_31895[(12)] = inst_31853);

(statearr_31895[(11)] = inst_31854__$1);

return statearr_31895;
})();
if(cljs.core.truth_(inst_31855)){
var statearr_31896_31925 = state_31881__$1;
(statearr_31896_31925[(1)] = (8));

} else {
var statearr_31897_31926 = state_31881__$1;
(statearr_31897_31926[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (14))){
var inst_31874 = (state_31881[(2)]);
var inst_31875 = cljs.core.async.close_BANG_.call(null,out);
var state_31881__$1 = (function (){var statearr_31899 = state_31881;
(statearr_31899[(13)] = inst_31874);

return statearr_31899;
})();
var statearr_31900_31927 = state_31881__$1;
(statearr_31900_31927[(2)] = inst_31875);

(statearr_31900_31927[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (10))){
var inst_31865 = (state_31881[(2)]);
var state_31881__$1 = state_31881;
var statearr_31901_31928 = state_31881__$1;
(statearr_31901_31928[(2)] = inst_31865);

(statearr_31901_31928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31882 === (8))){
var inst_31845 = (state_31881[(8)]);
var inst_31854 = (state_31881[(11)]);
var tmp31898 = inst_31845;
var inst_31845__$1 = tmp31898;
var inst_31846 = inst_31854;
var state_31881__$1 = (function (){var statearr_31902 = state_31881;
(statearr_31902[(7)] = inst_31846);

(statearr_31902[(8)] = inst_31845__$1);

return statearr_31902;
})();
var statearr_31903_31929 = state_31881__$1;
(statearr_31903_31929[(2)] = null);

(statearr_31903_31929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___31915,out))
;
return ((function (switch__29105__auto__,c__29219__auto___31915,out){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_31907 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31907[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_31907[(1)] = (1));

return statearr_31907;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31881){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e31908){if((e31908 instanceof Object)){
var ex__29109__auto__ = e31908;
var statearr_31909_31930 = state_31881;
(statearr_31909_31930[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31881);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31908;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31931 = state_31881;
state_31881 = G__31931;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31881){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___31915,out))
})();
var state__29221__auto__ = (function (){var statearr_31910 = f__29220__auto__.call(null);
(statearr_31910[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___31915);

return statearr_31910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___31915,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args31932 = [];
var len__27753__auto___32006 = arguments.length;
var i__27754__auto___32007 = (0);
while(true){
if((i__27754__auto___32007 < len__27753__auto___32006)){
args31932.push((arguments[i__27754__auto___32007]));

var G__32008 = (i__27754__auto___32007 + (1));
i__27754__auto___32007 = G__32008;
continue;
} else {
}
break;
}

var G__31934 = args31932.length;
switch (G__31934) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31932.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29219__auto___32010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___32010,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___32010,out){
return (function (state_31976){
var state_val_31977 = (state_31976[(1)]);
if((state_val_31977 === (7))){
var inst_31972 = (state_31976[(2)]);
var state_31976__$1 = state_31976;
var statearr_31978_32011 = state_31976__$1;
(statearr_31978_32011[(2)] = inst_31972);

(statearr_31978_32011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (1))){
var inst_31935 = [];
var inst_31936 = inst_31935;
var inst_31937 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_31976__$1 = (function (){var statearr_31979 = state_31976;
(statearr_31979[(7)] = inst_31937);

(statearr_31979[(8)] = inst_31936);

return statearr_31979;
})();
var statearr_31980_32012 = state_31976__$1;
(statearr_31980_32012[(2)] = null);

(statearr_31980_32012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (4))){
var inst_31940 = (state_31976[(9)]);
var inst_31940__$1 = (state_31976[(2)]);
var inst_31941 = (inst_31940__$1 == null);
var inst_31942 = cljs.core.not.call(null,inst_31941);
var state_31976__$1 = (function (){var statearr_31981 = state_31976;
(statearr_31981[(9)] = inst_31940__$1);

return statearr_31981;
})();
if(inst_31942){
var statearr_31982_32013 = state_31976__$1;
(statearr_31982_32013[(1)] = (5));

} else {
var statearr_31983_32014 = state_31976__$1;
(statearr_31983_32014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (15))){
var inst_31966 = (state_31976[(2)]);
var state_31976__$1 = state_31976;
var statearr_31984_32015 = state_31976__$1;
(statearr_31984_32015[(2)] = inst_31966);

(statearr_31984_32015[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (13))){
var state_31976__$1 = state_31976;
var statearr_31985_32016 = state_31976__$1;
(statearr_31985_32016[(2)] = null);

(statearr_31985_32016[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (6))){
var inst_31936 = (state_31976[(8)]);
var inst_31961 = inst_31936.length;
var inst_31962 = (inst_31961 > (0));
var state_31976__$1 = state_31976;
if(cljs.core.truth_(inst_31962)){
var statearr_31986_32017 = state_31976__$1;
(statearr_31986_32017[(1)] = (12));

} else {
var statearr_31987_32018 = state_31976__$1;
(statearr_31987_32018[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (3))){
var inst_31974 = (state_31976[(2)]);
var state_31976__$1 = state_31976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31976__$1,inst_31974);
} else {
if((state_val_31977 === (12))){
var inst_31936 = (state_31976[(8)]);
var inst_31964 = cljs.core.vec.call(null,inst_31936);
var state_31976__$1 = state_31976;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31976__$1,(15),out,inst_31964);
} else {
if((state_val_31977 === (2))){
var state_31976__$1 = state_31976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31976__$1,(4),ch);
} else {
if((state_val_31977 === (11))){
var inst_31944 = (state_31976[(10)]);
var inst_31940 = (state_31976[(9)]);
var inst_31954 = (state_31976[(2)]);
var inst_31955 = [];
var inst_31956 = inst_31955.push(inst_31940);
var inst_31936 = inst_31955;
var inst_31937 = inst_31944;
var state_31976__$1 = (function (){var statearr_31988 = state_31976;
(statearr_31988[(11)] = inst_31954);

(statearr_31988[(7)] = inst_31937);

(statearr_31988[(8)] = inst_31936);

(statearr_31988[(12)] = inst_31956);

return statearr_31988;
})();
var statearr_31989_32019 = state_31976__$1;
(statearr_31989_32019[(2)] = null);

(statearr_31989_32019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (9))){
var inst_31936 = (state_31976[(8)]);
var inst_31952 = cljs.core.vec.call(null,inst_31936);
var state_31976__$1 = state_31976;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31976__$1,(11),out,inst_31952);
} else {
if((state_val_31977 === (5))){
var inst_31937 = (state_31976[(7)]);
var inst_31944 = (state_31976[(10)]);
var inst_31940 = (state_31976[(9)]);
var inst_31944__$1 = f.call(null,inst_31940);
var inst_31945 = cljs.core._EQ_.call(null,inst_31944__$1,inst_31937);
var inst_31946 = cljs.core.keyword_identical_QMARK_.call(null,inst_31937,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_31947 = (inst_31945) || (inst_31946);
var state_31976__$1 = (function (){var statearr_31990 = state_31976;
(statearr_31990[(10)] = inst_31944__$1);

return statearr_31990;
})();
if(cljs.core.truth_(inst_31947)){
var statearr_31991_32020 = state_31976__$1;
(statearr_31991_32020[(1)] = (8));

} else {
var statearr_31992_32021 = state_31976__$1;
(statearr_31992_32021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (14))){
var inst_31969 = (state_31976[(2)]);
var inst_31970 = cljs.core.async.close_BANG_.call(null,out);
var state_31976__$1 = (function (){var statearr_31994 = state_31976;
(statearr_31994[(13)] = inst_31969);

return statearr_31994;
})();
var statearr_31995_32022 = state_31976__$1;
(statearr_31995_32022[(2)] = inst_31970);

(statearr_31995_32022[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (10))){
var inst_31959 = (state_31976[(2)]);
var state_31976__$1 = state_31976;
var statearr_31996_32023 = state_31976__$1;
(statearr_31996_32023[(2)] = inst_31959);

(statearr_31996_32023[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31977 === (8))){
var inst_31936 = (state_31976[(8)]);
var inst_31944 = (state_31976[(10)]);
var inst_31940 = (state_31976[(9)]);
var inst_31949 = inst_31936.push(inst_31940);
var tmp31993 = inst_31936;
var inst_31936__$1 = tmp31993;
var inst_31937 = inst_31944;
var state_31976__$1 = (function (){var statearr_31997 = state_31976;
(statearr_31997[(7)] = inst_31937);

(statearr_31997[(8)] = inst_31936__$1);

(statearr_31997[(14)] = inst_31949);

return statearr_31997;
})();
var statearr_31998_32024 = state_31976__$1;
(statearr_31998_32024[(2)] = null);

(statearr_31998_32024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___32010,out))
;
return ((function (switch__29105__auto__,c__29219__auto___32010,out){
return (function() {
var cljs$core$async$state_machine__29106__auto__ = null;
var cljs$core$async$state_machine__29106__auto____0 = (function (){
var statearr_32002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32002[(0)] = cljs$core$async$state_machine__29106__auto__);

(statearr_32002[(1)] = (1));

return statearr_32002;
});
var cljs$core$async$state_machine__29106__auto____1 = (function (state_31976){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_31976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e32003){if((e32003 instanceof Object)){
var ex__29109__auto__ = e32003;
var statearr_32004_32025 = state_31976;
(statearr_32004_32025[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31976);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32026 = state_31976;
state_31976 = G__32026;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
cljs$core$async$state_machine__29106__auto__ = function(state_31976){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29106__auto____1.call(this,state_31976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29106__auto____0;
cljs$core$async$state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29106__auto____1;
return cljs$core$async$state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___32010,out))
})();
var state__29221__auto__ = (function (){var statearr_32005 = f__29220__auto__.call(null);
(statearr_32005[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___32010);

return statearr_32005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___32010,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1475875128718