// Compiled by ClojureScript 1.9.229 {}
goog.provide('re_com.typeahead');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('re_com.misc');
goog.require('re_com.util');
goog.require('re_com.popover');
goog.require('re_com.box');
goog.require('re_com.validate');
goog.require('reagent.core');
goog.require('goog.events.KeyCodes');
re_com.typeahead.typeahead_args_desc = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null)," supplies suggestion objects. This can either accept a single string argument (the search term), or a string and a callback. For the first case, the fn should return a collection of suggestion objects (which can be anything). For the second case, the fn should return ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil"], null),", and eventually result in a call to the callback with a collection of suggestion objects."], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"string -> nil",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":change-on-blur?"], null)," controls when it is called. It is passed a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, invoke ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-change"], null)," when the use chooses a suggestion, otherwise invoke it on every change (navigating through suggestions with the mouse or keyboard, or if ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"rigid?"], null)," is also ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null),", invoke it on every character typed.)"], null)], null),cljs.core.PersistentArrayMap.fromArray([new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"object | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"The initial value of the typeahead (should match the suggestion objects returned by ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),")."], true, false),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),(250),new cljs.core.Keyword(null,"type","type",1174270348),"integer",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.integer_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"After receiving input, the typeahead will wait this many milliseconds without receiving new input before calling ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"render fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"override the rendering of the suggestion items by passing a fn that returns hiccup forms. The fn will receive two arguments: the search term, and the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"suggestion -> string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"When a suggestion is chosen, the input-text value will be set to the result of calling this fn with the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"If ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null)," the user will be allowed to choose arbitrary text input rather than a suggestion from ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),". In this case, a string will be supplied in lieu of a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"keyword",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.input_status_type_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"validation status. ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil/omitted"], null)," for normal status or one of: ",re_com.validate.input_status_types_list], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, display an icon to match ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":status"], null)," (no icon for nil)"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"displayed in status icon's tooltip"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"background text shown when empty"], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"250px",new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS width setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS height setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, the user can't interact (input anything)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS class names, space separated"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"CSS style map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.css_style_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS styles to add or override"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"HTML attr map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.html_attr_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"HTML attributes, like ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-mouse-move"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),"No ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":class"], null)," or ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":style"], null),"allowed"], null)], null)], null);

/**
 * Return an initial value for the typeahead state, given `args`.
 */
re_com.typeahead.make_typeahead_state = (function re_com$typeahead$make_typeahead_state(p__32212){
var map__32216 = p__32212;
var map__32216__$1 = ((((!((map__32216 == null)))?((((map__32216.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32216.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32216):map__32216);
var args = map__32216__$1;
var on_change = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var rigid_QMARK_ = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var data_source = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var suggestion_to_string = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var debounce_delay = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982));
var model = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"model","model",331153215));
var external_model_value = re_com.util.deref_or_value.call(null,model);
var G__32218 = (function (){var c_input = cljs.core.async.chan.call(null);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"c-search","c-search",1832536180),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"c-input","c-input",-1821004232),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"external-model","external-model",506095421),new cljs.core.Keyword(null,"model","model",331153215)],[false,(function (){var or__26570__auto__ = suggestion_to_string;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return cljs.core.str;
}
})(),false,"",rigid_QMARK_,data_source,re_com.typeahead.debounce.call(null,c_input,debounce_delay),change_on_blur_QMARK_,cljs.core.PersistentVector.EMPTY,c_input,on_change,re_com.util.deref_or_value.call(null,model),re_com.util.deref_or_value.call(null,model)]);
})();
if(cljs.core.truth_(external_model_value)){
return re_com.typeahead.display_suggestion.call(null,G__32218,external_model_value);
} else {
return G__32218;
}
});
/**
 * Should `event` update the `typeahead` `model`?
 */
re_com.typeahead.event_updates_model_QMARK_ = (function re_com$typeahead$event_updates_model_QMARK_(p__32219,event){
var map__32223 = p__32219;
var map__32223__$1 = ((((!((map__32223 == null)))?((((map__32223.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32223.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32223):map__32223);
var state = map__32223__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__32223__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var rigid_QMARK_ = cljs.core.get.call(null,map__32223__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var rigid_QMARK___$1 = re_com.util.deref_or_value.call(null,rigid_QMARK_);
var G__32225 = (((event instanceof cljs.core.Keyword))?event.fqn:null);
switch (G__32225) {
case "input-text-blurred":
var and__26558__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(and__26558__auto__)){
return cljs.core.not.call(null,rigid_QMARK___$1);
} else {
return and__26558__auto__;
}

break;
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
case "input-text-changed":
return cljs.core.not.call(null,(function (){var or__26570__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return rigid_QMARK___$1;
}
})());

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(event)].join('')));

}
});
/**
 * Should `event` cause the `input-text` value to be used to show the active suggestion?
 */
re_com.typeahead.event_displays_suggestion_QMARK_ = (function re_com$typeahead$event_displays_suggestion_QMARK_(p__32227,event){
var map__32231 = p__32227;
var map__32231__$1 = ((((!((map__32231 == null)))?((((map__32231.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32231.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32231):map__32231);
var state = map__32231__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__32231__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var G__32233 = (((event instanceof cljs.core.Keyword))?event.fqn:null);
switch (G__32233) {
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
default:
return false;

}
});
/**
 * Change the `typeahead` `model` value to `new-value`
 */
re_com.typeahead.update_model = (function re_com$typeahead$update_model(p__32235,new_value){
var map__32238 = p__32235;
var map__32238__$1 = ((((!((map__32238 == null)))?((((map__32238.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32238.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32238):map__32238);
var state = map__32238__$1;
var on_change = cljs.core.get.call(null,map__32238__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
if(cljs.core.truth_(on_change)){
on_change.call(null,new_value);
} else {
}

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"model","model",331153215),new_value);
});
/**
 * Change the `input-text` `model` to the string representation of `suggestion`
 */
re_com.typeahead.display_suggestion = (function re_com$typeahead$display_suggestion(p__32240,suggestion){
var map__32244 = p__32240;
var map__32244__$1 = ((((!((map__32244 == null)))?((((map__32244.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32244.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32244):map__32244);
var state = map__32244__$1;
var suggestion_to_string = cljs.core.get.call(null,map__32244__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var suggestion_string = suggestion_to_string.call(null,suggestion);
var G__32246 = state;
if(cljs.core.truth_(suggestion_string)){
return cljs.core.assoc.call(null,G__32246,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),suggestion_string,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),true);
} else {
return G__32246;
}
});
re_com.typeahead.clear_suggestions = (function re_com$typeahead$clear_suggestions(state){
return cljs.core.dissoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
});
/**
 * Make the suggestion at `index` the active suggestion
 */
re_com.typeahead.activate_suggestion_by_index = (function re_com$typeahead$activate_suggestion_by_index(p__32247,index){
var map__32251 = p__32247;
var map__32251__$1 = ((((!((map__32251 == null)))?((((map__32251.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32251.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32251):map__32251);
var state = map__32251__$1;
var suggestions = cljs.core.get.call(null,map__32251__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
var G__32253 = state;
var G__32253__$1 = cljs.core.assoc.call(null,G__32253,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),index)
;
var G__32253__$2 = (cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))?re_com.typeahead.update_model.call(null,G__32253__$1,suggestion):G__32253__$1);
if(cljs.core.truth_(re_com.typeahead.event_displays_suggestion_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))){
return re_com.typeahead.display_suggestion.call(null,G__32253__$2,suggestion);
} else {
return G__32253__$2;
}
});
/**
 * Choose the suggestion at `index`
 */
re_com.typeahead.choose_suggestion_by_index = (function re_com$typeahead$choose_suggestion_by_index(p__32254,index){
var map__32257 = p__32254;
var map__32257__$1 = ((((!((map__32257 == null)))?((((map__32257.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32257.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32257):map__32257);
var state = map__32257__$1;
var suggestions = cljs.core.get.call(null,map__32257__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,re_com.typeahead.activate_suggestion_by_index.call(null,state,index),suggestion),suggestion));
});
re_com.typeahead.choose_suggestion_active = (function re_com$typeahead$choose_suggestion_active(p__32259){
var map__32263 = p__32259;
var map__32263__$1 = ((((!((map__32263 == null)))?((((map__32263.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32263.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32263):map__32263);
var state = map__32263__$1;
var suggestion_active_index = cljs.core.get.call(null,map__32263__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__32265 = state;
if(cljs.core.truth_(suggestion_active_index)){
return re_com.typeahead.choose_suggestion_by_index.call(null,G__32265,suggestion_active_index);
} else {
return G__32265;
}
});
re_com.typeahead.wrap = (function re_com$typeahead$wrap(index,count){
return cljs.core.mod.call(null,(count + index),count);
});
re_com.typeahead.activate_suggestion_next = (function re_com$typeahead$activate_suggestion_next(p__32266){
var map__32270 = p__32266;
var map__32270__$1 = ((((!((map__32270 == null)))?((((map__32270.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32270.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32270):map__32270);
var state = map__32270__$1;
var suggestions = cljs.core.get.call(null,map__32270__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__32270__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__32272 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__32272,re_com.typeahead.wrap.call(null,((function (){var or__26570__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return (-1);
}
})() + (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__32272;
}
});
re_com.typeahead.activate_suggestion_prev = (function re_com$typeahead$activate_suggestion_prev(p__32273){
var map__32277 = p__32273;
var map__32277__$1 = ((((!((map__32277 == null)))?((((map__32277.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32277.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32277):map__32277);
var state = map__32277__$1;
var suggestions = cljs.core.get.call(null,map__32277__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__32277__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__32279 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__32279,re_com.typeahead.wrap.call(null,((function (){var or__26570__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return (0);
}
})() - (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__32279;
}
});
re_com.typeahead.reset_typeahead = (function re_com$typeahead$reset_typeahead(state){
var G__32281 = state;
var G__32281__$1 = re_com.typeahead.clear_suggestions.call(null,G__32281)
;
var G__32281__$2 = cljs.core.assoc.call(null,G__32281__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),"",new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__32281__$2,null);
} else {
return G__32281__$2;
}
});
/**
 * Update state when new suggestions are available
 */
re_com.typeahead.got_suggestions = (function re_com$typeahead$got_suggestions(state,suggestions){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),suggestions,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),null);
});
/**
 * Update state when the `input-text` is about to lose focus.
 */
re_com.typeahead.input_text_will_blur = (function re_com$typeahead$input_text_will_blur(p__32282){
var map__32286 = p__32282;
var map__32286__$1 = ((((!((map__32286 == null)))?((((map__32286.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32286.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32286):map__32286);
var state = map__32286__$1;
var input_text = cljs.core.get.call(null,map__32286__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var displaying_suggestion_QMARK_ = cljs.core.get.call(null,map__32286__$1,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862));
var G__32288 = state;
if(cljs.core.truth_((function (){var and__26558__auto__ = cljs.core.not.call(null,displaying_suggestion_QMARK_);
if(and__26558__auto__){
return re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-blurred","input-text-blurred",-501892307));
} else {
return and__26558__auto__;
}
})())){
return re_com.typeahead.update_model.call(null,G__32288,input_text);
} else {
return G__32288;
}
});
/**
 * Update `state` given a new `data-source`. Resets the typeahead since any existing suggestions
 *   came from the old `data-source`.
 */
re_com.typeahead.change_data_source = (function re_com$typeahead$change_data_source(state,data_source){
return cljs.core.assoc.call(null,re_com.typeahead.reset_typeahead.call(null,state),new cljs.core.Keyword(null,"data-source","data-source",-658934676),data_source);
});
/**
 * Update state when the external model value has changed.
 */
re_com.typeahead.external_model_changed = (function re_com$typeahead$external_model_changed(state,new_value){
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,state,new_value),new_value));
});
/**
 * Call the `data-source` fn with `text`, and then call `got-suggestions` with the result
 *   (asynchronously, if `data-source` does not return a truthy value).
 */
re_com.typeahead.search_data_source_BANG_ = (function re_com$typeahead$search_data_source_BANG_(data_source,state_atom,text){
var temp__6726__auto__ = data_source.call(null,text,(function (p1__32289_SHARP_){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,p1__32289_SHARP_);
}));
if(cljs.core.truth_(temp__6726__auto__)){
var return_value = temp__6726__auto__;
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,return_value);
} else {
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),true);
}
});
/**
 * For every value arriving on the `c-search` channel, call `search-data-source!`.
 */
re_com.typeahead.search_data_source_loop_BANG_ = (function re_com$typeahead$search_data_source_loop_BANG_(state_atom,c_search){
var c__29219__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto__){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto__){
return (function (state_32339){
var state_val_32340 = (state_32339[(1)]);
if((state_val_32340 === (1))){
var state_32339__$1 = state_32339;
var statearr_32341_32356 = state_32339__$1;
(statearr_32341_32356[(2)] = null);

(statearr_32341_32356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32340 === (2))){
var state_32339__$1 = state_32339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32339__$1,(4),c_search);
} else {
if((state_val_32340 === (3))){
var inst_32337 = (state_32339[(2)]);
var state_32339__$1 = state_32339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32339__$1,inst_32337);
} else {
if((state_val_32340 === (4))){
var inst_32325 = (state_32339[(7)]);
var inst_32325__$1 = (state_32339[(2)]);
var inst_32326 = cljs.core.deref.call(null,state_atom);
var inst_32327 = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(inst_32326);
var inst_32328 = cljs.core._EQ_.call(null,"",inst_32325__$1);
var state_32339__$1 = (function (){var statearr_32342 = state_32339;
(statearr_32342[(8)] = inst_32327);

(statearr_32342[(7)] = inst_32325__$1);

return statearr_32342;
})();
if(inst_32328){
var statearr_32343_32357 = state_32339__$1;
(statearr_32343_32357[(1)] = (5));

} else {
var statearr_32344_32358 = state_32339__$1;
(statearr_32344_32358[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32340 === (5))){
var inst_32330 = cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
var state_32339__$1 = state_32339;
var statearr_32345_32359 = state_32339__$1;
(statearr_32345_32359[(2)] = inst_32330);

(statearr_32345_32359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32340 === (6))){
var inst_32327 = (state_32339[(8)]);
var inst_32325 = (state_32339[(7)]);
var inst_32332 = re_com.typeahead.search_data_source_BANG_.call(null,inst_32327,state_atom,inst_32325);
var state_32339__$1 = state_32339;
var statearr_32346_32360 = state_32339__$1;
(statearr_32346_32360[(2)] = inst_32332);

(statearr_32346_32360[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32340 === (7))){
var inst_32334 = (state_32339[(2)]);
var state_32339__$1 = (function (){var statearr_32347 = state_32339;
(statearr_32347[(9)] = inst_32334);

return statearr_32347;
})();
var statearr_32348_32361 = state_32339__$1;
(statearr_32348_32361[(2)] = null);

(statearr_32348_32361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__29219__auto__))
;
return ((function (switch__29105__auto__,c__29219__auto__){
return (function() {
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto__ = null;
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto____0 = (function (){
var statearr_32352 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32352[(0)] = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto__);

(statearr_32352[(1)] = (1));

return statearr_32352;
});
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto____1 = (function (state_32339){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_32339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e32353){if((e32353 instanceof Object)){
var ex__29109__auto__ = e32353;
var statearr_32354_32362 = state_32339;
(statearr_32354_32362[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32339);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32353;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32363 = state_32339;
state_32339 = G__32363;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto__ = function(state_32339){
switch(arguments.length){
case 0:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto____0.call(this);
case 1:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto____1.call(this,state_32339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto____0;
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto____1;
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto__))
})();
var state__29221__auto__ = (function (){var statearr_32355 = f__29220__auto__.call(null);
(statearr_32355[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto__);

return statearr_32355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto__))
);

return c__29219__auto__;
});
/**
 * Update state in response to `input-text` `on-change`, and put text on the `c-input` channel
 */
re_com.typeahead.input_text_on_change_BANG_ = (function re_com$typeahead$input_text_on_change_BANG_(state_atom,new_text){
var map__32368 = cljs.core.deref.call(null,state_atom);
var map__32368__$1 = ((((!((map__32368 == null)))?((((map__32368.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32368.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32368):map__32368);
var state = map__32368__$1;
var input_text = cljs.core.get.call(null,map__32368__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var c_input = cljs.core.get.call(null,map__32368__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
if(cljs.core._EQ_.call(null,new_text,input_text)){
return state;
} else {
if(clojure.string.blank_QMARK_.call(null,new_text)){
} else {
cljs.core.async.put_BANG_.call(null,c_input,new_text);
}

return cljs.core.swap_BANG_.call(null,state_atom,((function (map__32368,map__32368__$1,state,input_text,c_input){
return (function (p1__32364_SHARP_){
var G__32370 = p1__32364_SHARP_;
var G__32370__$1 = cljs.core.assoc.call(null,G__32370,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new_text,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__32370__$1,new_text);
} else {
return G__32370__$1;
}
});})(map__32368,map__32368__$1,state,input_text,c_input))
);
}
});
re_com.typeahead.input_text_on_key_down_BANG_ = (function re_com$typeahead$input_text_on_key_down_BANG_(state_atom,event){
var pred__32374 = cljs.core._EQ_;
var expr__32375 = event.which;
if(cljs.core.truth_(pred__32374.call(null,goog.events.KeyCodes.UP,expr__32375))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_prev);
} else {
if(cljs.core.truth_(pred__32374.call(null,goog.events.KeyCodes.DOWN,expr__32375))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);
} else {
if(cljs.core.truth_(pred__32374.call(null,goog.events.KeyCodes.ENTER,expr__32375))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_active);
} else {
if(cljs.core.truth_(pred__32374.call(null,goog.events.KeyCodes.ESC,expr__32375))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
} else {
if(cljs.core.truth_(pred__32374.call(null,goog.events.KeyCodes.TAB,expr__32375))){
if(cljs.core.truth_(cljs.core.not_empty.call(null,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state_atom))))){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);

return event.preventDefault();
} else {
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.input_text_will_blur);
}
} else {
return true;
}
}
}
}
}
});
/**
 * typeahead reagent component
 */
re_com.typeahead.typeahead = (function re_com$typeahead$typeahead(var_args){
var args__27760__auto__ = [];
var len__27753__auto___32405 = arguments.length;
var i__27754__auto___32406 = (0);
while(true){
if((i__27754__auto___32406 < len__27753__auto___32405)){
args__27760__auto__.push((arguments[i__27754__auto___32406]));

var G__32407 = (i__27754__auto___32406 + (1));
i__27754__auto___32406 = G__32407;
continue;
} else {
}
break;
}

var argseq__27761__auto__ = ((((0) < args__27760__auto__.length))?(new cljs.core.IndexedSeq(args__27760__auto__.slice((0)),(0),null)):null);
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(argseq__27761__auto__);
});

re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic = (function (p__32379){
var map__32380 = p__32379;
var map__32380__$1 = ((((!((map__32380 == null)))?((((map__32380.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32380.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32380):map__32380);
var args = map__32380__$1;
var data_source = cljs.core.get.call(null,map__32380__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var on_change = cljs.core.get.call(null,map__32380__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var rigid_QMARK_ = cljs.core.get.call(null,map__32380__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__32380__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__32382 = re_com.typeahead.make_typeahead_state.call(null,args);
var map__32382__$1 = ((((!((map__32382 == null)))?((((map__32382.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32382.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32382):map__32382);
var state = map__32382__$1;
var c_search = cljs.core.get.call(null,map__32382__$1,new cljs.core.Keyword(null,"c-search","c-search",1832536180));
var c_input = cljs.core.get.call(null,map__32382__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
var state_atom = reagent.core.atom.call(null,state);
var input_text_model = reagent.core.cursor.call(null,state_atom,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input-text","input-text",-1336297114)], null));
re_com.typeahead.search_data_source_loop_BANG_.call(null,state_atom,c_search);

return ((function (map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_){
return (function() { 
var G__32408__delegate = function (p__32384){
var map__32385 = p__32384;
var map__32385__$1 = ((((!((map__32385 == null)))?((((map__32385.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32385.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32385):map__32385);
var args__$1 = map__32385__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var status_icon_QMARK_ = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612));
var height = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var status_tooltip = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007));
var model = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"model","model",331153215));
var suggestion_to_string = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var placeholder = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var render_suggestion = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503));
var rigid_QMARK___$1 = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var width = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var data_source__$1 = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var style = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var status = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var class$ = cljs.core.get.call(null,map__32385__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args__$1,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__32387 = cljs.core.deref.call(null,state_atom);
var map__32387__$1 = ((((!((map__32387 == null)))?((((map__32387.cljs$lang$protocol_mask$partition0$ & (64))) || (map__32387.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32387):map__32387);
var state__$1 = map__32387__$1;
var suggestions = cljs.core.get.call(null,map__32387__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var waiting_QMARK_ = cljs.core.get.call(null,map__32387__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var suggestion_active_index = cljs.core.get.call(null,map__32387__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var external_model = cljs.core.get.call(null,map__32387__$1,new cljs.core.Keyword(null,"external-model","external-model",506095421));
var last_data_source = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(state__$1);
var latest_external_model = re_com.util.deref_or_value.call(null,model);
var width__$1 = (function (){var or__26570__auto__ = width;
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return "250px";
}
})();
if(cljs.core.not_EQ_.call(null,last_data_source,data_source__$1)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.change_data_source,data_source__$1);
} else {
}

if(cljs.core.not_EQ_.call(null,latest_external_model,external_model)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.external_model_changed,latest_external_model);
} else {
}

return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.input_text,new cljs.core.Keyword(null,"model","model",331153215),input_text_model,new cljs.core.Keyword(null,"class","class",-2030961996),class$,new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),status_icon_QMARK_,new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),status_tooltip,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,re_com.typeahead.input_text_on_change_BANG_,state_atom),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),false,new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-key-down","on-key-down",-1374733765),cljs.core.partial.call(null,re_com.typeahead.input_text_on_key_down_BANG_,state_atom)], null)], null),(cljs.core.truth_((function (){var or__26570__auto__ = cljs.core.not_empty.call(null,suggestions);
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
return waiting_QMARK_;
}
})())?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-suggestions-container",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"align","align",1964212802),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.throbber,new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"small","small",2133478704),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-throbber"], null)], null):null),(function (){var iter__27424__auto__ = ((function (map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_){
return (function re_com$typeahead$iter__32389(s__32390){
return (new cljs.core.LazySeq(null,((function (map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_){
return (function (){
var s__32390__$1 = s__32390;
while(true){
var temp__6728__auto__ = cljs.core.seq.call(null,s__32390__$1);
if(temp__6728__auto__){
var s__32390__$2 = temp__6728__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__32390__$2)){
var c__27422__auto__ = cljs.core.chunk_first.call(null,s__32390__$2);
var size__27423__auto__ = cljs.core.count.call(null,c__27422__auto__);
var b__32392 = cljs.core.chunk_buffer.call(null,size__27423__auto__);
if((function (){var i__32391 = (0);
while(true){
if((i__32391 < size__27423__auto__)){
var vec__32399 = cljs.core._nth.call(null,c__27422__auto__,i__32391);
var i = cljs.core.nth.call(null,vec__32399,(0),null);
var s = cljs.core.nth.call(null,vec__32399,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
cljs.core.chunk_append.call(null,b__32392,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str("rc-typeahead-suggestion"),cljs.core.str(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (i__32391,selected_QMARK_,vec__32399,i,s,c__27422__auto__,size__27423__auto__,b__32392,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(i__32391,selected_QMARK_,vec__32399,i,s,c__27422__auto__,size__27423__auto__,b__32392,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (i__32391,selected_QMARK_,vec__32399,i,s,c__27422__auto__,size__27423__auto__,b__32392,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_){
return (function (p1__32377_SHARP_){
p1__32377_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(i__32391,selected_QMARK_,vec__32399,i,s,c__27422__auto__,size__27423__auto__,b__32392,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)));

var G__32409 = (i__32391 + (1));
i__32391 = G__32409;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32392),re_com$typeahead$iter__32389.call(null,cljs.core.chunk_rest.call(null,s__32390__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__32392),null);
}
} else {
var vec__32402 = cljs.core.first.call(null,s__32390__$2);
var i = cljs.core.nth.call(null,vec__32402,(0),null);
var s = cljs.core.nth.call(null,vec__32402,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),[cljs.core.str("rc-typeahead-suggestion"),cljs.core.str(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (selected_QMARK_,vec__32402,i,s,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(selected_QMARK_,vec__32402,i,s,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (selected_QMARK_,vec__32402,i,s,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_){
return (function (p1__32377_SHARP_){
p1__32377_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(selected_QMARK_,vec__32402,i,s,s__32390__$2,temp__6728__auto__,map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)),re_com$typeahead$iter__32389.call(null,cljs.core.rest.call(null,s__32390__$2)));
}
} else {
return null;
}
break;
}
});})(map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_))
,null,null));
});})(map__32387,map__32387__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__32385,map__32385__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,suggestion_to_string,placeholder,render_suggestion,rigid_QMARK___$1,width,data_source__$1,style,status,class$,map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_))
;
return iter__27424__auto__.call(null,cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),suggestions));
})()], null)], null):null)], null)], null);
};
var G__32408 = function (var_args){
var p__32384 = null;
if (arguments.length > 0) {
var G__32410__i = 0, G__32410__a = new Array(arguments.length -  0);
while (G__32410__i < G__32410__a.length) {G__32410__a[G__32410__i] = arguments[G__32410__i + 0]; ++G__32410__i;}
  p__32384 = new cljs.core.IndexedSeq(G__32410__a,0);
} 
return G__32408__delegate.call(this,p__32384);};
G__32408.cljs$lang$maxFixedArity = 0;
G__32408.cljs$lang$applyTo = (function (arglist__32411){
var p__32384 = cljs.core.seq(arglist__32411);
return G__32408__delegate(p__32384);
});
G__32408.cljs$core$IFn$_invoke$arity$variadic = G__32408__delegate;
return G__32408;
})()
;
;})(map__32382,map__32382__$1,state,c_search,c_input,state_atom,input_text_model,map__32380,map__32380__$1,args,data_source,on_change,rigid_QMARK_,change_on_blur_QMARK_))
});

re_com.typeahead.typeahead.cljs$lang$maxFixedArity = (0);

re_com.typeahead.typeahead.cljs$lang$applyTo = (function (seq32378){
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32378));
});

/**
 * Return a channel which will receive a value from the `in` channel only
 *   if no further value is received on the `in` channel in the next `ms` milliseconds.
 */
re_com.typeahead.debounce = (function re_com$typeahead$debounce(in$,ms){
var out = cljs.core.async.chan.call(null);
var c__29219__auto___32578 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29219__auto___32578,out){
return (function (){
var f__29220__auto__ = (function (){var switch__29105__auto__ = ((function (c__29219__auto___32578,out){
return (function (state_32545){
var state_val_32546 = (state_32545[(1)]);
if((state_val_32546 === (7))){
var inst_32500 = (state_32545[(2)]);
var state_32545__$1 = state_32545;
var statearr_32547_32579 = state_32545__$1;
(statearr_32547_32579[(2)] = inst_32500);

(statearr_32547_32579[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (1))){
var inst_32495 = null;
var state_32545__$1 = (function (){var statearr_32548 = state_32545;
(statearr_32548[(7)] = inst_32495);

return statearr_32548;
})();
var statearr_32549_32580 = state_32545__$1;
(statearr_32549_32580[(2)] = null);

(statearr_32549_32580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (4))){
var state_32545__$1 = state_32545;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32545__$1,(7),in$);
} else {
if((state_val_32546 === (15))){
var inst_32530 = (state_32545[(2)]);
var state_32545__$1 = (function (){var statearr_32550 = state_32545;
(statearr_32550[(8)] = inst_32530);

return statearr_32550;
})();
var statearr_32551_32581 = state_32545__$1;
(statearr_32551_32581[(2)] = null);

(statearr_32551_32581[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (13))){
var inst_32518 = (state_32545[(9)]);
var inst_32532 = cljs.core._EQ_.call(null,inst_32518,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_32545__$1 = state_32545;
if(inst_32532){
var statearr_32552_32582 = state_32545__$1;
(statearr_32552_32582[(1)] = (16));

} else {
var statearr_32553_32583 = state_32545__$1;
(statearr_32553_32583[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (6))){
var inst_32504 = (state_32545[(10)]);
var inst_32503 = (state_32545[(2)]);
var inst_32504__$1 = cljs.core.async.timeout.call(null,ms);
var inst_32512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32513 = [in$,inst_32504__$1];
var inst_32514 = (new cljs.core.PersistentVector(null,2,(5),inst_32512,inst_32513,null));
var state_32545__$1 = (function (){var statearr_32554 = state_32545;
(statearr_32554[(10)] = inst_32504__$1);

(statearr_32554[(11)] = inst_32503);

return statearr_32554;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_32545__$1,(8),inst_32514);
} else {
if((state_val_32546 === (17))){
var state_32545__$1 = state_32545;
var statearr_32555_32584 = state_32545__$1;
(statearr_32555_32584[(2)] = null);

(statearr_32555_32584[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (3))){
var inst_32543 = (state_32545[(2)]);
var state_32545__$1 = state_32545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32545__$1,inst_32543);
} else {
if((state_val_32546 === (12))){
var inst_32503 = (state_32545[(11)]);
var state_32545__$1 = state_32545;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32545__$1,(15),out,inst_32503);
} else {
if((state_val_32546 === (2))){
var inst_32495 = (state_32545[(7)]);
var inst_32497 = (inst_32495 == null);
var state_32545__$1 = state_32545;
if(cljs.core.truth_(inst_32497)){
var statearr_32556_32585 = state_32545__$1;
(statearr_32556_32585[(1)] = (4));

} else {
var statearr_32557_32586 = state_32545__$1;
(statearr_32557_32586[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (11))){
var inst_32540 = (state_32545[(2)]);
var inst_32495 = inst_32540;
var state_32545__$1 = (function (){var statearr_32558 = state_32545;
(statearr_32558[(7)] = inst_32495);

return statearr_32558;
})();
var statearr_32559_32587 = state_32545__$1;
(statearr_32559_32587[(2)] = null);

(statearr_32559_32587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (9))){
var inst_32516 = (state_32545[(12)]);
var inst_32524 = cljs.core.nth.call(null,inst_32516,(0),null);
var inst_32525 = cljs.core.nth.call(null,inst_32516,(1),null);
var state_32545__$1 = (function (){var statearr_32560 = state_32545;
(statearr_32560[(13)] = inst_32525);

return statearr_32560;
})();
var statearr_32561_32588 = state_32545__$1;
(statearr_32561_32588[(2)] = inst_32524);

(statearr_32561_32588[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (5))){
var inst_32495 = (state_32545[(7)]);
var state_32545__$1 = state_32545;
var statearr_32562_32589 = state_32545__$1;
(statearr_32562_32589[(2)] = inst_32495);

(statearr_32562_32589[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (14))){
var inst_32538 = (state_32545[(2)]);
var state_32545__$1 = state_32545;
var statearr_32563_32590 = state_32545__$1;
(statearr_32563_32590[(2)] = inst_32538);

(statearr_32563_32590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (16))){
var inst_32517 = (state_32545[(14)]);
var state_32545__$1 = state_32545;
var statearr_32564_32591 = state_32545__$1;
(statearr_32564_32591[(2)] = inst_32517);

(statearr_32564_32591[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (10))){
var inst_32518 = (state_32545[(9)]);
var inst_32504 = (state_32545[(10)]);
var inst_32527 = cljs.core._EQ_.call(null,inst_32518,inst_32504);
var state_32545__$1 = state_32545;
if(inst_32527){
var statearr_32565_32592 = state_32545__$1;
(statearr_32565_32592[(1)] = (12));

} else {
var statearr_32566_32593 = state_32545__$1;
(statearr_32566_32593[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (18))){
var inst_32536 = (state_32545[(2)]);
var state_32545__$1 = state_32545;
var statearr_32567_32594 = state_32545__$1;
(statearr_32567_32594[(2)] = inst_32536);

(statearr_32567_32594[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32546 === (8))){
var inst_32518 = (state_32545[(9)]);
var inst_32516 = (state_32545[(12)]);
var inst_32516__$1 = (state_32545[(2)]);
var inst_32517 = cljs.core.nth.call(null,inst_32516__$1,(0),null);
var inst_32518__$1 = cljs.core.nth.call(null,inst_32516__$1,(1),null);
var inst_32519 = cljs.core._EQ_.call(null,inst_32518__$1,in$);
var state_32545__$1 = (function (){var statearr_32568 = state_32545;
(statearr_32568[(14)] = inst_32517);

(statearr_32568[(9)] = inst_32518__$1);

(statearr_32568[(12)] = inst_32516__$1);

return statearr_32568;
})();
if(inst_32519){
var statearr_32569_32595 = state_32545__$1;
(statearr_32569_32595[(1)] = (9));

} else {
var statearr_32570_32596 = state_32545__$1;
(statearr_32570_32596[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29219__auto___32578,out))
;
return ((function (switch__29105__auto__,c__29219__auto___32578,out){
return (function() {
var re_com$typeahead$debounce_$_state_machine__29106__auto__ = null;
var re_com$typeahead$debounce_$_state_machine__29106__auto____0 = (function (){
var statearr_32574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32574[(0)] = re_com$typeahead$debounce_$_state_machine__29106__auto__);

(statearr_32574[(1)] = (1));

return statearr_32574;
});
var re_com$typeahead$debounce_$_state_machine__29106__auto____1 = (function (state_32545){
while(true){
var ret_value__29107__auto__ = (function (){try{while(true){
var result__29108__auto__ = switch__29105__auto__.call(null,state_32545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29108__auto__;
}
break;
}
}catch (e32575){if((e32575 instanceof Object)){
var ex__29109__auto__ = e32575;
var statearr_32576_32597 = state_32545;
(statearr_32576_32597[(5)] = ex__29109__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32545);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32575;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32598 = state_32545;
state_32545 = G__32598;
continue;
} else {
return ret_value__29107__auto__;
}
break;
}
});
re_com$typeahead$debounce_$_state_machine__29106__auto__ = function(state_32545){
switch(arguments.length){
case 0:
return re_com$typeahead$debounce_$_state_machine__29106__auto____0.call(this);
case 1:
return re_com$typeahead$debounce_$_state_machine__29106__auto____1.call(this,state_32545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$debounce_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$debounce_$_state_machine__29106__auto____0;
re_com$typeahead$debounce_$_state_machine__29106__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$debounce_$_state_machine__29106__auto____1;
return re_com$typeahead$debounce_$_state_machine__29106__auto__;
})()
;})(switch__29105__auto__,c__29219__auto___32578,out))
})();
var state__29221__auto__ = (function (){var statearr_32577 = f__29220__auto__.call(null);
(statearr_32577[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29219__auto___32578);

return statearr_32577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29221__auto__);
});})(c__29219__auto___32578,out))
);


return out;
});

//# sourceMappingURL=typeahead.js.map?rel=1475875130391