// Compiled by ClojureScript 1.9.229 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('reagent.impl.util');
goog.require('reagent.interop');
goog.require('reagent.ratom');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('cljsjs.react.dom');
goog.require('reagent.debug');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(cljs.core.some_QMARK_.call(null,reagent.dom.imported)){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__26570__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__26570__auto__)){
return or__26570__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_28464 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_28464){
return (function (){
var _STAR_always_update_STAR_28465 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(cljs.core.some_QMARK_.call(null,callback)){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_28465;
}});})(_STAR_always_update_STAR_28464))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_28464;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args28466 = [];
var len__27753__auto___28469 = arguments.length;
var i__27754__auto___28470 = (0);
while(true){
if((i__27754__auto___28470 < len__27753__auto___28469)){
args28466.push((arguments[i__27754__auto___28470]));

var G__28471 = (i__27754__auto___28470 + (1));
i__27754__auto___28470 = G__28471;
continue;
} else {
}
break;
}

var G__28468 = args28466.length;
switch (G__28468) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args28466.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__28477_28481 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__28478_28482 = null;
var count__28479_28483 = (0);
var i__28480_28484 = (0);
while(true){
if((i__28480_28484 < count__28479_28483)){
var v_28485 = cljs.core._nth.call(null,chunk__28478_28482,i__28480_28484);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_28485);

var G__28486 = seq__28477_28481;
var G__28487 = chunk__28478_28482;
var G__28488 = count__28479_28483;
var G__28489 = (i__28480_28484 + (1));
seq__28477_28481 = G__28486;
chunk__28478_28482 = G__28487;
count__28479_28483 = G__28488;
i__28480_28484 = G__28489;
continue;
} else {
var temp__6728__auto___28490 = cljs.core.seq.call(null,seq__28477_28481);
if(temp__6728__auto___28490){
var seq__28477_28491__$1 = temp__6728__auto___28490;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28477_28491__$1)){
var c__27473__auto___28492 = cljs.core.chunk_first.call(null,seq__28477_28491__$1);
var G__28493 = cljs.core.chunk_rest.call(null,seq__28477_28491__$1);
var G__28494 = c__27473__auto___28492;
var G__28495 = cljs.core.count.call(null,c__27473__auto___28492);
var G__28496 = (0);
seq__28477_28481 = G__28493;
chunk__28478_28482 = G__28494;
count__28479_28483 = G__28495;
i__28480_28484 = G__28496;
continue;
} else {
var v_28497 = cljs.core.first.call(null,seq__28477_28491__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_28497);

var G__28498 = cljs.core.next.call(null,seq__28477_28491__$1);
var G__28499 = null;
var G__28500 = (0);
var G__28501 = (0);
seq__28477_28481 = G__28498;
chunk__28478_28482 = G__28499;
count__28479_28483 = G__28500;
i__28480_28484 = G__28501;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map?rel=1475841535290