(ns hara.image.base.size
  (:require [hara.protocol.image :as image])
  (:import  (clojure.lang IPersistentMap
                          IPersistentVector)))

(extend-protocol image/ISize

  IPersistentVector
  (-width  [v] (first v))
  (-height [v] (second v))
  
  IPersistentMap
  (-width  [m] (:width m))
  (-height [m] (:height m)))

(defn size->map
  "converts a size to a map
 
   (size->map [100 200])
   => {:width 100, :height 200}
 
   (size->map {:width 2 :height 3})
   => {:width 2, :height 3}"
  {:added "2.8"} [size]
  {:width (image/-width size)
   :height (image/-height size)})

(defn length
  "calculates the length of the array
 
   (length {:width 2 :height 3})
   => 6
 
   (length [100 200])
   => 20000"
  {:added "2.8"}
  [size]
  (* (image/-width size) (image/-height size)))
