(ns hara.io.file.charset
  (:import (java.nio.charset Charset)))

(defn charset-default
  "returns the default charset
   
   (charset-default)
   => \"UTF-8\""
  {:added "2.4"}
  []
  (str (Charset/defaultCharset)))

(defn charset-list
  "returns the list of available charset
   
   (charset-list)
   => (\"Big5\" \"Big5-HKSCS\" ... \"x-windows-iso2022jp\")"
  {:added "2.4"}
  []
  (keys (Charset/availableCharsets)))

(defn charset
  "constructs a charset object from a string
   (charset \"UTF-8\")
   => java.nio.charset.Charset"
  {:added "2.4"}
  [s]
  (Charset/forName s))
