(ns hara.object.print
  (:require [hara.protocol.object :as object]
            [hara.object.read :as read]))

(defn assoc-print-vars
  "helper to assoc print vars in options
 
   (print/assoc-print-vars {} {:tag \"hello\"})
   => {:tag \"hello\"}"
  {:added "2.3"}
  [read {:keys [tag print display]}]
  (cond-> read
    tag   (assoc :tag tag)
    print (assoc :print print)
    display (assoc :display display)))

(defn format-value
  "formats the object into a readable string
 
   (print/format-value (test.Cat. \"fluffy\")
                       {:tag \"cat\"})
   => \"#cat{:name \"fluffy\"}\""
  {:added "2.3"}
  [v {:keys [tag print display]}]
  (str "#" (or tag (.getName ^Class (type v)))
       (let [out (if print
                   (print v)
                   (cond-> (read/to-data v)
                     display display))]
         (if (string? out)
           (str " \"" out "\"")
           out))))

(defmacro extend-print
  "extend `print-method` function for a particular class
 
   (macroexpand-1 '(print/extend-print test.Cat))"
  {:added "2.3"}
  [cls]
  `(defmethod print-method ~cls
     [~'v ^java.io.Writer w#]
     (let [read# (object/-meta-read ~cls)]
       (.write w# (format-value ~'v read#)))))
