(ns hara.protocol.image)

(defmulti -image-meta
  "additional information about the image"
  {:added "2.8"}
  (fn [cls] cls))

(defprotocol ISize
  (-height        [dim])
  (-width         [dim]))

(defprotocol IRepresentation
  (-channels   [img])
  (-size       [img])
  (-model      [img])
  (-data       [img])
  (-subimage   [img x y w h]))

(defmulti -image
  "creates an image based on inputs"
  {:added "2.8"}
  (fn [size model data type] type))

(defmulti -blank
  "creates an empty image"
  {:added "2.8"}
  (fn [size model type] type))

(defmulti -read
  "reads an image from file"
  {:added "2.8"}
  (fn [source model type] type))

(defprotocol ITransfer
  (-to-byte-gray [image])
  (-to-int-argb  [image])
  (-write   [image opts sink]))

(defmulti -display
  "displays an image"
  {:added "2.8"}
  (fn [img opts type] type))

(defmulti -display-class
  "types that are able to be displayed"
  {:added "2.8"}
  (fn [type] type))

(defprotocol ITransform
  (-op  [transform img args opts]))
