(ns hara.reflect.pretty.display
  (:require [hara.reflect.types.element :refer [to-element element?]]
            [hara.reflect.pretty.display.filter :refer [filter-terms-fn]]
            [hara.reflect.pretty.display.sort :refer [sort-terms-fn]]))

(defn first-terms-fn
  "creates a function that returns the first element of the list
   
   ((display/first-terms-fn {:first true}) [1 2 3])
   => 1"
  {:added "2.1"}
  [grp]
  (if (:first grp) first))

(defn merge-terms-fn
  "creates a function that returns the first element of the list
 
   (-> (query/query-class (type []) [\"create\"])
       ((display/merge-terms-fn {:merge true})))
   ;;=> #[create :: ([java.util.List]), ([clojure.lang.ISeq]),
   ;;               ([clojure.lang.IReduceInit]), ([java.lang.Object[]]),
   ;;               ([java.lang.Iterable])]
   "
  {:added "2.1"}
  [grp]
  (if (:merge grp)
    (fn [eles]
      (if-let [name (-> eles first :name)]
        (let [eles (take-while #(= name (:name %)) eles)]
          (if (= 1 (count eles))
            (first eles)
            (if (every? element? eles)
              (to-element (vec eles))
              (set eles))))
        (first eles)))))

(defn select-terms-fn
  "creates a function that selects terms to output
 
   (-> (query/query-class (type []) [\"create\"])
       ((display/select-terms-fn {:select-terms [:name]})))
   => [\"create\"]"
  {:added "2.1"}
  [grp]
  (let [sterms (sort (:select-terms grp))]
    (fn [eles]
      (condp = (count sterms)
        0 eles
        1 (distinct (map (first sterms) eles))
        (map #(select-keys (get % nil) sterms) eles)))))

(defn display
  "formats an output for 
 
   (->> (query/query-class (type []) [\"create\"])
        (display {:select-terms [:params]}))
   ;;=> ([java.util.List] [clojure.lang.ISeq]
   ;;    [clojure.lang.IReduceInit] [[Ljava.lang.Object;]
   ;;    [java.lang.Iterable])
   "
  {:added "2.1"}
  [grp eles]
  ((comp
    (or (merge-terms-fn grp) (first-terms-fn grp) identity)
    (select-terms-fn grp)
    (sort-terms-fn grp)
    (filter-terms-fn grp))
   eles))

