(ns lucid.aether.base
  (:require [lucid.aether
             [listener :as listener]
             [session :as session]
             [system :as system]]))

(def +defaults+
  {:listeners {:transfer listener/blank-transfer-listener
               :repository listener/default-repository-listener}
   :repositories [{:id "clojars"
                   :type "default"
                   :url "https://clojars.org/repo"}
                  {:id "central"
                   :type "default"
                   :url "https://repo1.maven.org/maven2/"}]})

(defrecord Aether [])

(defmethod print-method Aether
  [v w]
  (.write w (str "#aether" (into {} v))))

(defn aether
  "creates an `Aether` object
 
   (aether)
   => (contains
       {:repositories [{:id \"clojars\",
                        :type \"default\",
                        :url \"https://clojars.org/repo\"}
                       {:id \"central\",
                       :type \"default\",
                        :url \"https://repo1.maven.org/maven2/\"}],
        :system org.eclipse.aether.RepositorySystem
        :session org.eclipse.aether.RepositorySystemSession})"
  {:added "1.1"}
  ([] (aether {}))
  ([config]
   (let [system  (system/repository-system)
         session (->> (select-keys config [:local-repo])
                      (session/session system))]
     (-> +defaults+
         (merge {:system system
                 :session session})
         (map->Aether)))))

(defn flatten-values
  "can flatten out a group of values
 
   (-> (aether/resolve-hierarchy (aether) '[midje \"1.6.3\"])
       (flatten-values))
   ;;=> ([midje/midje \"1.6.3\"] ... [joda-time/joda-time \"2.2\"])
   "
  {:added "1.1"}
  [node]
  (cond (map? node)
        (cons (key (first node))
                    (flatten-values (val (first node))))
        
        (vector? node)
        (mapcat (fn [item]
                  (cond (map? item)
                        (flatten-values item)

                        (vector? item)
                        [item]))
                node)))
