(ns lucid.core.code.setup
  (:require [clojure.tools.reader.edn :as edn]
            [clojure.tools.reader.impl.commons :as common]
            [clojure.tools.reader.impl.utils :as utils]))

(try
  (require '[clojure.tools.reader.reader-types :as reader])
  (catch Throwable t))

(try
  (require '[clojure.tools.reader.impl.errors :as errors])
  (catch Throwable t))


(def reader-error @(or (resolve 'reader/reader-error)
                       (resolve 'errors/reader-error)))

(defn read-keyword
  "read-keyword function to allow for `:a/b/c`"
  {:added "1.2"}
  [reader initch opts]
  (let [ch (reader/read-char reader)]
    (if-not (utils/whitespace? ch)
      (let [token (#'edn/read-token reader ch)]
        (keyword token))
      (reader-error reader "Invalid token: :"))))

(defn patch-read-keyword
  "patched the original keyword function for `reader/read-keyword`"
  {:added "1.2"}
  []
  (alter-var-root #'clojure.tools.reader.edn/read-keyword
                  (fn [_]
                    read-keyword)))

(defonce ^:dynamic *patched* (patch-read-keyword))
