(ns lucid.insight
  (:require [lucid.insight.bundle :as bundle]
            [lucid.insight.viewer :as viewer]))

(defn insight
  "creates a viewer for the bundle"
  {:added "0.1"}
  ([] (insight [#"src"] {}))
  ([selectors] (insight selectors {}))
  ([selectors options]
   (let [selectors (cond (map? selectors)
                         selectors

                         (vector? selectors)
                         {:include selectors}
                         
                         :else
                         {:include [selectors]}) 
         bundle (bundle/bundle selectors)
         viewer (viewer/viewer {:bundle bundle}
                               options)]
     viewer)))
