(ns lucid.legacy.analyzer.ast.query
  "Utilities for querying tools.analyzer ASTs with Datomic"
  (:require [lucid.legacy.analyzer.ast :as ast]
            [lucid.legacy.analyzer.utils :refer [compile-if]]))

(defn query-map
  ""
  [query]
  (if (map? query)
    query
    (loop [ret {:find [] :in [] :where []} query query op nil]
      (if (seq query)
        (let [[el & query] query]
          (if (keyword? el)
            (recur ret query el)
            (recur (update-in ret [op] conj el) query op)))
        (reduce-kv (fn [m k v] (if (seq v) (assoc m k v) m)) {} ret)))))

(defn unfold-expression-clauses
  ""
  [query]
  (let [{:keys [where] :as query} (query-map query)]
    (if-not where
      query
      (assoc query :where
             (mapcat (fn [[op & rest :as form]]
                       (if-let [[f & args] (and (seq? op) op)]
                         (if (some seq? args)
                           (loop [args args to-ssa {} cur [f] binds rest ret []]
                             (if (seq args)
                               (let [[a & args] args]
                                 (if (and (seq? a)
                                          (not= 'quote (first a)))
                                   (let [g (gensym "?")]
                                     (recur args (assoc to-ssa g a) (conj cur g) binds ret))
                                   (recur args to-ssa (conj cur a) binds ret)))
                               (let [ret (conj ret (into [(seq cur)] binds))]
                                 (if (seq to-ssa)
                                   (let [[k [f & args]] (first to-ssa)]
                                     (recur args (dissoc to-ssa k) [f] [k] ret))
                                   ret))))
                           [form])
                         [form])) where)))))

(defn resolve-calls
  ""
  [query]
    (let [{:keys [where] :as query} (query-map query)]
      (if-not where
        query
        (assoc query :where
               (mapv (fn [[op & rest :as form]]
                       (if-let [[f & args] (and (seq? op) op)]
                         (if-let [f-var (and (symbol? f) (resolve f))]
                           (into [(seq (into [(symbol (str (ns-name (.ns f-var)))
                                                      (str (.sym f-var)))] args))]
                                 rest)
                           form)
                         form)) where)))))

(defn db
  ""
  [asts]
  (mapcat ast/ast->eav asts))

(defn q
  ""
  [query asts & inputs]
  (compile-if (Class/forName "datomic.Datom")
    (do (require '[datomic.api :as d])
        (apply (resolve 'datomic.api/q) (unfold-expression-clauses query) (db asts) inputs))
    (throw (Exception. "Datomic is required"))))
