(defproject zcaudate/lucid.package "1.4.7"
  :description "tools for code clarity"
  :url "https://www.github.com/zcaudate/lucidity"
  :license {:name "The MIT License"
            :url "http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" ":exit"]}
  :dependencies [[org.clojure/clojure "1.8.0"] [org.bouncycastle/bcpg-jdk15on "1.59"] [zcaudate/hara.io.file "2.8.7"] [zcaudate/hara.reflect "2.8.7"] [zcaudate/hara.io.encode "2.8.7"] [zcaudate/hara.io.project "2.8.7"] [org.bouncycastle/bcprov-jdk15on "1.59"] [zcaudate/hara.io.classpath "2.8.7"] [hiccup/hiccup "1.0.5"] [zcaudate/hara.io.archive "2.8.7"] [zcaudate/hara.security "2.8.7"] [zcaudate/lucid.aether "1.4.7"]]
                
  :publish {:theme  "stark"
            
            :template {:site   "lucid"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}
            
            :files {"index"
                    {:template "home.html"
                     :input "test/documentation/home_lucidity.clj"
                     :title "lucidity"
                     :subtitle "tools for code clarity"}
                    "lucid-aether"
                    {:input "test/documentation/lucid_aether.clj"
                     :title "aether"
                     :subtitle "wrapper for org.eclipse.aether"}
                    "lucid-core"
                    {:input "test/documentation/lucid_core.clj"
                     :title "core"
                     :subtitle "functions for the code environment"}
                    "lucid-distribute"
                    {:input "test/documentation/lucid_distribute.clj"
                     :title "distribute"
                     :subtitle "code repackaging and distribution"}
                    "lucid-git"
                    {:input "test/documentation/lucid_git.clj"
                     :title "git"
                     :subtitle "wrapper for org.eclipse.jgit"}
                    "lucid-graph"
                    {:input "test/documentation/lucid_graph.clj"
                     :title "graph"
                     :subtitle "simple graph visualisations"}
                    "lucid-insight"
                    {:input "test/documentation/lucid_insight.clj"
                     :title "insight"
                     :subtitle "exploring functional connectivity"}
                    "lucid-mind"
                    {:input "test/documentation/lucid_mind.clj"
                     :title "mind"
                     :subtitle "contemplative reflection for the jvm"}
                    "lucid-package"
                    {:input "test/documentation/lucid_package.clj"
                     :title "package"
                     :subtitle "project packaging and dependencies"}
                    "lucid-publish"
                    {:input "test/documentation/lucid_publish.clj"
                     :title "publish"
                     :subtitle "generate documentation from code"}
                    "lucid-query"
                    {:input "test/documentation/lucid_query.clj"
                     :title "query"
                     :subtitle "intuitive search for code"}
                    "lucid-system"
                    {:input "test/documentation/lucid_system.clj"
                     :title "system"
                     :subtitle "system information and process monitoring"}
                    "lucid-unit"
                    {:input "test/documentation/lucid_unit.clj"
                     :title "unit"
                     :subtitle "metadata through unit tests"}}}
   
  :repl-options {:host "0.0.0.0"}
    
  :unit {:exclude ["lucid.legacy"]}
  :java-source-paths ["java"]
  :jvm-opts ["-Xmx8G"]
  :jar-exclusions [#"^test\..+\.class"])
