(ns lucid.publish.render.util
  (:require [clojure.string :as string]
            [markdown.core :as markdown]))

(defn adjust-indent
  "adjusts indents of multiple lines
 
   (adjust-indent \"\\n    a\\n    b\\n    c\"
                  2)
   => \"\\n  a\\n  b\\n  c\""
  {:added "1.2"}
  [s spaces]
  (->> (string/split-lines s)
       (map (fn [line]
              (if (and (< spaces (count line))
                       (re-find #"^\s+$" (subs line 0 spaces)))
                (subs line spaces)
                line)))
       (string/join "\n")))

(defn basic-html-escape
  "escape html tags for output
 
   (basic-html-escape \"<>\")
   => \"&lt;&gt;\""
  {:added "1.2"}
  [data]
  (clojure.string/escape data { \< "&lt;" \> "&gt;" \& "&amp;" \" "&quot;" \\ "&#92;"}))

(defn basic-html-unescape
  "unescape html output for rendering"
  {:added "1.2"}
  [data]
  (let [out (-> data
                (.replaceAll "&amp;quot;" "&quot;")
                (.replaceAll "&amp;lt;" "&lt;")
                (.replaceAll "&amp;gt;" "&gt;")
                (.replaceAll "&amp;amp;" "&amp;"))]
    out))

(defn join-string
  "join string in the form of vector or string
 
   (join-string \"hello\") => \"hello\"
 
   (join-string [\"hello\" \" \" \"world\"]) => \"hello world\""
  {:added "1.2"}
  [data]
  (cond (string? data)
        data

        (vector? data)
        (string/join data)))

(defn markup
  "creates html from markdown script
 
   (markup \"#title\")
   => \"<h1>title</h1>\""
  {:added "1.2"}
  [data]
  (markdown/md-to-html-string data))
