(defproject zcaudate/lucid "1.4.5"
  :description "tools for code clarity"
  :url "https://www.github.com/zcaudate/lucidity"
  :license {:name "The MIT License"
            :url "http://opensource.org/licenses/MIT"}
  :aliases {"test" ["run" "-m" "hara.test" ":exit"]}
  :dependencies [[org.clojure/clojure "1.8.0"] [zcaudate/hara.common "2.8.4"] [zcaudate/hara.class "2.8.4"] [zcaudate/hara.concurrent.latch "2.8.4"] [zcaudate/hara.data.diff "2.8.4"] [zcaudate/hara.data.nested "2.8.4"] [zcaudate/hara.event "2.8.4"] [zcaudate/hara.io.archive "2.8.4"] [zcaudate/hara.io.classloader "2.8.4"] [zcaudate/hara.io.classpath "2.8.4"] [zcaudate/hara.io.encode "2.8.4"] [zcaudate/hara.io.file "2.8.4"] [zcaudate/hara.io.project "2.8.4"] [zcaudate/hara.io.watch "2.8.4"] [zcaudate/hara.namespace "2.8.4"] [zcaudate/hara.object "2.8.4"] [zcaudate/hara.reflect "2.8.4"] [zcaudate/hara.security "2.8.4"] [zcaudate/hara.string.case "2.8.4"] [zcaudate/hara.string.mustache "2.8.4"] [zcaudate/hara.string.prose "2.8.4"] [zcaudate/hara.test "2.8.4"] [org.eclipse.aether/aether-api "1.1.0"] [org.eclipse.aether/aether-spi "1.1.0"] [org.eclipse.aether/aether-util "1.1.0"] [org.eclipse.aether/aether-impl "1.1.0"] [org.eclipse.aether/aether-connector-basic "1.1.0"] [org.eclipse.aether/aether-transport-wagon "1.1.0"] [org.eclipse.aether/aether-transport-http "1.1.0"] [org.eclipse.aether/aether-transport-file "1.1.0"] [org.eclipse.aether/aether-transport-classpath "1.1.0"] [org.apache.maven/maven-aether-provider "3.3.9"] [org.ow2.asm/asm "6.2"] [org.bouncycastle/bcprov-jdk15on "1.59"] [org.bouncycastle/bcpg-jdk15on "1.59"] [version-clj/version-clj "0.1.2"] [rewrite-clj/rewrite-clj "0.6.0"] [markdown-clj/markdown-clj "1.0.2"] [hiccup/hiccup "1.0.5"] [org.eclipse.jgit "4.8.0.201706111038-r"] [com.github.dblock/oshi-core "3.4.0"] [garden "1.3.5"] [net.sourceforge.cssparser/cssparser "0.9.25"] [org.graphstream/gs-ui "1.3" :exclusions [[bouncycastle/bcprov-jdk14] [bouncycastle/bcmail-jdk14]]] [net.bytebuddy/byte-buddy "1.8.12"] [zcaudate/lucid.package "1.4.5"] [zcaudate/lucid.graph "1.4.5"] [zcaudate/lucid.core.code "1.4.5"] [zcaudate/lucid.query "1.4.5"] [zcaudate/lucid.core.inject "1.4.5"] [zcaudate/lucid.legacy "1.4.5"] [zcaudate/lucid.core.debug "1.4.5"] [zcaudate/lucid.distribute "1.4.5"] [zcaudate/lucid.publish "1.4.5"] [zcaudate/lucid.git "1.4.5"] [zcaudate/lucid.mind "1.4.5"] [zcaudate/lucid.core.namespace "1.4.5"] [zcaudate/lucid.unit "1.4.5"] [zcaudate/lucid.system "1.4.5"] [zcaudate/lucid.inception "1.4.5"] [zcaudate/lucid.core.asm "1.4.5"] [zcaudate/lucid.core.java "1.4.5"] [zcaudate/lucid.aether "1.4.5"]]
                
  :publish {:theme  "stark"
            
            :template {:site   "lucid"
                       :author "Chris Zheng"
                       :email  "z@caudate.me"
                       :icon   "favicon"
                       :tracking-enabled "true"
                       :tracking "UA-31320512-2"}
            
            :files {"index"
                    {:template "home.html"
                     :input "test/documentation/home_lucidity.clj"
                     :title "lucidity"
                     :subtitle "tools for code clarity"}
                    "lucid-aether"
                    {:input "test/documentation/lucid_aether.clj"
                     :title "aether"
                     :subtitle "wrapper for org.eclipse.aether"}
                    "lucid-core"
                    {:input "test/documentation/lucid_core.clj"
                     :title "core"
                     :subtitle "functions for the code environment"}
                    "lucid-distribute"
                    {:input "test/documentation/lucid_distribute.clj"
                     :title "distribute"
                     :subtitle "code repackaging and distribution"}
                    "lucid-git"
                    {:input "test/documentation/lucid_git.clj"
                     :title "git"
                     :subtitle "wrapper for org.eclipse.jgit"}
                    "lucid-graph"
                    {:input "test/documentation/lucid_graph.clj"
                     :title "graph"
                     :subtitle "simple graph visualisations"}
                    #_"lucid-insight"
                    #_{:input "test/documentation/lucid_insight.clj"
                     :title "insight"
                     :subtitle "exploring functional connectivity"}
                    "lucid-mind"
                    {:input "test/documentation/lucid_mind.clj"
                     :title "mind"
                     :subtitle "contemplative reflection for the jvm"}
                    "lucid-package"
                    {:input "test/documentation/lucid_package.clj"
                     :title "package"
                     :subtitle "project packaging and dependencies"}
                    "lucid-publish"
                    {:input "test/documentation/lucid_publish.clj"
                     :title "publish"
                     :subtitle "generate documentation from code"}
                    "lucid-query"
                    {:input "test/documentation/lucid_query.clj"
                     :title "query"
                     :subtitle "intuitive search for code"}
                    "lucid-system"
                    {:input "test/documentation/lucid_system.clj"
                     :title "system"
                     :subtitle "system information and process monitoring"}
                    "lucid-unit"
                    {:input "test/documentation/lucid_unit.clj"
                     :title "unit"
                     :subtitle "metadata through unit tests"}}}
   
  :repl-options {:host "0.0.0.0"}
    
  :unit {:exclude ["lucid.legacy"]}
  :java-source-paths ["java"]
  
  :jar-exclusions [#"^test\..+\.class"])
