(ns spirit.io.datomic.api.link
  (:require [hara.common [checks :refer [hash-map?]]]
            [spirit.io.datomic.api.prepare :as prepare]
            [datomic.api :as datomic]))

(declare linked-ids)

(defn wrap-linked-set
  "helper funcion for linked-ids on set inputs"
  {:added "0.9"}
  [f]
  (fn [entrf pmodel rmodel seen fsch]
    (cond (set? entrf)
          (mapv #(f % pmodel rmodel seen fsch)
                (filter #(not (@seen (:db/id %))) entrf))
          :else
          (if (not (@seen (:db/id entrf)))
            (f entrf pmodel rmodel seen fsch)))))

(defn linked-ids-loop
  "main loop funcion for linked-ids"
  {:added "0.9"}
  ([ent rmodel fsch]
     (linked-ids ent rmodel rmodel (atom #{}) fsch))
  ([ent pmodel rmodel seen fsch]
     (if-let [[k v] (first pmodel)]
       (do (cond (hash-map? v)
                 (if-let [entrf (get ent (-> fsch k first :ref :key))]
                   ((wrap-linked-set linked-ids)
                    entrf v rmodel seen fsch))

                 (= v :yield)
                 (if-let [entrf (get ent (-> fsch k first :ref :key))]
                   ((wrap-linked-set linked-ids)
                    entrf rmodel rmodel seen fsch)))
           (recur ent (next pmodel) rmodel seen fsch)))))

(defn linked-ids
  "linked ids in database for a given entity and access model
 
   (let [ds (doto (scaffold/order-db)
              (datomic/insert! [{:account {:user \"A\"
                                           :orders [{:number 1}
                                                    {:number 2}]}}
                                {:account {:user \"B\"
                                           :orders [{:number 3}
                                                   {:number 4}]}}]))
         model (:pull (prepare/model-pull {}
                                          {:account {:orders :checked}}
                                          :unchecked
                                          (-> ds :schema :tree)))
         id (datomic/select ds {:account/user \"A\"} :first :return :ids)
         entity (datomic.api/entity (:db (prepare/prepare-db ds))
                                    id)]
     (linked-ids entity
                 model
                 (-> ds :schema :flat)))
   => #{17592186045418 17592186045420 17592186045419}"
  {:added "0.9"}
  ([ent rmodel fsch]
   (let [seen (atom #{})]
           (linked-ids ent rmodel rmodel seen fsch)
           @seen))
  ([ent pmodel rmodel seen fsch]
   (swap! seen conj (:db/id ent))
   (linked-ids-loop ent pmodel rmodel seen fsch)))

(defn linked-entities
  "returns all linked entities for a given entity object
   
   (let [ds (doto (scaffold/order-db)
              (datomic/insert! [{:account {:user \"A\"
                                           :orders [{:number 1}
                                                    {:number 2}]}}
                                {:account {:user \"B\"
                                           :orders [{:number 3}
                                                    {:number 4}]}}]))
         model (:pull (prepare/model-pull {}
                                         {:account {:orders :checked}}
                                          :unchecked
                                          (-> ds :schema :tree)))
         id (datomic/select ds {:account/user \"A\"} :first :return :ids)
         entity (datomic.api/entity (:db (prepare/prepare-db ds))
                                    id)]
     (->> (linked-entities entity model ds)
          (map :db/id)
          set))
   => #{17592186045418 17592186045420 17592186045419}"
  {:added "0.9"}
  [ent rmodel datasource]
  (let [datasource (prepare/prepare datasource {} {})]
    (->> datasource :schema :flat
         (linked-ids ent rmodel)
         (map #(datomic/entity (:db datasource) %)))))
