(ns spirit.io.datomic.data.checks
  (:require [hara.common.checks :refer [long? hash-map?]]))

(defn enum?
  "checks if data is a datomic :enum type
 
   (enum? 10) => true
 
   (enum? :hello) => true"
  {:added "0.9"}
  [x] (or (keyword? x) (long? x)))

(defn db-id?
  "checks if data is a datomic id
 
   (db-id? #db/id[:db.part/user -1])
   => true"
  {:added "0.9"}
  [x]  (instance? datomic.db.DbId x))

(defn entity?
  "checks if data is an datomic entity
 
   (entity? {}) => false"
  {:added "0.9"}
  [x] (instance? datomic.query.EntityMap x))

(defn ref?
  "checks if data is a datomic ref representation
 
   (ref? 10) => true
 
   (ref? {}) => true"
  {:added "0.9"}
  [x] (or (hash-map? x) (entity? x) (db-id? x) (long? x)))
  
(defn vexpr?
  "checks if data is a valid expression
 
   (vexpr? [[\":hello\"]]) => true"
  {:added "0.9"}
  [v]
  (and (vector? v)
       (= 1 (count v))
       (vector? (first v))
       (= 1 (count (first v)))))