(ns spirit.io.datomic.process.pack
  (:require [hara.common.error :refer [error]]
            [spirit.io.datomic.process.pack
             [analyse :as analyse]
             [review :as review]]))

(defn pack
  "top level function for packing the data to pass to emit
   
   (-> (doto (datomic/test-instance
              {:schema {:user {:name    [{:required true}]
                               :created [{:default (fn []
                                                     \"NOW\")}]}}})
         (datomic/insert! {:# {:nss #{:user}
                               :id '?id_0}
                           :user/name \"chris\"}
                          {:options {:skip-pack true
                                    :skip-normalise true
                                     }}))
       (datomic/select :user))
   => (contains-in [{:user {:name \"chris\"}
                     :db {:id number?}}])"
  {:added "0.9"}
  [datasource]
  (let [data (-> datasource :process :normalised)]
    (if (-> datasource :options :skip-pack)
      (assoc-in datasource [:process :reviewed] data)
      (-> datasource
          (analyse/analyse)
          (review/review)))))
