(ns spirit.io.datomic.process.pipeline.id
  (:require [hara.event :refer [raise]]
            [hara.common.checks :refer [long?]]
            [spirit.io.datomic.data.checks :as checks]))

(defn wrap-single-id
  "Allow ids to be passed if type is a ref
 
   (-> (pipeline/normalise {:schema (schema/schema {:user {:link [{:type :ref
                                                                   :ref {:ns :user}}]
                                                           :name [{}]}})
                            :process {:input {:user/link 1000}}})
       :process
       :normalised)
  => {:user {:link 1000}}"
  {:added "0.9"}
  [f]
  (fn [subdata [attr] nsv interim fns datasource]
    (if (and (= (:type attr) :ref)
             (or (long? subdata) 
                 (checks/db-id? subdata)))
      subdata
      (f subdata [attr] nsv interim fns datasource))))
