(ns spirit.io.datomic.process.pipeline.type-check
  (:require [spirit.common.util.coerce :refer [coerce]]
            [spirit.core.schema.base :as base]
            [spirit.io.datomic.schema.base]
            [hara.event :refer [raise]]))

(defn wrap-single-type-check
  "wraps normalise with support for type checking and coercion
 
   (pipeline/normalise {:account {:age \"1\"}}
                       {:schema (schema/schema {:account/age [{:type :long}]})}
                       {:normalise-single [wrap-single-type-check]})
   => throws
 
   (pipeline/normalise {:account {:age \"1\"}}
                       {:schema (schema/schema {:account/age [{:type :long}]})
                        :options {:use-coerce true}}
                       {:normalise-single [wrap-single-type-check]})
   => {:account {:age 1}}"
  {:added "0.9"}
  [f]
  (fn [subdata [attr] nsv interim fns spirit]
    (let [t (:type attr)
          chk (base/type-checks :default t)]
      (cond
        (chk subdata) (f subdata [attr] nsv interim fns spirit)

        (-> spirit :options :use-coerce)
        (f (coerce subdata t) [attr] nsv interim fns spirit)
        
        :else
        (raise [:normalise :wrong-type
                {:data subdata :nsv nsv :key-path (:key-path interim) :type t}]
               (str "WRAP_SINGLE_TYPE_CHECK: " subdata " in " nsv " is not of type " t))))))
