(ns spirit.mail.interop.header
  (:require [hara.object :as object])
  (:import javax.mail.Header))

(defn read-header
  "converts a Header object into a pair
 
   (read-header (Header. \"Hello\" \"World\"))
   => [\"Hello\" \"World\"]"
  {:added "0.8"}
  [header]
  [(.getName header)
   (.getValue header)])

(defn write-header
  "converts pair of strings into a Header object
 
   (write-header [\"Hello\" \"World\"])
   ;q=> #header[\"Hello\" \"World\"]
   "
  {:added "0.8"}
  [[name value]]
  (Header. name value))

(object/vector-like
 Header
 {:tag "header"
  :read read-header
  :write write-header})