(ns spirit.net.mail.interop.address
  (:require [hara.object :as object])
  (:import [javax.mail.internet InternetAddress]))

(object/string-like
 javax.mail.Address
 {:tag "address"
  :read str
  :write (fn [s] (InternetAddress. s))})

(defn write-addresses
  "converts a vector of strings into an Address array
 
   (seq (write-addresses [\"a@a.com\" \"b@b.com\" \"c@c.com\"]))
   ;;=> (#address \"a@a.com\" #address \"b@b.com\" #address \"c@c.com\")
   "
  {:added "0.8"}
  [arr]
  (->> arr
       (map (fn [address]
              (InternetAddress. address)))
       (into-array)))
