goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return cljs.core._vreset_BANG_(shadow.cljs.devtools.client.browser.active_modules_ref,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(shadow.cljs.devtools.client.browser.active_modules_ref),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(name)));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4521__auto__ = [];
var len__4518__auto___40284 = arguments.length;
var i__4519__auto___40285 = (0);
while(true){
if((i__4519__auto___40285 < len__4518__auto___40284)){
args__4521__auto__.push((arguments[i__4519__auto___40285]));

var G__40286 = (i__4519__auto___40285 + (1));
i__4519__auto___40285 = G__40286;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((1) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4522__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
return console.log.apply(null,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),"color: blue;"], null),args)));
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq40282){
var G__40283 = cljs.core.first(seq40282);
var seq40282__$1 = cljs.core.next(seq40282);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40283,seq40282__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5455__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5455__auto__)){
var s = temp__5455__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__40287){
var map__40288 = p__40287;
var map__40288__$1 = ((((!((map__40288 == null)))?(((((map__40288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40288.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40288):map__40288);
var src = map__40288__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40288__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40288__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__3936__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__3936__auto__){
return or__3936__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_(output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_(cljs.core.deref(shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__40290 = cljs.core.seq(sources);
var chunk__40291 = null;
var count__40292 = (0);
var i__40293 = (0);
while(true){
if((i__40293 < count__40292)){
var map__40294 = chunk__40291.cljs$core$IIndexed$_nth$arity$2(null,i__40293);
var map__40294__$1 = ((((!((map__40294 == null)))?(((((map__40294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40294):map__40294);
var src = map__40294__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40294__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40294__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40294__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40294__$1,new cljs.core.Keyword(null,"js","js",1768080579));
SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__40298 = seq__40290;
var G__40299 = chunk__40291;
var G__40300 = count__40292;
var G__40301 = (i__40293 + (1));
seq__40290 = G__40298;
chunk__40291 = G__40299;
count__40292 = G__40300;
i__40293 = G__40301;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40290);
if(temp__5457__auto__){
var seq__40290__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40290__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__40290__$1);
var G__40302 = cljs.core.chunk_rest(seq__40290__$1);
var G__40303 = c__4338__auto__;
var G__40304 = cljs.core.count(c__4338__auto__);
var G__40305 = (0);
seq__40290 = G__40302;
chunk__40291 = G__40303;
count__40292 = G__40304;
i__40293 = G__40305;
continue;
} else {
var map__40296 = cljs.core.first(seq__40290__$1);
var map__40296__$1 = ((((!((map__40296 == null)))?(((((map__40296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40296.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40296):map__40296);
var src = map__40296__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40296__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40296__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40296__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40296__$1,new cljs.core.Keyword(null,"js","js",1768080579));
SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));


var G__40306 = cljs.core.next(seq__40290__$1);
var G__40307 = null;
var G__40308 = (0);
var G__40309 = (0);
seq__40290 = G__40306;
chunk__40291 = G__40307;
count__40292 = G__40308;
i__40293 = G__40309;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__40310 = cljs.core.seq(js_requires);
var chunk__40311 = null;
var count__40312 = (0);
var i__40313 = (0);
while(true){
if((i__40313 < count__40312)){
var js_ns = chunk__40311.cljs$core$IIndexed$_nth$arity$2(null,i__40313);
var require_str_40314 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_40314);


var G__40315 = seq__40310;
var G__40316 = chunk__40311;
var G__40317 = count__40312;
var G__40318 = (i__40313 + (1));
seq__40310 = G__40315;
chunk__40311 = G__40316;
count__40312 = G__40317;
i__40313 = G__40318;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40310);
if(temp__5457__auto__){
var seq__40310__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40310__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__40310__$1);
var G__40319 = cljs.core.chunk_rest(seq__40310__$1);
var G__40320 = c__4338__auto__;
var G__40321 = cljs.core.count(c__4338__auto__);
var G__40322 = (0);
seq__40310 = G__40319;
chunk__40311 = G__40320;
count__40312 = G__40321;
i__40313 = G__40322;
continue;
} else {
var js_ns = cljs.core.first(seq__40310__$1);
var require_str_40323 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_40323);


var G__40324 = cljs.core.next(seq__40310__$1);
var G__40325 = null;
var G__40326 = (0);
var G__40327 = (0);
seq__40310 = G__40324;
chunk__40311 = G__40325;
count__40312 = G__40326;
i__40313 = G__40327;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__40328 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__40328) : callback.call(null,G__40328));
} else {
var G__40329 = shadow.cljs.devtools.client.env.files_url();
var G__40330 = ((function (G__40329){
return (function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
});})(G__40329))
;
var G__40331 = "POST";
var G__40332 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0));
var G__40333 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__40329,G__40330,G__40331,G__40332,G__40333);
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__40335){
var map__40336 = p__40335;
var map__40336__$1 = ((((!((map__40336 == null)))?(((((map__40336.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40336.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40336):map__40336);
var msg = map__40336__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40336__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40336__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__40338 = info;
var map__40338__$1 = ((((!((map__40338 == null)))?(((((map__40338.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40338.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40338):map__40338);
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40338__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40338__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4311__auto__ = ((function (map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40340(s__40341){
return (new cljs.core.LazySeq(null,((function (map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info){
return (function (){
var s__40341__$1 = s__40341;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__40341__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var map__40346 = cljs.core.first(xs__6012__auto__);
var map__40346__$1 = ((((!((map__40346 == null)))?(((((map__40346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40346.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40346):map__40346);
var src = map__40346__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40346__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40346__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4307__auto__ = ((function (s__40341__$1,map__40346,map__40346__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40340_$_iter__40342(s__40343){
return (new cljs.core.LazySeq(null,((function (s__40341__$1,map__40346,map__40346__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info){
return (function (){
var s__40343__$1 = s__40343;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__40343__$1);
if(temp__5457__auto____$1){
var s__40343__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40343__$2)){
var c__4309__auto__ = cljs.core.chunk_first(s__40343__$2);
var size__4310__auto__ = cljs.core.count(c__4309__auto__);
var b__40345 = cljs.core.chunk_buffer(size__4310__auto__);
if((function (){var i__40344 = (0);
while(true){
if((i__40344 < size__4310__auto__)){
var warning = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4309__auto__,i__40344);
cljs.core.chunk_append(b__40345,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__40365 = (i__40344 + (1));
i__40344 = G__40365;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40345),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40340_$_iter__40342(cljs.core.chunk_rest(s__40343__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40345),null);
}
} else {
var warning = cljs.core.first(s__40343__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40340_$_iter__40342(cljs.core.rest(s__40343__$2)));
}
} else {
return null;
}
break;
}
});})(s__40341__$1,map__40346,map__40346__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info))
,null,null));
});})(s__40341__$1,map__40346,map__40346__$1,src,resource_name,warnings,xs__6012__auto__,temp__5457__auto__,map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info))
;
var fs__4308__auto__ = cljs.core.seq(iterys__4307__auto__(warnings));
if(fs__4308__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4308__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__40340(cljs.core.rest(s__40341__$1)));
} else {
var G__40366 = cljs.core.rest(s__40341__$1);
s__40341__$1 = G__40366;
continue;
}
} else {
var G__40367 = cljs.core.rest(s__40341__$1);
s__40341__$1 = G__40367;
continue;
}
} else {
return null;
}
break;
}
});})(map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info))
,null,null));
});})(map__40338,map__40338__$1,sources,compiled,map__40336,map__40336__$1,msg,info,reload_info))
;
return iter__4311__auto__(sources);
})()));
var seq__40348_40368 = cljs.core.seq(warnings);
var chunk__40349_40369 = null;
var count__40350_40370 = (0);
var i__40351_40371 = (0);
while(true){
if((i__40351_40371 < count__40350_40370)){
var map__40352_40372 = chunk__40349_40369.cljs$core$IIndexed$_nth$arity$2(null,i__40351_40371);
var map__40352_40373__$1 = ((((!((map__40352_40372 == null)))?(((((map__40352_40372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40352_40372.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40352_40372):map__40352_40372);
var w_40374 = map__40352_40373__$1;
var msg_40375__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40352_40373__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_40376 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40352_40373__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_40377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40352_40373__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_40378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40352_40373__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_40378)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_40376),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_40377),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_40375__$1)].join(''));


var G__40379 = seq__40348_40368;
var G__40380 = chunk__40349_40369;
var G__40381 = count__40350_40370;
var G__40382 = (i__40351_40371 + (1));
seq__40348_40368 = G__40379;
chunk__40349_40369 = G__40380;
count__40350_40370 = G__40381;
i__40351_40371 = G__40382;
continue;
} else {
var temp__5457__auto___40383 = cljs.core.seq(seq__40348_40368);
if(temp__5457__auto___40383){
var seq__40348_40384__$1 = temp__5457__auto___40383;
if(cljs.core.chunked_seq_QMARK_(seq__40348_40384__$1)){
var c__4338__auto___40385 = cljs.core.chunk_first(seq__40348_40384__$1);
var G__40386 = cljs.core.chunk_rest(seq__40348_40384__$1);
var G__40387 = c__4338__auto___40385;
var G__40388 = cljs.core.count(c__4338__auto___40385);
var G__40389 = (0);
seq__40348_40368 = G__40386;
chunk__40349_40369 = G__40387;
count__40350_40370 = G__40388;
i__40351_40371 = G__40389;
continue;
} else {
var map__40354_40390 = cljs.core.first(seq__40348_40384__$1);
var map__40354_40391__$1 = ((((!((map__40354_40390 == null)))?(((((map__40354_40390.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40354_40390.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40354_40390):map__40354_40390);
var w_40392 = map__40354_40391__$1;
var msg_40393__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40354_40391__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_40394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40354_40391__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_40395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40354_40391__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_40396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40354_40391__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_40396)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_40394),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_40395),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_40393__$1)].join(''));


var G__40397 = cljs.core.next(seq__40348_40384__$1);
var G__40398 = null;
var G__40399 = (0);
var G__40400 = (0);
seq__40348_40368 = G__40397;
chunk__40349_40369 = G__40398;
count__40350_40370 = G__40399;
i__40351_40371 = G__40400;
continue;
}
} else {
}
}
break;
}

if(!(shadow.cljs.devtools.client.env.autoload)){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info){
return (function (p__40356){
var map__40357 = p__40356;
var map__40357__$1 = ((((!((map__40357 == null)))?(((((map__40357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40357):map__40357);
var src = map__40357__$1;
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40357__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40357__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src))) || (((cljs.core.contains_QMARK_(compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info){
return (function (p__40359){
var map__40360 = p__40359;
var map__40360__$1 = ((((!((map__40360 == null)))?(((((map__40360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40360):map__40360);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40360__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
});})(map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info){
return (function (p__40362){
var map__40363 = p__40362;
var map__40363__$1 = ((((!((map__40363 == null)))?(((((map__40363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40363):map__40363);
var rc = map__40363__$1;
var module = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40363__$1,new cljs.core.Keyword(null,"module","module",1424618191));
var or__3936__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("js",shadow.cljs.devtools.client.env.module_format);
if(or__3936__auto__){
return or__3936__auto__;
} else {
return shadow.cljs.devtools.client.browser.module_is_active_QMARK_(module);
}
});})(map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info))
,sources))));
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,((function (sources_to_get,map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info){
return (function (p1__40334_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__40334_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
});})(sources_to_get,map__40338,map__40338__$1,sources,compiled,warnings,map__40336,map__40336__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__40401){
var map__40402 = p__40401;
var map__40402__$1 = ((((!((map__40402 == null)))?(((((map__40402.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40402.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40402):map__40402);
var msg = map__40402__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40402__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__40404 = cljs.core.seq(updates);
var chunk__40406 = null;
var count__40407 = (0);
var i__40408 = (0);
while(true){
if((i__40408 < count__40407)){
var path = chunk__40406.cljs$core$IIndexed$_nth$arity$2(null,i__40408);
if(clojure.string.ends_with_QMARK_(path,"css")){
var temp__5457__auto___40412 = document.querySelector(["link[href^=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"\"]"].join(''));
if(cljs.core.truth_(temp__5457__auto___40412)){
var node_40413 = temp__5457__auto___40412;
var new_link_40414 = (function (){var G__40410 = document.createElement("link");
G__40410.setAttribute("rel","stylesheet");

G__40410.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__40410;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_40414,node_40413);

goog.dom.removeNode(node_40413);
} else {
}


var G__40415 = seq__40404;
var G__40416 = chunk__40406;
var G__40417 = count__40407;
var G__40418 = (i__40408 + (1));
seq__40404 = G__40415;
chunk__40406 = G__40416;
count__40407 = G__40417;
i__40408 = G__40418;
continue;
} else {
var G__40419 = seq__40404;
var G__40420 = chunk__40406;
var G__40421 = count__40407;
var G__40422 = (i__40408 + (1));
seq__40404 = G__40419;
chunk__40406 = G__40420;
count__40407 = G__40421;
i__40408 = G__40422;
continue;
}
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40404);
if(temp__5457__auto__){
var seq__40404__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40404__$1)){
var c__4338__auto__ = cljs.core.chunk_first(seq__40404__$1);
var G__40423 = cljs.core.chunk_rest(seq__40404__$1);
var G__40424 = c__4338__auto__;
var G__40425 = cljs.core.count(c__4338__auto__);
var G__40426 = (0);
seq__40404 = G__40423;
chunk__40406 = G__40424;
count__40407 = G__40425;
i__40408 = G__40426;
continue;
} else {
var path = cljs.core.first(seq__40404__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var temp__5457__auto___40427__$1 = document.querySelector(["link[href^=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"\"]"].join(''));
if(cljs.core.truth_(temp__5457__auto___40427__$1)){
var node_40428 = temp__5457__auto___40427__$1;
var new_link_40429 = (function (){var G__40411 = document.createElement("link");
G__40411.setAttribute("rel","stylesheet");

G__40411.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__40411;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path], 0));

goog.dom.insertSiblingAfter(new_link_40429,node_40428);

goog.dom.removeNode(node_40428);
} else {
}


var G__40430 = cljs.core.next(seq__40404__$1);
var G__40431 = null;
var G__40432 = (0);
var G__40433 = (0);
seq__40404 = G__40430;
chunk__40406 = G__40431;
count__40407 = G__40432;
i__40408 = G__40433;
continue;
} else {
var G__40434 = cljs.core.next(seq__40404__$1);
var G__40435 = null;
var G__40436 = (0);
var G__40437 = (0);
seq__40404 = G__40434;
chunk__40406 = G__40435;
count__40407 = G__40436;
i__40408 = G__40437;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__40438){
var map__40439 = p__40438;
var map__40439__$1 = ((((!((map__40439 == null)))?(((((map__40439.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40439.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40439):map__40439);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40439__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40439__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call(((function (map__40439,map__40439__$1,id,js){
return (function (){
return eval(js);
});})(map__40439,map__40439__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__40441){
var map__40442 = p__40441;
var map__40442__$1 = ((((!((map__40442 == null)))?(((((map__40442.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40442.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40442):map__40442);
var msg = map__40442__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40442__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__40442,map__40442__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__40444){
var map__40445 = p__40444;
var map__40445__$1 = ((((!((map__40445 == null)))?(((((map__40445.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40445.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40445):map__40445);
var src = map__40445__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40445__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__3925__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__3925__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__3925__auto__;
}
});})(map__40442,map__40442__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,((function (sources_to_load,map__40442,map__40442__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
});})(sources_to_load,map__40442,map__40442__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__40447){
var map__40448 = p__40447;
var map__40448__$1 = ((((!((map__40448 == null)))?(((((map__40448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40448):map__40448);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40448__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40448__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(repl_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current","current",-1088038603),new cljs.core.Keyword(null,"ns","ns",441598760)], null)));

return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__40448,map__40448__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

return shadow.cljs.devtools.client.browser.devtools_msg("REPL init successful");
});})(map__40448,map__40448__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__40450){
var map__40451 = p__40450;
var map__40451__$1 = ((((!((map__40451 == null)))?(((((map__40451.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40451.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40451):map__40451);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40451__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40451__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
cljs.core.reset_BANG_(shadow.cljs.devtools.client.browser.repl_ns_ref,ns);

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__40453){
var map__40454 = p__40453;
var map__40454__$1 = ((((!((map__40454 == null)))?(((((map__40454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40454):map__40454);
var msg = map__40454__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40454__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

var G__40456 = type;
var G__40456__$1 = (((G__40456 instanceof cljs.core.Keyword))?G__40456.fqn:null);
switch (G__40456__$1) {
case "asset-watch":
return shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
return shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
return shadow.cljs.devtools.client.browser.repl_require(msg);

break;
case "repl/set-ns":
return shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
return shadow.cljs.devtools.client.browser.repl_init(msg);

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

return shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

return shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
return shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

return shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":
return null;

break;
case "client/stale":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
return cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"\" not running"].join(''));

break;
default:
return new cljs.core.Keyword(null,"ignored","ignored",1227374526);

}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
var G__40458 = ["http",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((shadow.cljs.devtools.client.env.ssl)?"s":null)),"://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_host),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.build_id),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.proc_id),"/browser"].join('');
var G__40459 = ((function (G__40458){
return (function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
});})(G__40458))
;
var G__40460 = "POST";
var G__40461 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0));
var G__40462 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__40458,G__40459,G__40460,G__40461,G__40462);
});
shadow.cljs.devtools.client.browser.heartbeat_BANG_ = (function shadow$cljs$devtools$client$browser$heartbeat_BANG_(){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ping","ping",-1670114784),new cljs.core.Keyword(null,"v","v",21465059),Date.now()], null)], 0)));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__3936__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_();
});})(print_fn,ws_url,socket))
;

socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
});})(print_fn,ws_url,socket))
;

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5457__auto___40463 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto___40463)){
var s_40464 = temp__5457__auto___40463;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

s_40464.onclose = ((function (s_40464,temp__5457__auto___40463){
return (function (e){
return null;
});})(s_40464,temp__5457__auto___40463))
;

s_40464.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5457__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
return s.close();
} else {
return null;
}
}));

shadow.cljs.devtools.client.browser.ws_connect();
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
