goog.provide('yin.data.map');
goog.require('cljs.core');
/**
 * disassociates keys from a nested map. Setting `keep` to `true` will
 * not remove a empty map after dissoc
 *  
 * (dissoc-in {:a {:b 10 :c 20}} [:a :b])
 * => {:a {:c 20}}
 *  
 * (dissoc-in {:a {:b 10}} [:a :b])
 * => {}
 *  
 * (dissoc-in {:a {:b 10}} [:a :b] true)
 * => {:a {}}
 */
yin.data.map.dissoc_in = (function yin$data$map$dissoc_in(var_args){
var G__26087 = arguments.length;
switch (G__26087) {
case 2:
return yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$2 = (function (m,p__26101){
var vec__26102 = p__26101;
var seq__26103 = cljs.core.seq(vec__26102);
var first__26104 = cljs.core.first(seq__26103);
var seq__26103__$1 = cljs.core.next(seq__26103);
var k = first__26104;
var ks = seq__26103__$1;
if(cljs.core.not(ks)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
var nm = yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$2((m.cljs$core$IFn$_invoke$arity$1 ? m.cljs$core$IFn$_invoke$arity$1(k) : m.call(null,k)),ks);
if(cljs.core.empty_QMARK_(nm)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,nm);

}
}
});

yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__26105,keep){
var vec__26106 = p__26105;
var seq__26107 = cljs.core.seq(vec__26106);
var first__26108 = cljs.core.first(seq__26107);
var seq__26107__$1 = cljs.core.next(seq__26107);
var k = first__26108;
var ks = seq__26107__$1;
if(cljs.core.not(ks)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$3((m.cljs$core$IFn$_invoke$arity$1 ? m.cljs$core$IFn$_invoke$arity$1(k) : m.call(null,k)),ks,keep));
}
});

yin.data.map.dissoc_in.cljs$lang$maxFixedArity = 3;

/**
 * returns a map of all key/value pairs that differ from a second map
 *  
 * (unique {:a 1} {:a 2})
 * => {:a 1}
 *  
 * (unique {:a 1 :b 2} {:b 2})
 * => {:a 1}
 *  
 * (unique {:b 2} {:b 2 :a 1})
 * => nil
 */
yin.data.map.unique = (function yin$data$map$unique(m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (i,p__26113){
var vec__26114 = p__26113;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26114,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26114,(1),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m2,k))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(i,k,v);
} else {
return i;
}
}),null,m1);
});
/**
 * assoc key/value pairs to the map only on non-nil values
 *  
 * (assoc-if {} :a 1)
 * => {:a 1}
 *  
 * (assoc-if {} :a 1 :b nil)
 * => {:a 1}
 */
yin.data.map.assoc_if = (function yin$data$map$assoc_if(var_args){
var G__26123 = arguments.length;
switch (G__26123) {
case 3:
return yin.data.map.assoc_if.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4533__auto__ = [];
var len__4518__auto___26128 = arguments.length;
var i__4519__auto___26129 = (0);
while(true){
if((i__4519__auto___26129 < len__4518__auto___26128)){
args_arr__4533__auto__.push((arguments[i__4519__auto___26129]));

var G__26130 = (i__4519__auto___26129 + (1));
i__4519__auto___26129 = G__26130;
continue;
} else {
}
break;
}

var argseq__4534__auto__ = (new cljs.core.IndexedSeq(args_arr__4533__auto__.slice((3)),(0),null));
return yin.data.map.assoc_if.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4534__auto__);

}
});

yin.data.map.assoc_if.cljs$core$IFn$_invoke$arity$3 = (function (m,k,v){
if(!((v == null))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
} else {
return m;
}
});

yin.data.map.assoc_if.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,v,more){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(yin.data.map.assoc_if,yin.data.map.assoc_if.cljs$core$IFn$_invoke$arity$3(m,k,v),more);
});

/** @this {Function} */
yin.data.map.assoc_if.cljs$lang$applyTo = (function (seq26119){
var G__26120 = cljs.core.first(seq26119);
var seq26119__$1 = cljs.core.next(seq26119);
var G__26121 = cljs.core.first(seq26119__$1);
var seq26119__$2 = cljs.core.next(seq26119__$1);
var G__26122 = cljs.core.first(seq26119__$2);
var seq26119__$3 = cljs.core.next(seq26119__$2);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26120,G__26121,G__26122,seq26119__$3);
});

yin.data.map.assoc_if.cljs$lang$maxFixedArity = (3);

/**
 * assoc-in a nested key/value pair to a map only on non-nil values
 *  
 * (assoc-in-if {} [:a :b] 1)
 * => {:a {:b 1}}
 *  
 * (assoc-in-if {} [:a :b] nil)
 * => {}
 */
yin.data.map.assoc_in_if = (function yin$data$map$assoc_in_if(m,arr,v){
if(!((v == null))){
return cljs.core.assoc_in(m,arr,v);
} else {
return m;
}
});
/**
 * update-in a nested key/value pair only if the value exists
 *  
 * (update-in-if {:a {:b 1}} [:a :b] inc)
 * => {:a {:b 2}}
 *  
 * (update-in-if {} [:a :b] inc)
 * => {}
 */
yin.data.map.update_in_if = (function yin$data$map$update_in_if(var_args){
var args__4521__auto__ = [];
var len__4518__auto___26137 = arguments.length;
var i__4519__auto___26138 = (0);
while(true){
if((i__4519__auto___26138 < len__4518__auto___26137)){
args__4521__auto__.push((arguments[i__4519__auto___26138]));

var G__26139 = (i__4519__auto___26138 + (1));
i__4519__auto___26138 = G__26139;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((3) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((3)),(0),null)):null);
return yin.data.map.update_in_if.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4522__auto__);
});

yin.data.map.update_in_if.cljs$core$IFn$_invoke$arity$variadic = (function (m,arr,f,args){
var v = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,arr);
if(!((v == null))){
return cljs.core.assoc_in(m,arr,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,v,args));
} else {
return m;
}
});

yin.data.map.update_in_if.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
yin.data.map.update_in_if.cljs$lang$applyTo = (function (seq26133){
var G__26134 = cljs.core.first(seq26133);
var seq26133__$1 = cljs.core.next(seq26133);
var G__26135 = cljs.core.first(seq26133__$1);
var seq26133__$2 = cljs.core.next(seq26133__$1);
var G__26136 = cljs.core.first(seq26133__$2);
var seq26133__$3 = cljs.core.next(seq26133__$2);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26134,G__26135,G__26136,seq26133__$3);
});

/**
 * merges key/value pairs into a single map only if the value exists
 *  
 * (merge-if {:a nil :b 1})
 * => {:b 1}
 *  
 * (merge-if {:a 1} {:b nil :c 2})
 * => {:a 1 :c 2}
 *  
 * (merge-if {:a 1} {:b nil} {:c 2})
 * => {:a 1 :c 2}
 */
yin.data.map.merge_if = (function yin$data$map$merge_if(var_args){
var G__26144 = arguments.length;
switch (G__26144) {
case 0:
return yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4533__auto__ = [];
var len__4518__auto___26160 = arguments.length;
var i__4519__auto___26161 = (0);
while(true){
if((i__4519__auto___26161 < len__4518__auto___26160)){
args_arr__4533__auto__.push((arguments[i__4519__auto___26161]));

var G__26162 = (i__4519__auto___26161 + (1));
i__4519__auto___26161 = G__26162;
continue;
} else {
}
break;
}

var argseq__4534__auto__ = (new cljs.core.IndexedSeq(args_arr__4533__auto__.slice((2)),(0),null));
return yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4534__auto__);

}
});

yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
});

yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$1 = (function (m){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (i,p__26145){
var vec__26146 = p__26145;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26146,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26146,(1),null);
if(!((v == null))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(i,k,v);
} else {
return i;
}
}),cljs.core.PersistentArrayMap.EMPTY,m);
});

yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$2 = (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (i,p__26149){
var vec__26154 = p__26149;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26154,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26154,(1),null);
if(!((v == null))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(i,k,v);
} else {
return i;
}
}),yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$1(m1),m2);
});

yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$variadic = (function (m1,m2,more){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(yin.data.map.merge_if,yin.data.map.merge_if.cljs$core$IFn$_invoke$arity$2(m1,m2),more);
});

/** @this {Function} */
yin.data.map.merge_if.cljs$lang$applyTo = (function (seq26141){
var G__26142 = cljs.core.first(seq26141);
var seq26141__$1 = cljs.core.next(seq26141);
var G__26143 = cljs.core.first(seq26141__$1);
var seq26141__$2 = cljs.core.next(seq26141__$1);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26142,G__26143,seq26141__$2);
});

yin.data.map.merge_if.cljs$lang$maxFixedArity = (2);

/**
 * like into but filters nil values for both key/value pairs
 * and sequences
 *  
 * (into-if [] [1 nil 2 3])
 * => [1 2 3]
 *  
 * (into-if {:a 1} {:b nil :c 2})
 * => {:a 1 :c 2}
 */
yin.data.map.into_if = (function yin$data$map$into_if(to,from){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (i,e){
if(((((cljs.core.coll_QMARK_(e)) && (!((cljs.core.second(e) == null))))) || (((!(cljs.core.coll_QMARK_(e))) && (!((e == null))))))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(i,e);
} else {
return i;
}
}),to,from);
});
/**
 * selects only the non-nil key/value pairs from a map
 *  
 * (select-keys-if {:a 1 :b nil} [:a :b])
 * => {:a 1}
 *  
 * (select-keys-if {:a 1 :b nil :c 2} [:a :b :c])
 * => {:a 1 :c 2}
 */
yin.data.map.select_keys_if = (function yin$data$map$select_keys_if(m,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (i,k){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(!((v == null))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(i,k,v);
} else {
return i;
}
}),null,ks);
});
/**
 * only merge if the value in the original map is nil
 *  
 * (merge-nil {:a 1} {:b 2})
 * => {:a 1 :b 2}
 *  
 * (merge-nil {:a 1} {:a 2})
 * => {:a 1}
 */
yin.data.map.merge_nil = (function yin$data$map$merge_nil(var_args){
var G__26172 = arguments.length;
switch (G__26172) {
case 0:
return yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4533__auto__ = [];
var len__4518__auto___26179 = arguments.length;
var i__4519__auto___26180 = (0);
while(true){
if((i__4519__auto___26180 < len__4518__auto___26179)){
args_arr__4533__auto__.push((arguments[i__4519__auto___26180]));

var G__26181 = (i__4519__auto___26180 + (1));
i__4519__auto___26180 = G__26181;
continue;
} else {
}
break;
}

var argseq__4534__auto__ = (new cljs.core.IndexedSeq(args_arr__4533__auto__.slice((2)),(0),null));
return yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4534__auto__);

}
});

yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
});

yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$1 = (function (m){
return m;
});

yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$2 = (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (i,p__26173){
var vec__26174 = p__26173;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26174,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26174,(1),null);
if(!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(i,k) == null))){
return i;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(i,k,v);
}
}),m1,m2);
});

yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$variadic = (function (m1,m2,more){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(yin.data.map.merge_nil,yin.data.map.merge_nil.cljs$core$IFn$_invoke$arity$2(m1,m2),more);
});

/** @this {Function} */
yin.data.map.merge_nil.cljs$lang$applyTo = (function (seq26169){
var G__26170 = cljs.core.first(seq26169);
var seq26169__$1 = cljs.core.next(seq26169);
var G__26171 = cljs.core.first(seq26169__$1);
var seq26169__$2 = cljs.core.next(seq26169__$1);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26170,G__26171,seq26169__$2);
});

yin.data.map.merge_nil.cljs$lang$maxFixedArity = (2);

/**
 * only assoc if the value in the original map is nil
 *  
 * (assoc-nil {:a 1} :b 2)
 * => {:a 1 :b 2}
 *  
 * (assoc-nil {:a 1} :a 2 :b 2)
 * => {:a 1 :b 2}
 */
yin.data.map.assoc_nil = (function yin$data$map$assoc_nil(var_args){
var G__26187 = arguments.length;
switch (G__26187) {
case 3:
return yin.data.map.assoc_nil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4533__auto__ = [];
var len__4518__auto___26189 = arguments.length;
var i__4519__auto___26190 = (0);
while(true){
if((i__4519__auto___26190 < len__4518__auto___26189)){
args_arr__4533__auto__.push((arguments[i__4519__auto___26190]));

var G__26191 = (i__4519__auto___26190 + (1));
i__4519__auto___26190 = G__26191;
continue;
} else {
}
break;
}

var argseq__4534__auto__ = (new cljs.core.IndexedSeq(args_arr__4533__auto__.slice((3)),(0),null));
return yin.data.map.assoc_nil.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4534__auto__);

}
});

yin.data.map.assoc_nil.cljs$core$IFn$_invoke$arity$3 = (function (m,k,v){
if(!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k) == null))){
return m;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});

yin.data.map.assoc_nil.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,v,more){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(yin.data.map.assoc_nil,yin.data.map.assoc_nil.cljs$core$IFn$_invoke$arity$3(m,k,v),more);
});

/** @this {Function} */
yin.data.map.assoc_nil.cljs$lang$applyTo = (function (seq26183){
var G__26184 = cljs.core.first(seq26183);
var seq26183__$1 = cljs.core.next(seq26183);
var G__26185 = cljs.core.first(seq26183__$1);
var seq26183__$2 = cljs.core.next(seq26183__$1);
var G__26186 = cljs.core.first(seq26183__$2);
var seq26183__$3 = cljs.core.next(seq26183__$2);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26184,G__26185,G__26186,seq26183__$3);
});

yin.data.map.assoc_nil.cljs$lang$maxFixedArity = (3);

/**
 * only assoc-in if the value in the original map is nil
 *  
 * (assoc-in-nil {} [:a :b] 2)
 * => {:a {:b 2}}
 *  
 * (assoc-in-nil {:a {:b 1}} [:a :b] 2)
 * => {:a {:b 1}}
 */
yin.data.map.assoc_in_nil = (function yin$data$map$assoc_in_nil(m,ks,v){
if(!((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,ks) == null))){
return m;
} else {
return cljs.core.assoc_in(m,ks,v);
}
});
/**
 * moves values around in a map according to a table
 *  
 * (transform-in {:a 1 :b 2}
 *               {[:c :d] [:a]})
 * => {:b 2, :c {:d 1}}
 */
yin.data.map.transform_in = (function yin$data$map$transform_in(m,rels){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (out,p__26192){
var vec__26197 = p__26192;
var to = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26197,(0),null);
var from = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26197,(1),null);
var v = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,from);
return yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$2(yin.data.map.assoc_in_if(out,to,v),from);
}),m,rels);
});
/**
 * reversed the changes by transform-in
 * 
 * (retract-in {:b 2, :c {:d 1}}
 *             {[:c :d] [:a]})
 * => {:a 1 :b 2}
 */
yin.data.map.retract_in = (function yin$data$map$retract_in(m,rels){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (out,p__26202){
var vec__26203 = p__26202;
var to = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26203,(0),null);
var from = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26203,(1),null);
var v = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,to);
return yin.data.map.dissoc_in.cljs$core$IFn$_invoke$arity$2(yin.data.map.assoc_in_if(out,from,v),to);
}),m,cljs.core.reverse(rels));
});

//# sourceMappingURL=yin.data.map.js.map
