goog.provide('yin.event');
goog.require('cljs.core');
goog.require('yin.event.common');
if((typeof yin !== 'undefined') && (typeof yin.event !== 'undefined') && (typeof yin.event._STAR_signal_manager_STAR_ !== 'undefined')){
} else {
yin.event._STAR_signal_manager_STAR_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(yin.event.common.manager.cljs$core$IFn$_invoke$arity$0());
}
/**
 * empties all event listeners
 * 
 * (clear-listeners)
 * ;; all defined listeners will be cleared 
 * 
 */
yin.event.clear_listeners = (function yin$event$clear_listeners(var_args){
var G__26296 = arguments.length;
switch (G__26296) {
case 0:
return yin.event.clear_listeners.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return yin.event.clear_listeners.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.event.clear_listeners.cljs$core$IFn$_invoke$arity$0 = (function (){
return yin.event.clear_listeners.cljs$core$IFn$_invoke$arity$1(yin.event._STAR_signal_manager_STAR_);
});

yin.event.clear_listeners.cljs$core$IFn$_invoke$arity$1 = (function (global){
return cljs.core.reset_BANG_(global,yin.event.common.manager.cljs$core$IFn$_invoke$arity$0());
});

yin.event.clear_listeners.cljs$lang$maxFixedArity = 1;

/**
 * shows all event listeners
 *  
 * (deflistener hello-listener :msg
 *   [msg]
 *   (str "recieved " msg))
 * 
 * (list-listeners)
 * => (contains-in [{:id 'hara.event-test/hello-listener,
 *                   :checker :msg}])
 */
yin.event.list_listeners = (function yin$event$list_listeners(var_args){
var G__26299 = arguments.length;
switch (G__26299) {
case 0:
return yin.event.list_listeners.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return yin.event.list_listeners.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.event.list_listeners.cljs$core$IFn$_invoke$arity$0 = (function (){
return yin.event.common.list_handlers.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(yin.event._STAR_signal_manager_STAR_));
});

yin.event.list_listeners.cljs$core$IFn$_invoke$arity$1 = (function (checker){
return yin.event.common.list_handlers.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(yin.event._STAR_signal_manager_STAR_),checker);
});

yin.event.list_listeners.cljs$lang$maxFixedArity = 1;

/**
 * adds an event listener, `deflistener` can also be used
 * 
 * (install-listener 'hello
 *                   :msg
 *                   (fn [{:keys [msg]}]
 *                     (str "recieved " msg)))
 *  
 * (list-listeners)
 * => (contains-in [{:id 'hello
 *                   :checker :msg}])
 */
yin.event.install_listener = (function yin$event$install_listener(id,checker,handler){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(yin.event._STAR_signal_manager_STAR_,yin.event.common.add_handler,checker,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"fn","fn",-1175266204),handler], null));
});
/**
 * uninstalls a global signal listener
 * 
 * (uninstall-listener 'hara.event-test/hello)
 */
yin.event.uninstall_listener = (function yin$event$uninstall_listener(id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(yin.event._STAR_signal_manager_STAR_,yin.event.common.remove_handler,id);
});
/**
 * signals an event that is sent to, it does not do anything by itself
 *  
 * (signal :anything) => ()
 *  
 * (deflistener hello _
 *   e
 *   e)
 *  
 * (signal :anything)
 * => '({:id hara.event-test/hello :result {:anything true}})
 */
yin.event.signal = (function yin$event$signal(var_args){
var G__26302 = arguments.length;
switch (G__26302) {
case 1:
return yin.event.signal.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.event.signal.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.event.signal.cljs$core$IFn$_invoke$arity$1 = (function (data){
return yin.event.signal.cljs$core$IFn$_invoke$arity$2(data,cljs.core.deref(yin.event._STAR_signal_manager_STAR_));
});

yin.event.signal.cljs$core$IFn$_invoke$arity$2 = (function (data,manager){
var ndata = yin.event.common.expand_data(data);
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__4311__auto__ = ((function (ndata){
return (function yin$event$iter__26303(s__26304){
return (new cljs.core.LazySeq(null,((function (ndata){
return (function (){
var s__26304__$1 = s__26304;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__26304__$1);
if(temp__5457__auto__){
var s__26304__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26304__$2)){
var c__4309__auto__ = cljs.core.chunk_first(s__26304__$2);
var size__4310__auto__ = cljs.core.count(c__4309__auto__);
var b__26306 = cljs.core.chunk_buffer(size__4310__auto__);
if((function (){var i__26305 = (0);
while(true){
if((i__26305 < size__4310__auto__)){
var handler = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4309__auto__,i__26305);
cljs.core.chunk_append(b__26306,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(handler),new cljs.core.Keyword(null,"result","result",1415092211),(function (){var fexpr__26307 = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(handler);
return (fexpr__26307.cljs$core$IFn$_invoke$arity$1 ? fexpr__26307.cljs$core$IFn$_invoke$arity$1(ndata) : fexpr__26307.call(null,ndata));
})()], null));

var G__26310 = (i__26305 + (1));
i__26305 = G__26310;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26306),yin$event$iter__26303(cljs.core.chunk_rest(s__26304__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26306),null);
}
} else {
var handler = cljs.core.first(s__26304__$2);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(handler),new cljs.core.Keyword(null,"result","result",1415092211),(function (){var fexpr__26308 = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(handler);
return (fexpr__26308.cljs$core$IFn$_invoke$arity$1 ? fexpr__26308.cljs$core$IFn$_invoke$arity$1(ndata) : fexpr__26308.call(null,ndata));
})()], null),yin$event$iter__26303(cljs.core.rest(s__26304__$2)));
}
} else {
return null;
}
break;
}
});})(ndata))
,null,null));
});})(ndata))
;
return iter__4311__auto__(yin.event.common.match_handlers(manager,ndata));
})());
});

yin.event.signal.cljs$lang$maxFixedArity = 2;


//# sourceMappingURL=yin.event.js.map
