goog.provide('yin.test.checker.base');
goog.require('cljs.core');
goog.require('yin.test.common');
goog.require('yin.common.primitives');
yin.test.checker.base.verify = (function yin$test$checker$base$verify(ck,result){
var out = (function (){try{return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"data","data",-232669377),(ck.cljs$core$IFn$_invoke$arity$1 ? ck.cljs$core$IFn$_invoke$arity$1(result) : ck.call(null,result))], null);
}catch (e36741){var t = e36741;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"data","data",-232669377),t], null);
}})();
return yin.test.common.result(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(out,new cljs.core.Keyword(null,"checker","checker",413112880),ck,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"actual","actual",107306363),result,new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"verify","verify",-1196899752)], 0)));
});
/**
 * determines if the results of a check have succeeded
 * 
 * (-> (satisfies Long)
 *     (verify )1
 *     succeeded?)
 * => true
 * 
 * (-> (satisfies even?)
 *     (verify 1)
 *     succeeded?)
 * => false
 */
yin.test.checker.base.succeeded_QMARK_ = (function yin$test$checker$base$succeeded_QMARK_(p__36742){
var map__36743 = p__36742;
var map__36743__$1 = ((((!((map__36743 == null)))?(((((map__36743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36743.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36743):map__36743);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36743__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36743__$1,new cljs.core.Keyword(null,"data","data",-232669377));
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"success","success",1890645906),type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(true,data)));
});
/**
 * checker that determines if an exception has been thrown
 * 
 * ((throws Exception "Hello There")
 *  (common/map->Result
 *   {:type :exception
 *    :data (Exception. "Hello There")}))
 * => true
 */
yin.test.checker.base.throws$ = (function yin$test$checker$base$throws(var_args){
var G__36746 = arguments.length;
switch (G__36746) {
case 0:
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$0 = (function (){
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"default","default",-1987822328));
});

yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$1 = (function (e){
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$2(e,null);
});

yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$2 = (function (e,msg){
return yin.test.common.checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"throws","throws",-562342583),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if an exception has been thrown",new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__36747){
var map__36748 = p__36747;
var map__36748__$1 = ((((!((map__36748 == null)))?(((((map__36748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36748):map__36748);
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36748__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36748__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var and__3925__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"exception","exception",-335277064),type);
if(and__3925__auto__){
throw "TODO";
} else {
return and__3925__auto__;
}
}),new cljs.core.Keyword(null,"expect","expect",-1170127352),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"exception","exception",-335277064),e,new cljs.core.Keyword(null,"message","message",-406056002),msg], null)], null));
});

yin.test.checker.base.throws$.cljs$lang$maxFixedArity = 2;

yin.test.checker.base.exactly = (function yin$test$checker$base$exactly(v){
return yin.test.common.checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"exactly","exactly",1304099233),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result exactly satisfies the condition",new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (res){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(yin.test.common.__GT_data(res),v);
}),new cljs.core.Keyword(null,"expect","expect",-1170127352),v], null));
});
yin.test.checker.base.satisfies = (function yin$test$checker$base$satisfies(v){
return yin.test.common.checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"satisfies","satisfies",-311664218),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result can satisfy the condition:",new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (res){
var data = yin.test.common.__GT_data(res);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(data,v)){
return true;
} else {
if(cljs.core.map_QMARK_(v)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,data),v);
} else {
if(cljs.core.vector_QMARK_(v)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(data,v);
} else {
if(cljs.core.ifn_QMARK_(v)){
return cljs.core.boolean$((v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(data) : v.call(null,data)));
} else {
return false;

}
}
}
}
}),new cljs.core.Keyword(null,"expect","expect",-1170127352),v], null));
});
/**
 * a checker that returns true for any value
 * 
 * (anything nil) => true
 *  
 * (anything [:hello :world]) => true
 */
yin.test.checker.base.anything = (function yin$test$checker$base$anything(x){
var fexpr__36751 = yin.test.checker.base.satisfies(yin.common.primitives.T);
return (fexpr__36751.cljs$core$IFn$_invoke$arity$1 ? fexpr__36751.cljs$core$IFn$_invoke$arity$1(x) : fexpr__36751.call(null,x));
});
/**
 * creates a 'satisfies' checker if not already a checker
 *  
 * ((->checker 1) 1) => true
 *  
 * ((->checker (exactly 1)) 1) => true
 */
yin.test.checker.base.__GT_checker = (function yin$test$checker$base$__GT_checker(x){
if((x instanceof yin.test.common.Checker)){
return x;
} else {
return yin.test.checker.base.satisfies(x);
}
});

//# sourceMappingURL=yin.test.checker.base.js.map
