goog.provide('yin.test.checker.logic');
goog.require('cljs.core');
goog.require('yin.test.common');
goog.require('yin.test.checker.base');
/**
 * checker that allows negative composition of checkers
 *  
 * (mapv (is-not even?)
 *       [1 2 3 4 5])
 * => [true false true false true]
 */
yin.test.checker.logic.is_not = (function yin$test$checker$logic$is_not(ck){
var ck__$1 = yin.test.checker.base.__GT_checker(ck);
return yin.test.common.checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"is-not","is-not",-677962855),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result is not an outcome",new cljs.core.Keyword(null,"fn","fn",-1175266204),((function (ck__$1){
return (function (res){
return cljs.core.not((ck__$1.cljs$core$IFn$_invoke$arity$1 ? ck__$1.cljs$core$IFn$_invoke$arity$1(res) : ck__$1.call(null,res)));
});})(ck__$1))
,new cljs.core.Keyword(null,"expect","expect",-1170127352),ck__$1], null));
});
/**
 * checker that allows `or` composition of checkers
 *  
 * (mapv (any even? 1)
 *       [1 2 3 4 5])
 * => [true true false true false]
 */
yin.test.checker.logic.any = (function yin$test$checker$logic$any(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36788 = arguments.length;
var i__4519__auto___36789 = (0);
while(true){
if((i__4519__auto___36789 < len__4518__auto___36788)){
args__4521__auto__.push((arguments[i__4519__auto___36789]));

var G__36791 = (i__4519__auto___36789 + (1));
i__4519__auto___36789 = G__36791;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.test.checker.logic.any.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.test.checker.logic.any.cljs$core$IFn$_invoke$arity$variadic = (function (cks){
var cks__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(yin.test.checker.base.__GT_checker,cks);
return yin.test.common.checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"any","any",1705907423),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result matches any of the checkers",new cljs.core.Keyword(null,"fn","fn",-1175266204),((function (cks__$1){
return (function (res){
var or__3936__auto__ = cljs.core.some(yin.test.checker.base.succeeded_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (cks__$1){
return (function (p1__36783_SHARP_){
return yin.test.checker.base.verify(p1__36783_SHARP_,res);
});})(cks__$1))
,cks__$1));
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return false;
}
});})(cks__$1))
,new cljs.core.Keyword(null,"expect","expect",-1170127352),cks__$1], null));
});

yin.test.checker.logic.any.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.test.checker.logic.any.cljs$lang$applyTo = (function (seq36784){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq36784));
});

/**
 * checker that allows `and` composition of checkers
 *  
 * (mapv (all even? #(< 3 %))
 *       [1 2 3 4 5])
 * => [false false false true false]
 */
yin.test.checker.logic.all = (function yin$test$checker$logic$all(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36797 = arguments.length;
var i__4519__auto___36798 = (0);
while(true){
if((i__4519__auto___36798 < len__4518__auto___36797)){
args__4521__auto__.push((arguments[i__4519__auto___36798]));

var G__36799 = (i__4519__auto___36798 + (1));
i__4519__auto___36798 = G__36799;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.test.checker.logic.all.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.test.checker.logic.all.cljs$core$IFn$_invoke$arity$variadic = (function (cks){
var cks__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(yin.test.checker.base.__GT_checker,cks);
return yin.test.common.checker(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"doc","doc",1913296891),"Checks if the result matches all of the checkers",new cljs.core.Keyword(null,"fn","fn",-1175266204),((function (cks__$1){
return (function (res){
return cljs.core.every_QMARK_(yin.test.checker.base.succeeded_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (cks__$1){
return (function (p1__36792_SHARP_){
return yin.test.checker.base.verify(p1__36792_SHARP_,res);
});})(cks__$1))
,cks__$1));
});})(cks__$1))
,new cljs.core.Keyword(null,"expect","expect",-1170127352),cks__$1], null));
});

yin.test.checker.logic.all.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.test.checker.logic.all.cljs$lang$applyTo = (function (seq36793){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq36793));
});


//# sourceMappingURL=yin.test.checker.logic.js.map
