goog.provide('yin.test.common');
goog.require('cljs.core');
goog.require('clojure.string');
if((typeof yin !== 'undefined') && (typeof yin.test !== 'undefined') && (typeof yin.test.common !== 'undefined') && (typeof yin.test.common._STAR_id_STAR_ !== 'undefined')){
} else {
yin.test.common._STAR_id_STAR_ = null;
}
if((typeof yin !== 'undefined') && (typeof yin.test !== 'undefined') && (typeof yin.test.common !== 'undefined') && (typeof yin.test.common._STAR_accumulator_STAR_ !== 'undefined')){
} else {
yin.test.common._STAR_accumulator_STAR_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
if((typeof yin !== 'undefined') && (typeof yin.test !== 'undefined') && (typeof yin.test.common !== 'undefined') && (typeof yin.test.common._STAR_errors_STAR_ !== 'undefined')){
} else {
yin.test.common._STAR_errors_STAR_ = null;
}
if((typeof yin !== 'undefined') && (typeof yin.test !== 'undefined') && (typeof yin.test.common !== 'undefined') && (typeof yin.test.common._STAR_print_STAR_ !== 'undefined')){
} else {
yin.test.common._STAR_print_STAR_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"print-bulk","print-bulk",1135161768),null,new cljs.core.Keyword(null,"print-failure","print-failure",-1738599187),null,new cljs.core.Keyword(null,"print-thrown","print-thrown",-178543920),null], null), null);
}

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
yin.test.common.Op = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
yin.test.common.Op.prototype.toString = (function (){
var self__ = this;
var op = this;
return ["#op.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(op))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,op),new cljs.core.Keyword(null,"type","type",1174270348)))].join('');
});

yin.test.common.Op.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12001__auto__,k__12002__auto__){
var self__ = this;
var this__12001__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12001__auto____$1,k__12002__auto__,null);
});

yin.test.common.Op.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12003__auto__,k26094,else__12004__auto__){
var self__ = this;
var this__12003__auto____$1 = this;
var G__26112 = k26094;
switch (G__26112) {
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26094,else__12004__auto__);

}
});

yin.test.common.Op.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12015__auto__,writer__12016__auto__,opts__12017__auto__){
var self__ = this;
var this__12015__auto____$1 = this;
var pr_pair__12018__auto__ = ((function (this__12015__auto____$1){
return (function (keyval__12019__auto__){
return cljs.core.pr_sequential_writer(writer__12016__auto__,cljs.core.pr_writer,""," ","",opts__12017__auto__,keyval__12019__auto__);
});})(this__12015__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12016__auto__,pr_pair__12018__auto__,"#yin.test.common.Op{",", ","}",opts__12017__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

yin.test.common.Op.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26093){
var self__ = this;
var G__26093__$1 = this;
return (new cljs.core.RecordIter((0),G__26093__$1,0,cljs.core.PersistentVector.EMPTY,(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

yin.test.common.Op.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11999__auto__){
var self__ = this;
var this__11999__auto____$1 = this;
return self__.__meta;
});

yin.test.common.Op.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11996__auto__){
var self__ = this;
var this__11996__auto____$1 = this;
return (new yin.test.common.Op(self__.__meta,self__.__extmap,self__.__hash));
});

yin.test.common.Op.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12005__auto__){
var self__ = this;
var this__12005__auto____$1 = this;
return (0 + cljs.core.count(self__.__extmap));
});

yin.test.common.Op.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11997__auto__){
var self__ = this;
var this__11997__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = (function (){var fexpr__26117 = ((function (h__4048__auto__,this__11997__auto____$1){
return (function (coll__11998__auto__){
return (245358784 ^ cljs.core.hash_unordered_coll(coll__11998__auto__));
});})(h__4048__auto__,this__11997__auto____$1))
;
return fexpr__26117(this__11997__auto____$1);
})();
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

yin.test.common.Op.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26095,other26096){
var self__ = this;
var this26095__$1 = this;
return ((!((other26096 == null))) && ((this26095__$1.constructor === other26096.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26095__$1.__extmap,other26096.__extmap)));
});

yin.test.common.Op.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12010__auto__,k__12011__auto__){
var self__ = this;
var this__12010__auto____$1 = this;
if(cljs.core.contains_QMARK_(cljs.core.PersistentHashSet.EMPTY,k__12011__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12010__auto____$1),self__.__meta),k__12011__auto__);
} else {
return (new yin.test.common.Op(self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12011__auto__)),null));
}
});

yin.test.common.Op.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12008__auto__,k__12009__auto__,G__26093){
var self__ = this;
var this__12008__auto____$1 = this;
var pred__26124 = cljs.core.keyword_identical_QMARK_;
var expr__26125 = k__12009__auto__;
return (new yin.test.common.Op(self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12009__auto__,G__26093),null));
});

yin.test.common.Op.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12013__auto__){
var self__ = this;
var this__12013__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

yin.test.common.Op.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12000__auto__,G__26093){
var self__ = this;
var this__12000__auto____$1 = this;
return (new yin.test.common.Op(G__26093,self__.__extmap,self__.__hash));
});

yin.test.common.Op.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12006__auto__,entry__12007__auto__){
var self__ = this;
var this__12006__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12007__auto__)){
return cljs.core._assoc(this__12006__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12006__auto____$1,entry__12007__auto__);
}
});

yin.test.common.Op.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

yin.test.common.Op.cljs$lang$type = true;

yin.test.common.Op.cljs$lang$ctorPrSeq = (function (this__4227__auto__){
return (new cljs.core.List(null,"yin.test.common/Op",null,(1),null));
});

yin.test.common.Op.cljs$lang$ctorPrWriter = (function (this__4227__auto__,writer__4228__auto__){
return cljs.core._write(writer__4228__auto__,"yin.test.common/Op");
});

/**
 * Positional factory function for yin.test.common/Op.
 */
yin.test.common.__GT_Op = (function yin$test$common$__GT_Op(){
return (new yin.test.common.Op(null,null,null));
});

/**
 * Factory function for yin.test.common/Op, taking a map of keywords to field values.
 */
yin.test.common.map__GT_Op = (function yin$test$common$map__GT_Op(G__26100){
var extmap__4223__auto__ = (function (){var G__26131 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(G__26100);
if(cljs.core.record_QMARK_(G__26100)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26131);
} else {
return G__26131;
}
})();
return (new yin.test.common.Op(null,cljs.core.not_empty(extmap__4223__auto__),null));
});

yin.test.common.Op.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

yin.test.common.Op.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (op,writer,_){
var op__$1 = this;
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(op__$1)].join('')], 0));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
yin.test.common.Result = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
yin.test.common.Result.prototype.toString = (function (){
var self__ = this;
var res = this;
return ["#result.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(res))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,res),new cljs.core.Keyword(null,"type","type",1174270348)))].join('');
});

yin.test.common.Result.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12001__auto__,k__12002__auto__){
var self__ = this;
var this__12001__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12001__auto____$1,k__12002__auto__,null);
});

yin.test.common.Result.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12003__auto__,k26151,else__12004__auto__){
var self__ = this;
var this__12003__auto____$1 = this;
var G__26158 = k26151;
switch (G__26158) {
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26151,else__12004__auto__);

}
});

yin.test.common.Result.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12015__auto__,writer__12016__auto__,opts__12017__auto__){
var self__ = this;
var this__12015__auto____$1 = this;
var pr_pair__12018__auto__ = ((function (this__12015__auto____$1){
return (function (keyval__12019__auto__){
return cljs.core.pr_sequential_writer(writer__12016__auto__,cljs.core.pr_writer,""," ","",opts__12017__auto__,keyval__12019__auto__);
});})(this__12015__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12016__auto__,pr_pair__12018__auto__,"#yin.test.common.Result{",", ","}",opts__12017__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

yin.test.common.Result.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26150){
var self__ = this;
var G__26150__$1 = this;
return (new cljs.core.RecordIter((0),G__26150__$1,0,cljs.core.PersistentVector.EMPTY,(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

yin.test.common.Result.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11999__auto__){
var self__ = this;
var this__11999__auto____$1 = this;
return self__.__meta;
});

yin.test.common.Result.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11996__auto__){
var self__ = this;
var this__11996__auto____$1 = this;
return (new yin.test.common.Result(self__.__meta,self__.__extmap,self__.__hash));
});

yin.test.common.Result.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12005__auto__){
var self__ = this;
var this__12005__auto____$1 = this;
return (0 + cljs.core.count(self__.__extmap));
});

yin.test.common.Result.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11997__auto__){
var self__ = this;
var this__11997__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = (function (){var fexpr__26163 = ((function (h__4048__auto__,this__11997__auto____$1){
return (function (coll__11998__auto__){
return (-1981247755 ^ cljs.core.hash_unordered_coll(coll__11998__auto__));
});})(h__4048__auto__,this__11997__auto____$1))
;
return fexpr__26163(this__11997__auto____$1);
})();
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

yin.test.common.Result.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26152,other26153){
var self__ = this;
var this26152__$1 = this;
return ((!((other26153 == null))) && ((this26152__$1.constructor === other26153.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26152__$1.__extmap,other26153.__extmap)));
});

yin.test.common.Result.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12010__auto__,k__12011__auto__){
var self__ = this;
var this__12010__auto____$1 = this;
if(cljs.core.contains_QMARK_(cljs.core.PersistentHashSet.EMPTY,k__12011__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12010__auto____$1),self__.__meta),k__12011__auto__);
} else {
return (new yin.test.common.Result(self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12011__auto__)),null));
}
});

yin.test.common.Result.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12008__auto__,k__12009__auto__,G__26150){
var self__ = this;
var this__12008__auto____$1 = this;
var pred__26164 = cljs.core.keyword_identical_QMARK_;
var expr__26165 = k__12009__auto__;
return (new yin.test.common.Result(self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12009__auto__,G__26150),null));
});

yin.test.common.Result.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12013__auto__){
var self__ = this;
var this__12013__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

yin.test.common.Result.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12000__auto__,G__26150){
var self__ = this;
var this__12000__auto____$1 = this;
return (new yin.test.common.Result(G__26150,self__.__extmap,self__.__hash));
});

yin.test.common.Result.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12006__auto__,entry__12007__auto__){
var self__ = this;
var this__12006__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12007__auto__)){
return cljs.core._assoc(this__12006__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12006__auto____$1,entry__12007__auto__);
}
});

yin.test.common.Result.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

yin.test.common.Result.cljs$lang$type = true;

yin.test.common.Result.cljs$lang$ctorPrSeq = (function (this__4227__auto__){
return (new cljs.core.List(null,"yin.test.common/Result",null,(1),null));
});

yin.test.common.Result.cljs$lang$ctorPrWriter = (function (this__4227__auto__,writer__4228__auto__){
return cljs.core._write(writer__4228__auto__,"yin.test.common/Result");
});

/**
 * Positional factory function for yin.test.common/Result.
 */
yin.test.common.__GT_Result = (function yin$test$common$__GT_Result(){
return (new yin.test.common.Result(null,null,null));
});

/**
 * Factory function for yin.test.common/Result, taking a map of keywords to field values.
 */
yin.test.common.map__GT_Result = (function yin$test$common$map__GT_Result(G__26157){
var extmap__4223__auto__ = (function (){var G__26167 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(G__26157);
if(cljs.core.record_QMARK_(G__26157)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26167);
} else {
return G__26167;
}
})();
return (new yin.test.common.Result(null,cljs.core.not_empty(extmap__4223__auto__),null));
});

yin.test.common.Result.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

yin.test.common.Result.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (op,writer,_){
var op__$1 = this;
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(op__$1)].join('')], 0));
});
/**
 * creates a 'hara.test.common.Result' object
 * 
 * (result {:type :success :data true})
 * => hara.test.common.Result
 */
yin.test.common.result = (function yin$test$common$result(m){
return yin.test.common.map__GT_Result(m);
});
yin.test.common.result_QMARK_ = (function yin$test$common$result_QMARK_(x){
return (x instanceof yin.test.common.Result);
});
yin.test.common.__GT_data = (function yin$test$common$__GT_data(res){
if(cljs.core.truth_(yin.test.common.result_QMARK_(res))){
return new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(res);
} else {
return res;
}
});
yin.test.common.function_string = (function yin$test$common$function_string(func){
return cljs.core.demunge(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(func))].join(''),/\$/)));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
yin.test.common.Checker = (function (fn,__meta,__extmap,__hash){
this.fn = fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
yin.test.common.Checker.prototype.toString = (function (){
var self__ = this;
var map__26206 = this;
var map__26206__$1 = ((((!((map__26206 == null)))?(((((map__26206.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26206.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26206):map__26206);
var expect = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26206__$1,new cljs.core.Keyword(null,"expect","expect",-1170127352));
var tag = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26206__$1,new cljs.core.Keyword(null,"tag","tag",-1290361223));
return ["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name(tag)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(expect))?expect:((cljs.core.fn_QMARK_(expect))?["<",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.test.common.function_string(expect)),">"].join(''):["<",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expect),">"].join('')
)))].join('');
});

yin.test.common.Checker.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__12001__auto__,k__12002__auto__){
var self__ = this;
var this__12001__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__12001__auto____$1,k__12002__auto__,null);
});

yin.test.common.Checker.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__12003__auto__,k26194,else__12004__auto__){
var self__ = this;
var this__12003__auto____$1 = this;
var G__26208 = k26194;
var G__26208__$1 = (((G__26208 instanceof cljs.core.Keyword))?G__26208.fqn:null);
switch (G__26208__$1) {
case "fn":
return self__.fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26194,else__12004__auto__);

}
});

yin.test.common.Checker.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__12015__auto__,writer__12016__auto__,opts__12017__auto__){
var self__ = this;
var this__12015__auto____$1 = this;
var pr_pair__12018__auto__ = ((function (this__12015__auto____$1){
return (function (keyval__12019__auto__){
return cljs.core.pr_sequential_writer(writer__12016__auto__,cljs.core.pr_writer,""," ","",opts__12017__auto__,keyval__12019__auto__);
});})(this__12015__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__12016__auto__,pr_pair__12018__auto__,"#yin.test.common.Checker{",", ","}",opts__12017__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn","fn",-1175266204),self__.fn],null))], null),self__.__extmap));
});

yin.test.common.Checker.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26193){
var self__ = this;
var G__26193__$1 = this;
return (new cljs.core.RecordIter((0),G__26193__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fn","fn",-1175266204)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

yin.test.common.Checker.prototype.call = (function (self__,data){
var self__ = this;
var self____$1 = this;
var ck = self____$1;
var func = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(ck);
return (func.cljs$core$IFn$_invoke$arity$1 ? func.cljs$core$IFn$_invoke$arity$1(data) : func.call(null,data));
});

yin.test.common.Checker.prototype.apply = (function (self__,args26201){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args26201)));
});

yin.test.common.Checker.prototype.cljs$core$IFn$_invoke$arity$1 = (function (data){
var self__ = this;
var ck = this;
var func = new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(ck);
return (func.cljs$core$IFn$_invoke$arity$1 ? func.cljs$core$IFn$_invoke$arity$1(data) : func.call(null,data));
});

yin.test.common.Checker.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__11999__auto__){
var self__ = this;
var this__11999__auto____$1 = this;
return self__.__meta;
});

yin.test.common.Checker.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__11996__auto__){
var self__ = this;
var this__11996__auto____$1 = this;
return (new yin.test.common.Checker(self__.fn,self__.__meta,self__.__extmap,self__.__hash));
});

yin.test.common.Checker.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__12005__auto__){
var self__ = this;
var this__12005__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
});

yin.test.common.Checker.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__11997__auto__){
var self__ = this;
var this__11997__auto____$1 = this;
var h__4048__auto__ = self__.__hash;
if(!((h__4048__auto__ == null))){
return h__4048__auto__;
} else {
var h__4048__auto____$1 = (function (){var fexpr__26209 = ((function (h__4048__auto__,this__11997__auto____$1){
return (function (coll__11998__auto__){
return (-279956727 ^ cljs.core.hash_unordered_coll(coll__11998__auto__));
});})(h__4048__auto__,this__11997__auto____$1))
;
return fexpr__26209(this__11997__auto____$1);
})();
self__.__hash = h__4048__auto____$1;

return h__4048__auto____$1;
}
});

yin.test.common.Checker.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26195,other26196){
var self__ = this;
var this26195__$1 = this;
return ((!((other26196 == null))) && ((this26195__$1.constructor === other26196.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26195__$1.fn,other26196.fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26195__$1.__extmap,other26196.__extmap)));
});

yin.test.common.Checker.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__12010__auto__,k__12011__auto__){
var self__ = this;
var this__12010__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"fn","fn",-1175266204),null], null), null),k__12011__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__12010__auto____$1),self__.__meta),k__12011__auto__);
} else {
return (new yin.test.common.Checker(self__.fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__12011__auto__)),null));
}
});

yin.test.common.Checker.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__12008__auto__,k__12009__auto__,G__26193){
var self__ = this;
var this__12008__auto____$1 = this;
var pred__26210 = cljs.core.keyword_identical_QMARK_;
var expr__26211 = k__12009__auto__;
if(cljs.core.truth_((function (){var G__26213 = new cljs.core.Keyword(null,"fn","fn",-1175266204);
var G__26214 = expr__26211;
return (pred__26210.cljs$core$IFn$_invoke$arity$2 ? pred__26210.cljs$core$IFn$_invoke$arity$2(G__26213,G__26214) : pred__26210.call(null,G__26213,G__26214));
})())){
return (new yin.test.common.Checker(G__26193,self__.__meta,self__.__extmap,null));
} else {
return (new yin.test.common.Checker(self__.fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__12009__auto__,G__26193),null));
}
});

yin.test.common.Checker.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__12013__auto__){
var self__ = this;
var this__12013__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fn","fn",-1175266204),self__.fn],null))], null),self__.__extmap));
});

yin.test.common.Checker.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__12000__auto__,G__26193){
var self__ = this;
var this__12000__auto____$1 = this;
return (new yin.test.common.Checker(self__.fn,G__26193,self__.__extmap,self__.__hash));
});

yin.test.common.Checker.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__12006__auto__,entry__12007__auto__){
var self__ = this;
var this__12006__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__12007__auto__)){
return cljs.core._assoc(this__12006__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__12007__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__12006__auto____$1,entry__12007__auto__);
}
});

yin.test.common.Checker.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"fn","fn",465265323,null)], null);
});

yin.test.common.Checker.cljs$lang$type = true;

yin.test.common.Checker.cljs$lang$ctorPrSeq = (function (this__4227__auto__){
return (new cljs.core.List(null,"yin.test.common/Checker",null,(1),null));
});

yin.test.common.Checker.cljs$lang$ctorPrWriter = (function (this__4227__auto__,writer__4228__auto__){
return cljs.core._write(writer__4228__auto__,"yin.test.common/Checker");
});

/**
 * Positional factory function for yin.test.common/Checker.
 */
yin.test.common.__GT_Checker = (function yin$test$common$__GT_Checker(fn){
return (new yin.test.common.Checker(fn,null,null,null));
});

/**
 * Factory function for yin.test.common/Checker, taking a map of keywords to field values.
 */
yin.test.common.map__GT_Checker = (function yin$test$common$map__GT_Checker(G__26200){
var extmap__4223__auto__ = (function (){var G__26217 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__26200,new cljs.core.Keyword(null,"fn","fn",-1175266204));
if(cljs.core.record_QMARK_(G__26200)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26217);
} else {
return G__26217;
}
})();
return (new yin.test.common.Checker(new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(G__26200),null,cljs.core.not_empty(extmap__4223__auto__),null));
});

yin.test.common.Checker.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL;

yin.test.common.Checker.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (op,writer,_){
var op__$1 = this;
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(op__$1)].join('')], 0));
});
/**
 * creates a 'hara.test.common.Checker' object
 * 
 * (checker {:tag :anything :fn (fn [x] true)})
 * => hara.test.common.Checker
 */
yin.test.common.checker = (function yin$test$common$checker(m){
return yin.test.common.map__GT_Checker(m);
});
/**
 * checks to see if a datastructure is a 'hara.test.common.Checker'
 * 
 * (checker? (checker {:tag :anything :fn (fn [x] true)}))
 * => true
 */
yin.test.common.checker_QMARK_ = (function yin$test$common$checker_QMARK_(x){
return (x instanceof yin.test.common.Checker);
});
/**
 * converts a form to a result
 * 
 * (->> (evaluate '(+ 1 2 3))
 *      (into {}))
 * => {:type :success, :data 6, :form '(+ 1 2 3), :from :evaluate}
 */
yin.test.common.evaluate = (function yin$test$common$evaluate(p__26241){
var map__26242 = p__26241;
var map__26242__$1 = ((((!((map__26242 == null)))?(((((map__26242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26242.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26242):map__26242);
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26242__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26242__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var out = (function (){try{return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"data","data",-232669377),(function$.cljs$core$IFn$_invoke$arity$0 ? function$.cljs$core$IFn$_invoke$arity$0() : function$.call(null))], null);
}catch (e26244){var t = e26244;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"data","data",-232669377),t], null);
}})();
return yin.test.common.result(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(out,new cljs.core.Keyword(null,"form","form",-1624062471),form,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"evaluate","evaluate",1525218437)], 0)));
});

//# sourceMappingURL=yin.test.common.js.map
