goog.provide('yin.test.form.print');
goog.require('cljs.core');
goog.require('yin.io.ansii');
goog.require('yin.test.checker.base');
goog.require('yin.test.common');
goog.require('clojure.string');
/**
 * outputs the description for a successful test
 */
yin.test.form.print.print_success = (function yin$test$form$print$print_success(p__36752){
var map__36753 = p__36752;
var map__36753__$1 = ((((!((map__36753 == null)))?(((((map__36753.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36753.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36753):map__36753);
var summary = map__36753__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36753__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36753__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36753__$1,new cljs.core.Keyword(null,"line","line",212345235));
var desc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36753__$1,new cljs.core.Keyword(null,"desc","desc",2093485764));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36753__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var check = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36753__$1,new cljs.core.Keyword(null,"check","check",1226308904));
var name__$1 = (cljs.core.truth_(name)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)," @ "].join(''):"");
var file = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),/\./)))),".cljs"].join('');
var line__$1 = (cljs.core.truth_(line)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):"");
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style("Success",new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"green","green",-945526839),null], null), null))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line__$1),"]",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(desc)?["\n    ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Info"], 0))),"  \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(desc),"",cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join(''):"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n    ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Form"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(form)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n   ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Check"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(check)].join(''))].join('')], 0));
});
/**
 * outputs the description for a failed test
 */
yin.test.form.print.print_failure = (function yin$test$form$print$print_failure(p__36757){
var map__36758 = p__36757;
var map__36758__$1 = ((((!((map__36758 == null)))?(((((map__36758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36758.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36758):map__36758);
var summary = map__36758__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36758__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36758__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36758__$1,new cljs.core.Keyword(null,"line","line",212345235));
var desc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36758__$1,new cljs.core.Keyword(null,"desc","desc",2093485764));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36758__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var check = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36758__$1,new cljs.core.Keyword(null,"check","check",1226308904));
var actual = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36758__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var name__$1 = (cljs.core.truth_(name)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)," @ "].join(''):"");
var file = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),/\./)))),".cljs"].join('');
var line__$1 = (cljs.core.truth_(line)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):"");
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style("Failure",new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"red","red",-969428204),null], null), null))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line__$1),"]",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(desc)?["\n    ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Info"], 0))),"  \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(desc),"",cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join(''):"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n    ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Form"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(form)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n   ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Check"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(check)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Actual"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.sequential_QMARK_(actual))?cljs.core.vec(actual):actual))].join(''))].join('')], 0));
});
/**
 * outputs the description for a failed test
 */
yin.test.form.print.print_failure_short = (function yin$test$form$print$print_failure_short(p__36768){
var map__36769 = p__36768;
var map__36769__$1 = ((((!((map__36769 == null)))?(((((map__36769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36769):map__36769);
var summary = map__36769__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36769__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36769__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36769__$1,new cljs.core.Keyword(null,"line","line",212345235));
var name__$1 = (cljs.core.truth_(name)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)," @ "].join(''):"");
var file = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),/\./)))),".cljs"].join('');
var line__$1 = (cljs.core.truth_(line)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):"");
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style(" Failure",new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"red","red",-969428204),null], null), null))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line__$1),"]"].join('')], 0));
});
/**
 * outputs the description for a form that throws an exception
 */
yin.test.form.print.print_thrown = (function yin$test$form$print$print_thrown(p__36771){
var map__36772 = p__36771;
var map__36772__$1 = ((((!((map__36772 == null)))?(((((map__36772.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36772.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36772):map__36772);
var summary = map__36772__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36772__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36772__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36772__$1,new cljs.core.Keyword(null,"line","line",212345235));
var desc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36772__$1,new cljs.core.Keyword(null,"desc","desc",2093485764));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36772__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var name__$1 = (cljs.core.truth_(name)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)," @ "].join(''):"");
var file = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),/\./)))),".clj"].join('');
var line__$1 = (cljs.core.truth_(line)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):"");
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style(" Thrown",new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"yellow","yellow",-881035449),null], null), null))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line__$1),"]",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(desc)?["\n    ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Info"], 0))),"  \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(desc),"",cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join(''):"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n    ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Form"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(form)].join(''))].join('')], 0));
});
/**
 * outputs the description for a form that throws an exception
 */
yin.test.form.print.print_thrown_short = (function yin$test$form$print$print_thrown_short(p__36776){
var map__36777 = p__36776;
var map__36777__$1 = ((((!((map__36777 == null)))?(((((map__36777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36777.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36777):map__36777);
var summary = map__36777__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36777__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36777__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36777__$1,new cljs.core.Keyword(null,"line","line",212345235));
var name__$1 = (cljs.core.truth_(name)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)," @ "].join(''):"");
var file = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),/\./)))),".clj"].join('');
var line__$1 = (cljs.core.truth_(line)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):"");
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style(" Thrown",new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"yellow","yellow",-881035449),null], null), null))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line__$1),"]"].join('')], 0));
});
/**
 * outputs the description for a fact form that contains many statements
 */
yin.test.form.print.print_fact = (function yin$test$form$print$print_fact(p__36782,results){
var map__36785 = p__36782;
var map__36785__$1 = ((((!((map__36785 == null)))?(((((map__36785.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36785.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36785):map__36785);
var meta = map__36785__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36785__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36785__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36785__$1,new cljs.core.Keyword(null,"line","line",212345235));
var desc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36785__$1,new cljs.core.Keyword(null,"desc","desc",2093485764));
var refer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36785__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var name__$1 = (cljs.core.truth_(name)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)," @ "].join(''):"");
var file = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.munge(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)].join(''),/\./)))),".cljs"].join('');
var line__$1 = (cljs.core.truth_(line)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):"");
var all = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (name__$1,file,line__$1,map__36785,map__36785__$1,meta,name,ns,line,desc,refer){
return (function (p1__36779_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(p1__36779_SHARP_),new cljs.core.Keyword(null,"verify","verify",-1196899752));
});})(name__$1,file,line__$1,map__36785,map__36785__$1,meta,name,ns,line,desc,refer))
,results);
var passed = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(yin.test.checker.base.succeeded_QMARK_,all);
var num = cljs.core.count(passed);
var total = cljs.core.count(all);
var ops = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (name__$1,file,line__$1,all,passed,num,total,map__36785,map__36785__$1,meta,name,ns,line,desc,refer){
return (function (p1__36780_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(p1__36780_SHARP_),new cljs.core.Keyword(null,"evaluate","evaluate",1525218437));
});})(name__$1,file,line__$1,all,passed,num,total,map__36785,map__36785__$1,meta,name,ns,line,desc,refer))
,results);
var errors = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (name__$1,file,line__$1,all,passed,num,total,ops,map__36785,map__36785__$1,meta,name,ns,line,desc,refer){
return (function (p1__36781_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(p1__36781_SHARP_),new cljs.core.Keyword(null,"exception","exception",-335277064));
});})(name__$1,file,line__$1,all,passed,num,total,ops,map__36785,map__36785__$1,meta,name,ns,line,desc,refer))
,ops);
var thrown = cljs.core.count(errors);
if(cljs.core.truth_((function (){var or__3936__auto__ = (function (){var G__36790 = new cljs.core.Keyword(null,"print-facts-success","print-facts-success",218687116);
return (yin.test.common._STAR_print_STAR_.cljs$core$IFn$_invoke$arity$1 ? yin.test.common._STAR_print_STAR_.cljs$core$IFn$_invoke$arity$1(G__36790) : yin.test.common._STAR_print_STAR_.call(null,G__36790));
})();
if(cljs.core.truth_(or__3936__auto__)){
return or__3936__auto__;
} else {
return !(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(num,total)) && ((thrown > (0)))));
}
})())){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style("   Fact",new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"blue","blue",-622100620),null], null), null))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line__$1),"]",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(refer)?[" - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(refer)].join(''):null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(desc)?["\n    ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Info"], 0))),"  \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(desc),"",cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join(''):"")),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Passed"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style(num,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(num,total))?new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"blue","blue",-622100620),null], null), null):new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"green","green",-945526839),null], null), null))))," of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.blue.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([total], 0)))].join(''))].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1((((thrown > (0)))?["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Thrown"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.yellow.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([thrown], 0)))].join(''):""))].join('')], 0));
} else {
return null;
}
});
/**
 * outputs the description for an entire test run
 */
yin.test.form.print.print_summary = (function yin$test$form$print$print_summary(p__36800){
var map__36801 = p__36800;
var map__36801__$1 = ((((!((map__36801 == null)))?(((((map__36801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36801):map__36801);
var result = map__36801__$1;
var files = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36801__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var thrown = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36801__$1,new cljs.core.Keyword(null,"thrown","thrown",-978456523));
var facts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36801__$1,new cljs.core.Keyword(null,"facts","facts",-1734543718));
var checks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36801__$1,new cljs.core.Keyword(null,"checks","checks",526134637));
var passed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36801__$1,new cljs.core.Keyword(null,"passed","passed",-28165278));
var failed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36801__$1,new cljs.core.Keyword(null,"failed","failed",-1397425762));
var npassed = cljs.core.count(passed);
var nchecks = cljs.core.count(checks);
var nfailed = cljs.core.count(failed);
var nthrown = cljs.core.count(thrown);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.style(["Summary (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(files),")"].join(''),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"blue","blue",-622100620),null], null), null))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" Files"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.blue.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.count(files)], 0)))].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" Facts"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.blue.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.count(facts)], 0)))].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Checks"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.blue.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([nchecks], 0)))].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Passed"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var fexpr__36803 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(npassed,nchecks))?yin.io.ansii.blue:yin.io.ansii.yellow);
return (fexpr__36803.cljs$core$IFn$_invoke$arity$1 ? fexpr__36803.cljs$core$IFn$_invoke$arity$1(npassed) : fexpr__36803.call(null,npassed));
})())].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1(["\n  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(yin.io.ansii.white.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Thrown"], 0))),"  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var fexpr__36804 = (((nthrown > (0)))?yin.io.ansii.yellow:yin.io.ansii.blue);
return (fexpr__36804.cljs$core$IFn$_invoke$arity$1 ? fexpr__36804.cljs$core$IFn$_invoke$arity$1(nthrown) : fexpr__36804.call(null,nthrown));
})())].join(''))].join('')], 0));

if((nfailed > (0))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n",yin.io.ansii.style(["Failed  (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(nfailed),")"].join(''),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"red","red",-969428204),null], null), null))], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["\n",yin.io.ansii.style(["Success (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(npassed),")"].join(''),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"bold","bold",-116809535),null,new cljs.core.Keyword(null,"cyan","cyan",1118839274),null], null), null))], 0));
}

return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([""], 0));
});

//# sourceMappingURL=yin.test.form.print.js.map
