goog.provide('yin.test');
goog.require('cljs.core');
goog.require('yin.test.common');
goog.require('yin.test.form.process');
goog.require('yin.test.form.listener');
goog.require('yin.test.runner');
goog.require('yin.test.checker.base');
goog.require('yin.test.checker.logic');
goog.require('yin.test.checker.collection');
goog.require('yin.io.ansii');
new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
/**
 * checker that determines if an exception has been thrown
 * 
 * ((throws Exception "Hello There")
 *  (common/map->Result
 *   {:type :exception
 *    :data (Exception. "Hello There")}))
 * => true
 */
yin.test.throws$ = (function yin$test$throws(var_args){
var G__36864 = arguments.length;
switch (G__36864) {
case 0:
return yin.test.throws$.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return yin.test.throws$.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return yin.test.throws$.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.test.throws$.cljs$core$IFn$_invoke$arity$0 = (function (){
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$0();
});

yin.test.throws$.cljs$core$IFn$_invoke$arity$1 = (function (e){
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$1(e);
});

yin.test.throws$.cljs$core$IFn$_invoke$arity$2 = (function (e,msg){
return yin.test.checker.base.throws$.cljs$core$IFn$_invoke$arity$2(e,msg);
});

yin.test.throws$.cljs$lang$maxFixedArity = 2;

return null;
})()
,yin.test.exactly = (function yin$test$exactly(v){
return yin.test.checker.base.exactly(v);
}),yin.test.satisfies = (function yin$test$satisfies(v){
return yin.test.checker.base.satisfies(v);
}),/**
 * a checker that returns true for any value
 * 
 * (anything nil) => true
 *  
 * (anything [:hello :world]) => true
 */
yin.test.anything = (function yin$test$anything(x){
return yin.test.checker.base.anything(x);
}),(function (){
/**
 * checker for maps and vectors
 *  
 * ((contains {:a odd? :b even?}) {:a 1 :b 4})
 * => true
 *  
 * ((contains {:a 1 :b even?}) {:a 2 :b 4})
 * => false
 *  
 * ((contains [1 2 3]) [1 2 3 4])
 * => true
 *  
 * ((contains [1 3]) [1 2 3 4])
 * => false
 *  
 * 
 */
yin.test.contains = (function yin$test$contains(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36872 = arguments.length;
var i__4519__auto___36873 = (0);
while(true){
if((i__4519__auto___36873 < len__4518__auto___36872)){
args__4521__auto__.push((arguments[i__4519__auto___36873]));

var G__36874 = (i__4519__auto___36873 + (1));
i__4519__auto___36873 = G__36874;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((1) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((1)),(0),null)):null);
return yin.test.contains.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4522__auto__);
});

yin.test.contains.cljs$core$IFn$_invoke$arity$variadic = (function (x,modifiers){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(yin.test.checker.collection.contains,x,modifiers);
});

yin.test.contains.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
yin.test.contains.cljs$lang$applyTo = (function (seq36865){
var G__36866 = cljs.core.first(seq36865);
var seq36865__$1 = cljs.core.next(seq36865);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36866,seq36865__$1);
});

return null;
})()
,(function (){
/**
 * combination checker for both maps and vectors
 *  
 * ((just {:a odd? :b even?}) {:a 1 :b 4})
 * => true
 *  
 * ((just {:a 1 :b even?}) {:a 1 :b 2 :c 3})
 * => false
 *  
 * ((just [1 2 3 4]) [1 2 3 4])
 * => true
 * 
 * ((just [1 2 3]) [1 2 3 4])
 * => false
 *  
 * ((just [3 2 4 1] :in-any-order) [1 2 3 4])
 * => true
 */
yin.test.just = (function yin$test$just(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36875 = arguments.length;
var i__4519__auto___36876 = (0);
while(true){
if((i__4519__auto___36876 < len__4518__auto___36875)){
args__4521__auto__.push((arguments[i__4519__auto___36876]));

var G__36877 = (i__4519__auto___36876 + (1));
i__4519__auto___36876 = G__36877;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((1) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((1)),(0),null)):null);
return yin.test.just.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4522__auto__);
});

yin.test.just.cljs$core$IFn$_invoke$arity$variadic = (function (x,modifiers){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(yin.test.checker.collection.just,x,modifiers);
});

yin.test.just.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
yin.test.just.cljs$lang$applyTo = (function (seq36867){
var G__36868 = cljs.core.first(seq36867);
var seq36867__$1 = cljs.core.next(seq36867);
var self__4505__auto__ = this;
return self__4505__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36868,seq36867__$1);
});

return null;
})()
,(function (){
/**
 * checker that allows `or` composition of checkers
 *  
 * (mapv (any even? 1)
 *       [1 2 3 4 5])
 * => [true true false true false]
 */
yin.test.any = (function yin$test$any(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36878 = arguments.length;
var i__4519__auto___36879 = (0);
while(true){
if((i__4519__auto___36879 < len__4518__auto___36878)){
args__4521__auto__.push((arguments[i__4519__auto___36879]));

var G__36880 = (i__4519__auto___36879 + (1));
i__4519__auto___36879 = G__36880;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.test.any.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.test.any.cljs$core$IFn$_invoke$arity$variadic = (function (cks){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(yin.test.checker.logic.any,cks);
});

yin.test.any.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.test.any.cljs$lang$applyTo = (function (seq36869){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq36869));
});

return null;
})()
,(function (){
/**
 * checker that allows `and` composition of checkers
 *  
 * (mapv (all even? #(< 3 %))
 *       [1 2 3 4 5])
 * => [false false false true false]
 */
yin.test.all = (function yin$test$all(var_args){
var args__4521__auto__ = [];
var len__4518__auto___36881 = arguments.length;
var i__4519__auto___36882 = (0);
while(true){
if((i__4519__auto___36882 < len__4518__auto___36881)){
args__4521__auto__.push((arguments[i__4519__auto___36882]));

var G__36883 = (i__4519__auto___36882 + (1));
i__4519__auto___36882 = G__36883;
continue;
} else {
}
break;
}

var argseq__4522__auto__ = ((((0) < args__4521__auto__.length))?(new cljs.core.IndexedSeq(args__4521__auto__.slice((0)),(0),null)):null);
return yin.test.all.cljs$core$IFn$_invoke$arity$variadic(argseq__4522__auto__);
});

yin.test.all.cljs$core$IFn$_invoke$arity$variadic = (function (cks){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(yin.test.checker.logic.all,cks);
});

yin.test.all.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
yin.test.all.cljs$lang$applyTo = (function (seq36870){
var self__4506__auto__ = this;
return self__4506__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq36870));
});

return null;
})()
,/**
 * checker that allows negative composition of checkers
 *  
 * (mapv (is-not even?)
 *       [1 2 3 4 5])
 * => [true false true false true]
 */
yin.test.is_not = (function yin$test$is_not(ck){
return yin.test.checker.logic.is_not(ck);
})], null);
yin.test.form.listener.install_listeners();
/**
 * output options for test results
 *  
 * (print-options)
 * => #{:disable :reset :default :all :list :current :help}
 *  
 * (print-options :default)
 * => #{:print-bulk :print-failure :print-thrown}
 * 
 */
yin.test.print_options = (function yin$test$print_options(var_args){
var G__36885 = arguments.length;
switch (G__36885) {
case 0:
return yin.test.print_options.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return yin.test.print_options.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

yin.test.print_options.cljs$core$IFn$_invoke$arity$0 = (function (){
return yin.test.print_options.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"help","help",-439233446));
});

yin.test.print_options.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if(cljs.core.set_QMARK_(opts)){
return yin.test.common._STAR_print_STAR_ = opts;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"help","help",-439233446),opts)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"disable","disable",1717637504),null,new cljs.core.Keyword(null,"reset","reset",-800929946),null,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"all","all",892129742),null,new cljs.core.Keyword(null,"list","list",765357683),null,new cljs.core.Keyword(null,"current","current",-1088038603),null,new cljs.core.Keyword(null,"help","help",-439233446),null], null), null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"current","current",-1088038603),opts)){
return yin.test.common._STAR_print_STAR_;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),opts)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"print-bulk","print-bulk",1135161768),null,new cljs.core.Keyword(null,"print-failure","print-failure",-1738599187),null,new cljs.core.Keyword(null,"print-thrown","print-thrown",-178543920),null], null), null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"list","list",765357683),opts)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"print-bulk","print-bulk",1135161768),null,new cljs.core.Keyword(null,"print-facts-success","print-facts-success",218687116),null,new cljs.core.Keyword(null,"print-failure","print-failure",-1738599187),null,new cljs.core.Keyword(null,"print-thrown","print-thrown",-178543920),null,new cljs.core.Keyword(null,"print-facts","print-facts",14538385),null,new cljs.core.Keyword(null,"print-success","print-success",-1473371233),null], null), null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"disable","disable",1717637504),opts)){
return yin.test.common._STAR_print_STAR_ = cljs.core.PersistentHashSet.EMPTY;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"reset","reset",-800929946),opts)){
return yin.test.common._STAR_print_STAR_ = yin.test.print_options.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"default","default",-1987822328));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"all","all",892129742),opts)){
return yin.test.common._STAR_print_STAR_ = yin.test.print_options.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"list","list",765357683));
} else {
return null;
}
}
}
}
}
}
}
}
});

yin.test.print_options.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=yin.test.js.map
