(ns yin.namespace.import
  (:refer-clojure :exclude [import var]))

(defmacro var [v]
  `(#'~v))

(defn import-var-func [fsym args]
  (let [params (reduce (fn [out arg]
                         (cond (= arg '&)
                               (assoc out :varg? true)

                               (map? arg)
                               (update-in out [:list] conj (:as arg))

                               :else
                               (update-in out [:list] conj arg)))
                       {:list []
                        :varg? false}
                       args)]
    (if (:varg? params)
      (list args (apply list 'apply fsym (:list params)))
      (list args (apply list fsym (:list params))))))

(defn import-var-form [nss sym {:keys [arglists doc] :as meta}]
  (let [ext (symbol (str nss) (str sym))]
    (cond (nil? arglists)
          `(def ~sym ~ext)

          :else
          `(defn ~sym
             ~meta
             ~@(for [args (eval arglists)]
                 (import-var-func ext args))))))

(defmacro import-var [nss sym]
  (let [meta (-> (cljs.analyzer.api/find-ns nss)
                 :defs
                 (get sym)
                 :meta)]
    (import-var-form nss sym meta)))

(defn import-namespace-form [nss syms]
  (let [defs (:defs (cljs.analyzer.api/find-ns nss))]
    (mapv (fn [sym]
            (let [meta (-> defs (get sym) :meta)]
              (import-var-form nss sym meta)))
          syms)))

(defmacro import-namespace [nss syms]
  (import-namespace-form nss syms))

(defmacro import
  "Imports all or a selection of vars from one namespace to the current one.
 
   (import hara.common.checks [bytes? long?]) => nil
   (eval '(long? 1))  => true
   (eval '(bytes? 1)) => false
 
   (import hara.common.checks :all) => nil
   (eval '(bigint? 1)) => false
 
   "
  {:added "2.0"}
  [& inputs]
  (->> (partition 2 inputs)
            (map #(apply import-namespace-form %))
            (apply concat)
            (vec)))
