(ns leiningen.new.zeta
  (:require [clojure.java.io :as io]
            [clojure.string :as cs]
            [leiningen.new.templates :refer [->files
                                             *dir*
                                             group-name
                                             name-to-path
                                             project-name
                                             renderer
                                             sanitize-ns]]
            [leiningen.core.main :as main]))

(def ^:dynamic *data* {})

(def render (renderer "zeta"))

(defn fill [path]
  (render path *data*))

(defn copy [path]
  (render path {}))

(defn absolute-path [path]
  (if (cs/starts-with? path "/")
    path
    (-> "leiningen.original.pwd"
      System/getProperty
      (io/file path)
      .getAbsolutePath)))

(defn zeta
  "Zeta Project"
  [name]
  (main/info "Generating fresh 'lein new' zeta project.")
  (binding [*dir* (absolute-path (or *dir* (project-name name)))
            *data* {:name name
                    :ns (sanitize-ns name)
                    :group (group-name name)
                    :project (project-name name)
                    :sanitized (name-to-path name)}]
    (->files *data*
             ["project.clj" (fill "project.clj")]
             [".gitignore" (copy "gitignore")]

             ["resources/statics/public/assets/home/pages/index.html" (copy "resources/index.html")]

             ["src/{{sanitized}}/app.clj" (fill "src/app.clj")]

             ["src/{{sanitized}}/config/development/api.edn" (copy "src/config/api.edn")]
             ["src/{{sanitized}}/config/development/crypto.edn" (copy "src/config/development/crypto.edn")]
             ["src/{{sanitized}}/config/development/kafka.edn" (copy "src/config/kafka.edn")]
             ["src/{{sanitized}}/config/development/repositories.edn" (copy "src/config/repositories.edn")]
             ["src/{{sanitized}}/config/development/snapshots.edn" (copy "src/config/snapshots.edn")]

             ["src/{{sanitized}}/app.clj" (fill "src/app.clj")]
             ["src/{{sanitized}}/config/production/api.edn" (copy "src/config/api.edn")]
             ["src/{{sanitized}}/config/production/crypto.edn" (copy "src/config/production/crypto.edn")]
             ["src/{{sanitized}}/config/production/kafka.edn" (copy "src/config/kafka.edn")]
             ["src/{{sanitized}}/config/production/repositories.edn" (copy "src/config/repositories.edn")]
             ["src/{{sanitized}}/config/production/snapshots.edn" (copy "src/config/snapshots.edn")]

             ["src/{{sanitized}}/restful/home.clj" (fill "src/restful/home.clj")])))
