(ns clostack.scratch
  (:require [clostack.keystone :refer [token-create] :as keystone]
            [clostack.nova :as nova]
            [clostack.glance :as glance]
            [clostack.neutron :as neutron]
            [clojure.repl :refer [source doc]]))


(let [url "http://192.168.101.200:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "8099ee5232274985")]
  ;; (neutron/quota-get token "e13a922156cb46289a78d07852276f81")
  ;; (neutron/quota-list token)
  (glance/image-list token))

(let [url "http://192.168.24.101:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "keytonecloud")]
  (glance/image-list token))

(let [url "http://192.168.101.200:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "8099ee5232274985")]
  (->>
   (keystone/project-list token) (map #(select-keys % [:id :name]))))


(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/hypervisor-migratenode-list token "cns-1")
   ;; (nova/hypervisor-uptime token "1") :body :hypervisor :uptime
   ;; (nova/hypervisor-statistic token) :body :hypervisor_statistics
   ))


(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/server-list token {:all_tenants true :server_id "bf043ce3-4532-41d0-8a11-8998129754b1"})
   ))

(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/flavor-list token) (map #(select-keys % [:id :name]))
   ))


(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/flavor-delete token "7e60e211-909d-4201-82e6-1adce350b3cd") 
   ))

(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (glance/image-list token)))

(let [url "http://10.181.0.33:5000/v3/auth/tokens"
      token (token-create url :name "testuser" :password "keyTonetestuser" :domain-name "keyTone")]
  (glance/image-list token))

(let [url "http://10.181.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "CONFIG_KEYSTONE_ADMIN_PW")]
  ;; (keystone/domain-list token)
  ;; (keystone/user-list token {:name "testuser"})
  (keystone/domain-get token "f7ff95405f62409194f66193bd7cb1fb"))

