(ns clostack.scratch
  (:require [clostack.keystone :refer [token-create] :as keystone]
            [clostack.nova :as nova]
            [clostack.utils :as util]
            [clostack.glance :as glance]
            [clostack.neutron :as neutron]
            [clojure.repl :refer [source doc]]
            [clojure.java.io :as io]))


(let [url "http://192.168.101.200:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "8099ee5232274985" :domain-name "default")]
  ;; (keystone/user-list token)
  ;; (keystone/role-assignment-list token {:user-id "2bd69651721d486bacfa26cfd760caaf"})
  ;; (keystone/role-get token "9fe2ff9ee4384b1894a90878d3e92bab")
  (keystone/project-get token "e13a922156cb46289a78d07852276f81"))

(let [url "http://192.168.24.101:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "keytonecloud" :domain-name "default")]
  (nova/server-list token))

(let [url "http://192.168.24.101:5000/v3/auth/tokens"
      token (token-create url :name "xy" :password "asdf" :domain-name "test")]
  (nova/server-list token))

(let [url "http://192.168.101.200:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "8099ee5232274985")]
  (->>
   (keystone/project-list token) (map #(select-keys % [:id :name]))))


(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/hypervisor-migratenode-list token "cns-1")
   ;; (nova/hypervisor-uptime token "1") :body :hypervisor :uptime
   ;; (nova/hypervisor-statistic token) :body :hypervisor_statistics
   ))


(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/server-list token {:all_tenants true :server_id "bf043ce3-4532-41d0-8a11-8998129754b1"})
   ))

(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/flavor-list token) (map #(select-keys % [:id :name]))
   ))


(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (nova/flavor-delete token "7e60e211-909d-4201-82e6-1adce350b3cd") 
   ))

(let [url "http://10.160.0.33:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "aa68fbf2-ec23-4716-8d5c-4f3165606a6a")]
  (->>
   (glance/image-list token)))

(let [url "http://10.181.0.33:5000/v3/auth/tokens"
      token (token-create url :name "testuser" :password "keyTonetestuser" :domain-name "keyTone")]
  (glance/image-list token))

(let [url "http://10.110.1.4:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "admin" :scope {:project {:name "admin" :domain {:name "Default"}}})]
  (nova/server-list token))

(let [url "http://10.110.1.4:5000/v3/auth/tokens"
      token (token-create url {:name "admin" :password "admin" :scope {:project {:name "admin" :domain {:name "Default"}}}})]
  (nova/server-create token {:name "test-33"
                             :imageRef "e9731d6c-c712-4dd5-bb07-ef9237cacf85"
                             :flavorRef "1"
                             :networks [{:uuid "2cd19f58-4b2c-4748-bdbd-36c0486010a2"}]}))

(let [url "http://10.110.1.4:5000/v3/auth/tokens"
      token (token-create url :name "admin" :password "admin" :scope {:project {:name "admin" :domain {:name "Default"}}})]
  (neutron/port-list token {:device-id "4aa23693-524a-48b5-8885-a1275e8d2a92"}))



(def token (token-create "http://10.110.1.4:5000/v3/auth/tokens" :name "admin" :password "admin" :scope {:project {:name "admin" :domain {:name "Default"}}}))

(def server-id (-> (nova/server-list token {:name "wq"}) first :id))

(nova/server-volume-attachment-list token server-id)

(nova/server-volume-attachment-get token server-id "3b82ec63-7923-4504-8ad9-081858853d5a")

(nova/server-interface-attachment-list token server-id)

(def subnet-id
  (->
   (neutron/port-list token {:device-id server-id}) first :fixed_ips first :subnet_id))

(def network-id
  (->
   (neutron/port-list token {:device-id server-id}) first :network_id))

(def router-id
  (->
   (neutron/router-list token) first :id))

(neutron/router-list token)

(neutron/port-list token {:device-id router-id :device_owner ["network:router_interface_distributed" "network:router_interface"]})

(neutron/port-list token {:network_id network-id  :device_owner ["network:router_interface_distributed" "network:router_interface"]})

(neutron/network-list token {:router:external true})

(str
 (util/endpoint-get token "image" "public")
 (:file (first (glance/image-list token {:tag "cirros"}))))

(def image-id (:id (first
                    (glance/image-list token {:tag "cirros"}))))

(glance/image-get token image-id)

(io/copy 
 (glance/image-download token image-id)
 (io/file "/tmp/image"))

(type
 (glance/image-download token image-id))

(glance/version-list token)

(nova/hypervisor-statistic-list token)

(binding [clostack.utils/*proxy-port* 8119
          clostack.utils/*proxy-host* "localhost"]
  (glance/image-create token {:container_format "bare" :disk_format "qcow2" :name "upload-test"}))

(glance/image-upload token "972b69cc-06ea-4464-8775-1835eb3ad7e6" (io/input-stream "/etc/issue"))

(glance/image-get token "972b69cc-06ea-4464-8775-1835eb3ad7e6")

(io/copy
 (glance/image-download token "972b69cc-06ea-4464-8775-1835eb3ad7e6")
 (io/file "/tmp/download-test"))

(glance/image-list token)

(-> (glance/image-list token {:name "upload-test"}) first :id)

(glance/image-delete token "972b69cc-06ea-4464-8775-1835eb3ad7e6")
