/*
 * Decompiled with CFR 0.152.
 */
package net.matlux;

import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.matlux.MBeanRegistration;
import net.matlux.NreplMBean;

public class NreplServer
implements Map<String, Object>,
NreplMBean {
    private static final Logger LOGGER = Logger.getLogger(NreplServer.class.getSimpleName());
    public static NreplServer instance = null;
    public static final int DEFAULT_PORT = 1112;
    private static final Var USE = RT.var((String)"clojure.core", (String)"use");
    private static final Symbol REPL_SERVER_NS = Symbol.intern((String)"net.matlux.server.nrepl");
    private static final Var START_REPL_SERVER = RT.var((String)"net.matlux.server.nrepl", (String)"start-server-now");
    private static final Var STOP_REPL_SERVER = RT.var((String)"net.matlux.server.nrepl", (String)"stop-server-now");
    private static final Var SERVER = RT.var((String)"net.matlux.server.nrepl", (String)"server");
    private final Map<String, Object> objMap = new HashMap<String, Object>();
    private final boolean logExceptionStack;
    private final boolean propagateException;
    private int port;

    public NreplServer(int port, boolean startOnCreation, boolean registerMBeanOnCreation, boolean propagateException, boolean logExceptionStack) {
        this.port = port;
        this.propagateException = propagateException;
        this.logExceptionStack = logExceptionStack;
        LOGGER.info("Creating ReplStartup for Port=" + port);
        try {
            USE.invoke((Object)REPL_SERVER_NS);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Repl initialization caught an error", t);
        }
        if (startOnCreation) {
            this.start();
        }
        if (registerMBeanOnCreation) {
            this.registerMBean();
        }
        instance = this;
    }

    public NreplServer(int port) {
        this(port, true, true, false, true);
    }

    public static void main(String[] args) throws Exception {
        int port = 1112;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        new NreplServer(port);
    }

    @Override
    public boolean start() {
        try {
            START_REPL_SERVER.invoke((Object)this.port);
            LOGGER.info("Repl started successfully on Port = " + this.port);
        }
        catch (Throwable t) {
            if (this.logExceptionStack) {
                LOGGER.log(Level.SEVERE, "Repl startup caught an error", t);
            } else {
                LOGGER.log(Level.INFO, "Repl startup caught an error");
            }
            if (this.propagateException) {
                throw new RuntimeException("Repl startup caught an error", t);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean stop() {
        try {
            STOP_REPL_SERVER.invoke();
            LOGGER.info("Repl stopped successfully");
        }
        catch (Throwable t) {
            if (this.logExceptionStack) {
                LOGGER.log(Level.SEVERE, "Repl stop caught an error", t);
            } else {
                LOGGER.log(Level.INFO, "Repl stop caught an error");
            }
            if (this.propagateException) {
                throw new RuntimeException("Repl stop caught an error", t);
            }
            return false;
        }
        return true;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public boolean isStarted() {
        return SERVER.deref() != null;
    }

    public void registerMBean() {
        MBeanRegistration.registerNreplServerAsMBean(this, this.logExceptionStack);
    }

    public void unregisterMBean() {
        MBeanRegistration.unregisterNreplServerAsMBean(this.logExceptionStack);
    }

    public Object getObj(String key) {
        return this.objMap.get(key);
    }

    public void setObjMap(Map<String, Object> objMap) {
        this.objMap.putAll(objMap);
    }

    @Override
    public int size() {
        return this.objMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.objMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.objMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.objMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.objMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.objMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.objMap.remove(key);
    }

    @Override
    public void putAll(Map m) {
        this.objMap.putAll(m);
    }

    @Override
    public void clear() {
        this.objMap.clear();
    }

    @Override
    public Set keySet() {
        return this.objMap.keySet();
    }

    @Override
    public Collection values() {
        return this.objMap.values();
    }

    @Override
    public Set entrySet() {
        return this.objMap.entrySet();
    }
}

