(defproject zikajk/oauth2-client "0.3.0"
  :description "OAuth2/OpenID Connect Client Library for Clojure."

  :url "https://github.com/zikajk/oauth2-client"

  :license {:name "MIT License"
            :url "http://dd.mit-license.org"}

  :dependencies
  [[cheshire "5.10.0"]
   [clj-http "3.10.0"]
   [crypto-random "1.2.0"]
   [ring "1.8.0"]
   [ring/ring-codec "1.1.2"]
   [org.clojure/clojure "1.10.0"]
   [slingshot "0.12.2"]]

  :plugins [[codox "0.8.13"]]

  :codox
  {:exclude [oauth2-client.examples-utils
             oauth2-client.github
             oauth2-client.google
             oauth2-client.renault]}

  :profiles
  {:dev
   {:source-paths ["examples"]

    :plugins [[lein-environ "1.1.0"]]

    :dependencies
    [[compojure "1.4.0"]
     [environ "1.1.0"]
     [org.clojure/tools.nrepl "0.2.13"]
     [ring/ring-codec "1.1.2"]
     [ring/ring-mock "0.4.0"]]}})
