(ns leiningen.test!!
  (:refer-clojure :exclude [test])
  (:use [bultitude.core :only [namespaces-in-dir]]
        [leiningen.core.eval :only [eval-in-project]]
        [leiningen.clean :only [clean]]
        [leiningen.deps :only [deps]]
        [leiningen.test :only [test *exit-after-tests*]]))

(defn test-nses [project]
  (sort (namespaces-in-dir (:test-path project))))

(defn test!! [project]
  (doto project clean deps)
  (println "Project " project)
  (/ 1 0)
  (println "Tests "(test-nses project))
  (for [n (test-nses project)]
    (do
      (println n)
      (println (test project (str n))))))
