(ns {{namespace}}.view.main
  (:require [zou.util :as u]{{#hiccup?}}
            [zou.web.view.hiccup :as h]{{/hiccup?}}{{#enlive?}}
            [clojure.java.io :as io]
            [net.cgrand.enlive-html :as html]{{/enlive?}}))

(u/defnk home [app-name]
  (format "<html><title>%s</title><body>
<h1>%s</h1><p>Hello World!</p>{{#cljs?}}
<script src=\"/js/dist/main.js\"></script>{{/cljs?}}
</body></html>" app-name app-name)){{#hiccup?}}

(h/defhiccup hiccup [app-name header messages {javascripts []} {stylesheets []}]
  (h/html5
   [:head
    [:title app-name]
    (apply h/include-css (map last stylesheets))]
   [:body
    [:h1 header]
    (for [m messages]
      [:p m])
    (apply h/include-js (map last javascripts))])){{/hiccup?}}{{#enlive?}}

(html/deftemplate enlive (io/resource "templates/layout.html")
  [{:keys [app-name header message]}]
  [:title] (html/content app-name)
  [:h1] (html/content header)
  [:#content] (html/content message)){{/enlive?}}
