(ns {{namespace}}.view.main
  (:require [zou.util :as u]{{#hiccup?}}
            [zou.web.view.hiccup :as h]{{/hiccup?}}{{#enlive?}}
            [clojure.java.io :as io]
            [net.cgrand.enlive-html :as html]{{/enlive?}}
            [clojure.string :as str]))

(u/defnk home [app-name href {javascripts []} {stylesheets []}]
  (str "<html><head>"
       "<title>" app-name "</title>"
       (str/join (for [s stylesheets]
                   (str "<link rel=\"stylesheet\" href=\"" (href s) "\">")))
       "</head><body>"
       "<h1>" app-name "</h1>"
       "<p>Welcome to Zou!</p>"
       (str/join (for [j javascripts]
                   (str "<script src=\"" (href j) "\">")))
       "</body></html>")){{#hiccup?}}

(h/defhiccup hiccup [app-name header messages href {javascripts []} {stylesheets []}]
  (h/html5
   [:head
    [:title app-name]
    (apply h/include-css (map href stylesheets))]
   [:body
    [:h1 header]
    (for [m messages]
      [:p m])
    (apply h/include-js (map href javascripts))])){{/hiccup?}}{{#enlive?}}

(html/deftemplate enlive (io/resource "templates/layout.html")
  [{:keys [app-name header message javascripts stylesheets href]}]
  [:title] (html/content app-name)
  [:head] (html/append (html/html (for [s stylesheets]
                                    [:link {:rel "stylesheet" :href (href s)}])))
  [:body] (html/append (html/html (for [j javascripts]
                                    [:script {:src (href j)}])))
  [:h1] (html/content header)
  [:#content] (html/content message)){{/enlive?}}
