/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.vertiflex.p4edgerouting;

import org.eclipse.elk.alg.vertiflex.InternalProperties;
import org.eclipse.elk.alg.vertiflex.VertiFlexLayoutPhases;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class BendEdgeRouter
implements ILayoutPhase<VertiFlexLayoutPhases, ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("BendEdgeRouter", 1.0f);
        if (!graph.getChildren().isEmpty()) {
            ElkNode parent = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
            this.routeEdges(parent);
        }
        progressMonitor.done();
    }

    public LayoutProcessorConfiguration<VertiFlexLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }

    private void routeEdges(ElkNode node) {
        for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)node)) {
            ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
            ElkEdgeSection section = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)true, (boolean)true);
            double startX = node.getX() + node.getWidth() / 2.0;
            double startY = node.getY() + node.getHeight();
            double endX = target.getX() + target.getWidth() / 2.0;
            double endY = target.getY();
            section.setStartLocation(startX, startY);
            section.setEndLocation(endX, endY);
            double bendheight = (Double)target.getProperty(InternalProperties.EDGE_BEND_HEIGHT);
            double epsilon = 1.0E-4;
            if (Math.abs(bendheight - (endY - (Double)target.getParent().getProperty(CoreOptions.SPACING_NODE_NODE) / 2.0)) > epsilon) {
                ElkGraphUtil.createBendPoint((ElkEdgeSection)section, (double)endX, (double)bendheight);
            }
            this.routeEdges(target);
        }
    }
}

