/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleBoolValueHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        CommandStack stack = (CommandStack)editor.getAdapter(CommandStack.class);
        if (stack != null) {
            ToggleBoolValueHandler.getValues(HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event)).forEachOrdered(value -> ToggleBoolValueHandler.toggleValue(value, stack));
        }
        return null;
    }

    private static void toggleValue(Value value, CommandStack stack) {
        VarDeclaration varDeclaration;
        IInterfaceElement iInterfaceElement = value.getParentIE();
        if (iInterfaceElement instanceof VarDeclaration && (varDeclaration = (VarDeclaration)iInterfaceElement).isIsInput() && varDeclaration.getType() instanceof BoolType && !varDeclaration.isArray()) {
            String newValue = Boolean.parseBoolean(value.getValue()) ? "FALSE" : "TRUE";
            stack.execute((Command)new ChangeValueCommand(varDeclaration, newValue));
        }
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        Object object = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(object instanceof IStructuredSelection && ToggleBoolValueHandler.getValues(selection = (IStructuredSelection)object).allMatch(ToggleBoolValueHandler::isValidValue));
    }

    private static boolean isValidValue(Value value) {
        VarDeclaration varDeclaration;
        IInterfaceElement iInterfaceElement = value.getParentIE();
        return iInterfaceElement instanceof VarDeclaration && (varDeclaration = (VarDeclaration)iInterfaceElement).isIsInput() && varDeclaration.getType() instanceof BoolType && !varDeclaration.isArray();
    }

    private static Stream<Value> getValues(IStructuredSelection selection) {
        return selection.stream().filter(ValueEditPart.class::isInstance).map(ValueEditPart.class::cast).map(ValueEditPart::getModel);
    }
}

